angular.module('glancesApp').run(['$templateCache', function($templateCache) {$templateCache.put('plugins/alert.html','<div class="table">\n    <div class="table-row" ng-repeat="alert in statsAlert.getAlerts()">\n        <div class="table-cell text-left">\n{{alert.begin | date : \'yyyy-MM-dd H:mm:ss\'}} ({{ alert.ongoing ? \'ongoing\' : alert.duration }}) - <span ng-hide="alert.ongoing">{{alert.level}} on</span> <span class="{{ alert.level | lowercase }}">{{alert.name}}</span> ({{alert.max}})\n\t\t</div>\n    </div>\n</div>\n');
$templateCache.put('plugins/alerts.html','<span class="title" ng-show="!statsAlert.hasAlerts()">No warning or critical alert detected</span>\n<span class="title" ng-show="statsAlert.hasAlerts()">Warning or critical alerts (lasts {{statsAlert.count()}} entries)</span>\n');
$templateCache.put('plugins/amps.html','<div class="table">\n    <div class="table-row" ng-repeat="process in statsAmps.processes">\n        <div class="table-cell text-left" ng-class="statsAmps.getDescriptionDecoration(process)">{{ process.name }}</div>\n        <div class="table-cell text-left">{{ process.count }}</div>\n        <div class="table-cell text-left process-result">{{ process.result }}</div>\n    </div>\n</div>\n');
$templateCache.put('plugins/cpu.html','<div class="row">\n    <div class="col-sm-24 col-md-12 col-lg-8">\n        <div class="table">\n            <div class="table-row">\n                <div class="table-cell text-left title">CPU</div>\n                <div class="table-cell">{{ statsCpu.total }}%</div>\n            </div>\n            <div class="table-row">\n                <div class="table-cell text-left">user:</div>\n                <div class="table-cell" ng-class="statsCpu.getDecoration(\'user\')">\n                    {{ statsCpu.user }}%\n                </div>\n            </div>\n            <div class="table-row">\n                <div class="table-cell text-left">system:</div>\n                <div class="table-cell" ng-class="statsCpu.getDecoration(\'system\')">\n                    {{ statsCpu.system }}%\n                </div>\n            </div>\n            <div class="table-row">\n                <div class="table-cell text-left">idle:</div>\n                <div class="table-cell">{{ statsCpu.idle }}%</div>\n            </div>\n        </div>\n    </div>\n    <div class="hidden-xs hidden-sm col-md-12 col-lg-8">\n        <div class="table">\n            <div class="table-row">\n                <div class="table-cell text-left">nice:</div>\n                <div class="table-cell">\n                    {{ statsCpu.nice }}%\n                </div>\n            </div>\n            <div class="table-row" ng-show="statsCpu.irq != undefined">\n                <div class="table-cell text-left">irq:</div>\n                <div class="table-cell">\n                    {{ statsCpu.irq }}%\n                </div>\n            </div>\n            <div class="table-row" ng-show="statsCpu.iowait != undefined">\n                <div class="table-cell text-left">iowait:</div>\n                <div class="table-cell" ng-class="statsCpu.getDecoration(\'iowait\')">\n                    {{ statsCpu.iowait }}%\n                </div>\n            </div>\n            <div class="table-row" ng-show="statsCpu.steal != undefined">\n                <div class="table-cell text-left">steal:</div>\n                <div class="table-cell" ng-class="statsCpu.getDecoration(\'steal\')">\n                    {{ statsCpu.steal }}%\n                </div>\n            </div>\n        </div>\n    </div>\n    <div class="hidden-xs hidden-sm hidden-md col-lg-8">\n        <div class="table">\n            <div class="table-row" ng-if="statsCpu.ctx_switches">\n                <div class="table-cell text-left">ctx_sw:</div>\n                <div class="table-cell" ng-class="statsCpu.getDecoration(\'ctx_switches\')">\n                    {{ statsCpu.ctx_switches }}\n                </div>\n            </div>\n            <div class="table-row" ng-if="statsCpu.interrupts">\n                <div class="table-cell text-left">inter:</div>\n                <div class="table-cell">\n                    {{ statsCpu.interrupts }}\n                </div>\n            </div>\n            <div class="table-row" ng-if="statsCpu.soft_interrupts">\n                <div class="table-cell text-left">sw_int:</div>\n                <div class="table-cell">\n                    {{ statsCpu.soft_interrupts }}\n                </div>\n            </div>\n            <div class="table-row" ng-if="!statsSystem.isLinux() && statsCpu.syscalls">\n                <div class="table-cell text-left">syscal:</div>\n                <div class="table-cell">\n                    {{ statsCpu.syscalls }}\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n');
$templateCache.put('plugins/diskio.html','<div class="table-row">\n    <div class="table-cell text-left title">DISK I/O</div>\n    <div class="table-cell" ng-show="!arguments.diskio_iops">R/s</div>\n    <div class="table-cell" ng-show="!arguments.diskio_iops">W/s</div>\n\n    <div class="table-cell" ng-show="arguments.diskio_iops">IOR/s</div>\n    <div class="table-cell" ng-show="arguments.diskio_iops">IOW/s</div>\n</div>\n<div class="table-row" ng-repeat="disk in statsDiskio.disks">\n    <div class="table-cell text-left">{{(disk.alias ? disk.alias : disk.name) | min_size}}</div>\n    <div class="table-cell" ng-show="!arguments.diskio_iops">{{disk.bitrate.txps }}</div>\n    <div class="table-cell" ng-show="!arguments.diskio_iops">{{disk.bitrate.rxps }}</div>\n\n    <div class="table-cell" ng-show="arguments.diskio_iops">{{disk.count.txps }}</div>\n    <div class="table-cell" ng-show="arguments.diskio_iops">{{disk.count.rxps }}</div>\n</div>\n');
$templateCache.put('plugins/docker.html','<span class="title">CONTAINERS</span> {{ statsDocker.containers.length }} (served by Docker {{ statsDocker.version }})\n\n<div class="table">\n    <div class="table-row">\n        <div class="table-cell text-left">Name</div>\n        <div class="table-cell">Status</div>\n        <div class="table-cell">CPU%</div>\n        <div class="table-cell">MEM</div>\n        <div class="table-cell">IOR/s</div>\n        <div class="table-cell">IOW/s</div>\n        <div class="table-cell">RX/s</div>\n        <div class="table-cell">TX/s</div>\n        <div class="table-cell text-left">Command</div>\n    </div>\n    <div class="table-row" ng-repeat="container in statsDocker.containers">\n        <div class="table-cell text-left">{{ container.name }}</div>\n        <div class="table-cell" ng-class="container.status == \'Paused\' ? \'careful\' : \'ok\'">{{ container.status }}</div>\n        <div class="table-cell">{{ container.cpu | number:1 }}</div>\n        <div class="table-cell">{{ container.memory | bytes }}</div>\n        <div class="table-cell">{{ container.ior / container.io_time_since_update | bits }}</div>\n        <div class="table-cell">{{ container.iow / container.io_time_since_update | bits }}</div>\n        <div class="table-cell">{{ container.rx / container.net_time_since_update | bits }}</div>\n        <div class="table-cell">{{ container.tx / container.net_time_since_update | bits }}</div>\n        <div class="table-cell text-left">{{ container.command }}</div>\n    </div>\n</div>\n');
$templateCache.put('plugins/folders.html','<div class="table-row">\n    <div class="table-cell text-left title">FOLDERS</div>\n    <div class="table-cell">Size</div>\n</div>\n<div class="table-row" ng-repeat="folder in statsFolders.folders">\n    <div class="table-cell text-left">{{ folder.path }}</div>\n    <div class="table-cell" ng-class="statsFolders.getDecoration(folder)">{{ folder.size | bytes }}</div>\n</div>\n');
$templateCache.put('plugins/fs.html','<div class="table-row">\n    <div class="table-cell text-left title">FILE SYS</div>\n    <div class="table-cell">\n        <span ng-show="!arguments.fs_free_space">Used</span>\n        <span ng-show="arguments.fs_free_space">Free</span>\n    </div>\n    <div class="table-cell">Total</div>\n</div>\n<div class="table-row" ng-repeat="fs in statsFs.fileSystems | orderBy:  \'mnt_point\'">\n    <div class="table-cell text-left">{{ fs.mountPoint }} <span class="visible-lg-inline" ng-show="fs.name.length <= 20">({{ fs.name }})<span></div>\n    <div class="table-cell" ng-class="statsFs.getDecoration(fs.mountPoint, \'used\')">\n        <span ng-show="!arguments.fs_free_space">{{ fs.used | bytes }}</span>\n        <span ng-show="arguments.fs_free_space">{{ fs.free | bytes }}</span>\n    </div>\n    <div class="table-cell">{{ fs.size | bytes }}</div>\n</div>\n');
$templateCache.put('plugins/ip.html','&nbsp;-&nbsp;<span class="title">IP</span>&nbsp;<span>{{ statsIp.address }}/{{ statsIp.maskCidr }}</span>&nbsp;<span class="title">Pub</span>&nbsp;<span>{{ statsIp.publicAddress }}</span>\n');
$templateCache.put('plugins/irq.html','<div class="table-row">\n    <div class="table-cell text-left title">IRQ</div>\n    <div class="table-cell"></div>\n    <div class="table-cell">Rate/s</div>\n</div>\n<div class="table-row" ng-repeat="irq in statsIrq.irqs">\n    <div class="table-cell text-left">{{irq.irq_line}}</div>\n    <div class="table-cell"></div>\n    <div class="table-cell"><span>{{irq.irq_rate}}</span></div>\n</div>\n');
$templateCache.put('plugins/load.html','<div class="table">\n    <div class="table-row">\n        <div class="table-cell text-left title">LOAD</div>\n        <div class="table-cell">{{ statsLoad.cpucore }}-core</div>\n    </div>\n    <div class="table-row">\n        <div class="table-cell text-left">1 min:</div>\n        <div class="table-cell">\n            {{ statsLoad.min1 | number : 2}}\n        </div>\n    </div>\n    <div class="table-row">\n        <div class="table-cell text-left">5 min:</div>\n        <div class="table-cell" ng-class="statsLoad.getDecoration(\'min5\')">\n            {{ statsLoad.min5 | number : 2}}\n        </div>\n    </div>\n    <div class="table-row">\n        <div class="table-cell text-left">15 min:</div>\n        <div class="table-cell" ng-class="statsLoad.getDecoration(\'min15\')">\n            {{ statsLoad.min15 | number : 2}}\n        </div>\n    </div>\n</div>\n');
$templateCache.put('plugins/mem.html','<div class="table">\n    <div class="table-row">\n        <div class="table-cell text-left title">MEM</div>\n        <div class="table-cell">{{ statsMem.percent }}%</div>\n    </div>\n    <div class="table-row">\n        <div class="table-cell text-left">total:</div>\n        <div class="table-cell">{{ statsMem.total | bytes }}</div>\n    </div>\n    <div class="table-row">\n        <div class="table-cell text-left">used:</div>\n        <div class="table-cell" ng-class="statsMem.getDecoration(\'used\')">\n            {{ statsMem.used | bytes:2 }}\n        </div>\n    </div>\n    <div class="table-row">\n        <div class="table-cell text-left">free:</div>\n        <div class="table-cell">{{ statsMem.free | bytes }}</div>\n    </div>\n</div>\n');
$templateCache.put('plugins/mem_more.html','<div class="table">\n    <div class="table-row">\n        <div class="table-cell text-left">active:</div>\n        <div class="table-cell">{{ statsMem.active | bytes }}</div>\n    </div>\n    <div class="table-row">\n        <div class="table-cell text-left">inactive:</div>\n        <div class="table-cell">{{ statsMem.inactive | bytes }}</div>\n    </div>\n    <div class="table-row" ng-show="statsMem.buffers != undefined">\n        <div class="table-cell text-left">buffers:</div>\n        <div class="table-cell">{{ statsMem.buffers | bytes }}</div>\n    </div>\n    <div class="table-row" ng-show="statsMem.cached != undefined">\n        <div class="table-cell text-left">cached:</div>\n        <div class="table-cell">{{ statsMem.cached | bytes }}</div>\n    </div>\n</div>\n');
$templateCache.put('plugins/memswap.html','<div class="table">\n    <div class="table-row">\n        <div class="table-cell text-left title">SWAP</div>\n        <div class="table-cell">{{ statsMemSwap.percent }}%</div>\n    </div>\n    <div class="table-row">\n        <div class="table-cell text-left">total:</div>\n        <div class="table-cell">{{ statsMemSwap.total | bytes }}</div>\n    </div>\n    <div class="table-row">\n        <div class="table-cell text-left">used:</div>\n        <div class="table-cell" ng-class="statsMemSwap.getDecoration(\'used\')">\n            {{ statsMemSwap.used | bytes }}\n        </div>\n    </div>\n    <div class="table-row">\n        <div class="table-cell text-left">free:</div>\n        <div class="table-cell">{{ statsMemSwap.free | bytes }}</div>\n    </div>\n</div>\n');
$templateCache.put('plugins/network.html','<div class="table-row">\n    <div class="table-cell text-left title">NETWORK</div>\n    <div class="table-cell" ng-show="!arguments.network_cumul && !arguments.network_sum">Rx/s</div>\n    <div class="table-cell" ng-show="!arguments.network_cumul && !arguments.network_sum">Tx/s</div>\n\n    <div class="table-cell" ng-show="!arguments.network_cumul && arguments.network_sum"></div>\n    <div class="table-cell" ng-show="!arguments.network_cumul && arguments.network_sum">Rx+Tx/s</div>\n\n    <div class="table-cell" ng-show="arguments.network_cumul && !arguments.network_sum">Rx</div>\n    <div class="table-cell" ng-show="arguments.network_cumul && !arguments.network_sum">Tx</div>\n\n    <div class="table-cell" ng-show="arguments.network_cumul && arguments.network_sum"></div>\n    <div class="table-cell" ng-show="arguments.network_cumul && arguments.network_sum">Rx+Tx</div>\n</div>\n<div class="table-row" ng-repeat="network in statsNetwork.networks | orderBy: \'interfaceName\'">\n    <div class="table-cell text-left">{{ network.interfaceName | min_size }}</div>\n    <div class="table-cell" ng-show="!arguments.network_cumul && !arguments.network_sum">{{ arguments.byte ? (network.rx / network.time_since_update | bytes) : (network.rx / network.time_since_update | bits) }}</div>\n    <div class="table-cell" ng-show="!arguments.network_cumul && !arguments.network_sum">{{ arguments.byte ? (network.tx / network.time_since_update | bytes) : (network.tx / network.time_since_update | bits) }}</div>\n\n    <div class="table-cell" ng-show="!arguments.network_cumul && arguments.network_sum"></div>\n    <div class="table-cell" ng-show="!arguments.network_cumul && arguments.network_sum">{{ arguments.byte ? (network.cx / network.time_since_update | bytes) : (network.cx / network.time_since_update | bits) }}</div>\n\n    <div class="table-cell" ng-show="arguments.network_cumul && !arguments.network_sum">{{ arguments.byte ? (network.cumulativeRx | bytes) : (network.cumulativeRx | bits) }}</div>\n    <div class="table-cell" ng-show="arguments.network_cumul && !arguments.network_sum">{{ arguments.byte ? (network.cumulativeTx | bytes) : (network.cumulativeTx | bits) }}</div>\n\n    <div class="table-cell" ng-show="arguments.network_cumul && arguments.network_sum"></div>\n    <div class="table-cell" ng-show="arguments.network_cumul && arguments.network_sum">{{ arguments.byte ? (network.cumulativeCx | bytes) : (network.cumulativeCx | bits) }}</div>\n</div>\n');
$templateCache.put('plugins/per_cpu.html','<div class="table">\n    <div class="table-row">\n        <div class="table-cell text-left title">PER CPU</div>\n        <div class="table-cell" ng-repeat="percpu in statsPerCpu.cpus">{{ percpu.total }}%</div>\n    </div>\n    <div class="table-row">\n        <div class="table-cell text-left">user:</div>\n        <div class="table-cell" ng-repeat="percpu in statsPerCpu.cpus" ng-class="statsPerCpu.getUserAlert(percpu)">\n            {{ percpu.user }}%\n        </div>\n    </div>\n    <div class="table-row">\n        <div class="table-cell text-left">system:</div>\n        <div class="table-cell" ng-repeat="percpu in statsPerCpu.cpus" ng-class="statsPerCpu.getSystemAlert(percpu)">\n            {{ percpu.system }}%\n        </div>\n    </div>\n    <div class="table-row">\n        <div class="table-cell text-left">idle:</div>\n        <div class="table-cell" ng-repeat="percpu in statsPerCpu.cpus">{{ percpu.idle }}%</div>\n    </div>\n    <div class="table-row" ng-show="statsPerCpu.cpus[0].iowait">\n        <div class="table-cell text-left">iowait:</div>\n        <div class="table-cell" ng-repeat="percpu in statsPerCpu.cpus" ng-class="statsPerCpu.getSystemAlert(percpu)">\n            {{ percpu.iowait }}%\n        </div>\n    </div>\n    <div class="table-row" ng-show="statsPerCpu.cpus[0].steal">\n        <div class="table-cell text-left">steal:</div>\n        <div class="table-cell" ng-repeat="percpu in statsPerCpu.cpus" ng-class="statsPerCpu.getSystemAlert(percpu)">\n            {{ percpu.steal }}%\n        </div>\n    </div>\n</div>\n');
$templateCache.put('plugins/ports.html','<div class="table-row" ng-repeat="port in statsPorts.ports">\n  <div class="table-cell text-left">{{(port.description ? port.description : port.host + \' \' + port.port) | min_size: 20}}</div>\n  <div class="table-cell"></div>\n  <div ng-switch="port.status" ng-class="statsPorts.getDecoration(port)" class="table-cell">\n    <span ng-switch-when="null">Scanning</span>\n    <span ng-switch-when="false">Timeout</span>\n    <span ng-switch-when="true">Open</span>\n    <span ng-switch-default>{{port.status * 1000.0 | number:0}}ms</span>\n  </div>\n</div>\n');
$templateCache.put('plugins/processcount.html','<span class="title">TASKS</span>\n<span>{{ statsProcessCount.total }} ({{ statsProcessCount.thread }} thr),</span>\n<span>{{ statsProcessCount.running }} run,</span>\n<span>{{ statsProcessCount.sleeping }} slp,</span>\n<span>{{ statsProcessCount.stopped }} oth</span>\n<span> sorted {{ sorter.auto ? \'automatically\' : \'\' }} by {{ sorter.getColumnLabel(sorter.column) }}, flat view</span>\n');
$templateCache.put('plugins/processlist.html','<div class="table">\n    <div class="table-row">\n        <div sortable-th sorter="sorter" column="cpu_percent" class="table-cell">CPU%</div>\n        <div sortable-th sorter="sorter" column="memory_percent" class="table-cell">MEM%</div>\n        <div class="table-cell hidden-xs hidden-sm">VIRT</div>\n        <div class="table-cell hidden-xs hidden-sm">RES</div>\n        <div class="table-cell">PID</div>\n        <div sortable-th sorter="sorter" column="username" class="table-cell text-left">USER</div>\n        <div class="table-cell">NI</div>\n        <div class="table-cell">S</div>\n        <div sortable-th sorter="sorter" column="timemillis" class="table-cell hidden-xs hidden-sm">TIME+</div>\n        <div sortable-th sorter="sorter" column="io_read" class="table-cell hidden-xs hidden-sm" ng-show="statsProcessList.ioReadWritePresent">IOR/s</div>\n        <div sortable-th sorter="sorter" column="io_write" class="table-cell hidden-xs hidden-sm" ng-show="statsProcessList.ioReadWritePresent">IOW/s</div>\n        <div sortable-th sorter="sorter" column="name" class="table-cell text-left">Command</div>\n    </div>\n    <div class="table-row" ng-repeat="process in statsProcessList.processes | orderBy:sorter.column:sorter.isReverseColumn(sorter.column)">\n        <div class="table-cell" ng-class="statsProcessList.getCpuPercentAlert(process)">{{process.cpu_percent | number:1}}</div>\n        <div class="table-cell" ng-class="statsProcessList.getMemoryPercentAlert(process)">{{process.memory_percent | number:1}}</div>\n        <div class="table-cell hidden-xs hidden-sm">{{process.memvirt | bytes}}</div>\n        <div class="table-cell hidden-xs hidden-sm">{{process.memres | bytes}}</div>\n        <div class="table-cell">{{process.pid}}</div>\n        <div class="table-cell text-left">{{process.username}}</div>\n        <div class="table-cell" ng-class="{nice: process.isNice}">{{process.nice | exclamation}}</div>\n        <div class="table-cell" ng-class="{status: process.status == \'R\'}">{{process.status}}</div>\n        <div class="table-cell hidden-xs hidden-sm">\n            <span ng-show="process.timeplus.hours > 0" class="highlight">{{ process.timeplus.hours }}h</span>{{ process.timeplus.minutes | leftPad:2:\'0\' }}:{{ process.timeplus.seconds | leftPad:2:\'0\' }}<span ng-show="process.timeplus.hours <= 0">.{{ process.timeplus.milliseconds | leftPad:2:\'0\' }}</span>\n        </div>\n        <div class="table-cell hidden-xs hidden-sm" ng-show="statsProcessList.ioReadWritePresent">{{process.ioRead}}</div>\n        <div class="table-cell hidden-xs hidden-sm" ng-show="statsProcessList.ioReadWritePresent">{{process.ioWrite}}</div>\n        <div class="table-cell text-left" ng-show="arguments.process_short_name">{{process.name}}</div>\n        <div class="table-cell text-left" ng-show="!arguments.process_short_name">{{process.cmdline}}</div>\n    </div>\n</div>\n');
$templateCache.put('plugins/quicklook.html','<div class="cpu-name">\n    {{ statsQuicklook.cpu_name }}\n</div>\n<div class="table">\n    <div class="table-row" ng-show="!arguments.percpu">\n        <div class="table-cell text-left">CPU</div>\n        <div class="table-cell">\n            <div class="progress">\n                <div class="progress-bar progress-bar-{{ statsQuicklook.getDecoration(\'cpu\') }}" role="progressbar" aria-valuenow="{{ statsQuicklook.cpu }}" aria-valuemin="0" aria-valuemax="100" style="width: {{ statsQuicklook.cpu }}%;">\n                    &nbsp;\n                </div>\n            </div>\n        </div>\n        <div class="table-cell">\n            {{ statsQuicklook.cpu }}%\n        </div>\n    </div>\n    <div class="table-row" ng-show="arguments.percpu" ng-repeat="percpu in statsQuicklook.percpus">\n        <div class="table-cell text-left">CPU{{ percpu.number }}</div>\n        <div class="table-cell">\n            <div class="progress">\n                <div class="progress-bar progress-bar-{{ statsQuicklook.getDecoration(\'cpu\') }}" role="progressbar" aria-valuenow="{{ percpu.total }}" aria-valuemin="0" aria-valuemax="100" style="width: {{ percpu.total }}%;">\n                    &nbsp;\n                </div>\n            </div>\n        </div>\n        <div class="table-cell">\n            {{ percpu.total }}%\n        </div>\n    </div>\n    <div class="table-row">\n        <div class="table-cell text-left">MEM</div>\n        <div class="table-cell">\n            <div class="progress">\n                <div class="progress-bar progress-bar-{{ statsQuicklook.getDecoration(\'mem\') }}" role="progressbar" aria-valuenow="{{ statsQuicklook.mem }}" aria-valuemin="0" aria-valuemax="100" style="width: {{ statsQuicklook.mem }}%;">\n                    &nbsp;\n                </div>\n            </div>\n        </div>\n        <div class="table-cell">\n            {{ statsQuicklook.mem }}%\n        </div>\n    </div>\n    <div class="table-row">\n        <div class="table-cell text-left">SWAP</div>\n        <div class="table-cell">\n            <div class="progress">\n                <div class="progress-bar progress-bar-{{ statsQuicklook.getDecoration(\'swap\') }}" role="progressbar" aria-valuenow="{{ statsQuicklook.swap }}" aria-valuemin="0" aria-valuemax="100" style="width: {{ statsQuicklook.swap }}%;">\n                    &nbsp;\n                </div>\n            </div>\n        </div>\n        <div class="table-cell">\n            {{ statsQuicklook.swap }}%\n        </div>\n    </div>\n</div>\n');
$templateCache.put('plugins/raid.html','<div class="table-row">\n    <div class="table-cell text-left title">RAID disks</div>\n    <div class="table-cell">Used</div>\n    <div class="table-cell">Total</div>\n</div>\n<div class="table-row" ng-repeat="disk in statsRaid.disks | orderBy:  \'name\'">\n    <div class="table-cell text-left">\n        {{ disk.type | uppercase }} {{ disk.name }}\n        <div class="warning" ng-show="disk.degraded">\u2514\u2500 Degraded mode</div>\n        <div ng-show="disk.degraded"> &nbsp; &nbsp;\u2514\u2500 {{ disk.config }}</div>\n\n        <div class="critical" ng-show="disk.inactive">\u2514\u2500 Status {{ disk.status }}</div>\n        <div ng-show="disk.inactive" ng-repeat="component in disk.components | orderBy:  \'number\'">\n            &nbsp; &nbsp;{{ $last ? \'\u2514\u2500\' : \'\u251C\u2500\' }} disk {{ component.number }}: {{ component.name }}\n        </div>\n    </div>\n    <div class="table-cell" ng-show="!disk.inactive" ng-class="statsRaid.getAlert(disk)">{{ disk.used }}</div>\n    <div class="table-cell" ng-show="!disk.inactive" ng-class="statsRaid.getAlert(disk)">{{ disk.available }}</div>\n</div>');
$templateCache.put('plugins/sensors.html','<div class="table-row">\n    <div class="table-cell text-left title">SENSORS</div>\n</div>\n\n<div class="table-row" ng-repeat="sensor in statsSensors.sensors">\n    <div class="table-cell text-left">{{ sensor.label }}</div>\n    <div class="table-cell">{{ sensor.unit }}</div>\n    <div class="table-cell" ng-class="statsSensors.getAlert(sensor)">{{ sensor.value }}</div>\n</div>\n');
$templateCache.put('plugins/system.html','<span ng-if="is_disconnected" class="critical">Disconnected from</span>\n<span class="title">{{ statsSystem.hostname }}</span>\n<span ng-show="statsSystem.isLinux()" class="hidden-xs hidden-sm">({{ statsSystem.humanReadableName }} / {{ statsSystem.os.name }} {{ statsSystem.os.version }})</span>\n<span ng-show="!statsSystem.isLinux()" class="hidden-xs hidden-sm">({{ statsSystem.os.name }} {{ statsSystem.os.version }} {{ statsSystem.platform }})</span>');
$templateCache.put('plugins/uptime.html','<span>Uptime: {{ statsUptime.uptime }}</span>\n');}]);