#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <pty.h>
#include <gtk/gtk.h>
#include <errno.h>

#include "../config.h"

#include "defines.h"

#include "gksu.h"
#include "xauth.h"
#include "sudo.h"
#include "gui.h"

#define SUDO_PROMPT "GKSUPROMPT"
#define WRONGPASS "\nSorry, try again.\n"

gint
create_cmd (gchar *user, gchar **cmd, gint num_args, 
	    gint current_arg, gchar **args,
	    gboolean keep_env)
{
  gint i = 0, a = 0;
  gint command_starts = 0;

  cmd[i] = g_strdup("/usr/bin/sudo"); i++;
  cmd[i] = g_strdup("-u"); i++;
  cmd[i] = g_strdup(user); i++;
  cmd[i] = g_strdup("-S"); i++;
  cmd[i] = g_strdup("-p"); i++;
  cmd[i] = g_strdup(SUDO_PROMPT); i++;
  if (!keep_env)
    {
      cmd[i] = g_strdup("-H"); i++;
      cmd[i] = g_strdup("--"); i++; /* sudo will only accept
				       this flag when using -H... bug?
				    */
    }
  
  /* defines where the command is on cmd[] */
  command_starts = i;

  for (a = current_arg ; a < num_args ; a++)
    {
      cmd[i] = g_strdup (args[a]);
      i++;
    }

  cmd[i] = NULL;

  return command_starts;
}

void
clean_cmd (gchar **cmd)
{
  int i = 0;

  for (i = 0 ; cmd[i] != NULL ; i++)
    g_free (cmd[i]);
  g_free(cmd);
}


int
sudo_do (gchar *dir, gchar *message, gchar *user, 
	 gchar **cmd, gint cmd_starts)
{
  int fdin[2];
  int fdout[2];
  int fderr[2];
  fd_set efd;
  struct timeval tv;
  pid_t pid;
  pid_t pid_gc;
  int status;
  gchar *password = NULL;
  gchar *pass = NULL;

  if (pipe(fdin) || pipe(fdout) || pipe(fderr))
    {
      gk_dialog (strerror(errno));
      return 1;
    }

  pid = fork ();
  if (pid == 0)
    { /* child */

      pid_gc = fork ();
      if (pid_gc == 0)
	{ /* grandchild */
	  close (fileno(stdin));
	  dup(fdin[0]); /* 0 == read */
	  close (fdin[0]);
	  close (fdin[1]);

	  close (fileno(stdout));
	  dup(fdout[1]);
	  close (fdout[0]);
	  close (fdout[1]);

	  close (fileno(stderr));
	  dup(fderr[1]);
	  close (fderr[0]);
	  close (fderr[1]);

	  /* executes the command */
	  if (execv (cmd[0], cmd) == -1)
	    {
	      gk_dialog (_("Unable to run /usr/bin/sudo: %s"),
			   strerror(errno));
	    }
	  clean_cmd (cmd);
	}
      else if (pid_gc == -1)
	{
	  gk_dialog (strerror(errno));
	  return 1;
	}
      else
	{ /* grandchild's parent */
	  gchar buf[256];

	  close (fdin[0]);
	  close (fdout[1]);
	  close (fderr[1]);

	  /* so that read() won't block */
	  if ((fcntl (fderr[0], F_SETFL, O_NONBLOCK) == -1) ||
	      (fcntl (fdout[0], F_SETFL, O_NONBLOCK) == -1))
	  {
	    gk_dialog (_("An error happened, your program\n"
			 "may be blocked:\n%s"), strerror(errno));
	  }

	  bzero (buf, 256);

	  while (!waitpid (pid_gc, &status, WNOHANG))
	    {
	      tv.tv_sec = 0;
	      tv.tv_usec = 100;
	      /* just to wait sometime... not meaninfull */
	      select (0, NULL, NULL, NULL, &tv);
	      read (fderr[0], buf, 255);
	      fprintf (stderr, buf);
	      bzero(buf, 256);
	      read (fdout[0], buf, 255);
	      fprintf (stdout, buf);
	      bzero(buf, 256);
	    }

	  clean_dir (dir);

	  if (WIFEXITED(status))
	    {
	      if (WEXITSTATUS(status))
		{
		  gk_dialog (_("Child terminated with %d status"),
			     WEXITSTATUS(status));
		  return 1;
		}
	    }
	}
    }
  else if (pid == -1)
    {
      gk_dialog (strerror(errno));
      return 1;
    }
  else
    { /* parent */
      char buf[256];
      int r;

      close (fdin[0]);
      close (fdout[1]);
      close (fderr[1]);

      bzero (buf, 256); /* zero the buffer */

      r = read (fderr[0], buf, 256);

      if (!strcmp(buf, SUDO_PROMPT)) /* do we need passwd? */
	{
	  if (message == NULL)
	    password = ask_password (_("I need your password to run:\n"
				       "%s as %s"), cmd[cmd_starts], user);
	  else
	    password = ask_password (message);
	  
	  if (password == NULL) /* if password is NULL we let sudo go */
	      password = g_malloc0 (sizeof(char)); 

	  /* we cannot pass 'password' as it has no \n */
	  pass = g_strdup_printf ("%s\n", password);
	  write (fdin[1], pass, strlen(pass));

	  free_pass (pass);
	  free_pass (password);

	  tv.tv_sec = 4;
	  tv.tv_usec = 0;
	  select (1, &efd, NULL, NULL, &tv);
	  if (read (fderr[0], buf, 256))
	    { /* if passwd failed, give sudo an "enter" */
	      if (!strncmp (buf, WRONGPASS, strlen(WRONGPASS)))
		{
		  write (fdin[1], "\n", 1); 
		  wait(NULL);
		  gk_dialog (_("Wrong password, try again."));
		  return 1;
		}
	      else if (!strncmp (buf, "/usr/bin/sudo:", 14)) 
		{ /* an error, probably? */
		  gk_dialog (buf);
		  wait (NULL);
		  return 1;
		}
	    }
	}
      else if (!strncmp (buf, "/usr/bin/sudo:", 14)) /* an error, probably? */
	{
	  gk_dialog (buf);
	  wait (NULL);
	  return 1;
	}

    }

  return 0;
}
