#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <pty.h>
#include <gtk/gtk.h>

#include "../config.h"

#include "defines.h"

#include "gksu.h"
#include "xauth.h"
#include "su.h"
#include "gui.h"

int
su_do (gchar *dir, gchar *message, gchar *user, gchar *command, 
       gboolean login_shell, gboolean keep_env)
{
  int i = 0;
  int fdpty;
  int fdio[2];
  pid_t pid;
  pid_t pid_gc;
  gchar *password = NULL;
  gchar *pass = NULL;

  pipe (fdio);

  pid = fork ();
  if (pid == 0)
    {
      pid_gc = forkpty (&fdpty, NULL, NULL, NULL);
      if (pid_gc == 0)
	{
	  gchar **cmd = g_malloc (sizeof(gchar*)*7);

	  cmd[i] = g_strdup("/bin/su"); i++;
	  if (login_shell)
	    {
	      cmd[i] = g_strdup("-"); i++;
	    }
	  cmd[i] = g_strdup(user); i++;
	  if (keep_env)
	    {
	      cmd[i] = g_strdup("-p"); i++;
	    }
	  cmd[i] = g_strdup("-c"); i++;
	  cmd[i] = g_strdup(command); i++;
	  cmd[i] = NULL;

	  /* executes the command */
	  if (execv (cmd[0], cmd) == -1)
	    {
	      gk_dialog (_("Unable to run /bin/su: %s"),
			 strerror(errno));
	    }

	  for (i = 0 ; cmd[i] != NULL ; i++)
	    g_free (cmd[i]);
	  g_free(cmd);
	}
      else if (pid_gc == -1)
	{
	  gk_dialog (strerror(errno));
	  return 1;
	}
      else
	{
	  fd_set wfds;
	  struct timeval tv;
	  char buf[256];
	  int status;

	  while (!read (fdpty, buf, 256));
      
	  FD_ZERO(&wfds);
	  FD_SET(fdpty, &wfds);

	  tv.tv_sec = 2;
	  tv.tv_usec = 0;

	  /* ask for password */
	  if (message == NULL)
	    password = ask_password (_("I need %s's password to run:\n"
				       "%s."), user, command);
	  else
	    password = ask_password (message);

	  if (password == NULL)
	    return 1;

	  /* we cannot pass 'password' as it has no \n */
	  pass = g_strdup_printf ("%s\n", password);
	  select (1, &wfds, NULL, NULL, &tv);
	  write (fdpty, pass, strlen(pass));

	  /* cleans the memory */
	  free_pass (pass);
	  free_pass (password); 

	  /* tell the grandparent the password has been given */
	  close (fdio[0]);
	  write (fdio[1], "done", strlen ("done"));

	  if ((fcntl (fdpty, F_SETFL, O_NONBLOCK) == -1))
	    {
	      gk_dialog (_("An error happened, your program\n"
			   "may be blocked:\n%s"), strerror(errno));
	    }

	  while (!waitpid (pid_gc, &status, WNOHANG))
	    {
	      tv.tv_sec = 0;
	      tv.tv_usec = 100;
	      bzero(buf, 256);
	      select (0, NULL, NULL, NULL, &tv);
	      read (fdpty, buf, 255);
	      fprintf (stderr, buf);
	    }

	  clean_dir (dir);

	  if (WIFEXITED(status))
	    {
	      if (WEXITSTATUS(status))
		{
		  gk_dialog (_("Child terminated with %d status"),
			     WEXITSTATUS(status));
		  return 1;
		}
	    }
	}
    }
  else if (pid == -1)
    {
      gk_dialog (strerror(errno));
      return 1;
    }
  else
    { /* if we don't block the program quits 
       but this shall not last forever */
      char buf[5];
      
      close (fdio[1]);
      read(fdio[0], buf, 5);
    }

  return 0;
}
