#include <stdio.h>
#include <stdarg.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <X11/Xlib.h>

#include "defines.h"

#include "gksu.h"
#include "pixmaps.h"
#include "gui.h"

void 
ask_pass_ok_cb (GtkWidget *w, gpointer data)
{
  gtk_main_quit ();
}

void 
ask_pass_cancel_cb (GtkWidget *w, gpointer data)
{
  gchar *pass = (gchar*)data;

  free_pass (pass);

  XUngrabServer(GDK_DISPLAY());
  gdk_pointer_ungrab(GDK_CURRENT_TIME);
  gdk_keyboard_ungrab(GDK_CURRENT_TIME);
  gdk_flush();
  exit (0);
}

gchar*
ask_password (gchar *format, ...)
{
  gchar *pass = NULL;
	
  GtkWidget
    *dialog, 
    *table,
    *entry, 
    *label,
    *button_box,
    *button_ok,
    *button_cancel;

  va_list ap;
  gchar *msg;

  va_start(ap, format);
  msg = g_strdup_vprintf(format, ap);
  va_end(ap);

  /* dialog window */
  dialog = gtk_window_new(GTK_WINDOW_DIALOG);
  gtk_window_set_title (GTK_WINDOW(dialog), "GKsu");
  gtk_signal_connect (GTK_OBJECT(dialog), "delete_event",
		      GTK_SIGNAL_FUNC(ask_pass_cancel_cb),
		      pass);
  gtk_container_set_border_width (GTK_CONTAINER(dialog), 6);
  /* Center window and prepare for grab */
  gtk_object_set(GTK_OBJECT(dialog), "type", GTK_WINDOW_POPUP, NULL);
  gtk_window_set_position (GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);
  gtk_window_set_policy(GTK_WINDOW(dialog), FALSE, FALSE, TRUE);

  /* table */
  table = gtk_table_new (3, 2, FALSE);
  gtk_container_add (GTK_CONTAINER(dialog), table);
  gtk_container_set_border_width (GTK_CONTAINER(table), 6);
  gtk_widget_show (table);

  /* label */
  label = gtk_label_new (msg);
  g_free (msg);

  gtk_table_attach (GTK_TABLE(table), label, 0, 2, 0, 1,
		    GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 4);
  gtk_widget_show (label);

  /* entry */
  entry = gtk_entry_new();
  gtk_signal_connect (GTK_OBJECT(entry), "activate",
		      GTK_SIGNAL_FUNC(ask_pass_ok_cb),
		      NULL);
  gtk_entry_set_visibility(GTK_ENTRY(entry), FALSE);
  gtk_table_attach (GTK_TABLE(table), entry, 0, 2, 1, 2,
		    GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 4);
  gtk_widget_show (entry);

  /* ok button */
  button_ok = gtk_button_new ();
  button_box = create_image_label_box (dialog, OK_XPM);
  gtk_container_add (GTK_CONTAINER(button_ok), button_box);
  gtk_signal_connect (GTK_OBJECT(button_ok), "clicked",
		      GTK_SIGNAL_FUNC(ask_pass_ok_cb),
		      NULL);
  gtk_table_attach (GTK_TABLE(table), button_ok, 0, 1, 2, 3,
		    GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 4);
  gtk_widget_show (button_ok);

  /* cancel button */
  button_cancel = gtk_button_new ();
  button_box = create_image_label_box (dialog, CANCEL_XPM);
  gtk_container_add (GTK_CONTAINER(button_cancel), button_box);
  gtk_signal_connect (GTK_OBJECT(button_cancel), "clicked",
		      GTK_SIGNAL_FUNC(ask_pass_cancel_cb),
		      pass);
  gtk_table_attach (GTK_TABLE(table), button_cancel, 1, 2, 2, 3,
		    GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 4);
  gtk_widget_show (button_cancel);
  
  gtk_widget_grab_focus(entry);

  gtk_widget_show (dialog);

  /* Grab focus */
  XGrabServer(GDK_DISPLAY());
  if (gdk_pointer_grab(dialog->window, TRUE, 0, NULL, NULL, 
		       GDK_CURRENT_TIME))
    {
      gdk_pointer_ungrab(GDK_CURRENT_TIME);
      gtk_widget_hide (dialog);
      report_failed_grab ();
      return NULL;
    }
  if (gdk_keyboard_grab(dialog->window, FALSE, GDK_CURRENT_TIME))
    {
      gdk_pointer_ungrab(GDK_CURRENT_TIME);
      XUngrabServer(GDK_DISPLAY());
      gtk_widget_hide (dialog);
      report_failed_grab ();
      return NULL;
    }

  /* let the magic begin */
  gtk_main ();

  /* Ungrab */
  XUngrabServer(GDK_DISPLAY());
  gdk_pointer_ungrab(GDK_CURRENT_TIME);
  gdk_keyboard_ungrab(GDK_CURRENT_TIME);
  gdk_flush();

  /* Report passphrase if user selected OK */
  pass = gtk_entry_get_text(GTK_ENTRY(entry));
		
  /* Kill the entry's copy of the passphrase. */
  gtk_entry_set_text(GTK_ENTRY(entry), "");
			
  gtk_widget_hide (dialog);

  while (gtk_events_pending())
    gtk_main_iteration();

  return pass;
}

/*
  Returns a hbox with a pixmap and a label for a button
*/
GtkWidget*
create_image_label_box (GtkWidget *win, int type)
{
  GtkWidget *pix_win;
  GdkPixmap *pix;
  GdkColormap *colormap;
  GdkBitmap *mask;
  GtkStyle *style;
  gchar **pixmap_data = NULL;

  GtkWidget *label;
  gchar *label_msg = NULL;

  GtkWidget *hbox;

  switch (type)
    {
    case OK_XPM:
      pixmap_data = ok_xpm;
      label_msg = g_strdup (_("OK"));
      break;
    case CANCEL_XPM:
      pixmap_data = cancel_xpm;
      label_msg = g_strdup (_("Cancel"));
      break;
    default:
      printf ("Shouldn't happen");
    }

  /* pixmap */
  style = gtk_widget_get_style (win);
  colormap = gtk_widget_get_colormap(win);
  pix = gdk_pixmap_colormap_create_from_xpm_d (NULL, colormap, &mask,
					      NULL, pixmap_data);
  pix_win = gtk_pixmap_new (pix, mask);
  gtk_widget_show (pix_win);

  /* label */
  label = gtk_label_new (label_msg);
  g_free (label_msg);
  gtk_widget_show (label);

  /* box */
  hbox = gtk_hbox_new (FALSE, 1);
  gtk_widget_show (hbox);

  /* packing */
  gtk_box_pack_start (GTK_BOX(hbox), pix_win,
		      FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX(hbox), label,
		      FALSE, FALSE, 3);

  return hbox;
}

void
report_failed_grab (void)
{
  gk_dialog (_("Could not grab keyboard or mouse.\n"
	       "A malicious client may be eavesdropping\n"
	       "on your session."));
}

/* 
   Shows 'msg' in a dialog box with an OK button 
   This function is to be a helper for functions needing to
   display some information to the user
*/
void 
gk_dialog (gchar *format, ...)
{
  GtkWidget *diag_win;
  GtkWidget *diag_frame;
  GtkWidget *diag_table;
  GtkWidget *diag_label;
  GtkWidget *button_ok;
  GtkWidget *button_box;

  va_list ap;
  gchar *msg;

  va_start(ap, format);
  msg = g_strdup_vprintf(format, ap);
  va_end(ap);

  diag_win = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_window_set_title (GTK_WINDOW(diag_win), "GkSu");
  gtk_signal_connect_object (GTK_OBJECT(diag_win), "delete_event",
			     GTK_SIGNAL_FUNC(gtk_main_quit), 
			     NULL);
  gtk_container_set_border_width (GTK_CONTAINER(diag_win), 3);
  gtk_window_set_position (GTK_WINDOW(diag_win), GTK_WIN_POS_CENTER);
  gtk_window_set_policy(GTK_WINDOW(diag_win), FALSE, FALSE, TRUE);

  diag_frame = gtk_frame_new (NULL);
  gtk_container_set_border_width (GTK_CONTAINER(diag_frame), 3);
  gtk_container_add (GTK_CONTAINER(diag_win), diag_frame);
  gtk_widget_show (diag_frame);

  button_ok = gtk_button_new ();
  button_box = create_image_label_box (diag_win, OK_XPM);
  gtk_container_add (GTK_CONTAINER(button_ok), button_box);

  gtk_signal_connect_object (GTK_OBJECT(button_ok), "clicked",
			     GTK_SIGNAL_FUNC(gtk_main_quit), 
			     NULL);

  diag_label = gtk_label_new (msg);
  gtk_label_set_justify (GTK_LABEL(diag_label), GTK_JUSTIFY_LEFT);

  diag_table = gtk_table_new (2, 1, FALSE);
  gtk_container_add (GTK_CONTAINER(diag_frame), diag_table);

  gtk_table_attach (GTK_TABLE(diag_table), diag_label, 0, 1, 0, 1, 
		    GTK_FILL, GTK_EXPAND, 4, 4);
  gtk_table_attach (GTK_TABLE(diag_table), button_ok, 0, 1, 1, 2,
		    GTK_FILL, GTK_EXPAND, 4, 4);

  gtk_widget_show (button_ok);
  gtk_widget_show (diag_label);
  gtk_widget_show (diag_table);
  gtk_widget_show (diag_win);

  g_free (msg);

  gtk_main ();

  gtk_widget_destroy (diag_win);
}
