/* GKrellMSS - GKrellM Sound Scope
|  Copyright (C) 2001 Bill Wilson
|
|  Author:  Bill Wilson    bill@gkrellm.net
|
|  This program is free software which I release under the GNU General Public
|  License. You may redistribute and/or modify this program under the terms
|  of that license as published by the Free Software Foundation; either
|  version 2 of the License, or (at your option) any later version.
|
|  This program is distributed in the hope that it will be useful,
|  but WITHOUT ANY WARRANTY; without even the implied warranty of
|  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|  GNU General Public License for more details.
| 
|  To get a copy of the GNU General Puplic License, write to the Free Software
|  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "gkrellmss.h"

/* The format of the esd data to monitor.  STEREO is interleaved channels */
#define SOUND_FORMAT (ESD_BITS16 | ESD_STEREO | ESD_STREAM | ESD_PLAY)
#define SOUND_RATE	44100


static void
sound_peak_values(void)
	{
	SoundSample	*ss;
	short		l, r;
	int			i;

	sound->left_value = 0;
	sound->right_value = 0;
	ss = sound->buffer;
	for (i = 0; i < sound->buf_count; ++i)
		{
		l = ss[i].left;
		r = ss[i].right;
		l = abs(l);
		r = abs(r);
		if (l > sound->left_value)
			sound->left_value = l;
		if (r > sound->right_value)
			sound->right_value = r;
		}
	/* Multiply by 1/sqrt(2) so VU meter krells approximate RMS voltage
	*/
	sound->left_value = sound->left_value * 707 / 1000;
	sound->right_value = sound->right_value * 707 / 1000;
	}


static void
sound_input_read(gpointer data, gint source, GdkInputCondition condition)
	{
	gint	count;

	count = sound->buf_len * sizeof(SoundSample);
	sound->buf_count = read(source, sound->buffer, count);
	if (sound->buf_count <= 0)
		{
		sound_close_stream();
		return;
		}
	sound->buf_count /= sizeof(SoundSample);
	sound_peak_values();
	if (oscope->x_append)
		{
		oscope_trace(CHANNEL_LR);
		gkrellm_draw_chart_to_screen(chart);
		}
	sound->streaming = TRUE;
	}

SoundStatus
sound_status(gchar *host)
	{
	esd_standby_mode_t	mode;
	SoundStatus			status = Error;
	gint				fd;

	if ((fd = esd_open_sound(host)) < 0)
		return Unavailable;
	mode = esd_get_standby_mode(fd);
	esd_close(fd);
	if (mode == ESM_ON_STANDBY)
		status = Standby;
	else if (mode == ESM_ON_AUTOSTANDBY)
		status = AutoStandby;
	else if (mode == ESM_RUNNING)
		status = Running;
	return status;
	}

void
sound_open_stream(gchar *host)
	{
	sound->buf_len = N_SAMPLES;
	if (!sound->buffer)
		sound->buffer = g_new0(SoundSample, sound->buf_len);
	sound->fd = esd_monitor_stream(SOUND_FORMAT, SOUND_RATE, host,"gkrellmss");
	if (sound->fd < 0)
		{
		sound_close_stream();
		return;
		}
	sound->input_id = gdk_input_add(sound->fd, GDK_INPUT_READ,
						(GdkInputFunction) sound_input_read, NULL);
	}

void
sound_close_stream(void)
	{
	if (sound->fd >= 0)
		esd_close(sound->fd);
	sound->fd = -1;
	if (sound->input_id)
		gdk_input_remove(sound->input_id);
	sound->input_id = 0;

	sound->buf_count = 0;
	sound->buf_index = 0;
	oscope->x_append = oscope->y_append = 0;
	sound->status = Unavailable;
	}
