#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <signal.h>
#include <errno.h>

#include <linux/if.h>
#include <linux/ppp_defs.h>
#include <linux/ppp.h>

#include <time.h>
#include <ctype.h>
#include <fcntl.h>

#include "defines.h"
#include "gui.h"

#ifdef HAVE_GNOME
#include "applet.h"

extern guint is_applet;
extern GtkWidget *btn;
extern GtkWidget *btn_on_off;
extern GtkTooltips *time_tip;
extern GtkTooltips *inout_tip;

#endif

extern int ip_socket;
extern char lock_file[FILENAME_MAX];
extern GtkWidget *t_label;

extern GtkWidget *in_label;
extern GtkWidget *in_pix;
extern GtkWidget *out_label;
extern GtkWidget *out_pix;
extern GdkPixmap *in_out_on, *in_out_off;
extern GdkBitmap *in_out_mask;

/* 
   This function was *stolen* from modemlights[1] applet
   and modified, it is a better way to check wether we're
   connected or connecting and can be used on getting
   some information...
   
   [1] writen by John Ellis <johne@bellatlantic.net> and
   part of gnome-applets
*/
int get_stats (int *in, int *out)
{
  struct ifreq ifreq;
  struct ppp_stats stats;
  char device_name[] = "ppp0";


  memset(&ifreq, 0, sizeof(ifreq));
  strncpy(ifreq.ifr_name, device_name, IFNAMSIZ);
  ifreq.ifr_ifru.ifru_data = (caddr_t)&stats;
  
#ifdef SIOCGPPPSTATS
  if (ioctl(ip_socket, SIOCGPPPSTATS, (caddr_t)&ifreq) < 0)
#else
    if (TRUE)
#endif
      {
	/* failure means ppp is not up */
	*in = *out = 0;
	return FALSE;
      }
    else
      {
	*in = stats.p.ppp_ibytes;
	*out = stats.p.ppp_obytes;
	return TRUE;
      }
  
  return 0;
  
}

/*
  This function also comes from modemlights_applet
*/
int get_connect_time(int recalc_start)
{
  static time_t start_time = (time_t)0;
  struct stat st;

  if (recalc_start)
    {
      if (stat (lock_file, &st) == 0)
	start_time = st.st_mtime;
      else
	start_time = (time_t)0;
    }

  if (start_time != (time_t)0)
    return (int)(time(0) - start_time);
  else
    return -1;
}

/* updates connection time */
void update_ctime ()
{
  gchar *text;
  int t;
  int h, m, s;
  
  t = get_connect_time(FALSE);

  if (t != -1)
    {
      h = t / 3600;
      m = (t - (h * 3600)) / 60;
      s = (t - (h * 3600)) % 60;
    }
  else
    {
      h = m = s = 0;
    }
  
  text = g_strdup_printf(_("Time: %.2d:%.2d:%.2d"),
			 h, m, s);
  gtk_label_set_text (GTK_LABEL(t_label), text);

#ifdef HAVE_GNOME
  if (is_applet)
    {
      static int updates;

      if (updates < 5)
	updates++;
      else
	{
	  updates = 0;
	  gtk_tooltips_set_tip (GTK_TOOLTIPS(inout_tip), btn_on_off,
				text, NULL);
	}
    }
#endif

  g_free(text);
}

void
set_in_out (int in, int out)
{
  if (in)
    gtk_pixmap_set (GTK_PIXMAP(in_pix), in_out_on, in_out_mask);
  else
    gtk_pixmap_set (GTK_PIXMAP(in_pix), in_out_off, in_out_mask);

  if (out)
    gtk_pixmap_set (GTK_PIXMAP(out_pix), in_out_on, in_out_mask);
  else
    gtk_pixmap_set (GTK_PIXMAP(out_pix), in_out_off, in_out_mask);
}

void
update_bps (int in, int out)
{
  static int last_in = 0;
  static int last_out = 0;

  static int total_in = 0;
  static int total_out = 0;

  char unit = 'B';

  gchar *text;

  last_in = in;
  last_out = out;

  total_in += in;
  total_out += out;

  if (in > 1024)
    {
      in = in / 1024;
      unit = 'K';
    }

  text = g_strdup_printf (_("In: %d %c/s"), in, unit);
  gtk_label_set_text (GTK_LABEL(in_label), text);
  g_free (text);

  if (out > 1024)
    {
      out = out / 1024;
      unit = 'K';
    }
  else
    unit = 'B';

  text = g_strdup_printf (_("Out: %d %c/s"), out, unit);
  gtk_label_set_text (GTK_LABEL(out_label), text);
  g_free (text);

#ifdef HAVE_GNOME
  if (is_applet)
    {
      int in_mb, in_kb;
      int out_mb, out_kb;
      
      static int updates = 0;
      char *text_tip;

      in_mb = total_in / (1024*1024);
      in_kb = (total_in % (1024*1024)) / 1024;
      out_mb = total_out / (1024*1024);
      out_kb = (total_out % (1024*1024))/1024;

      if (updates < 5)
	{
	  updates++;
	}
      else
	{
	  updates = 0;
	  
	  text_tip = g_strdup_printf (_("In: %d M %d K / Out: %d M %d K"),
				      in_mb, in_kb, out_mb, out_kb);
	  gtk_tooltips_set_tip (GTK_TOOLTIPS(inout_tip), btn,
				text_tip, NULL);
	  g_free (text_tip);
	}
    }
#endif
}

/*
  stolen from modemlights applet, to check whether
  the connection is up more reliabily
*/
int 
is_connected (void)
{
  FILE *f = 0;
  gchar buf[64];
  pid_t pid = -1;

  f = fopen(lock_file, "r");

  if(!f) return FALSE;

  if (fgets(buf, sizeof(buf), f) == NULL)
	{
	  fclose(f);
	  return FALSE;
	}
  fclose(f);

  pid = (pid_t)strtol(buf, NULL, 10);
  if (pid < 1 || (kill (pid, 0) == -1 && errno != EPERM)) return FALSE;

  return TRUE;
}
