/*
 * GImageView
 * Copyright (C) 2001 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __THUMBNAIL_SUPPORT_H__
#define __THUMBNAIL_SUPPORT_H__

#include "gimv_image.h"

#define CACHE_GIMV_MIN_SIZE 4
#define CACHE_GIMV_MAX_SIZE 640

typedef enum
{
   NONE,
   GIMAGEVIEW,
   NAUTILUS,
   KONQUEROR_L,
   KONQUEROR_M,
   KONQUEROR_S,
   GQVIEW,
   EE_L,
   EE_M,
   EE_S,
   XVPIC,
   PICVIEW_L,
   PICVIEW_M
} ThumbCacheType;

typedef enum
{
   FixNULL,
   FixMax,
   FixWidth,
   FixHeight,
   FixBoth
} ThumbSizeType;

typedef gboolean (*CacheLoadCheckFunc) (gpointer data);

typedef struct _ThumbTypePrefs
{
   gchar              *label;
   gint                width;
   gint                height;
   ThumbSizeType       type;
   gchar              *path;
   gchar              *suffix;
   CacheLoadCheckFunc  load_check;
} ThumbTypePrefs;

/*  FIXME!! */
typedef struct _GQViewThumbsize
{
   gint width;
   gint height;
} GQViewThumbSize;
/* END FIXME!! */


GimvImage     *thumbsupport_load_thumbnail_cache (const gchar *filename,
						  ThumbCacheType type);
gboolean       thumbsupport_save_thumbnail_cache (const gchar *filename,
						  GimvImage *image,
						  ThumbCacheType type);
gchar         *thumbsupport_get_thumb_cache_path (const gchar *filename,
						  ThumbCacheType type);
gint           thumbsupport_get_thumb_cache_size (ThumbCacheType type,
						  gint *width_ret,
						   gint *height_ret,
						  ThumbSizeType *type_ret);

extern const gchar    *cache_write_items[];
extern ThumbTypePrefs  thumb_prefs [];
extern const gint      thumb_prefs_num;

#endif /* __THUMBNAIL_SUPPORT_H__ */
