/*
 * GImageView
 * Copyright (C) 2001 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __IMAGE_WINDOW_H__
#define __IMAGE_WINDOW_H__

#include "gimageview.h"
#include "fileload.h"
#include "gimv_image.h"
#include "image_view.h"
#include "thumbnail_window.h"


typedef struct SlideShow_Tag
{
   ImageWindow *iw;
   GList *filelist;
   GList *pos;
   gboolean repeat;
   gboolean running;
} SlideShow;


struct ImageWindow_Tag
{
   GtkWidget       *window;
   GtkWidget       *menubar_handle;
   GtkWidget       *menubar;
   GtkWidget       *toolbar_handle;
   GtkWidget       *toolbar;
   struct    /* buttons in toolbar */
   {
      GtkWidget *fileopen;
      GtkWidget *prefs;
      GtkWidget *xscale;
      GtkWidget *yscale;
   } button;
   GtkWidget       *main_vbox;  /* Image Container */ 

   GtkWidget       *status_bar_container;
   GtkWidget       *status_bar1;
   GtkWidget       *status_bar2;

   /* sub menus */
   GtkWidget       *view_menu;
   GtkWidget       *zoom_menu;
   GtkWidget       *rotate_menu;

   /* flags */
   gboolean         show_menubar;
   gboolean         show_toolbar;
   gboolean         show_statusbar;
   gboolean         show_scrollbar;

   /* window geometory */
   gboolean         fullscreen;
   gint             win_x;
   gint             win_y;
   gint             win_width;
   gint             win_height;

   /* Image View */
   ImageView       *iv;

   /* informatin about slide show */
   SlideShow       *slideshow;
};

extern GList *ImageWinList;

extern ImageWindow *shared_img_win;


void         imagewin_exec_slideshow    (SlideShow   *slideshow);

void         imagewin_change_image_file (ImageWindow *iw,
					 const gchar *newfile);
ImageWindow *imagewin_initialize        (const gchar *filename);
gboolean     imagewin_create_window     (ImageWindow *iw);
ImageWindow *imagewin_open_window       (const gchar *filename);

#endif /* __IMAGE_WINDOW_H__ */
