/*
 * $Id: tx_layer.h,v 1.2 2003/09/17 17:44:11 hipnod Exp $
 *
 * Copyright (C) 2003 giFT project (gift.sourceforge.net)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */

#ifndef GIFT_GT_TX_LAYER_H_
#define GIFT_GT_TX_LAYER_H_

/*****************************************************************************/

struct tx_layer_ops;
struct tx_layer;

struct io_buf;
struct gt_tx_stack;

struct tx_layer_ops
{
	BOOL (*init)    (struct tx_layer *tx);
	void (*destroy) (struct tx_layer *tx);
	void (*enable)  (struct tx_layer *tx);
	void (*disable) (struct tx_layer *tx);
	void (*send)    (struct tx_layer *tx, struct io_buf *io_buf);
};

struct tx_layer
{
	const char          *name;
	void                *udata;
	struct tx_layer_ops *ops;

	struct tx_layer     *upper;
	struct tx_layer     *lower;

	struct gt_tx_stack  *stack;
};

/*****************************************************************************/

struct tx_layer *tx_layer_new      (struct gt_tx_stack *stack, 
                                    const char *name, struct tx_layer_ops *ops);
void             tx_layer_free     (struct tx_layer *layer);

void             tx_layer_enable   (struct tx_layer *layer);
void             tx_layer_disable  (struct tx_layer *layer);

void             tx_layer_send     (struct tx_layer *layer, struct io_buf *buf);

/*****************************************************************************/

#endif /* GIFT_GT_TX_LAYER_H_ */
