// OGLVIEW_WCL.H : write a short description here...

// Copyright (C) 2005 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "ghemicalconfig2.h"

#ifndef OGLVIEW_WCL_H
#define OGLVIEW_WCL_H

class oglview_wcl;

#include <oglappth/base_wcl.h>

#include "project.h"
#include "custom_camera.h"

#include <ghemical/typedef.h>

/*################################################################################################*/

class oglview_wcl :
	public base_wcl
{
	protected:
	
	custom_camera * ccam;
	i32s my_wnd_number;
	
	i32s render; i32s label;
	color_mode * colormode;
	
	iGLu * select_buffer;
	
	bool enable_fog;
	bool accumulate;
	
	static bool quick_update;	// some static flags...
	static bool draw_info;		// some static flags...
	
	float animX;
	float animY;
	
	friend class custom_camera;
	friend class project;
	
	friend class gtk_app;
	friend class gtk_project;
	friend class gtk_oglview_wnd;	// timer + ???
	
	friend class w32_app;
	friend class w32_project;
	friend class w32_oglview_wnd;	// ???
	friend class w32_wnd;		// timer
	
	public:
	
	enum pmode { DoNotPick = 0, pDraw = 1, pErase = 2, pSelect = 3, pMeasure = 4 };
	
	oglview_wcl(custom_camera *);
	virtual ~oglview_wcl(void);
	
	custom_camera * GetCCam(void);
	
	void GetCRD(i32s *, fGL *);
	
	void ButtonEvent(int, int);		// virtual
	void MotionEvent(int, int);		// virtual
	
	void UpdateWnd(void);			// virtual
	
// here we sometimes need to pass extra parameters to UpdateWnd().
// but UpdateWnd() is defined at liboglappth and so it should be as
// universal as possible -> make a separate method with extra params.
	
	void MyUpdateWnd(pmode = DoNotPick, int = 0, int = 0);
	
	void InitGL(void);			// virtual
	void RenderGL(rmode);			// virtual
};

/*################################################################################################*/

#endif	// OGLVIEW_WCL_H

// eof
