// GPCVIEW_WCL.CPP

// Copyright (C) 2006 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "gpcview_wcl.h"

/*################################################################################################*/

gpcview_wcl::gpcview_wcl(void) :
	base_wcl(new ogl_camera(ogl_ol_static(), 1.0))
{
}

gpcview_wcl::~gpcview_wcl(void)
{
	// problem : lifetime of the camera object needs to be longer than
	// lifetime of this object since it is needed at the base class dtor.
	// solution : ask the base class to do the cleanup work for us...
	
	delete_cam_plz = true;
}

void gpcview_wcl::ButtonEvent(int, int)
{
}

void gpcview_wcl::MotionEvent(int, int)
{
}

void gpcview_wcl::UpdateWnd(void)
{
	base_wnd * wnd = GetWnd();
	if (!wnd || wnd->GetWidth() < 0 || !cam) return;
	
	wnd->SetCurrent();
	cam->RenderScene(wnd, false, false);
}

void gpcview_wcl::InitGL(void)
{
}

void gpcview_wcl::RenderGL(rmode)
{
}

/*################################################################################################*/

// eof
