/********************************************************************************************
	Clean OS Windows library module version 1.2.1.
	This module is part of the Clean Object I/O library, version 1.2.1,
	for the Windows platform.
********************************************************************************************/

/********************************************************************************************
	About this module:
	Routines related to window/dialog handling.
********************************************************************************************/

#include "cCrossCallWindows_121.h"
#include "cCCallWindows_121.h"
#include "cCCallSystem_121.h"
#include "cCrossCallCursor_121.h"
#include "cCrossCall_121.h"
#include "cCrossCallxDI_121.h"
#include <gdk/gdkkeysyms.h>

/*	Global data:
*/
//static PAINTSTRUCT gPaintStruct;
//static LONG stdEditCallback      = 0;			/* The standard internal Windows callback routine of edit controls. */
//static LONG stdPopUpCallback     = 0;			/* The standard internal Windows callback routine of pop up controls. */

//HWND ghCaretWnd = NULL;


/*	Registered Windows class names:
*/
//static char CustomControlClassName[]   = "__CleanCustomControl";	/* Class for CustomControls */
//static char CompoundControlClassName[] = "__CleanCompoundControl";	/* Class for CompoundControls */


/*	Local window data structures:
*/
//struct LocalWindowData
//{
//	int  lwd_cursorcode;		/* The cursor shape of the window */
//	BOOL lwd_usersizemoving;	/* The user is sizing/moving the window */
//};

//typedef struct LocalWindowData *LocalWindowData;

//static LocalWindowData AllocateLocalWindowData (void)
//{
//	LocalWindowData lwd_wdata;

//
//	lwd_wdata = (LocalWindowData) rmalloc (sizeof (struct LocalWindowData));
//	lwd_wdata->lwd_cursorcode     = 0;
//	lwd_wdata->lwd_usersizemoving = (BOOL)FALSE;

//
//	return (lwd_wdata);
//}

/*	DestroyLocalWindowData (wdata) frees the memory used by the wdata.
*/
//static void DestroyLocalWindowData (LocalWindowData wdata)
//{
//	rfree (wdata);
//}


//	Find the first non CompoundControl parent window of the argument.
static GtkWidget *GetControlParent (GtkWidget *widget)
{
	GtkWidget *parent = widget, *res = NULL;

	while (parent != NULL)
	{
		if (GTK_IS_SCROLLED_WINDOW(parent))
			res = parent;

		parent = gtk_widget_get_parent (parent);
	}

	return res;
}

/*	Return the hwnd of the parent window only if this is
	a Dialog (actually: is neither a SDIWindow or MDIWindow). If the parent is not
	a Dialog then NULL is returned.
	This procedure assumes that hwnd is the handle of a control.
*/
/*
static HWND GetControlParentDialog (HWND hwndControl)
{
	HWND parent;
	char *parentclassname;
	int  classnamelength;

	parent = GetControlParent (hwndControl);

	classnamelength = strlen (SDIWindowClassName) + 1;
	parentclassname = rmalloc (classnamelength);
	GetClassName (parent, parentclassname, classnamelength);

	if (strcmp(parentclassname, SDIWindowClassName) == 0)
	{
		parent = NULL;
	}
	else
		if (strcmp(parentclassname, MDIWindowClassName) == 0)
		{
			parent = NULL;
		}
	rfree (parentclassname);

	return parent;
}

*/

/*	WindowProcedures of the registered Clean windows/dialogs/controls.
*/

/*********************************************************************************************
	The callback routine for a modal/modeless dialog box.
*********************************************************************************************/
/*
static BOOL CALLBACK DialogProcedure (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	printMessage ("Dialog procedure", hwnd, message, wParam, lParam);

	switch (message)
	{
		case WM_CLOSE:
			{
				SendMessage1ToClean (CcWmCLOSE, hwnd);
				return TRUE;
			}
			break;
		case WM_SETCURSOR:
			{
				if (!GlobalCursorSet ())
				{
					return FALSE;
				}
				else
				{
					SetCursorFromCode (GetGlobalCursorCode ());
					SetWindowLong (hwnd, DWL_MSGRESULT, TRUE);
					return TRUE;
				}
			} break;
		//	WM_ENTERIDLE message is used to let Clean evaluate the initialisation action
		//	of a modal dialog by sending the CcWmIDLEDIALOG message.
		
		case WM_ENTERIDLE:
			{
				HWND hwndModalDialog;

				hwndModalDialog = (HWND)lParam;

				if (wParam == MSGF_DIALOGBOX && hwndModalDialog != ghwndLastModalDialog)
				{
					SendMessage1ToClean (CcWmIDLEDIALOG,(int)hwndModalDialog);
					ghwndLastModalDialog = hwndModalDialog;
				}
				else
				{
					SendMessage0ToClean (CcWmIDLETIMER);
				}
				return FALSE;
			} break;
		case WM_TIMER:
			{
				SendMessage2ToClean (CcWmTIMER, wParam, GetMessageTime ());
				return FALSE;
			} break;
		// WM_ACTIVATE:
		//	*	in case of activate and previously a window was active,
		//		send a deactivate message to Clean for the window.
		//	*	in case of deactivate and new active is a window,
		//		send an activate message to Clean for the window.
		
		case WM_ACTIVATE:
			{
				switch (LOWORD (wParam))
				{
					case WA_ACTIVE:
					case WA_CLICKACTIVE:
						{
							if (gActiveDialog == NULL && ghTopDocWindow != NULL)
							{
								//	Currently a window is active.
								//	Notify Clean of this by sending a deactivate event for this window.
								
								SendMessage1ToClean (CcWmDEACTIVATE, ghTopDocWindow);
							}
							SendMessage1ToClean (CcWmACTIVATE, hwnd);	// Now tell Clean that the dialog is active.
							gActiveDialog = hwnd;
						}
						break;
					case WA_INACTIVE:
						{
							HWND hwndNewActive = (HWND)lParam;			// The window handle to be activated.

							SendMessage1ToClean (CcWmDEACTIVATE, hwnd);
							gActiveDialog = NULL;

							if (hwndNewActive != NULL && hwndNewActive == ghTopDocWindow)
							{
								SendMessage1ToClean (CcWmACTIVATE, hwndNewActive);
							}
							else if (hwndNewActive == NULL && ghTopDocWindow != NULL)
							{
								SendMessage1ToClean (CcWmACTIVATE, ghTopDocWindow);
							}
						}
						break;
				}
				return FALSE;
			}
			break;
		case WM_COMMAND:
			{
				switch (LOWORD (wParam))	// First check if OK or CANCEL button has been pressed
				{
					case IDOK:
						{
							SendMessage2ToClean (CcWmSPECIALBUTTON, hwnd, ISOKBUTTON);
						}
						return TRUE;
					case IDCANCEL:
						{
							SendMessage2ToClean (CcWmSPECIALBUTTON, hwnd, ISCANCELBUTTON);
						}
						return TRUE;
				}
				switch (HIWORD (wParam))
				{
					case BN_CLICKED:
						{
							if (lParam != 0)
							{
								// Send also modifiers to Clean
								SendMessage4ToClean (CcWmBUTTONCLICKED, hwnd, lParam, GetModifiers (), LOWORD (wParam));
							}
							else if (LOWORD (wParam) == 2)
							{
								SendMessage1ToClean (CcWmCLOSE, hwnd);
							}
							return TRUE;
						}
						break;
					case CBN_SETFOCUS:
						{
							gComboSelection = SendMessage ((HWND) lParam, CB_GETCURSEL, 0, 0);
							return FALSE;
						}
						break;
					case CBN_KILLFOCUS:
						{
							gComboSelection = -1;
							return FALSE;
						}
						break;
					case CBN_SELENDOK:
						{
							char text[256];
							int newsel;
							HWND combo;

							combo = (HWND) lParam;
							newsel = SendMessage (combo, CB_GETCURSEL, 0, 0);
							SendMessage (combo, CB_GETLBTEXT, newsel, (LPARAM) text);
							if (!SendMessage (combo, CB_GETITEMDATA, newsel, 0))
							{
								SendMessage (combo, CB_SETCURSEL, gComboSelection, (LPARAM) text);
								MessageBeep (0xFFFFFFFF);
							}
							else
							{
								gComboSelection = newsel;
								if (newsel!=CB_ERR)
									SendMessage3ToClean (CcWmCOMBOSELECT, hwnd, combo, newsel);
							}
							return 1;
						}
						break;
				}
				return FALSE;
			} break;
		case WM_INITDIALOG:
			{
				int x, y, w, h;
				HWND defctrl;

				SendMessage1ToClean (CcWmINITDIALOG, hwnd);

				x = gCci.p1;
				y = gCci.p2;
				w = gCci.p3;
				h = gCci.p4;
				defctrl = (HWND) gCci.p5;

				w += 2 * GetSystemMetrics (SM_CXFIXEDFRAME);
				h += 2 * GetSystemMetrics (SM_CXFIXEDFRAME) + GetSystemMetrics (SM_CYCAPTION);

				if (x == -1 && y == -1)
				{
					x = (GetSystemMetrics (SM_CXSCREEN) - w) / 2;
					y = (GetSystemMetrics (SM_CYSCREEN) - h) / 2;
				}

				MoveWindow (hwnd, x, y, w, h, FALSE);


				if (defctrl != NULL)
				{
					SetFocus (defctrl);
					return FALSE;
				}
				else
				{
					return TRUE;		// allow windows to set focus;
				}
			}
			break;
		case WM_SETFONT:
			{
				HFONT hfont;

				hfont = (HFONT) wParam;

				gDlogFont = hfont;
				return FALSE;
			}
			break;
		case WM_HSCROLL:
		case WM_VSCROLL:
			{
				int nPos,nScrollCode;
				HWND hwndScrollBar;

				nScrollCode = LOWORD (wParam);

				if (nScrollCode != SB_ENDSCROLL)	// Do not send the SB_ENDSCROLL to Clean.
				{
					nPos = (short int) HIWORD (wParam);
					hwndScrollBar = (HWND) lParam;
					SendMessage5ToClean (CcWmSCROLLBARACTION, hwnd, hwndScrollBar, SB_CTL, nScrollCode, nPos);
				}
				return TRUE;
			}
			break;
		case WM_DRAWITEM:
			{
				LPDRAWITEMSTRUCT lpdis;
				lpdis = (LPDRAWITEMSTRUCT) lParam;

				switch (lpdis->CtlType)
				{
					case ODT_COMBOBOX:
						{
							char text[256];
							COLORREF forecolor, bkcolor;
							SendMessage (lpdis->hwndItem, CB_GETLBTEXT, lpdis->itemID, (LPARAM) text);
							if (lpdis->itemState & ODS_DISABLED)
							{
								forecolor = SetTextColor (lpdis->hDC, GetSysColor (COLOR_GRAYTEXT));
								bkcolor = SetBkColor (lpdis->hDC, GetSysColor (COLOR_3DFACE));
							}
							else if (lpdis->itemState & ODS_SELECTED)
							{
								if (lpdis->itemData)
								{
									forecolor = SetTextColor (lpdis->hDC, GetSysColor (COLOR_HIGHLIGHTTEXT));
									bkcolor = SetBkColor (lpdis->hDC, GetSysColor (COLOR_HIGHLIGHT));
								}
								else
								{
									forecolor = SetTextColor (lpdis->hDC, GetSysColor (COLOR_GRAYTEXT));
									bkcolor = SetBkColor (lpdis->hDC, GetSysColor (COLOR_WINDOW));
								}
							}
							else
							{
								if (lpdis->itemData)
									forecolor = SetTextColor (lpdis->hDC, GetSysColor (COLOR_WINDOWTEXT));
								else
									forecolor = SetTextColor (lpdis->hDC, GetSysColor (COLOR_GRAYTEXT));
								bkcolor = SetBkColor (lpdis->hDC, GetSysColor (COLOR_WINDOW));
							}

							ExtTextOut (lpdis->hDC,					// device context
										lpdis->rcItem.left + 2,		// ref point x            
										lpdis->rcItem.top + 1,		// ref point y            
										ETO_CLIPPED | ETO_OPAQUE,	// options                
										&lpdis->rcItem,				// clipping rect          
										text,					// text to draw           
										lstrlen (text),				// length of text to draw 
										NULL					// no kerning array       
								);

							SetTextColor (lpdis->hDC, forecolor);
							SetBkColor (lpdis->hDC, bkcolor);

							if (lpdis->itemState & ODS_FOCUS)
								DrawFocusRect (lpdis->hDC, &lpdis->rcItem);

							return TRUE;
						} break;
					case ODT_BUTTON:
						{
							SendMessage3ToClean (CcWmDRAWCONTROL, hwnd, lpdis->hwndItem, lpdis->hDC);

							if (lpdis->itemState & ODS_SELECTED)
								InvertRect (lpdis->hDC, &lpdis->rcItem);

							if (lpdis->itemState & ODS_FOCUS)
								DrawFocusRect (lpdis->hDC, &lpdis->rcItem);
							return TRUE;
						} break;
				}
				return FALSE;
			}
			break;
		//	WM_SETFOCUS alternative circumvents application-crash when dialog is closed
		//	from the inside (by an element button or close box).
		
		case WM_SETFOCUS:
			{
				return TRUE;
			}
			break;
		default:
			return FALSE;
			break;
	}
	ErrorExit ("Fatal error: case leak in DialogProcedure (%d).",message);
}	/* DialogProcedure */


/*********************************************************************************************
	The callback routine for a custom control.
*********************************************************************************************/
#if 0
static LRESULT CALLBACK CustomControlProcedure (HWND hwnd, UINT uMess, WPARAM wParam, LPARAM lParam)
{
	printMessage ("CustomControlProcedure", hwnd, uMess, wParam, lParam);
	switch (uMess)
	{
		case WM_PAINT:
			{
				HWND parent;
				HDC hdc;
				PAINTSTRUCT ps;

				parent = GetControlParent (hwnd);

				hdc = BeginPaint (hwnd, &ps);
				SendMessage3ToClean (CcWmDRAWCONTROL, parent, hwnd, hdc);
				EndPaint (hwnd, &ps);

				return 0;
			} break;
		case WM_LBUTTONDOWN:
			{
//				SendMouseDownToClean (GetControlParent (hwnd), hwnd, SIGNEDLOWORD (lParam), SIGNEDHIWORD (lParam));
				return 0;
			} break;
		case WM_MOUSEMOVE:
			{
				if (gInMouseDown)
				{
//					SendMouseStillDownToClean (GetControlParent (hwnd), hwnd, SIGNEDLOWORD (lParam), SIGNEDHIWORD (lParam));
				}
				else
				{
//					SendMouseStillUpToClean (GetControlParent (hwnd), hwnd, SIGNEDLOWORD (lParam), SIGNEDHIWORD (lParam));
				}
				return 0;
			} break;
		case WM_LBUTTONUP:
			{
				if (gInMouseDown)
				{
					ReleaseCapture ();	/* rely on WM_CAPTURECHANGED to send the mouseUp event */
				}
				return 0;
			} break;
		case WM_CANCELMODE:
			{
				if (gInMouseDown)
				{
					ReleaseCapture ();	/* rely on WM_CAPTURECHANGED to send the mouseUp event */
				}
				return DefWindowProc (hwnd, uMess, wParam, lParam);
			} break;
		case WM_CAPTURECHANGED:
			{
				if (gInMouseDown)
				{
					POINT p;
					GetCursorPos (&p);
					ScreenToClient (hwnd, &p);
//					SendMouseUpToClean (GetControlParent (hwnd), hwnd, p.x, p.y);
				}
				return 0;
			} break;
		case WM_SYSKEYDOWN:
		case WM_KEYDOWN:
			{
				int c = 0;
				HWND hwndParent;

				c = CheckVirtualKeyCode ((int) wParam);

				if (!c)
				/* Ignore non-virtual keys, because they arrive as WM_SYSCHAR and WM_CHAR. */
				{
					return DefWindowProc (hwnd, uMess, wParam, lParam);
				}
				/* Handle virtual keys analogously to keys received as WM_SYSCHAR and WM_CHAR. */
				hwndParent = GetControlParent (hwnd);
				if (gInKey)
				{
					if (gCurChar == c)
						SendKeyStillDownToClean (hwndParent, hwnd, gCurChar);
					else
					{
//						SendKeyUpToClean (hwndParent, hwnd, gCurChar);
						gCurChar = c;
//						SendKeyDownToClean (hwndParent, hwnd, gCurChar);
					}
				}
				else
				{
					gCurChar = c;
//					SendKeyDownToClean (hwndParent, hwnd, gCurChar);
					gInKey = TRUE;
				}
				return 0;
			}
			break;
		case WM_SYSCHAR:
		case WM_CHAR:
			{
				HWND hwndParent = GetControlParent (hwnd);

				if (gInKey)
				{
//					if (gCurChar == (int) wParam)
//						SendKeyStillDownToClean (hwndParent, hwnd, gCurChar);
//					else
//					{
//						SendKeyUpToClean (hwndParent, hwnd, gCurChar);
//						gCurChar = wParam;
//						SendKeyDownToClean (hwndParent, hwnd, gCurChar);
//					}
				}
				else
				{
//					gCurChar = wParam;
//					SendKeyDownToClean (hwndParent, hwnd, gCurChar);
//					gInKey = TRUE;
				}
				return 0;
			}
			break;
		case WM_SYSKEYUP:
		case WM_KEYUP:
			{
//				if (gInKey)
//					SendKeyUpToClean (GetControlParent (hwnd), hwnd, gCurChar);
//				gInKey = FALSE;
//				gCurChar = 0;
				return DefWindowProc (hwnd, uMess, wParam, lParam);
			}
			break;
		case WM_KILLFOCUS:
			{
				HWND hwndParent = GetControlParent (hwnd);
				if (gInKey)
					SendKeyUpToClean (hwndParent, hwnd, gCurChar);
				gInKey = FALSE;
				gCurChar = 0;
				/*	WM_KILLFOCUS now also sends the CcWmKILLFOCUS message to
					Clean (because of the ControlDeactivate attribute).
				*/
				SendMessage2ToClean (CcWmKILLFOCUS, hwndParent, hwnd);
				return 0;
			}
			break;
		case WM_SETFOCUS:
			{
				/*	WM_SETFOCUS sends the CcWmSETFOCUS message to Clean (because of
					ControlActivate attribute).
				*/
				SendMessage2ToClean (CcWmSETFOCUS, GetControlParent (hwnd), hwnd);
				return 0;
			}
			break;
		case WM_GETDLGCODE:		/*	Inform dialog procedure to pass all keyboard input to the control. */
			return (DLGC_WANTCHARS | DLGC_WANTARROWS);
			break;
		default:
			return DefWindowProc (hwnd, uMess, wParam, lParam);
			break;
	}
	ErrorExit ("Fatal error: case leak in CustomControlProcedure (%d).",uMess);
}	/* CustomControlProcedure */

#endif

/*********************************************************************************************
	The callback routine for a compound control.
*********************************************************************************************/
#if 0
static LRESULT CALLBACK CompoundControlProcedure (HWND hwnd, UINT uMess, WPARAM wParam, LPARAM lParam)
{
	printMessage ("CompoundControlProcedure", hwnd, uMess, wParam, lParam);

	switch (uMess)
	{
		case WM_COMMAND:
			{
				switch (HIWORD (wParam))
				{
					case BN_CLICKED:
						{
							if (lParam != 0)
							{
								/*	Send also modifiers to Clean */
								SendMessage4ToClean (CcWmBUTTONCLICKED, GetControlParent (hwnd), lParam, GetModifiers (), LOWORD (wParam));
							}
							return 0;
						}
						break;
					case CBN_SETFOCUS:
						{
							gComboSelection = SendMessage ((HWND) lParam, CB_GETCURSEL, 0, 0);
							return 0;
						}
						break;
					case CBN_KILLFOCUS:
						{
							gComboSelection = -1;
							return 0;
						}
						break;
					case CBN_SELENDOK:
						{
							char text[256];
							int newsel;
							HWND combo;

							combo = (HWND) lParam;
							newsel = SendMessage (combo, CB_GETCURSEL, 0, 0);
							SendMessage (combo, CB_GETLBTEXT, newsel, (LPARAM) text);
							if (!SendMessage (combo, CB_GETITEMDATA, newsel, 0))
							{
								SendMessage (combo, CB_SETCURSEL, gComboSelection, (LPARAM) text);
								MessageBeep (0xFFFFFFFF);
								return 0;
							}
							else
							{
								gComboSelection = newsel;
								if (newsel!=CB_ERR)
									SendMessage3ToClean (CcWmCOMBOSELECT, GetControlParent (hwnd), combo, newsel);
								return 1;
							}
						}
						break;
				}
				return 0;
			} break;
		case WM_PAINT:
			{
				HWND parentwindow;
				HDC hdc;
				PAINTSTRUCT ps;

				if (GetUpdateRect(hwnd,NULL,FALSE))	// determine if there is really an update area.
				{
					parentwindow = GetControlParent (hwnd);
					hdc = BeginPaint (hwnd, &ps);
					SendMessage3ToClean (CcWmDRAWCONTROL, parentwindow, hwnd, hdc);
					EndPaint (hwnd, &ps);
				}
				return 0;
			} break;
		case WM_HSCROLL:
			{
				int nPos,nScrollCode,controlkind;
				HWND parentwindow, hwndScrollBar;

				nScrollCode = LOWORD (wParam);

				if (nScrollCode != SB_ENDSCROLL)	/* Do not send the SB_ENDSCROLL to Clean. */
				{
					nPos = (short int) HIWORD (wParam);
					parentwindow  = GetControlParent (hwnd);
					hwndScrollBar = (HWND) lParam;

					if (hwndScrollBar==0)
					{
						controlkind = SB_HORZ;		/* lParam==0 in case of Compound scrollbars. */
						hwndScrollBar = hwnd;		/* pass the compound control handle to Clean. */
						UpdateWindow (hwnd);		/* but first ensure that compound control is updated. */
					}
					else
					{
						controlkind = SB_CTL;		/* lParam!==0 in case of SliderControls. */
					}
					SendMessage5ToClean (CcWmSCROLLBARACTION, parentwindow, hwndScrollBar, controlkind, nScrollCode, nPos);
				}
				return 0;
			}
			break;
		case WM_VSCROLL:
			{
				int nPos,nScrollCode,controlkind;
				HWND parentwindow, hwndScrollBar;

				nScrollCode = LOWORD (wParam);

				if (nScrollCode != SB_ENDSCROLL)	/* Do not send the SB_ENDSCROLL to Clean. */
				{
					nPos = (short int) HIWORD (wParam);
					parentwindow  = GetControlParent (hwnd);
					hwndScrollBar = (HWND) lParam;

					if (hwndScrollBar==0)
					{
						controlkind = SB_VERT;		/* lParam==0 in case of Compound scrollbars. */
						hwndScrollBar = hwnd;		/* pass the compound control handle to Clean. */
						UpdateWindow (hwnd);		/* but first ensure that compound control is updated. */
					}
					else
					{
						controlkind = SB_CTL;		/* lParam!==0 in case of SliderControls. */
					}
					SendMessage5ToClean (CcWmSCROLLBARACTION, parentwindow, hwndScrollBar, controlkind, nScrollCode, nPos);
				}
				return 0;
			}
			break;
		/*	The following cases concerning mouse events
				(WM_LBUTTONDOWN upto WM_TIMER) have been copied from CustomControlProcedure.
		*/
		case WM_LBUTTONDOWN:
			{
//				SendMouseDownToClean (GetControlParent (hwnd), hwnd, SIGNEDLOWORD (lParam), SIGNEDHIWORD (lParam));
				return 0;
			} break;
		case WM_MOUSEMOVE:
			{
				if (gInMouseDown)
				{
//					SendMouseStillDownToClean (GetControlParent (hwnd), hwnd, SIGNEDLOWORD (lParam), SIGNEDHIWORD (lParam));
				}
				else
				{
//					SendMouseStillUpToClean (GetControlParent (hwnd), hwnd, SIGNEDLOWORD (lParam), SIGNEDHIWORD (lParam));
				}
				return 0;
			} break;
		case WM_LBUTTONUP:
			{
				if (gInMouseDown)
				{
					ReleaseCapture ();	/* rely on WM_CAPTURECHANGED to send the mouseUp event */
				}
				return 0;
			} break;
		case WM_CANCELMODE:
			{
				if (gInMouseDown)
				{
					ReleaseCapture ();	/* rely on WM_CAPTURECHANGED to send the mouseUp event */
				}
				return DefWindowProc (hwnd, uMess, wParam, lParam);
			} break;
		case WM_CAPTURECHANGED:
			{
				if (gInMouseDown)
				{
					POINT p;
					GetCursorPos (&p);
					ScreenToClient (hwnd, &p);
//					SendMouseUpToClean (GetControlParent (hwnd), hwnd, p.x, p.y);
				}
				return 0;
			} break;
		/*	The following cases concerning key events and focus events
				(WM_SYSKEYDOWN upto WM_GETDLGCODE) have been copied from CustomControlProcedure.
		*/
		case WM_SYSKEYDOWN:
		case WM_KEYDOWN:
			{
				int c = 0;
				HWND hwndParent;

				c = CheckVirtualKeyCode ((int) wParam);

				if (!c)
				/* Ignore non-virtual keys, because they arrive as WM_SYSCHAR and WM_CHAR. */
				{
					return DefWindowProc (hwnd, uMess, wParam, lParam);
				}
				/* Handle virtual keys analogously to keys received as WM_SYSCHAR and WM_CHAR. */
				hwndParent = GetControlParent (hwnd);
//				if (gInKey)
//				{
//					if (gCurChar == c)
//						SendKeyStillDownToClean (hwndParent, hwnd, gCurChar);
//					else
//					{
//						SendKeyUpToClean (hwndParent, hwnd, gCurChar);
//						gCurChar = c;
//						SendKeyDownToClean (hwndParent, hwnd, gCurChar);
//					}
//				}
//				else
//				{
//					gCurChar = c;
//					SendKeyDownToClean (hwndParent, hwnd, gCurChar);
//					gInKey = TRUE;
//				}
				return 0;
			}
			break;
		case WM_SYSCHAR:
		case WM_CHAR:
			{
				HWND hwndParent = GetControlParent (hwnd);

//				if (gInKey)
//				{
//					if (gCurChar == (int) wParam)
//						SendKeyStillDownToClean (hwndParent, hwnd, gCurChar);
//					else
//					{
//						SendKeyUpToClean (hwndParent, hwnd, gCurChar);
//						gCurChar = wParam;
//						SendKeyDownToClean (hwndParent, hwnd, gCurChar);
//					}
//				}
//				else
//				{
//					gCurChar = wParam;
//					SendKeyDownToClean (hwndParent, hwnd, gCurChar);
//					gInKey = TRUE;
//				}
				return 0;
			}
			break;
		case WM_SYSKEYUP:
		case WM_KEYUP:
			{
				if (gInKey)
					SendKeyUpToClean (GetControlParent (hwnd), hwnd, gCurChar);
				gInKey = FALSE;
				gCurChar = 0;
				return DefWindowProc (hwnd, uMess, wParam, lParam);
			}
			break;
		case WM_KILLFOCUS:
			{
				HWND hwndParent = GetControlParent (hwnd);
				if (gInKey)
					SendKeyUpToClean (hwndParent, hwnd, gCurChar);
				gInKey = FALSE;
				gCurChar = 0;
				/*	WM_KILLFOCUS now also sends the CcWmKILLFOCUS message to
					Clean (because of the ControlDeactivate attribute).
				*/
				SendMessage2ToClean (CcWmKILLFOCUS, hwndParent, hwnd);
				return 0;
			}
			break;
		case WM_SETFOCUS:
			{
				/*	WM_SETFOCUS sends the CcWmSETFOCUS message to Clean because
					of the ControlActivate attribute.
				*/
				SendMessage2ToClean (CcWmSETFOCUS, GetControlParent (hwnd), hwnd);
				return 0;
			}
			break;
		/*	The WM_CLOSE event is generated when a user presses escape inside an EditControl that exists
			within the CompoundControl which exists within a Dialog.
		*/
		case WM_CLOSE:
			{
				SendMessage1ToClean (CcWmCLOSE, GetControlParent (hwnd));
				return 0;
			}
			break;
		case WM_GETDLGCODE:		/*	Inform dialog procedure to pass all keyboard input to the control. */
			return (DLGC_WANTCHARS | DLGC_WANTARROWS);
			break;
		case WM_DRAWITEM:
			{
				LPDRAWITEMSTRUCT lpdis;
				lpdis = (LPDRAWITEMSTRUCT) lParam;

				switch (lpdis->CtlType)
				{
					case ODT_COMBOBOX:
						{
							char text[256];
							COLORREF forecolor, bkcolor;
							SendMessage (lpdis->hwndItem, CB_GETLBTEXT, lpdis->itemID, (LPARAM) text);
							if (lpdis->itemState & ODS_DISABLED)
							{
								forecolor = SetTextColor (lpdis->hDC, GetSysColor (COLOR_GRAYTEXT));
								bkcolor = SetBkColor (lpdis->hDC, GetSysColor (COLOR_3DFACE));
							}
							else if (lpdis->itemState & ODS_SELECTED)
							{
								if (lpdis->itemData)
								{
									forecolor = SetTextColor (lpdis->hDC, GetSysColor (COLOR_HIGHLIGHTTEXT));
									bkcolor = SetBkColor (lpdis->hDC, GetSysColor (COLOR_HIGHLIGHT));
								}
								else
								{
									forecolor = SetTextColor (lpdis->hDC, GetSysColor (COLOR_GRAYTEXT));
									bkcolor = SetBkColor (lpdis->hDC, GetSysColor (COLOR_WINDOW));
								}
							}
							else
							{
								if (lpdis->itemData)
									forecolor = SetTextColor (lpdis->hDC, GetSysColor (COLOR_WINDOWTEXT));
								else
									forecolor = SetTextColor (lpdis->hDC, GetSysColor (COLOR_GRAYTEXT));
								bkcolor = SetBkColor (lpdis->hDC, GetSysColor (COLOR_WINDOW));
							}

							ExtTextOut (lpdis->hDC,					/* device context         */
										lpdis->rcItem.left + 2,		/* ref point x            */
										lpdis->rcItem.top + 1,		/* ref point y            */
										ETO_CLIPPED | ETO_OPAQUE,	/* options                */
										&lpdis->rcItem,				/* clipping rect          */
										text,						/* text to draw           */
										lstrlen (text),				/* length of text to draw */
										NULL						/* no kerning array       */
								);

							SetTextColor (lpdis->hDC, forecolor);
							SetBkColor (lpdis->hDC, bkcolor);

							if (lpdis->itemState & ODS_FOCUS)
								DrawFocusRect (lpdis->hDC, &lpdis->rcItem);
							return 0;
						} break;
					case ODT_BUTTON:
						{
							HWND parentwindow;
							parentwindow  = GetControlParent (hwnd);

							SendMessage3ToClean (CcWmDRAWCONTROL, parentwindow, lpdis->hwndItem, lpdis->hDC);

							if (lpdis->itemState & ODS_SELECTED)
								InvertRect (lpdis->hDC, &lpdis->rcItem);

							if (lpdis->itemState & ODS_FOCUS)
								DrawFocusRect (lpdis->hDC, &lpdis->rcItem);
							return 0;
						} break;
				}
				return 0;
			}
			break;
		default:
			return DefWindowProc (hwnd, uMess, wParam, lParam);
			break;
	}
	ErrorExit ("Fatal error: case leak in CompoundControlProcedure (%d).",uMess);
}	/* CompoundControlProcedure */

#endif

/*********************************************************************************************
	Event handler for subclassing editable pop up controls.
	This routine catches all keyboard input and handles it as a standard windows pop up control
	would, but in addition it also sends each keyboard input to Clean.
	All other events are handled as a standard windows pop up control.
*********************************************************************************************/
#if 0
static LRESULT CALLBACK PopUpControlProcedure (HWND hwnd,UINT uMess,WPARAM wParam,LPARAM lParam)
{
	LRESULT stdresult;

	printMessage ("Clean PopUp Control", hwnd, uMess, wParam, lParam);

	/* First preprocess all messages as if you are a standard Windows edit control of a combobox. */
	stdresult = CallWindowProc ((WNDPROC) stdPopUpCallback, hwnd, uMess, wParam, lParam);

	switch (uMess)
	{
		case WM_SYSKEYDOWN:
		case WM_KEYDOWN:
			{
				int c = 0;
				HWND hwndParent;
				HWND hwndCombo;

				c = CheckVirtualKeyCode ((int) wParam);

				if (!c)
				/* Ignore non-virtual keys, because they arrive as WM_SYSCHAR and WM_CHAR. */
				{
					return stdresult;
				}
				/* Handle virtual keys analogously to keys received as WM_SYSCHAR and WM_CHAR. */
				hwndCombo  = GetParent (hwnd);
				hwndParent = GetControlParent (hwndCombo);
//				if (gInKey)
//				{
//					if (gCurChar == c)
//						SendKeyStillDownToClean (hwndParent, hwndCombo, gCurChar);
//					else
//					{
//						SendKeyUpToClean (hwndParent, hwndCombo, gCurChar);
//						gCurChar = c;
//						SendKeyDownToClean (hwndParent, hwndCombo, gCurChar);
//					}
//				}
//				else
//				{
//					gCurChar = c;
//					SendKeyDownToClean (hwndParent, hwndCombo, gCurChar);
//					gInKey = TRUE;
//				}
				return stdresult;
			}
			break;
		case WM_SYSCHAR:
		case WM_CHAR:
			{
				HWND hwndCombo  = GetParent (hwnd);
				HWND hwndParent = GetControlParent (hwndCombo);

//				if (gInKey)
//				{
//					if (gCurChar == (int) wParam)
//						SendKeyStillDownToClean (hwndParent, hwndCombo, gCurChar);
//					else
//					{
//						SendKeyUpToClean (hwndParent, hwndCombo, gCurChar);
//						gCurChar = wParam;
//						SendKeyDownToClean (hwndParent, hwndCombo, gCurChar);
//					}
//				}
//				else
//				{
//					gCurChar = wParam;
//					SendKeyDownToClean (hwndParent, hwndCombo, gCurChar);
//					gInKey = TRUE;
//				}
				return stdresult;
			}
			break;
		case WM_SYSKEYUP:
		case WM_KEYUP:
			{
				HWND hwndCombo  = GetParent (hwnd);
				HWND hwndParent = GetControlParent (hwndCombo);
				if (gInKey)
					SendKeyUpToClean (hwndParent, hwndCombo, gCurChar);
				gInKey = FALSE;
				gCurChar = 0;
				return stdresult;
			}
			break;
		case WM_KILLFOCUS:
			{
				HWND hwndCombo  = GetParent (hwnd);
				HWND hwndParent = GetControlParent (hwndCombo);
				if (gInKey)
					SendKeyUpToClean (hwndParent, hwndCombo, gCurChar);
				gInKey = FALSE;
				gCurChar = 0;
				/*	WM_KILLFOCUS now also sends the CcWmKILLFOCUS message to
					Clean (because of the ControlDeactivate attribute).
				*/
				SendMessage2ToClean (CcWmKILLFOCUS, hwndParent, hwndCombo);
				return stdresult;
			}
			break;
		/*	Send CcWmGETFOCUS message to Clean because of the ControlActivate attribute.
		*/
		case WM_SETFOCUS:
			{
				HWND hwndCombo  = GetParent (hwnd);
				HWND hwndParent = GetControlParent (hwndCombo);
				SendMessage2ToClean (CcWmSETFOCUS, hwndParent, hwndCombo);
				return stdresult;
			}
			break;
	}

	return stdresult;
}	/* PopUpControlProcedure */

#endif

/*********************************************************************************************
	Callback routine for SDI client windows.
	The callback routine handles all events for the client window of a SDI window.
	The accelerator table is now managed by its parent SDI frame window callback routine.
*********************************************************************************************/
#if 0
static LRESULT CALLBACK SDIWindowProcedure (HWND hWin,UINT uMess,WPARAM wPara,LPARAM lPara)
{
	switch (uMess)
	{
		case WM_CANCELMODE:
			{
				if (gInMouseDown)
				{
					ReleaseCapture ();	/* rely on WM_CAPTURECHANGED to send the mouseUp event */
				}
				return DefWindowProc (hWin, uMess, wPara, lPara);
			}
			break;
		case WM_CAPTURECHANGED:
			{
				if (gInMouseDown)
				{
					POINT p;
					GetCursorPos (&p);
					ScreenToClient (hWin, &p);
//					SendMouseUpToClean (hWin, hWin, p.x, p.y);
				}
			}
			break;
		/*	The cases WM_ENTERSIZEMOVE and WM_EXITSIZEMOVE flag the lwd_usersizemove field
			of the LocalWindowData of the window. This is used to determine whether the window
			should be redrawn in case of resizing.
		*/
		case WM_ENTERSIZEMOVE:
			{
				LocalWindowData wdata;

				wdata = (LocalWindowData) GetWindowLong (hWin,0);
				wdata->lwd_usersizemoving = (BOOL)TRUE;
				SetWindowLong (hWin, 0, (long)wdata);
			}
			break;
		case WM_EXITSIZEMOVE:
			{
				LocalWindowData wdata;

				wdata = (LocalWindowData) GetWindowLong (hWin,0);
				wdata->lwd_usersizemoving = (BOOL)FALSE;
				SetWindowLong (hWin, 0, (long)wdata);
			}
			break;
		/*	The WM_SIZE message informs Clean about the new size.
		*/
		case WM_SIZE:
			{
				if (wPara != SIZE_MAXHIDE && wPara != SIZE_MAXSHOW)
				{
					int width,height;
					LocalWindowData wdata;

					width  = LOWORD (lPara);		// Width  of window excluding vertical scrollbar
					height = HIWORD (lPara);		// Height of window excluding horizontal scrollbar
					wdata  = (LocalWindowData) GetWindowLong (hWin,0);
					UpdateWindow (hWin);			// But first update the window
					SendMessage4ToClean (CcWmSIZE, hWin, width, height, (int)wdata->lwd_usersizemoving);
				}
			}
			break;
		case WM_HSCROLL:
			{
				int nPos,nScrollCode,controlkind;
				HWND hwndScrollBar;

				nScrollCode = LOWORD (wPara);

				if (nScrollCode != SB_ENDSCROLL)	/* Do not send the SB_ENDSCROLL to Clean. */
				{
					nPos = (short int) HIWORD (wPara);
					hwndScrollBar = (HWND) lPara;

					if (hwndScrollBar==0)
					{
						controlkind = SB_HORZ;		/* lPara==0 in case of Window scrollbars. */
						hwndScrollBar = hWin;		/* pass the compound control handle to Clean. */
						UpdateWindow (hWin);		/* but first ensure that window is updated. */
					}
					else
					{
						controlkind = SB_CTL;		/* lPara!=0 in case of SliderControls. */
					}
					SendMessage5ToClean (CcWmSCROLLBARACTION, hWin, hwndScrollBar, controlkind, nScrollCode, nPos);
				}
			}
			break;
		case WM_VSCROLL:
			{
				int nPos,nScrollCode,controlkind;
				HWND hwndScrollBar;

				nScrollCode = LOWORD (wPara);

				if (nScrollCode != SB_ENDSCROLL)	/* Do not send the SB_ENDSCROLL to Clean. */
				{
					nPos = (short int) HIWORD (wPara);
					hwndScrollBar = (HWND) lPara;

					if (hwndScrollBar==0)
					{
						controlkind = SB_VERT;		/* lPara==0 in case of Window scrollbars. */
						hwndScrollBar = hWin;		/* pass the window handle to Clean. */
						UpdateWindow (hWin);		/* but first ensure that window is updated. */
					}
					else
					{
						controlkind = SB_CTL;		/* lPara!=0 in case of SliderControls. */
					}
					SendMessage5ToClean (CcWmSCROLLBARACTION, hWin, hwndScrollBar, controlkind, nScrollCode, nPos);
				}
			}
			break;
		case WM_DRAWITEM:
			{
				LPDRAWITEMSTRUCT lpdis;
				lpdis = (LPDRAWITEMSTRUCT) lPara;

				switch (lpdis->CtlType)
				{
					case ODT_COMBOBOX:
						{
							char text[256];
							COLORREF forecolor, bkcolor;
							SendMessage (lpdis->hwndItem, CB_GETLBTEXT, lpdis->itemID, (LPARAM) text);
							if (lpdis->itemState & ODS_DISABLED)
							{
								forecolor = SetTextColor (lpdis->hDC, GetSysColor (COLOR_GRAYTEXT));
								bkcolor = SetBkColor (lpdis->hDC, GetSysColor (COLOR_3DFACE));
							}
							else if (lpdis->itemState & ODS_SELECTED)
							{
								if (lpdis->itemData)
								{
									forecolor = SetTextColor (lpdis->hDC, GetSysColor (COLOR_HIGHLIGHTTEXT));
									bkcolor = SetBkColor (lpdis->hDC, GetSysColor (COLOR_HIGHLIGHT));
								}
								else
								{
									forecolor = SetTextColor (lpdis->hDC, GetSysColor (COLOR_GRAYTEXT));
									bkcolor = SetBkColor (lpdis->hDC, GetSysColor (COLOR_WINDOW));
								}
							}
							else
							{
								if (lpdis->itemData)
									forecolor = SetTextColor (lpdis->hDC, GetSysColor (COLOR_WINDOWTEXT));
								else
									forecolor = SetTextColor (lpdis->hDC, GetSysColor (COLOR_GRAYTEXT));
								bkcolor = SetBkColor (lpdis->hDC, GetSysColor (COLOR_WINDOW));
							}

							ExtTextOut (lpdis->hDC,					/* device context */
										lpdis->rcItem.left + 2,		/* ref point x */
										lpdis->rcItem.top + 1,		/* ref point y */
										ETO_CLIPPED | ETO_OPAQUE,	/* options */
										&lpdis->rcItem,				/* clipping rect */
										text,						/* text to draw */
										lstrlen (text),				/* length of text to draw */
										NULL						/* no kerning array */
								);

							SetTextColor (lpdis->hDC, forecolor);
							SetBkColor (lpdis->hDC, bkcolor);

							if (lpdis->itemState & ODS_FOCUS)
								DrawFocusRect (lpdis->hDC, &lpdis->rcItem);

						} break;
					case ODT_BUTTON:
						{
							SendMessage3ToClean (CcWmDRAWCONTROL, hWin, lpdis->hwndItem, lpdis->hDC);

							if (lpdis->itemState & ODS_SELECTED)
								InvertRect (lpdis->hDC, &lpdis->rcItem);

							if (lpdis->itemState & ODS_FOCUS)
								DrawFocusRect (lpdis->hDC, &lpdis->rcItem);
							return TRUE;
						} break;
				}
			} break;
	}
	return DefWindowProc (hWin,uMess,wPara,lPara);
}	/* SDIWindowProcedure */

#endif

/*********************************************************************************************
	Callback routine for MDI document window procedure.
	Copied almost straight from SDIWindowProcedure. Differences are:
	-	WM_COMMAND can not originate from menu selections (handled by MDIFrameProcedure);
	-	DefWindowProc must be DefMDIChildProc;
	-	Instead of WM_ACTIVATE, a MDI document window receives WM_MDIACTIVATE messages. However,
		these do not work well when dialogs are involved. Instead WM_NCACTIVATE messages are
		checked.
*********************************************************************************************/
#if 0
static LRESULT CALLBACK MDIWindowProcedure (HWND hWin,UINT uMess,WPARAM wPara,LPARAM lPara)
{
	printMessage ("Clean MDI Doc Window",hWin,uMess,wPara,lPara);
	switch (uMess)
	{
		case WM_COMMAND:
			{
				switch (HIWORD (wPara))
				{
					case BN_CLICKED:
						{
							if (lPara != 0)
							{
								/*	Send modifiers also to Clean */
								SendMessage4ToClean (CcWmBUTTONCLICKED, hWin, lPara, GetModifiers (), LOWORD (wPara));
							}
						}
						break;
					case 1:		/*	1: message originates from an accelerator */
						{
							SendMessage2ToClean (CcWmCOMMAND, LOWORD (wPara), GetModifiers ());
						}
						break;
					case CBN_SETFOCUS:
						{
							gComboSelection = SendMessage ((HWND) lPara, CB_GETCURSEL, 0, 0);
						}
						break;
					case CBN_KILLFOCUS:
						{
							gComboSelection = -1;
						}
						break;
					case CBN_SELENDOK:
						{
							char text[256];
							int newsel;
							HWND combo;

							combo = (HWND) lPara;
							newsel = SendMessage (combo, CB_GETCURSEL, 0, 0);
							SendMessage (combo, CB_GETLBTEXT, newsel, (LPARAM) text);
							if (!SendMessage (combo, CB_GETITEMDATA, newsel, 0))
							{
								SendMessage (combo, CB_SETCURSEL, gComboSelection, (LPARAM) text);
								MessageBeep (0xFFFFFFFF);
								return 0;
							}
							else
							{
								gComboSelection = newsel;
								if (newsel!=CB_ERR)
									SendMessage3ToClean (CcWmCOMBOSELECT, hWin, combo, newsel);
								return 1;
							}
						}
						break;
				}
			} break;
		case WM_PAINT:
			{
				RECT updaterect;
				HDC  hdc;
				PAINTSTRUCT ps;

				if (GetUpdateRect (hWin, &updaterect, FALSE))
				{
					hdc = BeginPaint (hWin, &ps);
					if (updaterect.left != updaterect.right && updaterect.top != updaterect.bottom)
						SendMessage6ToClean (CcWmPAINT, hWin, updaterect.left,updaterect.top,updaterect.right,updaterect.bottom,hdc);
					EndPaint (hWin, &ps);
				}
				else
				{
					GetClientRect (hWin, &updaterect);
					SendMessage6ToClean (CcWmPAINT, hWin, updaterect.left,updaterect.top,updaterect.right,updaterect.bottom,wPara);
				}
				return 0;
			}
		case WM_CLOSE:		/*	The window is requested to be closed. */
			{
				SendMessage1ToClean (CcWmCLOSE, hWin);
				return 0;
			}
		case WM_DESTROY:	/*	The window is in the act of being closed. */
			{
				LocalWindowData wdata;

				wdata = (LocalWindowData) GetWindowLong (hWin,0);	// Get the local MDI window data
				DestroyLocalWindowData (wdata);						//	and destroy it.

				ghTopDocWindow=NULL;
				return 0;
			}
		case WM_SETCURSOR:
			{
				int cursorcode;
				LocalWindowData wdata;

				if (!GlobalCursorSet ())
				{
					if ((HWND) wPara != hWin || LOWORD (lPara) != HTCLIENT)
					{
						return DefMDIChildProc (hWin, uMess, wPara, lPara);
					}
					wdata = (LocalWindowData) GetWindowLong (hWin,0);
					cursorcode = wdata->lwd_cursorcode;
				}
				else
				{
					cursorcode = GetGlobalCursorCode ();
				}
				SetCursorFromCode (cursorcode);
			}
			break;
		case WM_SYSCHAR:
		case WM_CHAR:
			{
//				if (gInKey)
//				{
//					if (gCurChar == (int) wPara)
//						SendKeyStillDownToClean (hWin, hWin, gCurChar);
//					else
//					{
//						SendKeyUpToClean (hWin, hWin, gCurChar);
//						gCurChar = wPara;
//						SendKeyDownToClean (hWin, hWin, gCurChar);
//					}
//				}
//				else
//				{
//					gCurChar = wPara;
//					SendKeyDownToClean (hWin, hWin, gCurChar);
//					gInKey = TRUE;
//				}
				return 0;
			}
			break;
		case WM_SYSKEYUP:
		case WM_KEYUP:
			{
				if (gInKey)
					SendKeyUpToClean (hWin, hWin, gCurChar);
				gInKey = FALSE;
				gCurChar = 0;
				return (DefMDIChildProc (hWin, uMess, wPara, lPara));
			}
			break;
		case WM_KILLFOCUS:
			{
				if (gInKey)
					SendKeyUpToClean (hWin, hWin, gCurChar);
				gInKey = FALSE;
				gCurChar = 0;
			}
			break;
		case WM_LBUTTONDOWN:
			{
//				SendMouseDownToClean (hWin, hWin, SIGNEDLOWORD (lPara), SIGNEDHIWORD (lPara));
				return 0;
			}
			break;
		case WM_MOUSEMOVE:
			{
				if (gInMouseDown)
				{
//					SendMouseStillDownToClean (hWin, hWin, SIGNEDLOWORD (lPara), SIGNEDHIWORD (lPara));
				}
				else
				{
//					SendMouseStillUpToClean (hWin, hWin, SIGNEDLOWORD (lPara), SIGNEDHIWORD (lPara));
				}
				return 0;
			}
			break;
		case WM_LBUTTONUP:
			{
				if (gInMouseDown)
				{
					ReleaseCapture ();	/* rely on WM_CAPTURECHANGED to send the mouseUp event */
				}
			}
			break;
		case WM_CANCELMODE:
			{
				if (gInMouseDown)
				{
					ReleaseCapture ();	/* rely on WM_CAPTURECHANGED to send the mouseUp event */
				}
				return DefMDIChildProc (hWin, uMess, wPara, lPara);
			}
			break;
		case WM_CAPTURECHANGED:
			{
				if (gInMouseDown)
				{
					POINT p;
					GetCursorPos (&p);
					ScreenToClient (hWin, &p);
//					SendMouseUpToClean (hWin, hWin, p.x, p.y);
				}
			}
			break;
		/*	Instead of using WM_MDIACTIVATE to know the activation state of a MDI document window,
			we use WM_NCACTIVATE. This is because WM_MDIACTIVATE events are  not generated when dialogs
			are involved. The WM_NCACTIVATE is more robust because it is used by the system to change
			the active state of the window title bar. Incidentally to many WM_NCACTIVATE message can be
			generated. This has to be dealt with on the Clean side.
		*/
		case WM_NCACTIVATE:
			{
				BOOL fActive = (BOOL)wPara;

				if (fActive)
				{
					SendMessage1ToClean (CcWmACTIVATE, hWin);
					ghTopDocWindow       = hWin;
					ghActiveClientWindow = GetParent (hWin);
					ghActiveFrameWindow  = GetParent (ghActiveClientWindow);
					UpdateWindow (hWin);		// enforce update at Clean side (necessary for setActiveWindow)
				}
				else
				{
					SendMessage1ToClean (CcWmDEACTIVATE, hWin);
					ghTopDocWindow       = NULL;
					ghActiveFrameWindow  = NULL;
					ghActiveClientWindow = NULL;
				}
				return DefMDIChildProc (hWin, uMess, wPara, lPara);
			}
			break;
		/*	The cases WM_ENTERSIZEMOVE and WM_EXITSIZEMOVE flag the lwd_usersizemove field
			of the LocalWindowData of the window. This is used to determine whether the window
			should be redrawn in case of resizing.
		*/
		case WM_ENTERSIZEMOVE:
			{
				LocalWindowData wdata;

				wdata = (LocalWindowData) GetWindowLong (hWin,0);
				wdata->lwd_usersizemoving = (BOOL)TRUE;
				SetWindowLong (hWin, 0, (long)wdata);
			}
			break;
		case WM_EXITSIZEMOVE:
			{
				LocalWindowData wdata;

				wdata = (LocalWindowData) GetWindowLong (hWin,0);
				wdata->lwd_usersizemoving = (BOOL)FALSE;
				SetWindowLong (hWin, 0, (long)wdata);
			}
			break;
		case WM_SIZE:
			{
				HWND hwndToolbar;

				hwndToolbar = (HWND) GetGWL_USERDATA (hWin);
				// First resize the toolbar if present
				if (hwndToolbar!=NULL)
					SendMessage (hwndToolbar, TB_AUTOSIZE, (WPARAM)0, (LPARAM)0);

				if (wPara != SIZE_MAXHIDE && wPara != SIZE_MAXSHOW)
				{
					int width,height;
					LocalWindowData wdata;

					width  = LOWORD (lPara);		// Width  of window excluding vertical scrollbar
					height = HIWORD (lPara);		// Height of window excluding horizontal scrollbar
					wdata  = (LocalWindowData) GetWindowLong (hWin,0);
					UpdateWindow (hWin);			// But first update the window
					SendMessage4ToClean (CcWmSIZE, hWin, width, height, (int)wdata->lwd_usersizemoving);
				}
			}
			break;
		case WM_HSCROLL:
			{
				int nPos,nScrollCode,controlkind;
				HWND hwndScrollBar;

				nScrollCode = LOWORD (wPara);

				if (nScrollCode != SB_ENDSCROLL)	/* Do not send the SB_ENDSCROLL to Clean. */
				{
					nPos = (short int) HIWORD (wPara);
					hwndScrollBar = (HWND) lPara;

					if (hwndScrollBar==0)
					{
						controlkind = SB_HORZ;		/* lPara==0 in case of Window scrollbars. */
						hwndScrollBar = hWin;		/* pass the window handle to Clean. */
						UpdateWindow (hWin);		/* but first ensure that window is updated. */
					}
					else
					{
						controlkind = SB_CTL;		/* lPara!=0 in case of SliderControls. */
					}
					SendMessage5ToClean (CcWmSCROLLBARACTION, hWin, hwndScrollBar, controlkind, nScrollCode, nPos);
				}
			}
			break;
		case WM_VSCROLL:
			{
				int nPos,nScrollCode,controlkind;
				HWND hwndScrollBar;

				nScrollCode = LOWORD (wPara);

				if (nScrollCode != SB_ENDSCROLL)	/* Do not send the SB_ENDSCROLL to Clean. */
				{
					nPos = (short int) HIWORD (wPara);
					hwndScrollBar = (HWND) lPara;

					if (hwndScrollBar==0)
					{
						controlkind = SB_VERT;		/* lPara==0 in case of Window scrollbars. */
						hwndScrollBar = hWin;		/* pass the window handle to Clean. */
						UpdateWindow (hWin);		/* but first ensure that window is updated. */
					}
					else
					{
						controlkind = SB_CTL;		/* lPara!=0 in case of SliderControls. */
					}
					SendMessage5ToClean (CcWmSCROLLBARACTION, hWin, hwndScrollBar, controlkind, nScrollCode, nPos);
				}
			}
			break;
		case WM_DRAWITEM:
			{
				LPDRAWITEMSTRUCT lpdis;
				lpdis = (LPDRAWITEMSTRUCT) lPara;

				switch (lpdis->CtlType)
				{
					case ODT_COMBOBOX:
						{
							char text[256];
							COLORREF forecolor, bkcolor;
							SendMessage (lpdis->hwndItem, CB_GETLBTEXT, lpdis->itemID, (LPARAM) text);
							if (lpdis->itemState & ODS_DISABLED)
							{
								forecolor = SetTextColor (lpdis->hDC, GetSysColor (COLOR_GRAYTEXT));
								bkcolor = SetBkColor (lpdis->hDC, GetSysColor (COLOR_3DFACE));
							}
							else if (lpdis->itemState & ODS_SELECTED)
							{
								if (lpdis->itemData)
								{
									forecolor = SetTextColor (lpdis->hDC, GetSysColor (COLOR_HIGHLIGHTTEXT));
									bkcolor = SetBkColor (lpdis->hDC, GetSysColor (COLOR_HIGHLIGHT));
								}
								else
								{
									forecolor = SetTextColor (lpdis->hDC, GetSysColor (COLOR_GRAYTEXT));
									bkcolor = SetBkColor (lpdis->hDC, GetSysColor (COLOR_WINDOW));
								}
							}
							else
							{
								if (lpdis->itemData)
									forecolor = SetTextColor (lpdis->hDC, GetSysColor (COLOR_WINDOWTEXT));
								else
									forecolor = SetTextColor (lpdis->hDC, GetSysColor (COLOR_GRAYTEXT));
								bkcolor = SetBkColor (lpdis->hDC, GetSysColor (COLOR_WINDOW));
							}

							ExtTextOut (lpdis->hDC,					/* device context */
										lpdis->rcItem.left + 2,		/* ref point x */
										lpdis->rcItem.top + 1,		/* ref point y */
										ETO_CLIPPED | ETO_OPAQUE,	/* options */
										&lpdis->rcItem,				/* clipping rect */
										text,						/* text to draw */
										lstrlen (text),				/* length of text to draw */
										NULL						/* no kerning array */
								);

							SetTextColor (lpdis->hDC, forecolor);
							SetBkColor (lpdis->hDC, bkcolor);

							if (lpdis->itemState & ODS_FOCUS)
								DrawFocusRect (lpdis->hDC, &lpdis->rcItem);

						} break;
					case ODT_BUTTON:
						{
							SendMessage3ToClean (CcWmDRAWCONTROL, hWin, lpdis->hwndItem, lpdis->hDC);

							if (lpdis->itemState & ODS_SELECTED)
								InvertRect (lpdis->hDC, &lpdis->rcItem);

							if (lpdis->itemState & ODS_FOCUS)
								DrawFocusRect (lpdis->hDC, &lpdis->rcItem);
							return TRUE;
						} break;
				}
			} break;
	}
	return DefMDIChildProc (hWin,uMess,wPara,lPara);
}	/* MDIWindowProcedure */

#endif

/*********************************************************************************************
	Cross call procedure implementations.
	Eval<nr> corresponds with a CrossCallEntry generated by NewCrossCallEntry (nr,Eval<nr>).
*********************************************************************************************/
void EvalCcRqBEGINPAINT (CrossCallInfo *pcci)	/* hwnd; HDC result. */
{
//	HDC hdc;
//	hdc = BeginPaint ((HWND) pcci->p1, &gPaintStruct);
	
	printf("EvalCcRqBEGINPAINT -> not implemented\n");
	MakeReturn1Cci (pcci, (int) NULL /*hdc*/);
}

void EvalCcRqENDPAINT (CrossCallInfo *pcci)		/* hwnd; no result.  */
{
//	EndPaint ((HWND) pcci->p1, &gPaintStruct);
	printf("EvalCcRqEndPaint -> not implemented\n");
	MakeReturn0Cci (pcci);
}

void EvalCcRqFAKEPAINT (CrossCallInfo *pcci)		/* hwnd; no result. */
{
//	HWND hwnd = (HWND) pcci->p1;

//
//	BeginPaint (hwnd, &gPaintStruct);
//	EndPaint (hwnd,&gPaintStruct);
//	InvalidateRect (hwnd, NULL, FALSE);

	printf("EvalCcRqFAKEPAINT -> not implemented\n");
	MakeReturn0Cci (pcci);
}

void EvalCcRqDESTROYMODALDIALOG (CrossCallInfo *pcci) /* hwnd; no result. */
{
//	EndDialog ((HWND)pcci->p1,0);
//	ghwndLastModalDialog = NULL;	/*	Create only one zero timer for modal dialog stack. */
	printf("EvalCcRqDESTROYMODALDIALOG -> not implemented\n");
	MakeReturn0Cci (pcci);
}

void EvalCcRqDESTROYMDIDOCWINDOW (CrossCallInfo *pcci)	/* hwndFrame, hwndClient, wPtr; no result. */
{
/*	HWND hwndFrame, hwndClient, hwndDocWindow, newActiveDocWindow;

	hwndFrame     = (HWND) pcci->p1;
	hwndClient    = (HWND) pcci->p2;
	hwndDocWindow = (HWND) pcci->p3;

	// First destroy the given MDI document window.
	SendMessage (hwndClient, WM_MDIDESTROY, (WPARAM) hwndDocWindow, 0);

	// Obtain the new active MDI document window.
	newActiveDocWindow = (HWND) SendMessage (hwndClient, WM_MDIGETACTIVE, (WPARAM) 0, (LPARAM) NULL);
	if (newActiveDocWindow==NULL)			// If all document windows have been closed
	{
		ghActiveFrameWindow  = hwndFrame;	// then keep track of the MDI frame window
		ghActiveClientWindow = hwndClient;	// and client window
	}

*/
	printf("EvalCcRqDESTROYMDIDOCWINDOW -> not implemented\n");
	MakeReturn0Cci (pcci);
}

static gint client_expose_handler(GtkWidget *widget, GdkEventExpose *event, gpointer user_data)
{
	SendMessage6ToClean(CcWmPAINT, (int)gtk_widget_get_parent(gtk_widget_get_parent(widget)),
		event->area.x,
		event->area.y,
		event->area.x+event->area.width,
		event->area.y+event->area.height,
		(int) GDK_DRAWABLE(event->window));

	return GTK_WIDGET_GET_CLASS(widget)->expose_event(widget,event);
};

static void sw_focus_out_handler(GtkWidget *widget, GdkEventFocus *event, gpointer user_data)
{
	if (gInKey)
		SendKeyUpToClean (widget, widget, gCurChar);

	gInKey = FALSE;
	gCurChar = 0;
}

static gboolean sw_button_press_handler(GtkWidget *widget, GdkEventButton *event, gpointer user_data)
{
	if (event->button == 1)
	{
		GtkWidget *client = gtk_widget_get_parent(widget);

		gInMouseDown = TRUE;

		switch (event->type)
		{
		case GDK_BUTTON_PRESS:
			SendMessage6ToClean (CcWmMOUSE, client, client, BUTTONDOWN, event->x, event->y, GetModifiers());
			break;
		case GDK_2BUTTON_PRESS:
			SendMessage6ToClean (CcWmMOUSE, client, client, BUTTONDOUBLEDOWN, event->x, event->y, GetModifiers());
			break;
		case GDK_3BUTTON_PRESS:
			SendMessage6ToClean (CcWmMOUSE, client, client, BUTTONTRIPLEDOWN, event->x, event->y, GetModifiers());
			break;
		}
	}
};

static gboolean sw_button_release_handler(GtkWidget *widget, GdkEventButton *event, gpointer user_data)
{
	if (event->button == 1)
	{
		GtkWidget *client = gtk_widget_get_parent(widget);

		gInMouseDown = FALSE;
		SendMessage6ToClean (CcWmMOUSE, client, client, BUTTONUP, event->x, event->y, GetModifiers());
	}
};

static gboolean sw_motion_notify_handler(GtkWidget *widget, GdkEventMotion *event, gpointer user_data)
{
	GtkWidget *client = gtk_widget_get_parent(widget);

	if (gInMouseDown)
		SendMessage6ToClean(CcWmMOUSE, client, client, BUTTONSTILLDOWN, event->x, event->y, GetModifiers());
	else
		SendMessage6ToClean (CcWmMOUSE, client, client, BUTTONSTILLUP, event->x, event->y, GetModifiers());
};

static void client_size_allocate(GtkWidget *widget, GtkAllocation *allocation, gpointer user_data)
{
	GtkWidget *sw = (GtkWidget *) user_data;
	SendMessage4ToClean (CcWmSIZE, sw, allocation->width, allocation->height, (int)FALSE);
};

static void client_size_request(GtkWidget *widget, GtkRequisition *requisition, gpointer user_data)
{
	*requisition = *((GtkRequisition *) user_data);
	printf("client_size_request(%d,%d)\n", requisition->width, requisition->height);
};

static gboolean client_delete_handler(GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	printf("client_delete_handler(%d,%d)\n", ((GtkRequisition *) user_data)->width, ((GtkRequisition *) user_data)->height);
	g_free((GtkRequisition *) user_data);
	return gtk_true();
}

static void compute_height(GtkWidget *widget, gpointer data)
{
	GtkRequisition requisition;
	gtk_widget_size_request(widget,&requisition);
	*((int *) data) += requisition.height;
};

/*	Create a SDI document window. */
void EvalCcRqCREATESDIDOCWINDOW (CrossCallInfo *pcci)	/* textptr, frameptr, packed pos, w,h, flags; client ptr result. */
{
	GtkWidget *window, *fixed, *box, *sw;
	const gchar *pwintitle;
	gint left, top, right, bottom;
	GtkRequisition *requisition;

	pwintitle    = (const gchar *) pcci->p1;
	window       = (GtkWidget *) pcci->p2;
	left		 = pcci->p3>>16;
	top		 = (pcci->p3<<16)>>16;
	right		 = pcci->p4;
	bottom		 = pcci->p5;

	requisition = g_new(GtkRequisition, 1);
	requisition->width = 0;
	requisition->height = 0;

	/* Adjust the pos and size of the frame window. */
	gtk_widget_set_uposition(window, left, top);

	if (pwintitle)
		gtk_window_set_title(GTK_WINDOW(window), pwintitle);

	/* Create a Scrolled Window */
	sw = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),
				      GTK_POLICY_AUTOMATIC,
				      GTK_POLICY_AUTOMATIC);
	box = gtk_bin_get_child(GTK_BIN(window));
	gtk_box_pack_end (GTK_BOX (box), sw, TRUE, TRUE, 0);

	/* Create a Fixed Container */
	fixed = gtk_fixed_new();
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(sw), fixed);

	/* Signals */
	gtk_signal_connect (GTK_OBJECT(fixed), "expose-event",
			GTK_SIGNAL_FUNC(client_expose_handler),
			NULL);
	gtk_signal_connect (GTK_OBJECT(GTK_BIN(sw)->child), "focus-out-event",
			GTK_SIGNAL_FUNC(sw_focus_out_handler),
			NULL);
	gtk_signal_connect (GTK_OBJECT(GTK_BIN(sw)->child), "button-press-event",
			GTK_SIGNAL_FUNC(sw_button_press_handler),
			NULL);
	gtk_signal_connect (GTK_OBJECT(GTK_BIN(sw)->child), "button-release-event",
			GTK_SIGNAL_FUNC(sw_button_release_handler),
			NULL);
	gtk_signal_connect (GTK_OBJECT(GTK_BIN(sw)->child), "motion_notify_event",
			GTK_SIGNAL_FUNC(sw_motion_notify_handler),
			NULL);
	gtk_signal_connect (GTK_OBJECT(fixed), "size-allocate",
			GTK_SIGNAL_FUNC(client_size_allocate),
			sw);
	gtk_signal_connect (GTK_OBJECT(fixed), "size-request",
			GTK_SIGNAL_FUNC(client_size_request),
			requisition);
	gtk_signal_connect (GTK_OBJECT(fixed), "delete-event",
			GTK_SIGNAL_FUNC(client_delete_handler),
			requisition);

	gtk_object_set_user_data(GTK_OBJECT(sw), requisition);

	SendMessage1ToClean (CcWmCREATE, sw);

	gtk_widget_realize(window);

	{
		int depth;
		GdkRectangle ext_rect, rect;

		gdk_window_get_geometry(window->window, &rect.x, &rect.y, &rect.width, &rect.height, &depth);
		gdk_window_get_frame_extents (window->window,&ext_rect);

		gtk_container_foreach(GTK_CONTAINER(GTK_BIN(window)->child), compute_height, &ext_rect.height);

		gtk_window_set_default_size(window,	(right-left)+(ext_rect.width - rect.width), (bottom-top)+(ext_rect.height - rect.height));
	}

	gtk_widget_show_all(window);

	gdk_window_set_events(GTK_BIN(sw)->child->window,
	    gdk_window_get_events(GTK_BIN(sw)->child->window) | GDK_BUTTON_RELEASE_MASK | GDK_POINTER_MOTION_MASK);

	MakeReturn1Cci (pcci, (int) sw);
}

/*	Create MDI child window. */
void EvalCcRqCREATEMDIDOCWINDOW (CrossCallInfo *pcci)		/* textptr, clientPtr, behindPtr, packed pos, packed size, flags; HWND result. */
{
/*	HWND    whandle,hwndClient,hwndBehind;
	POINT   dims, winpos;
	LPCTSTR pwintitle;
	DWORD   styleFlags, exStyleFlags;
	MDICREATESTRUCT mdicreate;		// The structure sent to the client window

	pwintitle    = (LPCTSTR) pcci->p1;
	hwndClient   = (HWND) pcci->p2;
	hwndBehind   = (HWND) pcci->p3;
	winpos.x     = pcci->p4>>16;
	winpos.y     = (pcci->p4<<16)>>16;
	dims.x       = pcci->p5>>16;
	dims.y       = (pcci->p5<<16)>>16;
	styleFlags   = (DWORD) pcci->p6;
	exStyleFlags = (DWORD) 0;

	if ((styleFlags&WS_THICKFRAME) != 0)
	{	// resizable window
		dims.x += 2 * GetSystemMetrics (SM_CXSIZEFRAME);
		dims.y += 2 * GetSystemMetrics (SM_CYSIZEFRAME) + GetSystemMetrics (SM_CYCAPTION);

		exStyleFlags |= WS_EX_CLIENTEDGE;			// then provide a 3D look to the window.
	}
	else
	{	// fixed size window
		dims.x += 2 * GetSystemMetrics (SM_CXFIXEDFRAME);
		dims.y += 2 * GetSystemMetrics (SM_CYFIXEDFRAME) + GetSystemMetrics (SM_CYCAPTION);
	}

	// fill the MDICREATESTRUCT record 
	mdicreate.szClass = MDIWindowClassName;
	mdicreate.szTitle = pwintitle;
	mdicreate.hOwner  = (HANDLE) ghInst;
	mdicreate.x       = winpos.x;
	mdicreate.y       = winpos.y;
	mdicreate.cx      = dims.x;
	mdicreate.cy      = dims.y;
	mdicreate.style   = styleFlags;
	mdicreate.lParam  = 0;

	// create the window 
	whandle = (HWND) SendMessage (hwndClient,WM_MDICREATE,0,(LPARAM)(LPMDICREATESTRUCT) &mdicreate);

	// take care of window stacking 
	if (hwndBehind!=0)
	{
		SetWindowPos (whandle, hwndBehind, 0, 0, 0, 0, SWP_NOMOVE + SWP_NOSIZE);
	}

*/
	printf("EvalCcRqCREATEMDIDOCWINDOW -> not implemented\n");
	MakeReturn1Cci (pcci, (int) NULL /*whandle*/);
}

void EvalCcRqSETWINDOWTITLE (CrossCallInfo *pcci)		/* hwnd, textptr		no result. */
{
	GtkWidget *window = (GtkWidget *) pcci->p1;
	gchar *title = (gchar *) pcci->p2;

	if (GTK_IS_WINDOW(window))
		gtk_window_set_title(GTK_WINDOW(window), title);
	else
		if (GTK_IS_LABEL(window))
			gtk_label_set_text(GTK_LABEL(window), title);
		else
			if (GTK_IS_BUTTON(window))
			{
				title = createMnemonicString(title);
				gtk_button_set_label(GTK_BUTTON(window), title);
				rfree(title);
			}
			else
				if (GTK_IS_ENTRY(window))
					gtk_entry_set_text(GTK_ENTRY(window), title);
				else
					if (GTK_IS_TEXT_VIEW(window))
					{
						GtkTextBuffer *buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(window));
						gtk_text_buffer_set_text (buffer, title, strlen(title));
					}
					else
						printf("EvalCcRqSETWINDOWTITLE -> unknown widget type");

	MakeReturn0Cci (pcci);
}

void EvalCcRqGETWINDOWTEXT (CrossCallInfo *pcci) /* hwnd;  textptr result. */
{
	G_CONST_RETURN gchar *title = NULL;
	char *textptr;

	GtkWidget *window = (GtkWidget *) pcci->p1;

	if (GTK_IS_WINDOW(window))
			title = gtk_window_get_title(GTK_WINDOW(window));
		else
			if (GTK_IS_LABEL(window))
				title = gtk_label_get_text(GTK_LABEL(window));
			else
				if (GTK_IS_BUTTON(window))
					title = gtk_button_get_label(GTK_BUTTON(window));
				else
					if (GTK_IS_ENTRY(window))
						title = gtk_entry_get_text(GTK_ENTRY(window));
					else
						if (GTK_IS_TEXT_VIEW(window))
						{
							GtkTextBuffer *buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(window));
							GtkTextIter start, end;

							gtk_text_buffer_get_start_iter(buffer, &start);
							gtk_text_buffer_get_end_iter(buffer, &end);
							title = gtk_text_buffer_get_text (buffer, &start, &end, gtk_true());
						}
						else
							printf("EvalCcRqSETWINDOWTITLE -> unknown widget type");

	if (GTK_IS_BUTTON(window))
		textptr = createMnemonicString(title);
	else
		textptr =  g_strdup(title);

	MakeReturn1Cci (pcci, (int) textptr);
}

/*	Update rect part of a window. */
void EvalCcRqUPDATEWINDOWRECT (CrossCallInfo *pcci) /* hwnd, left,top,right,bottom; no result. */
{
/*	RECT rect;
	HWND hwnd;

	hwnd       = (HWND) pcci->p1;
	rect.left  = pcci->p2;
	rect.top   = pcci->p3;
	rect.right = pcci->p4;
	rect.bottom= pcci->p5;

	InvalidateRect (hwnd,&rect,FALSE);
	UpdateWindow (hwnd);
	RedrawWindow (hwnd,&rect,NULL,RDW_FRAME | RDW_VALIDATE | RDW_UPDATENOW | RDW_NOCHILDREN);
*/
	printf("EvalCcRqUPDATEWINDOWRECT -> not implemented\n");
	MakeReturn0Cci (pcci);
}

/*	Set the ClientRect. */
void EvalCcRqSETCLIENTSIZE (CrossCallInfo *pcci) /* hwnd, width, height; no result. */
{
/*	HWND hwnd;
	int w,h,curw,curh,clientw,clienth;
	UINT flags;
	RECT clientRect,windowRect;

	hwnd  = (HWND) pcci->p1;
	w     = pcci->p2;
	h     = pcci->p3;
	flags = SWP_NOMOVE			// retain position 
		  | SWP_NOZORDER;		// retain Z order 

	GetClientRect (hwnd, &clientRect);
	GetWindowRect (hwnd, &windowRect);
	clientw = clientRect.right - clientRect.left;
	clienth = clientRect.bottom- clientRect.top;
	curw    = windowRect.right - windowRect.left;
	curh    = windowRect.bottom- windowRect.top;

	SetWindowPos (hwnd, HWND_TOP, 0,0, curw+w-clientw,curh+h-clienth, flags);
*/
	printf("EvalCcRqSETCLIENTSIZE -> not implemented\n");
	MakeReturn0Cci (pcci);
}

/*	(En/Dis)able windows/dialogues. */
void EvalCcRqSETSELECTWINDOW (CrossCallInfo *pcci)	/* hwnd, hasHScroll, hasVScroll, toAble, modalContext; no result. */
{
#if 0
	HWND window;
	BOOL hasHScroll, hasVScroll, toAble, modalContext;

	window       = (HWND) pcci->p1;
	hasHScroll   = (BOOL) pcci->p2;
	hasVScroll   = (BOOL) pcci->p3;
	toAble       = (BOOL) pcci->p4;
	modalContext = (BOOL) pcci->p5;

	if (modalContext)					/*	if not a modal context, then do not disable window	*/
		EnableWindow (window,toAble);	/*  because it can't be moved, or closed. */
	if (hasHScroll)
		EnableScrollBar (window,SB_HORZ,toAble ? ESB_ENABLE_BOTH : ESB_DISABLE_BOTH);
	if (hasVScroll)
		EnableScrollBar (window,SB_VERT,toAble ? ESB_ENABLE_BOTH : ESB_DISABLE_BOTH);

#endif
	printf("EvalCcRqSETSELECTWINDOW -> not implemented\n");
	MakeReturn0Cci (pcci);
}

/*	Set the position of windows/controls. */
void EvalCcRqSETWINDOWPOS (CrossCallInfo *pcci)	/* hwnd, x,y, update, include scrollbars ; no result. */
{
	/*
	HWND hwnd;
	int x,y;
	BOOL update,inclScrollbars;
	UINT flags;

	hwnd           = (HWND)pcci->p1;
	x              = pcci->p2;
	y              = pcci->p3;
	update         = pcci->p4;
	inclScrollbars = pcci->p5;
	flags          = SWP_NOSIZE			// retain size
				   | SWP_NOZORDER;		// retain Z order

	SetWindowPos (hwnd, HWND_TOP, x,y, 0,0, flags);
	if (IsWindowVisible (hwnd) && update!=0)
	{	// only if window is visible and update is requested, proceed to enforce update.
		if (inclScrollbars)
			UpdateWindowScrollbars (hwnd);
		else
		{
			InvalidateRect (hwnd,NULL,TRUE);
			UpdateWindow (hwnd);
			RedrawWindow (hwnd,NULL,NULL,RDW_FRAME | RDW_VALIDATE | RDW_UPDATENOW | RDW_NOCHILDREN);
		}
	}
*/
	printf("EvalCcRqSETWINDOWPOS -> not implemented\n");
	MakeReturn0Cci (pcci);
}

/*	Get the size of the bounding rectangle of windows/controls. */
void EvalCcRqGETWINDOWSIZE (CrossCallInfo *pcci) /* hwnd; width,height result. */
{
	GtkAllocation *alloc = &(((GtkWidget *) pcci->p1)->allocation);
	MakeReturn2Cci (pcci, alloc->width, alloc->height);
}

/*	Set the size of windows/controls. */
void EvalCcRqSETWINDOWSIZE (CrossCallInfo *pcci) /* hwnd, w,h, update; no result. */
{
#if 0
	HWND hwnd;
	int w,h;
	BOOL update;
	UINT flags;

	hwnd   = (HWND)pcci->p1;
	w      = pcci->p2;
	h      = pcci->p3;
	update = pcci->p4;
	flags  = SWP_NOMOVE			/* retain position */
		   | SWP_NOZORDER;		/* retain Z order  */
	/* flags do not contain SWP_NOREDRAW because otherwise not all windows get updated properly. */

	SetWindowPos (hwnd, HWND_TOP, 0,0, w,h, flags);
	if (update!=0)				/* still, updates are not sufficient using SetWindowPos only. */
		UpdateWindowScrollbars (hwnd);

#endif
	printf("EvalCcRqSETWINDOWSIZE -> not implemented\n");
	MakeReturn0Cci (pcci);
}

/*	Activate control. */
void EvalCcRqACTIVATECONTROL (CrossCallInfo *pcci)	/* controlPtr; no result. */
{
	gtk_widget_grab_focus((GtkWidget *) pcci->p1);
	MakeReturn0Cci (pcci);
}

/*	Activate window. */
void EvalCcRqACTIVATEWINDOW (CrossCallInfo *pcci)	/* isMDI, clientPtr, thisWindow; no result. */
{
	gboolean isMDI;
	GtkWidget *client, *thisWindow;

	isMDI       = (gboolean) pcci->p1;
	client      = (GtkWidget *) pcci->p2;
	thisWindow  = (GtkWidget *) pcci->p3;

	if (isMDI)
	{
		printf("EvalCcRqCHANGEWINDOWCURSOR -> unimplemented\n");
//		SendMessage (client,WM_MDIACTIVATE,(WPARAM)thisWindow,(LPARAM)0);
	}
	else
	{
		 gtk_window_activate_focus (GTK_WINDOW(thisWindow));
	}
	MakeReturn0Cci (pcci);
}

void EvalCcRqCHANGEWINDOWCURSOR (CrossCallInfo *pcci)	/* hwnd, cursor code; no result. It is assumed that the hwnd argument	*/
														/* corresponds to either a SDI/MDI window (and not frame).				*/
{
	printf("EvalCcRqCHANGEWINDOWCURSOR -> unimplemented\n");

/*	HWND hwnd;
	POINT p;
	int cursorcode;
	LocalWindowData wdata;

	hwnd = (HWND) pcci->p1;
	cursorcode = pcci->p2;

	GetCursorPos (&p);

	if (hwnd == WindowFromPoint (p) &&
		SendMessage (hwnd, WM_NCHITTEST, 0, MAKELPARAM (p.x, p.y)) == HTCLIENT)
	{
		SetCursorFromCode (cursorcode);
	}

	wdata = (LocalWindowData) GetWindowLong (hwnd,0);
	wdata->lwd_cursorcode = cursorcode;
	SetWindowLong (hwnd, 0, (long)wdata);
	*/
	MakeReturn0Cci (pcci);
}

void EvalCcRqOBSCURECURSOR (CrossCallInfo *pcci) /* no params; no result. */
{
//	SetCursor(GetHiddenCursor());
	printf("EvalCcRqOBSCURECURSOR -> not implemented\n");
	MakeReturn0Cci (pcci);
}

/*	Set range of scrollbars. */
void EvalCcRqSETSCROLLRANGE (CrossCallInfo *pcci)	/* hwnd, iBar, min, max, redraw, no result */
{
	GtkWidget *widget;
	GtkAdjustment *adj;
	GtkRequisition *requisition;
	int iBar, min, max;
	gboolean redraw;

	widget = (GtkWidget *) pcci->p1;
	iBar   = pcci->p2;
	min    = pcci->p3;		// maxx   is the right-most  x coordinate of the enclosing rectangle of the scrollbar
	max    = pcci->p4;		// maxy   is the bottom-most y coordinate of the enclosing rectangle of the scrollbar
	redraw = pcci->p5;		// extent is the width (height) of the vertical (horizontal) scrollbar

	requisition = (GtkRequisition *) gtk_object_get_user_data(GTK_OBJECT(widget));

	if (iBar==0)
	{
		requisition->width = max-min;
		adj = gtk_scrolled_window_get_hadjustment(GTK_SCROLLED_WINDOW(widget));
	}
	else
	{
		requisition->height = max-min;
		adj = gtk_scrolled_window_get_vadjustment(GTK_SCROLLED_WINDOW(widget));
	}

	printf("client_size_request(%d,%d)\n", requisition->width, requisition->height);

	adj->lower = min;
	adj->upper = max;
	gtk_adjustment_changed(adj);

	MakeReturn0Cci (pcci);
}

/*	Set pos of scrollbars. */
void EvalCcRqSETSCROLLPOS (CrossCallInfo *pcci)	/* hwnd, iBar, thumb, maxx, maxy, extent, no result */
{
	GtkWidget *widget;
	int thumb, iBar, maxx, maxy, extent;

	widget = (GtkWidget *) pcci->p1;
	iBar   = pcci->p2;
	thumb  = pcci->p3;
	maxx   = pcci->p4;		// maxx   is the right-most  x coordinate of the enclosing rectangle of the scrollbar
	maxy   = pcci->p5;		// maxy   is the bottom-most y coordinate of the enclosing rectangle of the scrollbar
	extent = pcci->p6;		// extent is the width (height) of the vertical (horizontal) scrollbar

	if (iBar==0)
		gtk_adjustment_set_value(gtk_scrolled_window_get_hadjustment(GTK_SCROLLED_WINDOW(widget)), thumb);
	else
		gtk_adjustment_set_value(gtk_scrolled_window_get_vadjustment(GTK_SCROLLED_WINDOW(widget)), thumb);

	MakeReturn0Cci (pcci);
}

/*	Set thumb size of scrollbars. */
void EvalCcRqSETSCROLLSIZE (CrossCallInfo *pcci)	/* hwnd, iBar, size, maxx, maxy, extent, no result */
{
	GtkWidget *widget;
	GtkAdjustment *adj;
	int size, iBar, maxx, maxy, extent;

	widget = (GtkWidget *) pcci->p1;
	iBar   = pcci->p2;
	size   = pcci->p3;
	maxx   = pcci->p4;		// maxx   is the right-most  x coordinate of the enclosing rectangle of the scrollbar
	maxy   = pcci->p5;		// maxy   is the bottom-most y coordinate of the enclosing rectangle of the scrollbar
	extent = pcci->p6;		// extent is the width (height) of the vertical (horizontal) scrollbar

	if (iBar==0)
		adj = gtk_scrolled_window_get_hadjustment(GTK_SCROLLED_WINDOW(widget));
	else
		adj = gtk_scrolled_window_get_vadjustment(GTK_SCROLLED_WINDOW(widget));

	adj->page_size = size;
	gtk_adjustment_changed(adj);

	MakeReturn0Cci (pcci);
}

/*	Set selection of edit controls. */
void EvalCcRqSETEDITSELECTION (CrossCallInfo *pcci)	/* hwnd, first, last, no result. */
{
/*	HWND hwnd;
	int first,last;

	hwnd  = (HWND) pcci->p1;
	first = pcci->p2;
	last  = pcci->p3;

	SendMessage (hwnd, EM_SETSEL, (WPARAM) first, (LPARAM) last);		// Set the selection of the edit control.
	SendMessage (hwnd, EM_SCROLLCARET, 0,0);		// Let the caret be displayed - (w/l)Param MUST be 0.
*/
	printf("
EvalCcRqSETEDITSELECTION -> not implemented\n");
	MakeReturn0Cci (pcci);
}

/*	EvalCcRqCREATEDIALOG is now restricted to modeless dialogues only. */
void EvalCcRqCREATEDIALOG (CrossCallInfo *pcci)	// textptr,parentptr,behindPtr; HWND result.
{
	GtkWidget *dialog, *fixed, *defctrl;
	const gchar *pwintitle;
	int x, y, w, h;

	printf("EvalCcRqCREATEDIALOG -> ignore parentptr,behindPtr\n");

	pwintitle    = (const gchar *) pcci->p1;
	dialog       = gtk_window_new(GTK_WINDOW_TOPLEVEL);

	gtk_window_set_resizable(GTK_WINDOW(dialog), gtk_false());

	if (pwintitle)
		gtk_window_set_title(GTK_WINDOW(dialog), pwintitle);

	/* Create a Fixed Container */
	fixed = gtk_fixed_new();
	gtk_container_add(GTK_CONTAINER(dialog), fixed);
	gtk_widget_show(fixed);

	SendMessage1ToClean (CcWmINITDIALOG, (int) fixed);

	x = gCci.p1;
	y = gCci.p2;
	w = gCci.p3;
	h = gCci.p4;
	defctrl = (GtkWidget *) gCci.p5;

	w += 0; //2 * GetSystemMetrics (SM_CXFIXEDFRAME);
	h += 0; //2 * GetSystemMetrics (SM_CXFIXEDFRAME) + GetSystemMetrics (SM_CYCAPTION);

	if (x == -1 && y == -1)
	{
		x = 0; //(GetSystemMetrics (SM_CXSCREEN) - w) / 2;
		y = 0; //(GetSystemMetrics (SM_CYSCREEN) - h) / 2;
	}

	/* Adjust the pos and size of the frame window. */
	gtk_widget_set_uposition(dialog, x, y);
	gtk_widget_set_usize(dialog, w, h);

	if (defctrl != NULL)
	{
		gtk_widget_grab_focus(defctrl);
	}

	gtk_widget_show(dialog);

	MakeReturn1Cci (pcci, (int) fixed);
}

//	Create modal dialogues.
void EvalCcRqCREATEMODALDIALOG (CrossCallInfo *pcci)	/* textptr,parentptr; error code result. */
{
//	WORD *p, *pdlgtemplate;
//	int nchar, errorcode;
//	DWORD lStyle;
//	HWND hwndParent;
//	UINT zeroTimer;

//	hwndParent = (HWND) pcci->p2;	/* The owner window    */
//	if (hwndParent == 0)
//		hwndParent = ghMainWindow;	/* If no parent is passed (NDI) then ghMainWindow should be the parent. */

	/* allocate some memory to play with  */
//	pdlgtemplate = p = (PWORD) rmalloc (1000);

	/* start to fill in the dlgtemplate information. Addressing by WORDs */
//	lStyle = WS_CAPTION | DS_SETFONT | DS_MODALFRAME | WS_SYSMENU | DS_SYSMODAL | WS_VISIBLE;

//	*p++ = LOWORD (lStyle);
//	*p++ = HIWORD (lStyle);
//	*p++ = 0;		/* LOWORD (lExtendedStyle) */
//	*p++ = 0;		/* HIWORD (lExtendedStyle) */
//	*p++ = 0;		/* NumberOfItems */
//	*p++ = 0;		/* x  (dummy value) */
//	*p++ = 0;		/* y  (dummy value) */
//	*p++ = 1000;	/* cx (dummy value) */
//	*p++ = 1000;	/* cy (dummy value) */
//	*p++ = 0;		/* Menu */
//	*p++ = 0;		/* Class */

	/* copy the title of the dialog */
//	nchar = NULL; // nCopyAnsiToWideChar (p, (char *) pcci->p1);
//	p += nchar;
	/* Font information because of DS_SETFONT */
//	*p++ = 8;		/* point size */
//	nchar = NULL; // nCopyAnsiToWideChar (p, "MS Sans Serif");		/* Face name */
//	p += nchar;
	/* make sure the first item starts on a DWORD boundary */

	/*	Before the modal dialog enters its event loop we create a timer to generate timer events.
		This is done only once per modal dialog stack.
	*/
//	if (ghwndLastModalDialog == NULL)	// The first modal dialog.
//	{
//		zeroTimer = SetTimer (NULL, (UINT) 0, (UINT) 0, NULL);

//		if (zeroTimer==0)				// Creation of zero timer failed.
//		{
//			LocalFree (LocalHandle (pdlgtemplate));
//			errorcode = 1;				// Report error to Clean side
//		}
//		else
//		{
//			DialogBoxIndirectParam (ghInst, (LPDLGTEMPLATE) pdlgtemplate, hwndParent, (DLGPROC) DialogProcedure, (LPARAM) 0);
//			LocalFree (LocalHandle (pdlgtemplate));
//			KillTimer (NULL, (UINT) zeroTimer);
//			errorcode = 0;				// Report no error to Clean side
//		}
//	}
//	else	// a zero timer has already been created.
//	{
//		DialogBoxIndirectParam (ghInst, (LPDLGTEMPLATE) pdlgtemplate, hwndParent, (DLGPROC) DialogProcedure, (LPARAM) 0);
//		LocalFree (LocalHandle (pdlgtemplate));
//		errorcode = 0;					// Report no error to Clean side
//	}

	printf("EvalCcRqCREATEMODALDIALOG -> not implemented\n");
	MakeReturn1Cci (pcci,0/*errorcode*/);
}

/*	Create compound controls (window in window) */
void EvalCcRqCREATECOMPOUND (CrossCallInfo *pcci)	/* hwnd, packed pos,w,h, scrollbars, transparent; HWND result. */
{
#if 0
	HWND parentwindow, compoundhandle;
	int left,top, width,height;
	int compoundstyle;
	BOOL transparent;
	DWORD compoundExStyle;

	parentwindow  = (HWND) pcci->p1;
	left          = pcci->p2>>16;
	top           = (pcci->p2<<16)>>16;
	width         = pcci->p3;
	height        = pcci->p4;
	compoundstyle = pcci->p5;
	transparent   = (BOOL) pcci->p6;

	compoundExStyle = WS_EX_CONTROLPARENT;
	if (transparent)
		 compoundExStyle |= WS_EX_TRANSPARENT;

	compoundstyle |= WS_CHILD;// | WS_CLIPSIBLINGS;

	/* create the compound window */
	compoundhandle
		= CreateWindowEx (compoundExStyle,				/* Extended style				 */
						  CompoundControlClassName,		/* Class name					 */
						  "",							/* Window title 				 */
						  compoundstyle,				/* style flags					 */
						  left, top,					/* x, y 						 */
						  width, height,		 		/* width, height				 */
						  parentwindow,					/* Parent window				 */
						  NULL,							/* menu handle					 */
						  (HANDLE) ghInst,				/* Instance that owns the window */
						  0);
	SetWindowPos (compoundhandle, HWND_BOTTOM, 0,0,0,0, SWP_NOMOVE+SWP_NOSIZE);	// This should implement control stack

#endif
	printf("EvalCcRqCREATECOMPOUND -> not implemented\n");
	MakeReturn1Cci (pcci, (int) NULL /*compoundhandle*/);
}

/*	Create scrollbars. */
void EvalCcRqCREATESCROLLBAR (CrossCallInfo *pcci)	/* hwnd, x,y,w,h bool; HWND result. */
{
#if 0
	HWND scroll;
	int style;
	int x, y, w, h;
	HWND parent;
	BOOL ishorizontal;

	parent = (HWND) pcci->p1;
	x = pcci->p2;
	y = pcci->p3;
	w = pcci->p4;
	h = pcci->p5;
	ishorizontal = pcci->p6;

	style	= WS_CHILD
			| WS_GROUP
			| WS_CLIPSIBLINGS;

	if (ishorizontal)
		style |= SBS_HORZ;
	else
		style |= SBS_VERT;

	scroll = CreateWindow (	"scrollbar",
							"",
							style,
							x, y, w, h,
							parent,
							0,
							ghInst,
							0);
	SetWindowPos (scroll, HWND_BOTTOM, 0,0,0,0, SWP_NOMOVE+SWP_NOSIZE);	// This should implement control stack

#endif
	printf("EvalCcRqCREATESCROLLBAR -> not implemented");
	MakeReturn1Cci (pcci, (int) NULL /*scroll*/);
}

static void button_clicked (GtkButton *button, gpointer user_data)
{
	GtkWidget *wbutton = GTK_WIDGET(button);
	GtkWidget *window  = GetControlParent(wbutton);

	switch (GPOINTER_TO_INT(user_data))
	{
		case ISOKBUTTON:
			SendMessage2ToClean (CcWmSPECIALBUTTON, window, ISOKBUTTON);
			return;
		case ISCANCELBUTTON:
			SendMessage2ToClean (CcWmSPECIALBUTTON, window, ISCANCELBUTTON);
			return;
		default:
			SendMessage4ToClean (CcWmBUTTONCLICKED, window, wbutton, GetModifiers (), 0);
			return;
	};
};

void EvalCcRqCREATEBUTTON (CrossCallInfo *pcci)	/* hwnd, x,y,w,h, kind;  HWND result. */
{
	GtkWidget *button, *parent;
	int x, y, w, h, kind;

	parent	= (GtkWidget *) pcci->p1;
	x		= pcci->p2;
	y		= pcci->p3;
	w		= pcci->p4;
	h		= pcci->p5;
	kind	= pcci->p6;

	if (kind==ISOKBUTTON)
	{
		button = gtk_button_new_from_stock("gtk-ok");
	}
	else
	{
		if (kind==ISCANCELBUTTON)
		{
			button = gtk_button_new_from_stock("gtk-quit");
		}
		else
		{
			button = gtk_button_new();
			gtk_button_set_use_underline(GTK_BUTTON(button), gtk_true());
		}
	}

	gtk_signal_connect (GTK_OBJECT (button), "clicked",
			GTK_SIGNAL_FUNC(button_clicked),
			GINT_TO_POINTER(kind));
	gtk_widget_set_usize(button, w, h);
	gtk_fixed_put (GTK_FIXED(GTK_BIN(GTK_BIN(parent)->child)->child), button, x, y);

 	MakeReturn1Cci (pcci, (int) button);
}

void EvalCcRqCREATEICONBUT (CrossCallInfo *pcci)	/* hwnd, x,y,w,h,kind; HWND result. */
{
#if 0
	HWND but, parent;
	int style, id, x, y, w, h, kind;

	parent	= (HWND) pcci->p1;
	x		= pcci->p2;
	y		= pcci->p3;
	w		= pcci->p4;
	h		= pcci->p5;
	kind    = pcci->p6;

	style	= WS_CHILD
			| WS_GROUP
			| WS_TABSTOP
			| BS_OWNERDRAW
			| WS_CLIPSIBLINGS;

	switch (kind)
	{
		case ISOKBUTTON:
			id = IDOK;
			break;
		case ISCANCELBUTTON:
			id = IDCANCEL;
			break;
		default:
			id = 0;
	}

	but = CreateWindow ("button",
						"",
						style,
						x, y, w, h,
						parent,
						(HMENU) id,
						ghInst,
						0);
	SetWindowPos (but, HWND_BOTTOM, 0,0,0,0, SWP_NOMOVE+SWP_NOSIZE);	// This should implement control stack

#endif
	printf("EvalCcRqCREATEICONBUT -> not implemented\n");
	MakeReturn1Cci (pcci, (int) NULL /*but*/);
}

void EvalCcRqCREATECUSTOM (CrossCallInfo *pcci)	/* hwnd, x,y,w,h; HWND result. */
{
#if 0
	HWND ctrl, parent;
	int style, x, y, w, h;

	parent	= (HWND) pcci->p1;
	x		= pcci->p2;
	y		= pcci->p3;
	w		= pcci->p4;
	h		= pcci->p5;
	style	= WS_CHILD
			| WS_GROUP
			| WS_TABSTOP
			| WS_CLIPSIBLINGS;		// Necessary to enforce proper control stack

	ctrl = CreateWindow (CustomControlClassName,
						 "",
						 style,
						 x, y, w, h,
						 parent,
						 (HMENU) 0,
						 ghInst,
						 0);
	SetWindowPos (ctrl, HWND_BOTTOM, 0,0,0,0, SWP_NOMOVE+SWP_NOSIZE);	// This should implement control stack

#endif
	printf("EvalCcRqCREATECUSTOM -> not implemented\n");
	MakeReturn1Cci (pcci, (int) NULL /*ctrl*/);
}

void EvalCcRqCREATESTATICTXT (CrossCallInfo *pcci)		/* hwnd, x,y,w,h; HWND result. */
{
#if 0
	int x, y, w, h;
	GtkWidget *parent, *label;

	parent = (GtkWidget *) pcci->p1;
	x = pcci->p2;
	y = pcci->p3;
	w = pcci->p4;
	h = pcci->p5;

	label =  gtk_label_new(NULL);
	gtk_widget_set_usize(label, w, h);
	gtk_fixed_put (GTK_FIXED(GTK_BIN(GTK_BIN(parent)->child)->child), label, x, y);

#endif
	printf("EvalCcRqCREATESTATICTXT -> not implemented\n");
	MakeReturn1Cci (pcci, (int) NULL /*label*/);
}

static void widget_focus_in_handler(GtkWidget *widget, GdkEventFocus *event, gpointer user_data)
{
	GTK_WIDGET_GET_CLASS(widget)->focus_in_event(widget, event);
	SendMessage2ToClean (CcWmSETFOCUS, GetControlParent(widget), widget);
}

static void widget_focus_out_handler(GtkWidget *widget, GdkEventFocus *event, gpointer user_data)
{
	GtkWidget *parent = GetControlParent(widget);

	GTK_WIDGET_GET_CLASS(widget)->focus_in_event(widget, event);

	if (gInKey)
	{
		SendKeyUpToClean (parent, widget, gCurChar);
		gInKey = FALSE;
		gCurChar = 0;
	}

	SendMessage2ToClean (CcWmKILLFOCUS, parent, widget);
}

static gboolean widget_key_press_handler(GtkWidget *widget, GdkEventKey *event, gpointer user_data)
{
	/* Handle virtual keys analogously to keys received as WM_SYSCHAR and WM_CHAR. */
	GtkWidget *parent = GetControlParent(widget);
	int c = (event->length > 0) ? event->string[0] : CheckVirtualKeyCode (event->keyval);
	if (!c) return gtk_false();

	if (event->keyval == GDK_Tab)
		return gtk_false();

	GTK_WIDGET_GET_CLASS(widget)->key_press_event(widget, event);

	if (gInKey)
	{
		if (gCurChar == c)
			SendKeyStillDownToClean (parent, widget, gCurChar);
		else
		{
			SendKeyUpToClean (parent, widget, gCurChar);
			gCurChar = c;
			SendKeyDownToClean (parent, widget, gCurChar);
		}
	}
	else
	{
		gCurChar = c;
		SendKeyDownToClean (parent, widget, gCurChar);
		gInKey = TRUE;
	}

	return gtk_true();
};

static gboolean widget_key_release_handler(GtkWidget *widget, GdkEventKey *event, gpointer user_data)
{
	if (event->keyval == GDK_Tab)
		return gtk_false();

	GTK_WIDGET_GET_CLASS(widget)->key_press_event(widget, event);

	if (gInKey)
	{
		SendKeyUpToClean (GetControlParent(widget), widget, gCurChar);
		gInKey = FALSE;
		gCurChar = 0;
	}

	return gtk_true();
};

void EvalCcRqCREATEEDITTXT (CrossCallInfo *pcci) /* hwnd, x,y,w,h, flags; HWND result. */
{
	GtkWidget *edit;
	GtkWidget *parent;
	int x, y, w, h, flags;

	parent			= (GtkWidget *) pcci->p1;
	x				= pcci->p2;
	y				= pcci->p3;
	w				= pcci->p4;
	h				= pcci->p5;
	flags			= pcci->p6;

	if (flags & EDITISMULTILINE)
		edit = gtk_text_view_new();
	else
		edit = gtk_entry_new();

	gtk_widget_set_usize(edit, w, h);
	gtk_fixed_put (GTK_FIXED(GTK_BIN(GTK_BIN(parent)->child)->child), edit, x, y);


	gtk_signal_connect (GTK_OBJECT (edit), "focus-in-event",
			GTK_SIGNAL_FUNC(widget_focus_in_handler),
			NULL);

	gtk_signal_connect (GTK_OBJECT (edit), "focus-out-event",
			GTK_SIGNAL_FUNC(widget_focus_out_handler),
			NULL);

	if (flags & EDITISKEYSENSITIVE)
	{
		gtk_signal_connect (GTK_OBJECT (edit), "key-press-event",
			GTK_SIGNAL_FUNC(widget_key_press_handler),
			NULL);

		gtk_signal_connect (GTK_OBJECT (edit), "key-release-event",
			GTK_SIGNAL_FUNC(widget_key_release_handler),
			NULL);
	}

	MakeReturn1Cci (pcci, (int) edit);
}

void EvalCcRqCREATERADIOBUT (CrossCallInfo *pcci)		/* hwnd, x,y,w,h, isfirst;	HWND result. */
{
#if 0
	HWND handle;
	int x, y, w, h, style;
	HWND parent;
	BOOL first;

	parent = (HWND) pcci->p1;
	x = pcci->p2;
	y = pcci->p3;
	w = pcci->p4;
	h = pcci->p5;
	first = pcci->p6;

	style	= WS_CHILD
			| BS_AUTORADIOBUTTON
			| WS_CLIPSIBLINGS;
	if (first)
		style |= WS_GROUP | WS_TABSTOP;

	handle = CreateWindow (	"button",
							"",
							style,
							x, y, w, h,
							parent,
							0,
							ghInst,
							0);
	SetWindowPos (handle, HWND_BOTTOM, 0,0,0,0, SWP_NOMOVE+SWP_NOSIZE);	// This should implement control stack

#endif
	printf("EvalCcRqCREATERADIOBUT -> not implemented\n");
	MakeReturn1Cci (pcci, (int) NULL /*handle*/);
}

void EvalCcRqCREATECHECKBOX (CrossCallInfo *pcci)		/* hwnd, x,y,w,h, isfirst; HWND result. */
{
#if 0
	HWND handle;
	int x, y, w, h, style;
	HWND parent;
	BOOL first;

	parent = (HWND) pcci->p1;
	x = pcci->p2;
	y = pcci->p3;
	w = pcci->p4;
	h = pcci->p5;
	first = pcci->p6;

	style	= WS_CHILD
			| BS_AUTOCHECKBOX
			| WS_CLIPSIBLINGS;
	if (first)
		style |= WS_GROUP | WS_TABSTOP;

	handle = CreateWindow (	"button",
							"",
							style,
							x, y, w, h,
							parent,
							0,
							ghInst,
							0);
	SetWindowPos (handle, HWND_BOTTOM, 0,0,0,0, SWP_NOMOVE+SWP_NOSIZE);	// This should implement control stack

#endif
	printf("EvalCcRqCREATECHECKBOX -> not implemented\n");
	MakeReturn1Cci (pcci, (int) NULL/*handle*/);
}

void EvalCcRqSETITEMCHECK (CrossCallInfo *pcci)	/* hwnd, bool; no result. */
{
#if 0
	HWND hwnd;
	BOOL on;
	int check;

	hwnd = (HWND) pcci->p1;
	on = pcci->p2;

	if (on)
		check = 1;
	else
		check = 0;

	SendMessage (hwnd, BM_SETCHECK, (WPARAM) check, 0);

#endif
	printf("EvalCcRqSETITEMCHECK -> not implemented\n");
	MakeReturn0Cci (pcci);
}

void EvalCcRqENABLECONTROL (CrossCallInfo *pcci) /* hwnd, bool; no result. */
{
	GtkWidget *widget = (GtkWidget *) pcci->p1;
	gboolean newSelect = (gboolean) pcci->p2;

	gtk_widget_set_sensitive(widget, newSelect);
	MakeReturn0Cci (pcci);
}

void EvalCcRqSHOWCONTROL (CrossCallInfo *pcci)	// hwnd, bool; no result.
{
	GtkWidget *control;
	gboolean show;

	control = (GtkWidget *) pcci->p1;
	show    = (gboolean) pcci->p2;

	if (!show)
		gtk_widget_hide(control);
	else
		gtk_widget_show(control);

	MakeReturn0Cci (pcci);
}

/* Hide/show windows. */
void EvalCcRqSHOWWINDOW (CrossCallInfo *pcci)	/* hwnd, show, activate; no result. */
{
	GtkWidget *window;
	gboolean show, activate;

	window   = (GtkWidget *) pcci->p1;
	show     = (gboolean) pcci->p2;
	activate = (gboolean) pcci->p3;

	if (!show)
		gtk_widget_hide(window);
	else
		gtk_widget_show(window);

	if (activate)
		gtk_window_activate_default(GTK_WINDOW(window));

	MakeReturn0Cci (pcci);
}

void EvalCcRqCREATEPOPUP (CrossCallInfo *pcci)	/* hwnd, x,y,w,h,isEditable;  HWND hwndPopUp,hwndEdit (if isEditable). */
{
#if 0
	HWND parent, hwndPopUp, hwndEdit;
	int x, y, w, h;
	int style;
	gboolean isEditable;

	parent     = (HWND) pcci->p1;
	x          = pcci->p2;
	y          = pcci->p3;
	w          = pcci->p4;
	h          = pcci->p5;
	isEditable = (BOOL) pcci->p6;

	style	= WS_CHILD
			| WS_GROUP
			| WS_TABSTOP
			| WS_VSCROLL
			| CBS_AUTOHSCROLL
		//	| CBS_OWNERDRAWFIXED	// PA: removed, otherwise garbage strings appear for empty popups.
			| CBS_HASSTRINGS
			| WS_CLIPSIBLINGS;
	if (isEditable)
		style |= CBS_DROPDOWN;
	else
		style |= CBS_DROPDOWNLIST;

	hwndPopUp = CreateWindowEx (0,
							 "COMBOBOX",
							 "",
							 style,
							 x, y, w, h,
							 parent,
							 (HMENU) 0,
							 ghInst,
							 0);
	SendMessage  (hwndPopUp, CB_SETEXTENDEDUI, (WPARAM) TRUE, 0);
	SetWindowPos (hwndPopUp, HWND_BOTTOM, 0,0,0,0, SWP_NOMOVE+SWP_NOSIZE);	// This should implement control stack

	/*	Store the standard Windows callback routine adress in stdPopUpCallback
		and subclass the combobox's edit control with PopUpControlProcedure.
	*/
	if (isEditable)
	{
		hwndEdit = GetWindow (hwndPopUp,GW_CHILD);
		stdPopUpCallback = SetWindowLong (hwndEdit, GWL_WNDPROC, (LONG) PopUpControlProcedure);
	}
	else
	{
		hwndEdit = 0;
	}
#endif
	printf("EvalCcRqCREATEPOPUP -> not implemented\n");
	MakeReturn2Cci (pcci, (int) NULL /*hwndPopUp*/, (int) NULL /*hwndEdit*/);
}

void EvalCcRqADDTOPOPUP (CrossCallInfo *pcci)	/* hwnd, textptr, enabled, selected, index; Pos result. */
{
/*	int  index, pos;
	HWND hpopup;
	char *text;
	BOOL enabled, selected;

	hpopup   = (HWND) pcci->p1;
	text     = (char *) pcci->p2;
	enabled  = (BOOL) pcci->p3;
	selected = (BOOL) pcci->p4;
	index    = (int)  pcci->p5;

	pos = SendMessage (hpopup, CB_ADDSTRING, 0, (LPARAM) text);
	//pos = SendMessage (hpopup, CB_INSERTSTRING, (WPARAM) index, (LPARAM) text);

	SendMessage (hpopup, CB_SETITEMDATA, (WPARAM) pos, (LPARAM) enabled);

	if (selected)
		SendMessage (hpopup, CB_SETCURSEL, (WPARAM) pos, 0);

*/
	printf("EvalCcRqADDTOPOPUP -> not implemented\n");
	MakeReturn1Cci (pcci, 0 /*pos*/);
}

void EvalCcRqSELECTPOPUPITEM (CrossCallInfo *pcci)		/* hwnd, pos; no result */
{
/*	HWND hpopup;
	int pos;

	hpopup = (HWND) pcci->p1;
	pos = pcci->p2;

	SendMessage (hpopup, CB_SETCURSEL, (WPARAM) pos, 0);

*/
	printf("EvalCcRqSELECTPOPUPITEM -> not implemented\n");
	MakeReturn0Cci (pcci);
}

void EvalCcRqENABLEPOPUPITEM (CrossCallInfo *pcci)		/* hwnd, pos, enabled; no result */
{
/*	HWND hpopup;
	int pos;
	LPARAM enabled;

	hpopup = (HWND) pcci->p1;
	pos = pcci->p2;
	enabled = (LPARAM) pcci->p3;

	SendMessage (hpopup, CB_SETITEMDATA, (WPARAM) pos, enabled);
	if (SendMessage (hpopup, CB_GETCURSEL, 0, 0) == pos)
	{
		InvalidateRect (hpopup, NULL, TRUE);
	}

*/
	printf("EvalCcRqENABLEPOPUPITEM -> not implemented\n");
	MakeReturn0Cci (pcci);
}

void EvalCcRqRESTACKWINDOW (CrossCallInfo *pcci)		/* thewindow,behind; no result. */
{
/*	HWND thePtr, behindPtr;
	UINT uflags = SWP_NOMOVE + SWP_NOSIZE;	//	Do not change current size or location 

	thePtr    = (HWND) pcci->p1;
	behindPtr = (HWND) pcci->p2;

	SetWindowPos (thePtr, behindPtr, 0, 0, 0, 0, uflags);

*/
	printf("EvalCcRqRESTACKWINDOW -> not implemented\n");
	MakeReturn0Cci (pcci);
}

/*	Add controls to tooltip area. */
void EvalCcRqADDCONTROLTIP (CrossCallInfo *pcci) /* parentPtr, controlPtr, textPtr; no result. */
{
	GtkWidget *parent  = (GtkWidget *) pcci->p1;
	GtkWidget *control = (GtkWidget *) pcci->p2;
	gchar *text = (gchar *)pcci->p3;

	gtk_tooltips_set_tip(gTooltip, control, text, text);

	MakeReturn0Cci (pcci);
}

/*	Remove controls from tooltip area. */
void EvalCcRqDELCONTROLTIP (CrossCallInfo *pcci) /* parentPtr, controlPtr; no result. */
{
	GtkWidget *parent  = (GtkWidget *) pcci->p1;
	GtkWidget *control = (GtkWidget *) pcci->p2;

	gtk_tooltips_set_tip(gTooltip, control, NULL, NULL);

	MakeReturn0Cci (pcci);
}

void EvalCcRqCREATECARET(CrossCallInfo *pcci)
{
/*
	HWND hWnd = (HWND) pcci->p1;
	int nWidth = max(max(GetSystemMetrics(SM_CYBORDER), GetSystemMetrics(SM_CXBORDER)) * 2, pcci->p2);
	int nHeight = pcci->p3;

	ghCaretWnd = hWnd;
	CreateCaret(hWnd, NULL, nWidth, nHeight);
	
	ShowCaret(hWnd);

*/
	printf("EvalCcRqCREATECARET -> not implemented\n");
	MakeReturn0Cci (pcci);
}

void EvalCcRqSETCARETPOS(CrossCallInfo *pcci)
{
//	if (ghCaretWnd == (HWND) pcci->p1)
//	{
//		SetCaretPos(pcci->p2, pcci->p3);
//	};

	printf("EvalCcRqSETCARETPOS -> not implemented\n");
	MakeReturn0Cci (pcci);
}

void EvalCcRqDESTROYCARET(CrossCallInfo *pcci)
{
//	HWND hWnd = (HWND) pcci->p1;

//
///	HideCaret(hWnd);
//	DestroyCaret();
//	ghCaretWnd = NULL;

	printf("EvalCcRqDESTROYCARET -> not implemented\n");
	MakeReturn0Cci (pcci);
}

void EvalCcRqSHOWCARET(CrossCallInfo *pcci)
{
//	ShowCaret((HWND) pcci->p1);
	printf("EvalCcRqSHOWCARET -> not implemented\n");
	MakeReturn0Cci (pcci);
}

void EvalCcRqHIDECARET(CrossCallInfo *pcci)
{
//	HideCaret((HWND) pcci->p1);
	printf("EvalCcRqHIDECARET -> not implemented\n");
	MakeReturn0Cci (pcci);
}

/*	Install the cross call procedures in the gCrossCallProcedureTable of cCrossCall_121.
*/
void InstallCrossCallWindows ()
{
	CrossCallProcedureTable newTable;

	newTable = EmptyCrossCallProcedureTable ();
	AddCrossCallEntry (newTable, CcRqBEGINPAINT,             EvalCcRqBEGINPAINT);
	AddCrossCallEntry (newTable, CcRqENDPAINT,               EvalCcRqENDPAINT);
	AddCrossCallEntry (newTable, CcRqFAKEPAINT,              EvalCcRqFAKEPAINT);
	AddCrossCallEntry (newTable, CcRqDESTROYMODALDIALOG,     EvalCcRqDESTROYMODALDIALOG);
	AddCrossCallEntry (newTable, CcRqDESTROYMDIDOCWINDOW,    EvalCcRqDESTROYMDIDOCWINDOW);
	AddCrossCallEntry (newTable, CcRqCREATESDIDOCWINDOW,     EvalCcRqCREATESDIDOCWINDOW);
	AddCrossCallEntry (newTable, CcRqCREATEMDIDOCWINDOW,     EvalCcRqCREATEMDIDOCWINDOW);
	AddCrossCallEntry (newTable, CcRqSETWINDOWTITLE,         EvalCcRqSETWINDOWTITLE);
	AddCrossCallEntry (newTable, CcRqGETWINDOWTEXT,          EvalCcRqGETWINDOWTEXT);
	AddCrossCallEntry (newTable, CcRqUPDATEWINDOWRECT,       EvalCcRqUPDATEWINDOWRECT);
	AddCrossCallEntry (newTable, CcRqSETCLIENTSIZE,          EvalCcRqSETCLIENTSIZE);
	AddCrossCallEntry (newTable, CcRqSETSELECTWINDOW,        EvalCcRqSETSELECTWINDOW);
	AddCrossCallEntry (newTable, CcRqSETWINDOWPOS,           EvalCcRqSETWINDOWPOS);
	AddCrossCallEntry (newTable, CcRqGETWINDOWSIZE,          EvalCcRqGETWINDOWSIZE);
	AddCrossCallEntry (newTable, CcRqSETWINDOWSIZE,          EvalCcRqSETWINDOWSIZE);
	AddCrossCallEntry (newTable, CcRqACTIVATECONTROL,        EvalCcRqACTIVATECONTROL);
	AddCrossCallEntry (newTable, CcRqACTIVATEWINDOW,         EvalCcRqACTIVATEWINDOW);
	AddCrossCallEntry (newTable, CcRqCHANGEWINDOWCURSOR,     EvalCcRqCHANGEWINDOWCURSOR);
	AddCrossCallEntry (newTable, CcRqOBSCURECURSOR,          EvalCcRqOBSCURECURSOR);
	AddCrossCallEntry (newTable, CcRqSETSCROLLRANGE,         EvalCcRqSETSCROLLRANGE);
	AddCrossCallEntry (newTable, CcRqSETSCROLLPOS,           EvalCcRqSETSCROLLPOS);
	AddCrossCallEntry (newTable, CcRqSETSCROLLSIZE,          EvalCcRqSETSCROLLSIZE);
	AddCrossCallEntry (newTable, CcRqSETEDITSELECTION,       EvalCcRqSETEDITSELECTION);
	AddCrossCallEntry (newTable, CcRqCREATEDIALOG,           EvalCcRqCREATEDIALOG);
	AddCrossCallEntry (newTable, CcRqCREATEMODALDIALOG,      EvalCcRqCREATEMODALDIALOG);
	AddCrossCallEntry (newTable, CcRqCREATECOMPOUND,         EvalCcRqCREATECOMPOUND);
	AddCrossCallEntry (newTable, CcRqCREATESCROLLBAR,        EvalCcRqCREATESCROLLBAR);
	AddCrossCallEntry (newTable, CcRqCREATEBUTTON,           EvalCcRqCREATEBUTTON);
	AddCrossCallEntry (newTable, CcRqCREATEICONBUT,          EvalCcRqCREATEICONBUT);
	AddCrossCallEntry (newTable, CcRqCREATECUSTOM,           EvalCcRqCREATECUSTOM);
	AddCrossCallEntry (newTable, CcRqCREATESTATICTXT,        EvalCcRqCREATESTATICTXT);
	AddCrossCallEntry (newTable, CcRqCREATEEDITTXT,          EvalCcRqCREATEEDITTXT);
	AddCrossCallEntry (newTable, CcRqCREATERADIOBUT,         EvalCcRqCREATERADIOBUT);
	AddCrossCallEntry (newTable, CcRqCREATECHECKBOX,         EvalCcRqCREATECHECKBOX);
	AddCrossCallEntry (newTable, CcRqSETITEMCHECK,           EvalCcRqSETITEMCHECK);
	AddCrossCallEntry (newTable, CcRqENABLECONTROL,          EvalCcRqENABLECONTROL);
	AddCrossCallEntry (newTable, CcRqSHOWCONTROL,            EvalCcRqSHOWCONTROL);
	AddCrossCallEntry (newTable, CcRqSHOWWINDOW,             EvalCcRqSHOWWINDOW);
	AddCrossCallEntry (newTable, CcRqCREATEPOPUP,            EvalCcRqCREATEPOPUP);
	AddCrossCallEntry (newTable, CcRqADDTOPOPUP,             EvalCcRqADDTOPOPUP);
	AddCrossCallEntry (newTable, CcRqSELECTPOPUPITEM,        EvalCcRqSELECTPOPUPITEM);
	AddCrossCallEntry (newTable, CcRqENABLEPOPUPITEM,        EvalCcRqENABLEPOPUPITEM);
	AddCrossCallEntry (newTable, CcRqRESTACKWINDOW,          EvalCcRqRESTACKWINDOW);
	AddCrossCallEntry (newTable, CcRqADDCONTROLTIP,          EvalCcRqADDCONTROLTIP);
	AddCrossCallEntry (newTable, CcRqDELCONTROLTIP,          EvalCcRqDELCONTROLTIP);
	AddCrossCallEntry (newTable, CcRqCREATECARET,			 EvalCcRqCREATECARET);
	AddCrossCallEntry (newTable, CcRqSETCARETPOS,			 EvalCcRqSETCARETPOS);
	AddCrossCallEntry (newTable, CcRqDESTROYCARET, 			 EvalCcRqDESTROYCARET);
	AddCrossCallEntry (newTable, CcRqHIDECARET, 			 EvalCcRqHIDECARET);
	AddCrossCallEntry (newTable, CcRqSHOWCARET, 			 EvalCcRqSHOWCARET);
	AddCrossCallEntries (gCrossCallProcedureTable, newTable);
}
