module Cutil_12 ( module Cutil_12, module Addr, module Bits, module Int, module Storable ) where


{-	This module contains some additional routines required for marshalling 
	Haskell arguments to OS C calling routines.
-}

import Addr
import Bits
import Int
import Storable


--	Conversion operations:
i8 :: Int -> Int8
i8 i = fromIntegral i

i16 :: Int -> Int16
i16 i = fromIntegral i

i32 :: Int -> Int32
i32 i = fromIntegral i

btoi :: Bool -> Int
btoi True = -1
btoi _    = 0

itob :: Int -> Bool
itob 0 = False
itob _ = True

--	fpeek addr first peeks addr, then frees addr:
fpeek :: (Storable a) => Addr -> IO a
fpeek addr
	= do {
		x <- peek addr;
		free addr;
		return x
	  }

-- CLEAN_STRING operations:
createCLEAN_STRING :: String -> IO Addr
createCLEAN_STRING string
	= do {
		csPtr <- malloc (4 + nrChars + 1);
		poke csPtr (i32 nrChars);
		pokeString csPtr (fromIntegral 4) string;
		return csPtr
	  }
	where
		nrChars = length string
		
		pokeString :: Addr -> AddrOff -> String -> IO ()
		pokeString csPtr off []     = pokeByteOff csPtr off (i8 0) >> return ()
		pokeString csPtr off (c:cs) = pokeByteOff csPtr off c >> pokeString csPtr (off+fromIntegral 1) cs

freeCLEAN_STRING :: Addr -> IO ()
freeCLEAN_STRING csPtr
	= free csPtr

i8toChar :: Int8 -> Char
i8toChar x = toEnum ((fromIntegral x)::Int)

readCLEAN_STRING :: Addr -> IO String
readCLEAN_STRING csPtr
	= peekString csPtr (fromIntegral 4)
	where
		peekString :: Addr -> AddrOff -> IO String
		peekString csPtr off
			= peekByteOff csPtr off >>= \(c::Int8) ->
				if c==0 then return []
				        else peekString csPtr (off+fromIntegral 1) >>= 
				             \s->return ((i8toChar c):s)
