module CounterControl where


--	********************************************************************************
--	CounterControl defines a new instance of the Controls class.
--	A CounterControl is a control that displays an integer value that can be
--	manually incremented or decremented using two buttons.
--	********************************************************************************


import StdIO


data	CounterControl ls ps
 =	CounterControl Int

instance Controls CounterControl where
	controlToHandles (CounterControl value)
		= do {
			displayId <- openId;
			controlToHandles 
				(	TextControl (show value) [ControlId displayId]
				:+:	NewLS value
				(	ButtonControl "-" [ControlFunction (f (-1) displayId),ControlPos (Below displayId,zero)]
				:+:	ButtonControl "+" [ControlFunction (f   1  displayId)]
				))
		  }
		where
			f dx displayId (value,ps)
				= do {
					setControlText displayId (show (value+dx));
					return (value+dx,ps)
				  }
