-----------------------------------------------------------------------------
-- $Id: Ptr.lhs,v 1.5 2001/01/11 17:25:58 simonmar Exp $
-- 
-- (c) 2000
-- 
-- Module Ptr

\begin{code}
module Ptr (
    --------------------------------------------------------------------
    -- Data pointers.
    
    Ptr(..),      -- data Ptr a
    nullPtr,      -- :: Ptr a
    castPtr,      -- :: Ptr a -> Ptr b
    plusPtr,      -- :: Ptr a -> Int -> Ptr b
    alignPtr,     -- :: Ptr a -> Int -> Ptr a
    minusPtr,     -- :: Ptr a -> Ptr b -> Int
    
    --------------------------------------------------------------------
    -- Function pointers.
    
    FunPtr(..),      -- data FunPtr a
    nullFunPtr,      -- :: FunPtr a
    castFunPtr,      -- :: FunPtr a -> FunPtr b
    castFunPtrToPtr, -- :: FunPtr a -> Ptr b
    castPtrToFunPtr, -- :: Ptr a -> FunPtr b
    
    freeHaskellFunPtr, -- :: FunPtr a -> IO ()
    -- Free the function pointer created by foreign export dynamic.

 ) where

import PrelPtr

foreign import "freeHaskellFunctionPtr" unsafe
    freeHaskellFunPtr :: FunPtr a -> IO ()
\end{code}
