%
% (c) The GRASP/AQUA Project, Glasgow University, 1998-2000
%
\section[Bits]{The @Bits@ interface}

Defines the @Bits@ class containing bit-based operations.
See library document for details on the semantics of the
individual operations.

\begin{code}
module Bits ( 
  Bits(..),
  shiftL, shiftR,   -- :: Bits a => a -> Int -> a
  rotateL, rotateR, -- :: Bits a => a -> Int -> a
 ) where

#ifdef __GLASGOW_HASKELL__
import PrelBits
import PrelNum
import PrelBase
#endif
\end{code}

Instance of Bits for Integer.

\begin{code}
#ifdef __GLASGOW_HASKELL__
instance Bits Integer where
   (S# x) .&. (S# y) = S# (word2Int# (int2Word# x `and#` int2Word# y))
   x@(S# _) .&. y = toBig x .&. y
   x .&. y@(S# _) = x .&. toBig y
   (J# s1 d1) .&. (J# s2 d2) = 
	case andInteger# s1 d1 s2 d2 of
	  (# s, d #) -> J# s d
   
   (S# x) .|. (S# y) = S# (word2Int# (int2Word# x `or#` int2Word# y))
   x@(S# _) .|. y = toBig x .|. y
   x .|. y@(S# _) = x .|. toBig y
   (J# s1 d1) .|. (J# s2 d2) = 
	case orInteger# s1 d1 s2 d2 of
	  (# s, d #) -> J# s d
   
   (S# x) `xor` (S# y) = S# (word2Int# (int2Word# x `xor#` int2Word# y))
   x@(S# _) `xor` y = toBig x `xor` y
   x `xor` y@(S# _) = x `xor` toBig y
   (J# s1 d1) `xor` (J# s2 d2) =
	case xorInteger# s1 d1 s2 d2 of
	  (# s, d #) -> J# s d
   
   complement (S# x) = S# (word2Int# (int2Word# x `xor#` int2Word# (0# -# 1#)))
   complement (J# s d) = case complementInteger# s d of (# s, d #) -> J# s d

   shift x i | i >= 0    = x * 2^i
	     | otherwise = x `div` 2^(-i)

   rotate x i = shift x i   -- since an Integer never wraps around

   bitSize _  = error "Bits.bitSize(Integer)"
   isSigned _ = True
#endif
\end{code}
