{-
   Cube.hs (adapted from cube.c which is (c) Silicon Graphics, Inc)
   This file is part of HOpenGL - a binding of OpenGL and GLUT for Haskell.
   Copyright (C) 2000  Sven Panne <Sven.Panne@BetaResearch.de>

   This program demonstrates a single modeling transformation,
   scalef() and a single viewing transformation, lookAt().
   A wireframe cube is rendered.
-}

import System   ( ExitCode(..), exitWith )

import GL
import GLU
import GLUT

myInit :: IO ()
myInit = do
   clearColor (Color4 0.0 0.0 0.0 0.0)
   shadeModel GL.Flat

display :: DisplayAction
display = do
   clear [ColorBufferBit]
   color (Color3 1 1 (1 ::GLfloat))
   loadIdentity            -- clear the matrix
                           -- viewing transformation
   lookAt (Vertex3 0 0 5) (Vertex3 0 0 0) (Normal3 0 1 0)
   scale 1 2 (1 ::GLfloat) -- modeling transformation
   wireCube 1
   flush

reshape :: ReshapeAction
reshape screenSize = do
   viewport (Viewport (WindowPosition 0 0) screenSize)
   matrixMode Projection
   loadIdentity
   frustum (-1.0) 1.0 (-1.0) 1.0 1.5 20.0
   matrixMode Modelview

keyboard :: KeyboardAction
keyboard '\27' _ = exitWith ExitSuccess
keyboard _     _ = return ()

main :: IO ()
main = do
   (progName, _args) <- GLUT.init Nothing
   createWindow progName display [ Single, GLUT.Rgb ]
                (Just (WindowPosition 100 100))
                (Just (WindowSize     500 500))
   myInit
   reshapeFunc (Just reshape)
   keyboardFunc (Just keyboard)
   mainLoop
