{-
HOpenGL - a binding of OpenGL and GLUT for Haskell.
Copyright (C) 2000  Sven Panne <Sven.Panne@BetaResearch.de>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library (COPYING.LIB); if not, write to the Free
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

This module corresponds to section 2.9 (Rectangles) of the OpenGL 1.2.1 specs.
-}

module GL_Rectangles (
   Rect(..), RectV(..)
) where

import Foreign          (Ptr)
import GL_BasicTypes    (GLshort, GLint, GLfloat, GLdouble)
import GL_VertexSpec    (Vertex2(..))

---------------------------------------------------------------------------

class Rect a where
   rect :: Vertex2 a -> Vertex2 a -> IO ()

instance Rect GLshort where
   rect (Vertex2 x1 y1) (Vertex2 x2 y2) = glRects x1 y1 x2 y2

instance Rect GLint where
   rect (Vertex2 x1 y1) (Vertex2 x2 y2) = glRecti x1 y1 x2 y2

instance Rect GLfloat where
   rect (Vertex2 x1 y1) (Vertex2 x2 y2) = glRectf x1 y1 x2 y2

instance Rect GLdouble where
   rect (Vertex2 x1 y1) (Vertex2 x2 y2) = glRectd x1 y1 x2 y2

foreign import "glRects" unsafe glRects :: GLshort  -> GLshort  -> GLshort  -> GLshort  -> IO ()
foreign import "glRecti" unsafe glRecti :: GLint    -> GLint    -> GLint    -> GLint    -> IO ()
foreign import "glRectf" unsafe glRectf :: GLfloat  -> GLfloat  -> GLfloat  -> GLfloat  -> IO ()
foreign import "glRectd" unsafe glRectd :: GLdouble -> GLdouble -> GLdouble -> GLdouble -> IO ()

---------------------------------------------------------------------------

class RectV a where
   rectV :: Ptr (Vertex2 a) -> Ptr (Vertex2 a) -> IO ()

instance RectV GLshort where
   rectV = glRectsv

instance RectV GLint where
   rectV = glRectiv

instance RectV GLfloat where
   rectV = glRectfv

instance RectV GLdouble where
   rectV = glRectdv

foreign import "glRectsv" unsafe glRectsv :: Ptr (Vertex2 GLshort ) -> Ptr (Vertex2 GLshort ) -> IO ()
foreign import "glRectiv" unsafe glRectiv :: Ptr (Vertex2 GLint   ) -> Ptr (Vertex2 GLint   ) -> IO ()
foreign import "glRectfv" unsafe glRectfv :: Ptr (Vertex2 GLfloat ) -> Ptr (Vertex2 GLfloat ) -> IO ()
foreign import "glRectdv" unsafe glRectdv :: Ptr (Vertex2 GLdouble) -> Ptr (Vertex2 GLdouble) -> IO ()
