{-
HOpenGL - a binding of OpenGL and GLUT for Haskell.
Copyright (C) 2000  Sven Panne <Sven.Panne@BetaResearch.de>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library (COPYING.LIB); if not, write to the Free
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-}

#include "config.h"

module GL_Constants where

import Int
import Word

default (HTYPE_GLENUM)

-- Boolean values --------------------------------------------------------------
gl_FALSE, gl_TRUE :: HTYPE_GLBOOLEAN
gl_FALSE                               = 0x0
gl_TRUE                                = 0x1

-- Data types ------------------------------------------------------------------
gl_BYTE                                = 0x1400
gl_UNSIGNED_BYTE                       = 0x1401
gl_SHORT                               = 0x1402
gl_UNSIGNED_SHORT                      = 0x1403
gl_INT                                 = 0x1404
gl_UNSIGNED_INT                        = 0x1405
gl_FLOAT                               = 0x1406
gl_DOUBLE                              = 0x140A
gl_2_BYTES                             = 0x1407
gl_3_BYTES                             = 0x1408
gl_4_BYTES                             = 0x1409

-- Primitives ------------------------------------------------------------------
gl_POINTS                              = 0x0000
gl_LINES                               = 0x0001
gl_LINE_LOOP                           = 0x0002
gl_LINE_STRIP                          = 0x0003
gl_TRIANGLES                           = 0x0004
gl_TRIANGLE_STRIP                      = 0x0005
gl_TRIANGLE_FAN                        = 0x0006
gl_QUADS                               = 0x0007
gl_QUAD_STRIP                          = 0x0008
gl_POLYGON                             = 0x0009

-- Vertex Arrays ---------------------------------------------------------------
gl_VERTEX_ARRAY                        = 0x8074
gl_NORMAL_ARRAY                        = 0x8075
gl_COLOR_ARRAY                         = 0x8076
gl_INDEX_ARRAY                         = 0x8077
gl_TEXTURE_COORD_ARRAY                 = 0x8078
gl_EDGE_FLAG_ARRAY                     = 0x8079
gl_VERTEX_ARRAY_SIZE                   = 0x807A
gl_VERTEX_ARRAY_TYPE                   = 0x807B
gl_VERTEX_ARRAY_STRIDE                 = 0x807C
gl_NORMAL_ARRAY_TYPE                   = 0x807E
gl_NORMAL_ARRAY_STRIDE                 = 0x807F
gl_COLOR_ARRAY_SIZE                    = 0x8081
gl_COLOR_ARRAY_TYPE                    = 0x8082
gl_COLOR_ARRAY_STRIDE                  = 0x8083
gl_INDEX_ARRAY_TYPE                    = 0x8085
gl_INDEX_ARRAY_STRIDE                  = 0x8086
gl_TEXTURE_COORD_ARRAY_SIZE            = 0x8088
gl_TEXTURE_COORD_ARRAY_TYPE            = 0x8089
gl_TEXTURE_COORD_ARRAY_STRIDE          = 0x808A
gl_EDGE_FLAG_ARRAY_STRIDE              = 0x808C
gl_VERTEX_ARRAY_POINTER                = 0x808E
gl_NORMAL_ARRAY_POINTER                = 0x808F
gl_COLOR_ARRAY_POINTER                 = 0x8090
gl_INDEX_ARRAY_POINTER                 = 0x8091
gl_TEXTURE_COORD_ARRAY_POINTER         = 0x8092
gl_EDGE_FLAG_ARRAY_POINTER             = 0x8093
gl_V2F                                 = 0x2A20
gl_V3F                                 = 0x2A21
gl_C4UB_V2F                            = 0x2A22
gl_C4UB_V3F                            = 0x2A23
gl_C3F_V3F                             = 0x2A24
gl_N3F_V3F                             = 0x2A25
gl_C4F_N3F_V3F                         = 0x2A26
gl_T2F_V3F                             = 0x2A27
gl_T4F_V4F                             = 0x2A28
gl_T2F_C4UB_V3F                        = 0x2A29
gl_T2F_C3F_V3F                         = 0x2A2A
gl_T2F_N3F_V3F                         = 0x2A2B
gl_T2F_C4F_N3F_V3F                     = 0x2A2C
gl_T4F_C4F_N3F_V4F                     = 0x2A2D

-- Matrix Mode -----------------------------------------------------------------
gl_MATRIX_MODE                         = 0x0BA0
gl_MODELVIEW                           = 0x1700
gl_PROJECTION                          = 0x1701
gl_TEXTURE                             = 0x1702

-- Points ----------------------------------------------------------------------
gl_POINT_SMOOTH                        = 0x0B10
gl_POINT_SIZE                          = 0x0B11
gl_POINT_SIZE_GRANULARITY              = 0x0B13
gl_POINT_SIZE_RANGE                    = 0x0B12

-- Lines -----------------------------------------------------------------------
gl_LINE_SMOOTH                         = 0x0B20
gl_LINE_STIPPLE                        = 0x0B24
gl_LINE_STIPPLE_PATTERN                = 0x0B25
gl_LINE_STIPPLE_REPEAT                 = 0x0B26
gl_LINE_WIDTH                          = 0x0B21
gl_LINE_WIDTH_GRANULARITY              = 0x0B23
gl_LINE_WIDTH_RANGE                    = 0x0B22

-- Polygons --------------------------------------------------------------------
gl_POINT                               = 0x1B00
gl_LINE                                = 0x1B01
gl_FILL                                = 0x1B02
gl_CW                                  = 0x0900
gl_CCW                                 = 0x0901
gl_FRONT                               = 0x0404
gl_BACK                                = 0x0405
gl_POLYGON_MODE                        = 0x0B40
gl_POLYGON_SMOOTH                      = 0x0B41
gl_POLYGON_STIPPLE                     = 0x0B42
gl_EDGE_FLAG                           = 0x0B43
gl_CULL_FACE                           = 0x0B44
gl_CULL_FACE_MODE                      = 0x0B45
gl_FRONT_FACE                          = 0x0B46
gl_POLYGON_OFFSET_FACTOR               = 0x8038
gl_POLYGON_OFFSET_UNITS                = 0x2A00
gl_POLYGON_OFFSET_POINT                = 0x2A01
gl_POLYGON_OFFSET_LINE                 = 0x2A02
gl_POLYGON_OFFSET_FILL                 = 0x8037

-- Display Lists ---------------------------------------------------------------
gl_COMPILE                             = 0x1300
gl_COMPILE_AND_EXECUTE                 = 0x1301
gl_LIST_BASE                           = 0x0B32
gl_LIST_INDEX                          = 0x0B33
gl_LIST_MODE                           = 0x0B30

-- Depth buffer ----------------------------------------------------------------
gl_NEVER                               = 0x0200
gl_LESS                                = 0x0201
gl_EQUAL                               = 0x0202
gl_LEQUAL                              = 0x0203
gl_GREATER                             = 0x0204
gl_NOTEQUAL                            = 0x0205
gl_GEQUAL                              = 0x0206
gl_ALWAYS                              = 0x0207
gl_DEPTH_TEST                          = 0x0B71
gl_DEPTH_BITS                          = 0x0D56
gl_DEPTH_CLEAR_VALUE                   = 0x0B73
gl_DEPTH_FUNC                          = 0x0B74
gl_DEPTH_RANGE                         = 0x0B70
gl_DEPTH_WRITEMASK                     = 0x0B72
gl_DEPTH_COMPONENT                     = 0x1902

-- Lighting --------------------------------------------------------------------
gl_LIGHTING                            = 0x0B50
gl_LIGHT0                              = 0x4000
gl_LIGHT1                              = 0x4001
gl_LIGHT2                              = 0x4002
gl_LIGHT3                              = 0x4003
gl_LIGHT4                              = 0x4004
gl_LIGHT5                              = 0x4005
gl_LIGHT6                              = 0x4006
gl_LIGHT7                              = 0x4007
gl_SPOT_EXPONENT                       = 0x1205
gl_SPOT_CUTOFF                         = 0x1206
gl_CONSTANT_ATTENUATION                = 0x1207
gl_LINEAR_ATTENUATION                  = 0x1208
gl_QUADRATIC_ATTENUATION               = 0x1209
gl_AMBIENT                             = 0x1200
gl_DIFFUSE                             = 0x1201
gl_SPECULAR                            = 0x1202
gl_SHININESS                           = 0x1601
gl_EMISSION                            = 0x1600
gl_POSITION                            = 0x1203
gl_SPOT_DIRECTION                      = 0x1204
gl_AMBIENT_AND_DIFFUSE                 = 0x1602
gl_COLOR_INDEXES                       = 0x1603
gl_LIGHT_MODEL_TWO_SIDE                = 0x0B52
gl_LIGHT_MODEL_LOCAL_VIEWER            = 0x0B51
gl_LIGHT_MODEL_AMBIENT                 = 0x0B53
gl_FRONT_AND_BACK                      = 0x0408
gl_SHADE_MODEL                         = 0x0B54
gl_FLAT                                = 0x1D00
gl_SMOOTH                              = 0x1D01
gl_COLOR_MATERIAL                      = 0x0B57
gl_COLOR_MATERIAL_FACE                 = 0x0B55
gl_COLOR_MATERIAL_PARAMETER            = 0x0B56
gl_NORMALIZE                           = 0x0BA1

-- User clipping planes --------------------------------------------------------
gl_CLIP_PLANE0                         = 0x3000
gl_CLIP_PLANE1                         = 0x3001
gl_CLIP_PLANE2                         = 0x3002
gl_CLIP_PLANE3                         = 0x3003
gl_CLIP_PLANE4                         = 0x3004
gl_CLIP_PLANE5                         = 0x3005

-- Accumulation buffer ---------------------------------------------------------
gl_ACCUM_RED_BITS                      = 0x0D58
gl_ACCUM_GREEN_BITS                    = 0x0D59
gl_ACCUM_BLUE_BITS                     = 0x0D5A
gl_ACCUM_ALPHA_BITS                    = 0x0D5B
gl_ACCUM_CLEAR_VALUE                   = 0x0B80
gl_ACCUM                               = 0x0100
gl_ADD                                 = 0x0104
gl_LOAD                                = 0x0101
gl_MULT                                = 0x0103
gl_RETURN                              = 0x0102

-- Alpha testing ---------------------------------------------------------------
gl_ALPHA_TEST                          = 0x0BC0
gl_ALPHA_TEST_REF                      = 0x0BC2
gl_ALPHA_TEST_FUNC                     = 0x0BC1

-- Blending --------------------------------------------------------------------
gl_BLEND                               = 0x0BE2
gl_BLEND_SRC                           = 0x0BE1
gl_BLEND_DST                           = 0x0BE0
gl_ZERO                                = 0x0
gl_ONE                                 = 0x1
gl_SRC_COLOR                           = 0x0300
gl_ONE_MINUS_SRC_COLOR                 = 0x0301
gl_DST_COLOR                           = 0x0306
gl_ONE_MINUS_DST_COLOR                 = 0x0307
gl_SRC_ALPHA                           = 0x0302
gl_ONE_MINUS_SRC_ALPHA                 = 0x0303
gl_DST_ALPHA                           = 0x0304
gl_ONE_MINUS_DST_ALPHA                 = 0x0305
gl_SRC_ALPHA_SATURATE                  = 0x0308
gl_CONSTANT_COLOR                      = 0x8001
gl_ONE_MINUS_CONSTANT_COLOR            = 0x8002
gl_CONSTANT_ALPHA                      = 0x8003
gl_ONE_MINUS_CONSTANT_ALPHA            = 0x8004

-- Render Mode -----------------------------------------------------------------
gl_FEEDBACK                            = 0x1C01
gl_RENDER                              = 0x1C00
gl_SELECT                              = 0x1C02

-- Feedback --------------------------------------------------------------------
gl_2D                                  = 0x0600
gl_3D                                  = 0x0601
gl_3D_COLOR                            = 0x0602
gl_3D_COLOR_TEXTURE                    = 0x0603
gl_4D_COLOR_TEXTURE                    = 0x0604
gl_POINT_TOKEN                         = 0x0701
gl_LINE_TOKEN                          = 0x0702
gl_LINE_RESET_TOKEN                    = 0x0707
gl_POLYGON_TOKEN                       = 0x0703
gl_BITMAP_TOKEN                        = 0x0704
gl_DRAW_PIXEL_TOKEN                    = 0x0705
gl_COPY_PIXEL_TOKEN                    = 0x0706
gl_PASS_THROUGH_TOKEN                  = 0x0700
gl_FEEDBACK_BUFFER_POINTER             = 0x0DF0
gl_FEEDBACK_BUFFER_SIZE                = 0x0DF1
gl_FEEDBACK_BUFFER_TYPE                = 0x0DF2

-- Selection -------------------------------------------------------------------
gl_SELECTION_BUFFER_POINTER            = 0x0DF3
gl_SELECTION_BUFFER_SIZE               = 0x0DF4

-- Fog -------------------------------------------------------------------------
gl_FOG                                 = 0x0B60
gl_FOG_MODE                            = 0x0B65
gl_FOG_DENSITY                         = 0x0B62
gl_FOG_COLOR                           = 0x0B66
gl_FOG_INDEX                           = 0x0B61
gl_FOG_START                           = 0x0B63
gl_FOG_END                             = 0x0B64

gl_LINEAR, gl_EXP, gl_EXP2 :: HTYPE_GLINT
gl_LINEAR                              = 0x2601
gl_EXP                                 = 0x0800
gl_EXP2                                = 0x0801

-- Logic Ops -------------------------------------------------------------------
gl_LOGIC_OP                            = 0x0BF1
gl_INDEX_LOGIC_OP                      = 0x0BF1
gl_COLOR_LOGIC_OP                      = 0x0BF2
gl_LOGIC_OP_MODE                       = 0x0BF0
gl_CLEAR                               = 0x1500
gl_SET                                 = 0x150F
gl_COPY                                = 0x1503
gl_COPY_INVERTED                       = 0x150C
gl_NOOP                                = 0x1505
gl_INVERT                              = 0x150A
gl_AND                                 = 0x1501
gl_NAND                                = 0x150E
gl_OR                                  = 0x1507
gl_NOR                                 = 0x1508
gl_XOR                                 = 0x1506
gl_EQUIV                               = 0x1509
gl_AND_REVERSE                         = 0x1502
gl_AND_INVERTED                        = 0x1504
gl_OR_REVERSE                          = 0x150B
gl_OR_INVERTED                         = 0x150D

-- Stencil ---------------------------------------------------------------------
gl_STENCIL_TEST                        = 0x0B90
gl_STENCIL_WRITEMASK                   = 0x0B98
gl_STENCIL_BITS                        = 0x0D57
gl_STENCIL_FUNC                        = 0x0B92
gl_STENCIL_VALUE_MASK                  = 0x0B93
gl_STENCIL_REF                         = 0x0B97
gl_STENCIL_FAIL                        = 0x0B94
gl_STENCIL_PASS_DEPTH_PASS             = 0x0B96
gl_STENCIL_PASS_DEPTH_FAIL             = 0x0B95
gl_STENCIL_CLEAR_VALUE                 = 0x0B91
gl_STENCIL_INDEX                       = 0x1901
gl_KEEP                                = 0x1E00
gl_REPLACE                             = 0x1E01
gl_INCR                                = 0x1E02
gl_DECR                                = 0x1E03

-- Buffers, Pixel Drawing/Reading ----------------------------------------------
gl_NONE                                = 0x0
gl_LEFT                                = 0x0406
gl_RIGHT                               = 0x0407
-- GL_FRONT                               = 0x0404 -- see Polygons
-- GL_BACK                                = 0x0405 -- see Polygons
-- GL_FRONT_AND_BACK                      = 0x0408 -- see Lighting
gl_FRONT_LEFT                          = 0x0400
gl_FRONT_RIGHT                         = 0x0401
gl_BACK_LEFT                           = 0x0402
gl_BACK_RIGHT                          = 0x0403
gl_AUX0                                = 0x0409
gl_AUX1                                = 0x040A
gl_AUX2                                = 0x040B
gl_AUX3                                = 0x040C
gl_COLOR_INDEX                         = 0x1900
gl_RED                                 = 0x1903
gl_GREEN                               = 0x1904
gl_BLUE                                = 0x1905
gl_ALPHA                               = 0x1906
gl_LUMINANCE                           = 0x1909
gl_LUMINANCE_ALPHA                     = 0x190A
gl_ALPHA_BITS                          = 0x0D55
gl_RED_BITS                            = 0x0D52
gl_GREEN_BITS                          = 0x0D53
gl_BLUE_BITS                           = 0x0D54
gl_INDEX_BITS                          = 0x0D51
gl_SUBPIXEL_BITS                       = 0x0D50
gl_AUX_BUFFERS                         = 0x0C00
gl_READ_BUFFER                         = 0x0C02
gl_DRAW_BUFFER                         = 0x0C01
gl_DOUBLEBUFFER                        = 0x0C32
gl_STEREO                              = 0x0C33
gl_BITMAP                              = 0x1A00
gl_COLOR                               = 0x1800
gl_DEPTH                               = 0x1801
gl_STENCIL                             = 0x1802
gl_DITHER                              = 0x0BD0
gl_RGB                                 = 0x1907
gl_RGBA                                = 0x1908

-- Implementation limits -------------------------------------------------------
gl_MAX_LIST_NESTING                    = 0x0B31
gl_MAX_ATTRIB_STACK_DEPTH              = 0x0D35
gl_MAX_MODELVIEW_STACK_DEPTH           = 0x0D36
gl_MAX_NAME_STACK_DEPTH                = 0x0D37
gl_MAX_PROJECTION_STACK_DEPTH          = 0x0D38
gl_MAX_TEXTURE_STACK_DEPTH             = 0x0D39
gl_MAX_EVAL_ORDER                      = 0x0D30
gl_MAX_LIGHTS                          = 0x0D31
gl_MAX_CLIP_PLANES                     = 0x0D32
gl_MAX_TEXTURE_SIZE                    = 0x0D33
gl_MAX_PIXEL_MAP_TABLE                 = 0x0D34
gl_MAX_VIEWPORT_DIMS                   = 0x0D3A
gl_MAX_CLIENT_ATTRIB_STACK_DEPTH       = 0x0D3B

-- Gets ------------------------------------------------------------------------
gl_ATTRIB_STACK_DEPTH                  = 0x0BB0
gl_CLIENT_ATTRIB_STACK_DEPTH           = 0x0BB1
gl_COLOR_CLEAR_VALUE                   = 0x0C22
gl_COLOR_WRITEMASK                     = 0x0C23
gl_CURRENT_INDEX                       = 0x0B01
gl_CURRENT_COLOR                       = 0x0B00
gl_CURRENT_NORMAL                      = 0x0B02
gl_CURRENT_RASTER_COLOR                = 0x0B04
gl_CURRENT_RASTER_DISTANCE             = 0x0B09
gl_CURRENT_RASTER_INDEX                = 0x0B05
gl_CURRENT_RASTER_POSITION             = 0x0B07
gl_CURRENT_RASTER_TEXTURE_COORDS       = 0x0B06
gl_CURRENT_RASTER_POSITION_VALID       = 0x0B08
gl_CURRENT_TEXTURE_COORDS              = 0x0B03
gl_INDEX_CLEAR_VALUE                   = 0x0C20
gl_INDEX_MODE                          = 0x0C30
gl_INDEX_WRITEMASK                     = 0x0C21
gl_MODELVIEW_MATRIX                    = 0x0BA6
gl_MODELVIEW_STACK_DEPTH               = 0x0BA3
gl_NAME_STACK_DEPTH                    = 0x0D70
gl_PROJECTION_MATRIX                   = 0x0BA7
gl_PROJECTION_STACK_DEPTH              = 0x0BA4
gl_RENDER_MODE                         = 0x0C40
gl_RGBA_MODE                           = 0x0C31
gl_TEXTURE_MATRIX                      = 0x0BA8
gl_TEXTURE_STACK_DEPTH                 = 0x0BA5
gl_VIEWPORT                            = 0x0BA2

-- Evaluators ------------------------------------------------------------------
gl_AUTO_NORMAL                         = 0x0D80
gl_MAP1_COLOR_4                        = 0x0D90
gl_MAP1_GRID_DOMAIN                    = 0x0DD0
gl_MAP1_GRID_SEGMENTS                  = 0x0DD1
gl_MAP1_INDEX                          = 0x0D91
gl_MAP1_NORMAL                         = 0x0D92
gl_MAP1_TEXTURE_COORD_1                = 0x0D93
gl_MAP1_TEXTURE_COORD_2                = 0x0D94
gl_MAP1_TEXTURE_COORD_3                = 0x0D95
gl_MAP1_TEXTURE_COORD_4                = 0x0D96
gl_MAP1_VERTEX_3                       = 0x0D97
gl_MAP1_VERTEX_4                       = 0x0D98
gl_MAP2_COLOR_4                        = 0x0DB0
gl_MAP2_GRID_DOMAIN                    = 0x0DD2
gl_MAP2_GRID_SEGMENTS                  = 0x0DD3
gl_MAP2_INDEX                          = 0x0DB1
gl_MAP2_NORMAL                         = 0x0DB2
gl_MAP2_TEXTURE_COORD_1                = 0x0DB3
gl_MAP2_TEXTURE_COORD_2                = 0x0DB4
gl_MAP2_TEXTURE_COORD_3                = 0x0DB5
gl_MAP2_TEXTURE_COORD_4                = 0x0DB6
gl_MAP2_VERTEX_3                       = 0x0DB7
gl_MAP2_VERTEX_4                       = 0x0DB8
gl_COEFF                               = 0x0A00
gl_DOMAIN                              = 0x0A02
gl_ORDER                               = 0x0A01

-- Hints -----------------------------------------------------------------------
gl_FOG_HINT                            = 0x0C54
gl_LINE_SMOOTH_HINT                    = 0x0C52
gl_PERSPECTIVE_CORRECTION_HINT         = 0x0C50
gl_POINT_SMOOTH_HINT                   = 0x0C51
gl_POLYGON_SMOOTH_HINT                 = 0x0C53
gl_DONT_CARE                           = 0x1100
gl_FASTEST                             = 0x1101
gl_NICEST                              = 0x1102

-- Scissor box -----------------------------------------------------------------
gl_SCISSOR_TEST                        = 0x0C11
gl_SCISSOR_BOX                         = 0x0C10

-- Pixel Mode / Transfer -------------------------------------------------------
gl_MAP_COLOR                           = 0x0D10
gl_MAP_STENCIL                         = 0x0D11
gl_INDEX_SHIFT                         = 0x0D12
gl_INDEX_OFFSET                        = 0x0D13
gl_RED_SCALE                           = 0x0D14
gl_RED_BIAS                            = 0x0D15
gl_GREEN_SCALE                         = 0x0D18
gl_GREEN_BIAS                          = 0x0D19
gl_BLUE_SCALE                          = 0x0D1A
gl_BLUE_BIAS                           = 0x0D1B
gl_ALPHA_SCALE                         = 0x0D1C
gl_ALPHA_BIAS                          = 0x0D1D
gl_DEPTH_SCALE                         = 0x0D1E
gl_DEPTH_BIAS                          = 0x0D1F
gl_PIXEL_MAP_S_TO_S_SIZE               = 0x0CB1
gl_PIXEL_MAP_I_TO_I_SIZE               = 0x0CB0
gl_PIXEL_MAP_I_TO_R_SIZE               = 0x0CB2
gl_PIXEL_MAP_I_TO_G_SIZE               = 0x0CB3
gl_PIXEL_MAP_I_TO_B_SIZE               = 0x0CB4
gl_PIXEL_MAP_I_TO_A_SIZE               = 0x0CB5
gl_PIXEL_MAP_R_TO_R_SIZE               = 0x0CB6
gl_PIXEL_MAP_G_TO_G_SIZE               = 0x0CB7
gl_PIXEL_MAP_B_TO_B_SIZE               = 0x0CB8
gl_PIXEL_MAP_A_TO_A_SIZE               = 0x0CB9
gl_PIXEL_MAP_S_TO_S                    = 0x0C71
gl_PIXEL_MAP_I_TO_I                    = 0x0C70
gl_PIXEL_MAP_I_TO_R                    = 0x0C72
gl_PIXEL_MAP_I_TO_G                    = 0x0C73
gl_PIXEL_MAP_I_TO_B                    = 0x0C74
gl_PIXEL_MAP_I_TO_A                    = 0x0C75
gl_PIXEL_MAP_R_TO_R                    = 0x0C76
gl_PIXEL_MAP_G_TO_G                    = 0x0C77
gl_PIXEL_MAP_B_TO_B                    = 0x0C78
gl_PIXEL_MAP_A_TO_A                    = 0x0C79
gl_PACK_ALIGNMENT                      = 0x0D05
gl_PACK_LSB_FIRST                      = 0x0D01
gl_PACK_ROW_LENGTH                     = 0x0D02
gl_PACK_SKIP_PIXELS                    = 0x0D04
gl_PACK_SKIP_ROWS                      = 0x0D03
gl_PACK_SWAP_BYTES                     = 0x0D00
gl_UNPACK_ALIGNMENT                    = 0x0CF5
gl_UNPACK_LSB_FIRST                    = 0x0CF1
gl_UNPACK_ROW_LENGTH                   = 0x0CF2
gl_UNPACK_SKIP_PIXELS                  = 0x0CF4
gl_UNPACK_SKIP_ROWS                    = 0x0CF3
gl_UNPACK_SWAP_BYTES                   = 0x0CF0
gl_ZOOM_X                              = 0x0D16
gl_ZOOM_Y                              = 0x0D17

-- Texture mapping -------------------------------------------------------------
gl_TEXTURE_ENV                         = 0x2300
gl_TEXTURE_ENV_MODE                    = 0x2200
gl_TEXTURE_1D                          = 0x0DE0
gl_TEXTURE_2D                          = 0x0DE1
gl_TEXTURE_WRAP_S                      = 0x2802
gl_TEXTURE_WRAP_T                      = 0x2803
gl_TEXTURE_MAG_FILTER                  = 0x2800
gl_TEXTURE_MIN_FILTER                  = 0x2801
gl_TEXTURE_ENV_COLOR                   = 0x2201
gl_TEXTURE_GEN_S                       = 0x0C60
gl_TEXTURE_GEN_T                       = 0x0C61
gl_TEXTURE_GEN_MODE                    = 0x2500
gl_TEXTURE_BORDER_COLOR                = 0x1004
gl_TEXTURE_WIDTH                       = 0x1000
gl_TEXTURE_HEIGHT                      = 0x1001
gl_TEXTURE_BORDER                      = 0x1005
gl_TEXTURE_COMPONENTS                  = 0x1003
gl_TEXTURE_RED_SIZE                    = 0x805C
gl_TEXTURE_GREEN_SIZE                  = 0x805D
gl_TEXTURE_BLUE_SIZE                   = 0x805E
gl_TEXTURE_ALPHA_SIZE                  = 0x805F
gl_TEXTURE_LUMINANCE_SIZE              = 0x8060
gl_TEXTURE_INTENSITY_SIZE              = 0x8061

gl_NEAREST_MIPMAP_NEAREST, gl_NEAREST_MIPMAP_LINEAR,
 gl_LINEAR_MIPMAP_NEAREST, gl_LINEAR_MIPMAP_LINEAR :: HTYPE_GLINT
gl_NEAREST_MIPMAP_NEAREST              = 0x2700
gl_NEAREST_MIPMAP_LINEAR               = 0x2702
gl_LINEAR_MIPMAP_NEAREST               = 0x2701
gl_LINEAR_MIPMAP_LINEAR                = 0x2703

gl_OBJECT_LINEAR                       = 0x2401
gl_OBJECT_PLANE                        = 0x2501
gl_EYE_LINEAR                          = 0x2400
gl_EYE_PLANE                           = 0x2502
gl_SPHERE_MAP                          = 0x2402
gl_DECAL                               = 0x2101
gl_MODULATE                            = 0x2100

gl_NEAREST :: HTYPE_GLINT
gl_NEAREST                             = 0x2600

gl_REPEAT, gl_CLAMP :: HTYPE_GLINT
gl_REPEAT                              = 0x2901
gl_CLAMP                               = 0x2900

gl_S                                   = 0x2000
gl_T                                   = 0x2001
gl_R                                   = 0x2002
gl_Q                                   = 0x2003
gl_TEXTURE_GEN_R                       = 0x0C62
gl_TEXTURE_GEN_Q                       = 0x0C63

-- GL 1.1 texturing ------------------------------------------------------------
gl_PROXY_TEXTURE_1D                    = 0x8063
gl_PROXY_TEXTURE_2D                    = 0x8064
gl_TEXTURE_PRIORITY                    = 0x8066
gl_TEXTURE_RESIDENT                    = 0x8067
gl_TEXTURE_BINDING_1D                  = 0x8068
gl_TEXTURE_BINDING_2D                  = 0x8069
gl_TEXTURE_INTERNAL_FORMAT             = 0x1003

-- GL 1.2 texturing ------------------------------------------------------------
gl_PACK_SKIP_IMAGES                    = 0x806B
gl_PACK_IMAGE_HEIGHT                   = 0x806C
gl_UNPACK_SKIP_IMAGES                  = 0x806D
gl_UNPACK_IMAGE_HEIGHT                 = 0x806E
gl_TEXTURE_3D                          = 0x806F
gl_PROXY_TEXTURE_3D                    = 0x8070
gl_TEXTURE_DEPTH                       = 0x8071
gl_TEXTURE_WRAP_R                      = 0x8072
gl_MAX_3D_TEXTURE_SIZE                 = 0x8073
gl_TEXTURE_BINDING_3D                  = 0x806A

-- Internal texture formats (GL 1.1) -------------------------------------------
gl_ALPHA4                              = 0x803B
gl_ALPHA8                              = 0x803C
gl_ALPHA12                             = 0x803D
gl_ALPHA16                             = 0x803E
gl_LUMINANCE4                          = 0x803F
gl_LUMINANCE8                          = 0x8040
gl_LUMINANCE12                         = 0x8041
gl_LUMINANCE16                         = 0x8042
gl_LUMINANCE4_ALPHA4                   = 0x8043
gl_LUMINANCE6_ALPHA2                   = 0x8044
gl_LUMINANCE8_ALPHA8                   = 0x8045
gl_LUMINANCE12_ALPHA4                  = 0x8046
gl_LUMINANCE12_ALPHA12                 = 0x8047
gl_LUMINANCE16_ALPHA16                 = 0x8048
gl_INTENSITY                           = 0x8049
gl_INTENSITY4                          = 0x804A
gl_INTENSITY8                          = 0x804B
gl_INTENSITY12                         = 0x804C
gl_INTENSITY16                         = 0x804D
gl_R3_G3_B2                            = 0x2A10
gl_RGB4                                = 0x804F
gl_RGB5                                = 0x8050
gl_RGB8                                = 0x8051
gl_RGB10                               = 0x8052
gl_RGB12                               = 0x8053
gl_RGB16                               = 0x8054
gl_RGBA2                               = 0x8055
gl_RGBA4                               = 0x8056
gl_RGB5_A1                             = 0x8057
gl_RGBA8                               = 0x8058
gl_RGB10_A2                            = 0x8059
gl_RGBA12                              = 0x805A
gl_RGBA16                              = 0x805B

-- Utility ---------------------------------------------------------------------
gl_VENDOR                              = 0x1F00
gl_RENDERER                            = 0x1F01
gl_VERSION                             = 0x1F02
gl_EXTENSIONS                          = 0x1F03

-- Errors ----------------------------------------------------------------------
gl_NO_ERROR                            = 0x0
gl_INVALID_VALUE                       = 0x0501
gl_INVALID_ENUM                        = 0x0500
gl_INVALID_OPERATION                   = 0x0502
gl_STACK_OVERFLOW                      = 0x0503
gl_STACK_UNDERFLOW                     = 0x0504
gl_OUT_OF_MEMORY                       = 0x0505

-- OpenGL 1.2 ------------------------------------------------------------------
gl_RESCALE_NORMAL                      = 0x803A

gl_CLAMP_TO_EDGE :: HTYPE_GLINT
gl_CLAMP_TO_EDGE                       = 0x812F

gl_MAX_ELEMENTS_VERTICES               = 0x80E8
gl_MAX_ELEMENTS_INDICES                = 0x80E9
gl_BGR                                 = 0x80E0
gl_BGRA                                = 0x80E1
gl_UNSIGNED_BYTE_3_3_2                 = 0x8032
gl_UNSIGNED_BYTE_2_3_3_REV             = 0x8362
gl_UNSIGNED_SHORT_5_6_5                = 0x8363
gl_UNSIGNED_SHORT_5_6_5_REV            = 0x8364
gl_UNSIGNED_SHORT_4_4_4_4              = 0x8033
gl_UNSIGNED_SHORT_4_4_4_4_REV          = 0x8365
gl_UNSIGNED_SHORT_5_5_5_1              = 0x8034
gl_UNSIGNED_SHORT_1_5_5_5_REV          = 0x8366
gl_UNSIGNED_INT_8_8_8_8                = 0x8035
gl_UNSIGNED_INT_8_8_8_8_REV            = 0x8367
gl_UNSIGNED_INT_10_10_10_2             = 0x8036
gl_UNSIGNED_INT_2_10_10_10_REV         = 0x8368
gl_LIGHT_MODEL_COLOR_CONTROL           = 0x81F8

gl_SINGLE_COLOR, gl_SEPARATE_SPECULAR_COLOR :: HTYPE_GLINT
gl_SINGLE_COLOR                        = 0x81F9
gl_SEPARATE_SPECULAR_COLOR             = 0x81FA

gl_TEXTURE_MIN_LOD                     = 0x813A
gl_TEXTURE_MAX_LOD                     = 0x813B
gl_TEXTURE_BASE_LEVEL                  = 0x813C
gl_TEXTURE_MAX_LEVEL                   = 0x813D
gl_SMOOTH_POINT_SIZE_RANGE             = 0x0B12
gl_SMOOTH_POINT_SIZE_GRANULARITY       = 0x0B13
gl_SMOOTH_LINE_WIDTH_RANGE             = 0x0B22
gl_SMOOTH_LINE_WIDTH_GRANULARITY       = 0x0B23
gl_ALIASED_POINT_SIZE_RANGE            = 0x846D
gl_ALIASED_LINE_WIDTH_RANGE            = 0x846E

-- OpenGL 1.2 imaging subset ---------------------------------------------------

-- GL_EXT_color_table ----------------------------------------------------------
gl_COLOR_TABLE                         = 0x80D0
gl_POST_CONVOLUTION_COLOR_TABLE        = 0x80D1
gl_POST_COLOR_MATRIX_COLOR_TABLE       = 0x80D2
gl_PROXY_COLOR_TABLE                   = 0x80D3
gl_PROXY_POST_CONVOLUTION_COLOR_TABLE  = 0x80D4
gl_PROXY_POST_COLOR_MATRIX_COLOR_TABLE = 0x80D5
gl_COLOR_TABLE_SCALE                   = 0x80D6
gl_COLOR_TABLE_BIAS                    = 0x80D7
gl_COLOR_TABLE_FORMAT                  = 0x80D8
gl_COLOR_TABLE_WIDTH                   = 0x80D9
gl_COLOR_TABLE_RED_SIZE                = 0x80DA
gl_COLOR_TABLE_GREEN_SIZE              = 0x80DB
gl_COLOR_TABLE_BLUE_SIZE               = 0x80DC
gl_COLOR_TABLE_ALPHA_SIZE              = 0x80DD
gl_COLOR_TABLE_LUMINANCE_SIZE          = 0x80DE
gl_COLOR_TABLE_INTENSITY_SIZE          = 0x80DF

-- GL_EXT_convolution and GL_HP_convolution_border_modes -----------------------
gl_CONVOLUTION_1D                      = 0x8010
gl_CONVOLUTION_2D                      = 0x8011
gl_SEPARABLE_2D                        = 0x8012
gl_CONVOLUTION_BORDER_MODE             = 0x8013
gl_CONVOLUTION_FILTER_SCALE            = 0x8014
gl_CONVOLUTION_FILTER_BIAS             = 0x8015
gl_REDUCE                              = 0x8016
gl_CONVOLUTION_FORMAT                  = 0x8017
gl_CONVOLUTION_WIDTH                   = 0x8018
gl_CONVOLUTION_HEIGHT                  = 0x8019
gl_MAX_CONVOLUTION_WIDTH               = 0x801A
gl_MAX_CONVOLUTION_HEIGHT              = 0x801B
gl_POST_CONVOLUTION_RED_SCALE          = 0x801C
gl_POST_CONVOLUTION_GREEN_SCALE        = 0x801D
gl_POST_CONVOLUTION_BLUE_SCALE         = 0x801E
gl_POST_CONVOLUTION_ALPHA_SCALE        = 0x801F
gl_POST_CONVOLUTION_RED_BIAS           = 0x8020
gl_POST_CONVOLUTION_GREEN_BIAS         = 0x8021
gl_POST_CONVOLUTION_BLUE_BIAS          = 0x8022
gl_POST_CONVOLUTION_ALPHA_BIAS         = 0x8023
gl_CONSTANT_BORDER                     = 0x8151
gl_REPLICATE_BORDER                    = 0x8153
gl_CONVOLUTION_BORDER_COLOR            = 0x8154

-- GL_SGI_color_matrix ---------------------------------------------------------
gl_COLOR_MATRIX                        = 0x80B1
gl_COLOR_MATRIX_STACK_DEPTH            = 0x80B2
gl_MAX_COLOR_MATRIX_STACK_DEPTH        = 0x80B3
gl_POST_COLOR_MATRIX_RED_SCALE         = 0x80B4
gl_POST_COLOR_MATRIX_GREEN_SCALE       = 0x80B5
gl_POST_COLOR_MATRIX_BLUE_SCALE        = 0x80B6
gl_POST_COLOR_MATRIX_ALPHA_SCALE       = 0x80B7
gl_POST_COLOR_MATRIX_RED_BIAS          = 0x80B8
gl_POST_COLOR_MATRIX_GREEN_BIAS        = 0x80B9
gl_POST_COLOR_MATRIX_BLUE_BIAS         = 0x80BA
gl_POST_COLOR_MATRIX_ALPHA_BIAS        = 0x80BB

-- GL_EXT_histogram ------------------------------------------------------------
gl_HISTOGRAM                           = 0x8024
gl_PROXY_HISTOGRAM                     = 0x8025
gl_HISTOGRAM_WIDTH                     = 0x8026
gl_HISTOGRAM_FORMAT                    = 0x8027
gl_HISTOGRAM_RED_SIZE                  = 0x8028
gl_HISTOGRAM_GREEN_SIZE                = 0x8029
gl_HISTOGRAM_BLUE_SIZE                 = 0x802A
gl_HISTOGRAM_ALPHA_SIZE                = 0x802B
gl_HISTOGRAM_LUMINANCE_SIZE            = 0x802C
gl_HISTOGRAM_SINK                      = 0x802D
gl_MINMAX                              = 0x802E
gl_MINMAX_FORMAT                       = 0x802F
gl_MINMAX_SINK                         = 0x8030
gl_TABLE_TOO_LARGE                     = 0x8031

-- GL_EXT_blend_color, GL_EXT_blend_minmax -------------------------------------
gl_BLEND_EQUATION                      = 0x8009
gl_MIN                                 = 0x8007
gl_MAX                                 = 0x8008
gl_FUNC_ADD                            = 0x8006
gl_FUNC_SUBTRACT                       = 0x800A
gl_FUNC_REVERSE_SUBTRACT               = 0x800B
gl_BLEND_COLOR                         = 0x8005

-- glPush/PopAttrib bits -------------------------------------------------------
gl_COLOR_BUFFER_BIT, gl_DEPTH_BUFFER_BIT, gl_ACCUM_BUFFER_BIT, gl_STENCIL_BUFFER_BIT :: HTYPE_GLBITFIELD

gl_CURRENT_BIT                         = 0x00000001
gl_POINT_BIT                           = 0x00000002
gl_LINE_BIT                            = 0x00000004
gl_POLYGON_BIT                         = 0x00000008
gl_POLYGON_STIPPLE_BIT                 = 0x00000010
gl_PIXEL_MODE_BIT                      = 0x00000020
gl_LIGHTING_BIT                        = 0x00000040
gl_FOG_BIT                             = 0x00000080
gl_DEPTH_BUFFER_BIT                    = 0x00000100
gl_ACCUM_BUFFER_BIT                    = 0x00000200
gl_STENCIL_BUFFER_BIT                  = 0x00000400
gl_VIEWPORT_BIT                        = 0x00000800
gl_TRANSFORM_BIT                       = 0x00001000
gl_ENABLE_BIT                          = 0x00002000
gl_COLOR_BUFFER_BIT                    = 0x00004000
gl_HINT_BIT                            = 0x00008000
gl_EVAL_BIT                            = 0x00010000
gl_LIST_BIT                            = 0x00020000
gl_TEXTURE_BIT                         = 0x00040000
gl_SCISSOR_BIT                         = 0x00080000
gl_ALL_ATTRIB_BITS                     = 0x000FFFFF

gl_CLIENT_PIXEL_STORE_BIT              = 0x00000001
gl_CLIENT_VERTEX_ARRAY_BIT             = 0x00000002
gl_ALL_CLIENT_ATTRIB_BITS              = 0xFFFFFFFF
