-- Types and functions declared in 'Data.Array.Parallel.Prim' and used by the vectoriser.
--
-- The @Builtins@ structure holds the name of all the things in 'Data.Array.Parallel.Prim' that
-- appear in code generated by the vectoriser.

module Vectorise.Builtins (
  -- * Restrictions
  mAX_DPH_SCALAR_ARGS,
  
  -- * Builtins
  Builtins(..),
  
  -- * Wrapped selectors
  selTy, selsTy,
  selReplicate,
  selTags,
  selElements,
  selsLength,
  sumTyCon,
  prodTyCon,
  prodDataCon,
  replicatePD_PrimVar,
  emptyPD_PrimVar,
  packByTagPD_PrimVar,
  combinePDVar,
  combinePD_PrimVar,
  scalarZip,
  closureCtrFun,

  -- * Initialisation
  initBuiltins, initBuiltinVars,
) where

import Vectorise.Builtins.Base
import Vectorise.Builtins.Initialise
