#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#include "gfcc.h"

extern struct _fwchain fwchain[MAXCHAINS];
extern struct _menu *service_tcp;
extern struct _menu *service_udp;
extern struct _menu *proto_name;
extern struct _menu tos_name[];
extern gint maxchains;
extern gint modified;

static guint get_mask(guint);

long int_from_hex(gchar *data)
{
	long Result;
	gint Hi, Lo;
	
	if(!*data)
		return (__u8)0;
	
	Hi = *data;
	if(Hi >= '0' && Hi <= '9') {
		Hi -= '0';
	} else if(Hi >= 'a' && Hi <= 'f') {
		Hi -= ('a'-10);
	} else if(Hi >= 'A' && Hi <= 'F') {
		Hi -= ('A'-10);
	}
	
	Lo = *(data+1);
	if(Lo >= '0' && Lo <= '9') {
		Lo -= '0';
	} else if(Lo >= 'a' && Lo <= 'f') {
		Lo -= ('a'-10);
	} else if(Lo >= 'A' && Lo <= 'F') {
		Lo -= ('A'-10);
	}

	Result = Lo + (16 * Hi);

	return Result;
}

void tosxor_itos(gchar *buf, __u8 tosxor)
{
	gint i;
	
	for(i=0; tos_name[i].label; i++) {
		if(tosxor == (__u8)tos_name[i].value) {
			strcpy(buf, tos_name[i].label);
			return;
		}
	}
}

__u8 tosxor_stoi(gchar *data)
{
	gint i;
	
	for(i=0; tos_name[i].label; i++) {
		if(!strcmp(tos_name[i].label, data)) {
			return (__u8)tos_name[i].value;
		}
	}
	return (__u8)0x00;
}

void proto_itos(gchar *data, guint proto)
{
	struct _menu *tmp;
	
	for(tmp = proto_name; tmp; tmp = tmp->next) {
		if(proto == tmp->value) {
			strcpy(data, tmp->label);
			return;
		}
	}
	sprintf(data, "%u", proto);
	return;
}

guint proto_stoi(gchar *data)
{
	struct _menu *tmp;
	
	for(tmp = proto_name; tmp; tmp = tmp->next) {
		if(!strcmp(data, tmp->label)) {
			return tmp->value;
		}
	}
	return (guint)atoi(data);
}

void port_itos(gchar *data, guint port, gchar *proto)
{
	struct _menu *tmp;
	
	if(!strcmp(proto, "tcp"))
		tmp = service_tcp;
	else if(!strcmp(proto, "udp"))
		tmp = service_udp;
	else {
		sprintf(data, "%u", port);
		return;
	}

	
	for(; tmp; tmp = tmp->next) {
		if(port == (guint)tmp->value) {
			strcpy(data, tmp->label);
			return;
		}
	}
	
	sprintf(data, "%u", port);
	return;
}

guint port_stoi(gchar *data)
{
	struct _menu *tmp;
	
	for(tmp = service_tcp; tmp; tmp = tmp->next) {
		if(!strcmp(data, tmp->label)) {
			return (guint)tmp->value;
		}
	}
	for(tmp = service_udp; tmp; tmp = tmp->next) {
		if(!strcmp(data, tmp->label)) {
			return (guint)tmp->value;
		}
	}
	
	return (guint)atoi(data);
}

void get_port(gchar *buf, guint pmin, guint pmax, gchar *proto)
{
	gchar bmin[64], bmax[64];

	port_itos(bmin, pmin, proto);
	port_itos(bmax, pmax, proto);
	if(pmin != pmax) {
		if(pmin || pmax < 65535) {
			sprintf(buf, "%s:%s", bmin, bmax);
		} else
			strcpy(buf, "n/a");
	} else
		sprintf(buf, "%s", bmin);
}

void force_quit(GtkWidget *widget, gpointer data)
{
	modified = 0;
	program_quit(widget, NULL, NULL);
}

void program_quit(GtkWidget *widget, GtkWidget *event, gpointer data)
{
	if(modified) {
		dialog_window("Data has changed. continue ?",
				GTK_SIGNAL_FUNC(force_quit));
		return;
	}
	save_host_name(NULL, NULL);
	gtk_main_quit();
}

int get_ipaddr(gchar *buf, __u32 ipaddr, __u32 mask)
{
	gchar ipbuf[64];

	if(!ipaddr) {
		strcpy(buf, "Any");
		return 0;
	}
	sprintf(ipbuf, "%u.%u.%u.%u/%u",
		               (ipaddr >> 24) & 0xff,
		               (ipaddr >> 16) & 0xff,
		               (ipaddr >>  8) & 0xff,
			       (ipaddr & 0xff), get_mask(mask));
	return host_iptoname(buf, ipbuf);
}

void get_only_ipaddr(gchar *buf, __u32 ipaddr, __u32 mask)
{
	if(!ipaddr) {
		strcpy(buf, "Any");
		return;
	}
	sprintf(buf, "%u.%u.%u.%u/%u",
		               (ipaddr >> 24) & 0xff,
		               (ipaddr >> 16) & 0xff,
		               (ipaddr >>  8) & 0xff,
			       (ipaddr & 0xff), get_mask(mask));
	return;
}

static guint get_mask(guint maskval)
{
	gint i, mask=0;

	for(i=32; i>0; i--) {
		if(!((maskval >> (i-1)) & 0x01))
			break;
		mask++;
	}
	
	return mask;
}

gchar *content_new(gchar *buf)
{
	gchar *tmp;
	
	tmp = g_malloc(strlen(buf)+1);
	if(!tmp)
		return NULL;

	strcpy(tmp, buf);
	
	return tmp;
}

void dot_to_underbar(char *buf, char *newhost)
{
	int i, j;
	
	for(i=0, j=0; buf[i]; i++) {
		switch(buf[i]) {
		case '_' : newhost[j++] = '_'; break;
		case '-' :
		case '.' : newhost[j++] = '_'; break;
		default  : newhost[j++] = buf[i]; break;
		}
	}
	newhost[j] = '\0';

	return;
}
