#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include <sys/types.h>

#include "gfcc.h"

extern gint modified;
extern GtkWidget *notebook;
extern GtkWidget *edit_win;
extern struct _fwchain fwchain[];
extern struct _menu *proto_name;

static gint check_port(gchar *min, gchar *max);
static gint check_proto(gchar *, GtkWidget *);
static void set_newdata(struct _fwentry *fwentry);
static __u32 addrstoi(gchar *);
static __u32 addrstom(gchar *);
static __u16 protostoi(gchar *);

static gint for_each_chain(gint (*fn)(), gint);

__u8 tosxor;
gchar *spts[2], *dpts[2];

void check_input_value(GtkWidget *widget, struct _fwentry *fwentry)
{
	gchar *text, ipbuf[64];
	gint tmpval;
	
	text = gtk_entry_get_text(GTK_ENTRY(fwentry->src));
	if(host_nametoip(ipbuf, text) < 0)
		return;
	spts[0] = gtk_entry_get_text(GTK_ENTRY(fwentry->spts[0]));
	spts[1] = gtk_entry_get_text(GTK_ENTRY(fwentry->spts[1]));
	if(check_port(spts[0], spts[1]) < 0) {
		dialog_window("Invalid Source port value", NULL);
		return;
	}

	text = gtk_entry_get_text(GTK_ENTRY(fwentry->dst));
	if(host_nametoip(ipbuf, text) < 0)
		return;
	dpts[0] = gtk_entry_get_text(GTK_ENTRY(fwentry->dpts[0]));
	dpts[1] = gtk_entry_get_text(GTK_ENTRY(fwentry->dpts[1]));
	if(check_port(dpts[0], dpts[1]) < 0) {
		dialog_window("Invalid Destination port value", NULL);
		return;
	}
	if(check_proto(fwentry->proto, fwentry->invproto) < 0) {
		return;
	}
	
	if(!strcmp(fwentry->target, IP_FW_LABEL_REDIRECT)) {
		if(GTK_TOGGLE_BUTTON(fwentry->invproto)->active ||
		   (strcmp(fwentry->proto, "tcp") &&
		    strcmp(fwentry->proto, "udp"))) {
			dialog_window("Redirecting only allowed with\n"
				     "TCP or UDP and not Inverse", NULL);
			return;
		}
		text = gtk_entry_get_text(GTK_ENTRY(fwentry->redirpt));
		if(check_port(text, text)) {
			dialog_window("Invalid Redirection port value", NULL);
			return;
		}
	}
	tosxor = tosxor_stoi(fwentry->tosxor);
	if(tosxor != 0x00 &&
	   strcmp(fwentry->proto, "icmp") &&
	   strcmp(fwentry->proto, "tcp") &&
	   strcmp(fwentry->proto, "udp")) {
		dialog_window("Tosand can only specify ports for\n"
			     "ICMP, TCP or UDP", NULL);
		return;
	}
	if(GTK_TOGGLE_BUTTON(fwentry->fw_mark)->active) {
		text = gtk_entry_get_text(GTK_ENTRY(fwentry->fw_mark_val));
		tmpval = atoi(text);
		if(tmpval <= 0 || tmpval > UINT_MAX) {
			dialog_window("Firewall mark number is NULL\n"
				      "or\nout of bound", NULL);
			return;
		}
		if(tmpval > UINT_MAX) {
			dialog_window("Firewall mark value out of bound",NULL);
			return;
		}
	}
	if(GTK_TOGGLE_BUTTON(fwentry->fw_netlink)->active) {
		text = gtk_entry_get_text(GTK_ENTRY(fwentry->fw_outputsize));
		tmpval = atoi(text);
		if(tmpval > UINT_MAX || tmpval < 0) {
			dialog_window("Netlink outputsize out of bound",NULL);
			return;
		}
	}
	
	set_newdata(fwentry);
	
	modified = 1;
	gtk_widget_destroy(edit_win);
	edit_win = NULL;
}

static gint check_port(gchar *min, gchar *max)
{
	guint vmin, vmax;
	
	vmin = (guint)port_stoi(min);
	vmax = (guint)port_stoi(max);

	if(vmin < 0 || vmin > 65535)
		return -1;
	if(vmax < 0 || vmax > 65535)
		return -1;
	if(vmin && !vmax)
		vmax = vmin;
	if(vmin > vmax)
		return -1;
	
	return 0;
}

static gint check_proto(gchar *proto, GtkWidget *invproto)
{
	gint sport[2], dport[2], flag=0;
	
	if(!strcmp(proto, "icmp"))
		flag = 1;
	if(!strcmp(proto, "tcp") || !strcmp(proto, "udp"))
		flag = 2;

	sport[0] = port_stoi(spts[0]);
	sport[1] = port_stoi(spts[1]);
	dport[0] = port_stoi(dpts[0]);
	dport[1] = port_stoi(dpts[1]);
	
	if(sport[0] || sport[1] != 65535 ||
	   dport[0] || dport[1] != 65535) {
		if(!flag) {
			dialog_window("No ports allowed without\n"
			     "ICMP or TCP or UDP protocol", NULL);
			return -1;
		}
		if(GTK_TOGGLE_BUTTON(invproto)->active) {
			dialog_window("No ports allowed with\n"
			     "Inverse protocol", NULL);
			return -1;
		}
	} else if(flag == 2) {
		if(!GTK_TOGGLE_BUTTON(invproto)->active) {
			dialog_window("One port required with\n"
				      "source/destination", NULL);
			return -1;
		}
	}
		
	return 0;
}

static gchar *content[NUMCOLS];

static void set_newdata(struct _fwentry *fwentry)
{
	gint page = gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook));
	gchar *text, buf[32];
	__u16 fw_flg = IP_FW_F_WILDIF;
	__u16 fw_invflg = 0;
	GtkCList *tlist;
	gint row = 0;
	guint ispts[2], idpts[2];
	
	if(page < 0)
		return;
	tlist = GTK_CLIST(fwchain[page].rulelist);

	memset(content, 0x00, sizeof(content));
	if(fwentry->action == NEW) {
		row = gtk_clist_append(tlist, content);
	} else if(fwentry->action == INSERT) {
		row = gtk_clist_insert(tlist,row,content);
	} else
		row = GTK_CLIST(fwchain[page].rulelist)->focus_row;
	
	text = gtk_entry_get_text(GTK_ENTRY(fwentry->src));
	if(!*text || !strcmp(text, "0.0.0.0/0"))
		gtk_clist_set_text(tlist, row, 0, "Any");
	else
		gtk_clist_set_text(tlist, row, 0, text);
	
	ispts[0] = port_stoi(spts[0]);
	ispts[1] = port_stoi(spts[1]);
	if(ispts[0] && !ispts[1])
		ispts[1] = ispts[0];
	get_port(buf, ispts[0], ispts[1], fwentry->proto);
	gtk_clist_set_text(tlist, row, 1, buf);

	text = gtk_entry_get_text(GTK_ENTRY(fwentry->dst));
	if(!*text || !strcmp(text, "0.0.0.0/0"))
		gtk_clist_set_text(tlist, row, 2, "Any");
	else
		gtk_clist_set_text(tlist, row, 2, text);
	
	idpts[0] = port_stoi(dpts[0]);
	idpts[1] = port_stoi(dpts[1]);
	if(idpts[0] && !idpts[1])
		idpts[1] = idpts[0];
	get_port(buf, idpts[0], idpts[1], fwentry->proto);
	gtk_clist_set_text(tlist, row, 3, buf);
	
	gtk_clist_set_text(tlist, row, 4, fwentry->proto);
	text = gtk_entry_get_text(GTK_ENTRY(fwentry->via));
	gtk_clist_set_text(tlist, row, 5, text);
	gtk_clist_set_text(tlist, row, 6, fwentry->target);
	if(!strcmp(fwentry->target, IP_FW_LABEL_REDIRECT)) {
		text = gtk_entry_get_text(GTK_ENTRY(fwentry->redirpt));
		gtk_clist_set_text(tlist, row, 15, text);
	}
	tosxor = tosxor_stoi(fwentry->tosxor);
	if(tosxor)
		strcpy(buf, "01");
	else
		strcpy(buf, "FF");
	gtk_clist_set_text(tlist, row, 7, buf);
	sprintf(buf, "%02hX", (__u8)tosxor);
	gtk_clist_set_text(tlist, row, 8, buf);
	port_itos(buf, ispts[0], fwentry->proto);
	gtk_clist_set_text(tlist, row, 9, buf);
	port_itos(buf, ispts[1], fwentry->proto);
	gtk_clist_set_text(tlist, row, 10, buf);
	port_itos(buf, idpts[0], fwentry->proto);
	gtk_clist_set_text(tlist, row, 11, buf);
	port_itos(buf, idpts[1], fwentry->proto);
	gtk_clist_set_text(tlist, row, 12, buf);
	
	if(GTK_TOGGLE_BUTTON(fwentry->invsrc)->active)
		fw_invflg |= IP_FW_INV_SRCIP;
	if(GTK_TOGGLE_BUTTON(fwentry->invdst)->active)
		fw_invflg |= IP_FW_INV_DSTIP;
	if(GTK_TOGGLE_BUTTON(fwentry->invproto)->active)
		fw_invflg |= IP_FW_INV_PROTO;
	if(GTK_TOGGLE_BUTTON(fwentry->invspts)->active)
		fw_invflg |= IP_FW_INV_SRCPT;
	if(GTK_TOGGLE_BUTTON(fwentry->invdpts)->active)
		fw_invflg |= IP_FW_INV_DSTPT;
	if(GTK_TOGGLE_BUTTON(fwentry->invvia)->active)
		fw_invflg |= IP_FW_INV_VIA;
	if(GTK_TOGGLE_BUTTON(fwentry->invsyn)->active) {
		fw_flg |= IP_FW_F_TCPSYN;
		fw_invflg |= IP_FW_INV_SYN;
	}
	if(GTK_TOGGLE_BUTTON(fwentry->syn)->active)
		fw_flg |= IP_FW_F_TCPSYN;
	if(GTK_TOGGLE_BUTTON(fwentry->invfragment)->active) {
		fw_flg |= IP_FW_F_FRAG;
		fw_invflg |= IP_FW_INV_FRAG;
	}
	if(GTK_TOGGLE_BUTTON(fwentry->fragment)->active)
		fw_flg |= IP_FW_F_FRAG;
	if(GTK_TOGGLE_BUTTON(fwentry->fw_mark)->active) {
		fw_flg |= IP_FW_F_MARKABS;
		text = gtk_entry_get_text(GTK_ENTRY(fwentry->fw_mark_val));
		gtk_clist_set_text(tlist, row, 16, text);
	}
	if(GTK_TOGGLE_BUTTON(fwentry->fw_netlink)->active) {
		fw_flg |= IP_FW_F_NETLINK;
		text = gtk_entry_get_text(GTK_ENTRY(fwentry->fw_outputsize));
		if(!*text || !strcmp(text, "0"))
			text = "65535";
		gtk_clist_set_text(tlist, row, 17, text);
	}
	if(GTK_TOGGLE_BUTTON(fwentry->log)->active) {
		fw_flg |= IP_FW_F_PRN;
	}
	
	sprintf(buf, "%hu", fw_flg);
	gtk_clist_set_text(tlist, row, 13, buf);
	sprintf(buf, "%hu", fw_invflg);
	gtk_clist_set_text(tlist, row, 14, buf);
	
	inverse_mark(tlist, row, fw_invflg);
}

void conv_fw_data(struct ip_fwuser *sfw,
		  ip_chainlabel target, GtkCList *tlist, gint row)
{
	guint8 tspace;
	GdkPixmap *tpixmap;
	GdkBitmap *tmask;
	gchar *text, ipbuf[64];

	gtk_clist_get_pixtext(tlist, row, 0, &text, &tspace,&tpixmap,&tmask);
	host_nametoip(ipbuf, text);
		    
	sfw->ipfw.fw_src.s_addr = addrstoi(ipbuf);
	sfw->ipfw.fw_smsk.s_addr = addrstom(ipbuf);
	
	gtk_clist_get_pixtext(tlist, row, 2, &text, &tspace,&tpixmap,&tmask);
	host_nametoip(ipbuf, text);
	sfw->ipfw.fw_dst.s_addr = addrstoi(ipbuf);
	sfw->ipfw.fw_dmsk.s_addr = addrstom(ipbuf);

	gtk_clist_get_pixtext(tlist, row, 4, &text, &tspace,&tpixmap,&tmask);
	sfw->ipfw.fw_proto = protostoi(text);
	gtk_clist_get_pixtext(tlist, row, 5, &text, &tspace,&tpixmap,&tmask);
	if(!*text)
		strcpy(sfw->ipfw.fw_vianame, "-");
	else
		strcpy(sfw->ipfw.fw_vianame, text);

	gtk_clist_get_text(tlist, row, 6, &text);
	if(!strcmp(text, IP_FW_LABEL_NONE))
		strcpy(target, "-");
	else
		strcpy(target, text);
	
	gtk_clist_get_text(tlist, row, 7, &text);
	sfw->ipfw.fw_tosand = int_from_hex(text);
	gtk_clist_get_text(tlist, row, 8, &text);
	sfw->ipfw.fw_tosxor = (__u8)int_from_hex(text);
	
	gtk_clist_get_text(tlist, row, 9, &text);
	sfw->ipfw.fw_spts[0] = (__u16)port_stoi(text);
	gtk_clist_get_text(tlist, row, 10, &text);
	sfw->ipfw.fw_spts[1] = (__u16)port_stoi(text);
	gtk_clist_get_text(tlist, row, 11, &text);
	sfw->ipfw.fw_dpts[0] = (__u16)port_stoi(text);
	gtk_clist_get_text(tlist, row, 12, &text);
	sfw->ipfw.fw_dpts[1] = (__u16)port_stoi(text);

	gtk_clist_get_text(tlist, row, 13, &text);
	sfw->ipfw.fw_flg = (__u16)atoi(text);
	gtk_clist_get_text(tlist, row, 14, &text);
	sfw->ipfw.fw_invflg = (__u16)atoi(text);

	gtk_clist_get_text(tlist, row, 15, &text);
	sfw->ipfw.fw_redirpt = (__u16)atoi(text);
	gtk_clist_get_text(tlist, row, 16, &text);
	sfw->ipfw.fw_mark = (__u32)atoi(text);
	gtk_clist_get_text(tlist, row, 17, &text);
	sfw->ipfw.fw_outputsize = (__u16)atoi(text);
}

static __u32 addrstoi(gchar *data)
{
	guint m;
	__u32 a,b,c,d;
	__u32 retval = 0;
	
	if(!strcmp(data, "Any"))
		return (__u32)0;

	sscanf(data, "%u.%u.%u.%u/%u", &a,&b,&c,&d,&m);
	
	retval |= (a << 24);
	retval |= (b << 16);
	retval |= (c << 8);
	retval |= d;
	
	return retval;
}

static __u32 addrstom(gchar *data)
{
	gint i;
	guint m;
	__u32 a,b,c,d;
	__u32 retval=0, tval;
	
	if(!strcmp(data, "Any"))
		return (__u32)0;

	sscanf(data, "%u.%u.%u.%u/%u", &a,&b,&c,&d,&m);
	
	for(i=0, tval = 0x80000000; i<m; i++, tval >>= 1) {
		retval |= tval;
	}
	
	return retval;
}

static __u16 protostoi(gchar *data)
{
	struct _menu *tmp;
	
	for(tmp = proto_name; tmp; tmp = tmp->next) {
		if(!strcmp(tmp->label, data))
			return (__u16)tmp->value;
	}
	return (__u16)IPPROTO_IP;
}

static gint for_each_chain(
		gint (*fn)(const ip_chainlabel), gint userchains_only)
{
	guint num_chains;
	gint ret = 1;
	struct ipfwc_fwchain *chains = ipfwc_get_chainnames(&num_chains);
	
	if(chains) {
		guint i = 0;
		for(i=0; i<num_chains; i++) {
			if(!userchains_only ||
			   (strcmp(chains[i].label, IP_FW_LABEL_FORWARD) &&
			    strcmp(chains[i].label, IP_FW_LABEL_INPUT) &&
			    strcmp(chains[i].label, IP_FW_LABEL_OUTPUT)))
			    ret &= fn(chains[i].label);
		}
	}
	else
		ret = 0;
	
	return ret;
}

gint append_entry(gchar *chain, gchar *jumpto, struct ip_fwuser sfw)
{
	if(!strcmp(jumpto, "-")) {
		sfw.label[0] = '\0';
	} else
		strcpy(sfw.label, jumpto);
	
	if(!strcmp(sfw.ipfw.fw_vianame, "-"))
		sfw.ipfw.fw_vianame[0] = '\0';
	
	sfw.ipfw.fw_src.s_addr = htonl(sfw.ipfw.fw_src.s_addr);
	sfw.ipfw.fw_smsk.s_addr = htonl(sfw.ipfw.fw_smsk.s_addr);
	sfw.ipfw.fw_dst.s_addr = htonl(sfw.ipfw.fw_dst.s_addr);
	sfw.ipfw.fw_dmsk.s_addr = htonl(sfw.ipfw.fw_dmsk.s_addr);
	
	return ipfwc_append_entry(chain, &sfw);
}

gint dialog_append_entry(gchar *chain, gchar *jumpto, struct ip_fwuser sfw)
{
	gint ret;

	ret = append_entry(chain, jumpto, sfw);
	if(!ret)
		dialog_window((gchar *)ipfwc_strerror(errno), NULL);
	
	return ret;
}

gint flush_entries(const ip_chainlabel chain)
{
	if(!chain)
		return for_each_chain(flush_entries, 0);
	else
		return ipfwc_flush_entries(chain);
}

gint zero_entries(const ip_chainlabel chain)
{
	if(!chain)
		return for_each_chain(zero_entries, 0);
	else
		return ipfwc_zero_entries(chain);
}

gint delete_user_chain(const ip_chainlabel chain)
{
	if(!chain)
		return for_each_chain(delete_user_chain, 1);
	else
		return ipfwc_delete_chain(chain);
}

gint clear_system()
{
	if(!ipfwc_set_policy(IP_FW_LABEL_INPUT, IP_FW_LABEL_ACCEPT))
		return 0;
	if(!ipfwc_set_policy(IP_FW_LABEL_FORWARD, IP_FW_LABEL_ACCEPT))
		return 0;
	if(!ipfwc_set_policy(IP_FW_LABEL_OUTPUT, IP_FW_LABEL_ACCEPT))
		return 0;
	if(!flush_entries(NULL))
		return 0;
	if(!delete_user_chain(NULL))
		return 0;
		
	return 1;
}

void dialog_clear_system()
{
	gchar buf[64];

	if(clear_system()) {
		strcpy(buf, "All system rules cleared");
		get_fw_data(NULL, 0);
	} else
		sprintf(buf, "%s", (gchar *)ipfwc_strerror(errno));
		
	dialog_window(buf, NULL);
}
