#include "polynomialring.h"
#include <sstream>
#include <string>
#include "printer.h"
#include "log.h"

#define plog1 if(0)


PolynomialRing::PolynomialRing(Field const &f, int numberOfVariables)
{
  vector<string> names;
  for(int i=0;i<numberOfVariables;i++)
    {
      stringstream s;
      s<<'x'<<i;
      names.push_back(s.str());
    }
  implementingObject= new PolynomialRingImplementation(f,numberOfVariables,names);
  implementingObject->refCount++;
  plog1 fprintf(Stderr,"Constructing PolynomialRing\n");
}

PolynomialRing::PolynomialRing(Field const &f, vector<string> const &variables)
{
  implementingObject= new PolynomialRingImplementation(f,variables.size(),variables);
  implementingObject->refCount++;
  plog1 fprintf(Stderr,"Constructing PolynomialRing\n");
}

PolynomialRing PolynomialRing::withVariablesAppended(string variableNames)const
{
  vector<string> names2=implementingObject->variableNames;
  names2.push_back(variableNames);///!!!!!!!
  return PolynomialRing(implementingObject->theField,names2);
}


int PolynomialRing::variableIndex(string const &name)const
{
  for(int i=0;i<implementingObject->variableNames.size();i++)
    {
      if(implementingObject->variableNames[i]==name)return i;
    }
  return -1;
}


string const &PolynomialRing::getVariableName(int i)const
{
  assert(implementingObject);
  assert(i>=0);
  assert(i<implementingObject->variableNames.size());
  return implementingObject->variableNames[i];
}


PolynomialRing::~PolynomialRing()
{
  assert(implementingObject);
  implementingObject->refCount--;
  assert(implementingObject->refCount>=0);
  if(implementingObject->refCount==0)
    {
      plog1 fprintf(Stderr,"Deleting implementing object\n");
      delete implementingObject;
    }
  implementingObject=0;
  plog1 fprintf(Stderr,"Destructing PolynomialRing\n");
}


PolynomialRing::PolynomialRing(PolynomialRing const &a)
  :implementingObject(a.implementingObject)
{
  implementingObject->refCount++;
  plog1 fprintf(Stderr,"Copying PolynomialRing\n");
}


PolynomialRing& PolynomialRing::operator=(const PolynomialRing& a)
{
  plog1 fprintf(Stderr,"Assigning Field\n");
  if(this==&a)
    {
      plog1 fprintf(Stderr,"---selfassigning\n");
      return *this;
    }

  if(implementingObject&& 0==(--(implementingObject->refCount)))delete implementingObject;
  //assert(a.implementingObject);
  if(a.implementingObject)
    {
      implementingObject=a.implementingObject;
      implementingObject->refCount++;
    }
  else
    implementingObject=0;
  return *this;
}
