/*
 * CreateDatumDlg.java
 * Created on September 5, 2000, 11:27 AM
 */

package geotrans.gui;


import geotrans.enumerations.ListType;
import geotrans.jni.*;
import geotrans.utility.Center;
import geotrans.utility.Platform;


/**
 * This class creats a user defined Datum 
 * if the input parameters are valid.  
 * 
 *
 * @author  Carol Finn
 * @version 1.0,  September 2000
 * 
 */
public class CreateDatumDlg extends javax.swing.JDialog 
{
_3ParamDatumPanel __3ParamDatumPanel = new _3ParamDatumPanel();
_7ParamDatumPanel __7ParamDatumPanel = new _7ParamDatumPanel();


  /** Creates new form CreateDatumDlg */
    public CreateDatumDlg(java.awt.Frame parent,boolean modal) 
    {
      super (parent, modal);
      initComponents ();
      createDatumTabbedPane.addTab("3 Parameter Datum", __3ParamDatumPanel);    
      createDatumTabbedPane.addTab("7 Parameter Datum", __7ParamDatumPanel);    
     
    if (Platform.isUnix)
    {
        okButton.setFont(new java.awt.Font("Dialog", 1, 10));
        cancelButton.setFont(new java.awt.Font("Dialog", 1, 10));
        okButton.setMaximumSize(new java.awt.Dimension(21, 19));
        okButton.setMinimumSize(new java.awt.Dimension(21, 19));
        okButton.setPreferredSize(new java.awt.Dimension(21, 19));
        cancelButton.setMaximumSize(new java.awt.Dimension(43, 19));
        cancelButton.setMinimumSize(new java.awt.Dimension(43, 19));
        cancelButton.setPreferredSize(new java.awt.Dimension(43, 19));
    }
        
    pack ();
    new Center(parent, this);      

  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the FormEditor.
   */
  // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
  private void initComponents()
  {
    java.awt.GridBagConstraints gridBagConstraints;

    createDatumTabbedPane = new javax.swing.JTabbedPane();
    okCancelPanel = new javax.swing.JPanel();
    okCancelSeparator = new javax.swing.JSeparator();
    buttonsPanel = new javax.swing.JPanel();
    okButton = new javax.swing.JButton();
    cancelButton = new javax.swing.JButton();

    getContentPane().setLayout(new java.awt.GridBagLayout());

    setTitle("Create Datum");
    addWindowListener(new java.awt.event.WindowAdapter()
    {
      public void windowClosing(java.awt.event.WindowEvent evt)
      {
        closeDialog(evt);
      }
    });

    createDatumTabbedPane.setMinimumSize(new java.awt.Dimension(435, 350));
    createDatumTabbedPane.setPreferredSize(new java.awt.Dimension(435, 350));
    getContentPane().add(createDatumTabbedPane, new java.awt.GridBagConstraints());

    okCancelPanel.setLayout(new java.awt.GridLayout(2, 1));

    okCancelSeparator.setForeground(java.awt.Color.black);
    okCancelPanel.add(okCancelSeparator);

    buttonsPanel.setLayout(new java.awt.GridBagLayout());

    okButton.setMnemonic(java.awt.event.KeyEvent.VK_O);
    okButton.setText("OK");
    okButton.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.RAISED));
    okButton.setMaximumSize(new java.awt.Dimension(19, 22));
    okButton.setMinimumSize(new java.awt.Dimension(19, 22));
    okButton.setOpaque(false);
    okButton.setPreferredSize(new java.awt.Dimension(19, 22));
    okButton.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(java.awt.event.ActionEvent evt)
      {
        okActionPerformed(evt);
      }
    });

    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
    gridBagConstraints.ipadx = 55;
    gridBagConstraints.insets = new java.awt.Insets(0, 0, 1, 35);
    buttonsPanel.add(okButton, gridBagConstraints);

    cancelButton.setMnemonic(java.awt.event.KeyEvent.VK_C);
    cancelButton.setText("Cancel");
    cancelButton.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.RAISED));
    cancelButton.setMaximumSize(new java.awt.Dimension(37, 22));
    cancelButton.setMinimumSize(new java.awt.Dimension(37, 22));
    cancelButton.setPreferredSize(new java.awt.Dimension(37, 22));
    cancelButton.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(java.awt.event.ActionEvent evt)
      {
        cancelActionPerformed(evt);
      }
    });

    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 2;
    gridBagConstraints.gridy = 0;
    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
    gridBagConstraints.ipadx = 30;
    gridBagConstraints.insets = new java.awt.Insets(0, 35, 1, 0);
    buttonsPanel.add(cancelButton, gridBagConstraints);

    okCancelPanel.add(buttonsPanel);

    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 1;
    gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
    gridBagConstraints.insets = new java.awt.Insets(0, 0, 7, 0);
    getContentPane().add(okCancelPanel, gridBagConstraints);

  }// </editor-fold>//GEN-END:initComponents

  private void cancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelActionPerformed
    setVisible (false);
    dispose ();
  }//GEN-LAST:event_cancelActionPerformed

  private void okActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okActionPerformed

    boolean datumCreated = false;
    
    int activePane = createDatumTabbedPane.getSelectedIndex();
    if( activePane == 0)
      datumCreated = __3ParamDatumPanel.createDatum();
    else
      datumCreated = __7ParamDatumPanel.createDatum();
    
    if(datumCreated)
    {
      setVisible (false);
      dispose ();
    }
  }//GEN-LAST:event_okActionPerformed

  private void ellipsoidComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ellipsoidComboBoxActionPerformed
    
    
  }//GEN-LAST:event_ellipsoidComboBoxActionPerformed

  /** Closes the dialog */
  private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
    setVisible (false);
    dispose ();
  }//GEN-LAST:event_closeDialog
    
  /**
  * @param args the command line arguments
  */
  public static void main (String args[]) {
    new CreateDatumDlg (new javax.swing.JFrame (), true).show ();
  }
  
  
  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JPanel buttonsPanel;
  private javax.swing.JButton cancelButton;
  private javax.swing.JTabbedPane createDatumTabbedPane;
  private javax.swing.JButton okButton;
  private javax.swing.JPanel okCancelPanel;
  private javax.swing.JSeparator okCancelSeparator;
  // End of variables declaration//GEN-END:variables

} // end of class.
