/*
 * coordPanel.java
 *
 * Created on April 18, 2001, 4:28 PM
 */

package geotrans.gui;


import geotrans.enumerations.ConversionState;
import geotrans.enumerations.CoordinateTypes;
import geotrans.jni.*;
import geotrans.projections.*;
import geotrans.utility.Platform;


/**
 *
 * @author  amyc
 * @version
 */
public class CoordPanel extends javax.swing.JPanel{

    private JNIStrtoval jniStrtoval;
    private JNIEngine jniEngine = new JNIEngine();
    private jOptions formatOptions;
    private boolean useNSEW;
    private boolean useMinutes;
    private boolean useSeconds;
    private char hemisphere;
    private int zone;
    // Flag to test if accuracy has been selected or is from previous conversion
    private boolean usePrevAccuracies = false;
    private boolean _3dConversion = false;

    /** Creates new form coordPanel */
    public CoordPanel(jOptions options, JNIStrtoval jniStr) {
        formatOptions = options;
        jniStrtoval = jniStr;

        setFormat();
        initComponents ();

        tempLabel1.setVisible(false);
        tempLabel2.setVisible(false);
        tempTextField1.setVisible(false);
        tempTextField2.setVisible(false);

        if (Platform.isJavaV1_3)
        {
            _3CoordFieldsLabelA.setForeground(java.awt.Color.black);
            _3CoordFieldsLabelB.setForeground(java.awt.Color.black);
            _3CoordFieldsLabelC.setForeground(java.awt.Color.black);
            _2CoordFieldsLabelA.setForeground(java.awt.Color.black);
            _2CoordFieldsLabelB.setForeground(java.awt.Color.black);
            ce90Label.setForeground(java.awt.Color.black);
            le90Label.setForeground(java.awt.Color.black);
            se90Label.setForeground(java.awt.Color.black);
            sourcesLabel.setForeground(java.awt.Color.black);
        }

        setPanelSizes();
        fillAccuracyList();
        if (Platform.isUnix)
        {
            _3CoordFieldsLabelA.setFont(new java.awt.Font("Dialog", 1, 10));
            _3CoordFieldsLabelB.setFont(new java.awt.Font("Dialog", 1, 10));
            _3CoordFieldsLabelC.setFont(new java.awt.Font("Dialog", 1, 10));
            _2CoordFieldsLabelA.setFont(new java.awt.Font("Dialog", 1, 10));
            _2CoordFieldsLabelB.setFont(new java.awt.Font("Dialog", 1, 10));
            ce90Label.setFont(new java.awt.Font("Dialog", 1, 10));
            le90Label.setFont(new java.awt.Font("Dialog", 1, 10));
            se90Label.setFont(new java.awt.Font("Dialog", 1, 10));
            sourcesLabel.setFont(new java.awt.Font("Dialog", 1, 10));
            sourcesComboBox.setFont(new java.awt.Font("Dialog", 1, 10));
            sourcesComboBox.setMaximumSize(new java.awt.Dimension(265, 22));
            sourcesComboBox.setMinimumSize(new java.awt.Dimension(265, 22));
            sourcesComboBox.setPreferredSize(new java.awt.Dimension(265, 22));
            ce90TextField.setToolTipText("90% CE");
            le90TextField.setToolTipText("90% LE");
            se90TextField.setToolTipText("90% SE");
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        coordLayeredPane = new javax.swing.JLayeredPane();
        _3CoordFieldsPanel = new javax.swing.JPanel();
        _3CoordFieldsLabelA = new javax.swing.JLabel();
        _3CoordFieldsLabelB = new javax.swing.JLabel();
        _3CoordFieldsLabelC = new javax.swing.JLabel();
        _3CoordFieldsTextFieldA = new javax.swing.JTextField();
        _3CoordFieldsTextFieldB = new javax.swing.JTextField();
        _3CoordFieldsTextFieldC = new javax.swing.JTextField();
        _2CoordFieldsPanel = new javax.swing.JPanel();
        _2CoordFieldsLabelA = new javax.swing.JLabel();
        _2CoordFieldsLabelB = new javax.swing.JLabel();
        _2CoordFieldsTextFieldA = new javax.swing.JTextField();
        _2CoordFieldsTextFieldB = new javax.swing.JTextField();
        tempLabel1 = new javax.swing.JLabel();
        tempLabel2 = new javax.swing.JLabel();
        tempTextField1 = new javax.swing.JTextField();
        tempTextField2 = new javax.swing.JTextField();
        errorsPanel = new javax.swing.JPanel();
        outputErrorPanel = new javax.swing.JPanel();
        ce90Label = new javax.swing.JLabel();
        le90Label = new javax.swing.JLabel();
        se90Label = new javax.swing.JLabel();
        ce90TextField = new javax.swing.JTextField();
        le90TextField = new javax.swing.JTextField();
        se90TextField = new javax.swing.JTextField();
        inputErrorPanel = new javax.swing.JPanel();
        sourcesLabel = new javax.swing.JLabel();
        sourcesComboBox = new javax.swing.JComboBox();

        setLayout(new java.awt.GridBagLayout());

        setMinimumSize(new java.awt.Dimension(439, 80));
        setPreferredSize(new java.awt.Dimension(439, 80));
        addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentResized(java.awt.event.ComponentEvent evt) {
                formComponentResized(evt);
            }
        });

        coordLayeredPane.setMaximumSize(new java.awt.Dimension(439, 36));
        coordLayeredPane.setMinimumSize(new java.awt.Dimension(439, 38));
        coordLayeredPane.setPreferredSize(new java.awt.Dimension(460, 38));
        coordLayeredPane.setOpaque(true);
        _3CoordFieldsPanel.setLayout(new java.awt.GridLayout(2, 3, 12, 0));

        _3CoordFieldsPanel.setMaximumSize(new java.awt.Dimension(339, 36));
        _3CoordFieldsPanel.setMinimumSize(new java.awt.Dimension(339, 36));
        _3CoordFieldsPanel.setPreferredSize(new java.awt.Dimension(339, 36));
        _3CoordFieldsPanel.setOpaque(false);
        _3CoordFieldsLabelA.setText("X (m):");
        _3CoordFieldsLabelA.setMaximumSize(new java.awt.Dimension(105, 16));
        _3CoordFieldsLabelA.setMinimumSize(new java.awt.Dimension(105, 16));
        _3CoordFieldsLabelA.setPreferredSize(new java.awt.Dimension(105, 16));
        _3CoordFieldsLabelA.setOpaque(true);
        _3CoordFieldsPanel.add(_3CoordFieldsLabelA);

        _3CoordFieldsLabelB.setText("Y (m):");
        _3CoordFieldsLabelB.setMaximumSize(new java.awt.Dimension(105, 16));
        _3CoordFieldsLabelB.setMinimumSize(new java.awt.Dimension(105, 16));
        _3CoordFieldsLabelB.setPreferredSize(new java.awt.Dimension(105, 16));
        _3CoordFieldsLabelB.setOpaque(true);
        _3CoordFieldsPanel.add(_3CoordFieldsLabelB);

        _3CoordFieldsLabelC.setText("Z (m):");
        _3CoordFieldsLabelC.setMaximumSize(new java.awt.Dimension(105, 16));
        _3CoordFieldsLabelC.setMinimumSize(new java.awt.Dimension(105, 16));
        _3CoordFieldsLabelC.setPreferredSize(new java.awt.Dimension(105, 16));
        _3CoordFieldsLabelC.setOpaque(true);
        _3CoordFieldsPanel.add(_3CoordFieldsLabelC);

        _3CoordFieldsTextFieldA.setText("0.0");
        _3CoordFieldsTextFieldA.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.LOWERED));
        _3CoordFieldsTextFieldA.setMinimumSize(new java.awt.Dimension(105, 20));
        _3CoordFieldsTextFieldA.setPreferredSize(new java.awt.Dimension(105, 20));
        _3CoordFieldsPanel.add(_3CoordFieldsTextFieldA);

        _3CoordFieldsTextFieldB.setText("0.0");
        _3CoordFieldsTextFieldB.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.LOWERED));
        _3CoordFieldsTextFieldB.setMinimumSize(new java.awt.Dimension(105, 20));
        _3CoordFieldsTextFieldB.setPreferredSize(new java.awt.Dimension(105, 20));
        _3CoordFieldsPanel.add(_3CoordFieldsTextFieldB);

        _3CoordFieldsTextFieldC.setText("0.0");
        _3CoordFieldsTextFieldC.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.LOWERED));
        _3CoordFieldsTextFieldC.setMinimumSize(new java.awt.Dimension(105, 20));
        _3CoordFieldsTextFieldC.setPreferredSize(new java.awt.Dimension(105, 20));
        _3CoordFieldsPanel.add(_3CoordFieldsTextFieldC);

        _3CoordFieldsPanel.setBounds(2, 2, 439, 37);
        coordLayeredPane.add(_3CoordFieldsPanel, javax.swing.JLayeredPane.DEFAULT_LAYER);

        _2CoordFieldsPanel.setLayout(new java.awt.GridBagLayout());

        _2CoordFieldsPanel.setMaximumSize(new java.awt.Dimension(229, 36));
        _2CoordFieldsPanel.setMinimumSize(new java.awt.Dimension(229, 36));
        _2CoordFieldsPanel.setPreferredSize(new java.awt.Dimension(229, 36));
        _2CoordFieldsPanel.setOpaque(false);
        _2CoordFieldsLabelA.setText("Easting / X (m):");
        _2CoordFieldsLabelA.setAlignmentX(1.0F);
        _2CoordFieldsLabelA.setMaximumSize(new java.awt.Dimension(106, 16));
        _2CoordFieldsLabelA.setMinimumSize(new java.awt.Dimension(106, 16));
        _2CoordFieldsLabelA.setPreferredSize(new java.awt.Dimension(106, 16));
        _2CoordFieldsLabelA.setOpaque(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 6);
        _2CoordFieldsPanel.add(_2CoordFieldsLabelA, gridBagConstraints);

        _2CoordFieldsLabelB.setText("Northing / Y (m):");
        _2CoordFieldsLabelB.setMaximumSize(new java.awt.Dimension(106, 16));
        _2CoordFieldsLabelB.setMinimumSize(new java.awt.Dimension(106, 16));
        _2CoordFieldsLabelB.setPreferredSize(new java.awt.Dimension(106, 16));
        _2CoordFieldsLabelB.setOpaque(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 6);
        _2CoordFieldsPanel.add(_2CoordFieldsLabelB, gridBagConstraints);

        _2CoordFieldsTextFieldA.setText("0.0");
        _2CoordFieldsTextFieldA.setAlignmentX(1.0F);
        _2CoordFieldsTextFieldA.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.LOWERED));
        _2CoordFieldsTextFieldA.setMargin(new java.awt.Insets(0, 0, 5, 0));
        _2CoordFieldsTextFieldA.setMinimumSize(new java.awt.Dimension(106, 20));
        _2CoordFieldsTextFieldA.setPreferredSize(new java.awt.Dimension(106, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 1, 6);
        _2CoordFieldsPanel.add(_2CoordFieldsTextFieldA, gridBagConstraints);

        _2CoordFieldsTextFieldB.setText("0.0");
        _2CoordFieldsTextFieldB.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.LOWERED));
        _2CoordFieldsTextFieldB.setMargin(new java.awt.Insets(0, 0, 5, 0));
        _2CoordFieldsTextFieldB.setMinimumSize(new java.awt.Dimension(106, 20));
        _2CoordFieldsTextFieldB.setPreferredSize(new java.awt.Dimension(106, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 1, 6);
        _2CoordFieldsPanel.add(_2CoordFieldsTextFieldB, gridBagConstraints);

        tempLabel1.setText("Easting / X (m):");
        tempLabel1.setAlignmentX(1.0F);
        tempLabel1.setMaximumSize(new java.awt.Dimension(106, 16));
        tempLabel1.setMinimumSize(new java.awt.Dimension(106, 16));
        tempLabel1.setPreferredSize(new java.awt.Dimension(106, 16));
        tempLabel1.setOpaque(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 6);
        _2CoordFieldsPanel.add(tempLabel1, gridBagConstraints);

        tempLabel2.setText("Northing / Y (m):");
        tempLabel2.setMaximumSize(new java.awt.Dimension(106, 16));
        tempLabel2.setMinimumSize(new java.awt.Dimension(106, 16));
        tempLabel2.setPreferredSize(new java.awt.Dimension(106, 16));
        tempLabel2.setOpaque(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 0);
        _2CoordFieldsPanel.add(tempLabel2, gridBagConstraints);

        tempTextField1.setText("0.0");
        tempTextField1.setAlignmentX(1.0F);
        tempTextField1.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.LOWERED));
        tempTextField1.setMargin(new java.awt.Insets(0, 0, 5, 0));
        tempTextField1.setMinimumSize(new java.awt.Dimension(106, 20));
        tempTextField1.setPreferredSize(new java.awt.Dimension(106, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 1, 6);
        _2CoordFieldsPanel.add(tempTextField1, gridBagConstraints);

        tempTextField2.setText("0.0");
        tempTextField2.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.LOWERED));
        tempTextField2.setMargin(new java.awt.Insets(0, 0, 5, 0));
        tempTextField2.setMinimumSize(new java.awt.Dimension(106, 20));
        tempTextField2.setPreferredSize(new java.awt.Dimension(106, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 1, 0);
        _2CoordFieldsPanel.add(tempTextField2, gridBagConstraints);

        _2CoordFieldsPanel.setBounds(4, 2, 460, 45);
        coordLayeredPane.add(_2CoordFieldsPanel, javax.swing.JLayeredPane.DEFAULT_LAYER);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(1, 2, 1, 2);
        add(coordLayeredPane, gridBagConstraints);

        errorsPanel.setLayout(new java.awt.GridBagLayout());

        errorsPanel.setMinimumSize(new java.awt.Dimension(460, 40));
        errorsPanel.setPreferredSize(new java.awt.Dimension(460, 40));
        errorsPanel.setOpaque(false);
        outputErrorPanel.setLayout(new java.awt.GridBagLayout());

        outputErrorPanel.setMinimumSize(new java.awt.Dimension(170, 40));
        outputErrorPanel.setPreferredSize(new java.awt.Dimension(170, 40));
        outputErrorPanel.setOpaque(false);
        ce90Label.setText("90% CE:");
        ce90Label.setMaximumSize(new java.awt.Dimension(48, 16));
        ce90Label.setMinimumSize(new java.awt.Dimension(48, 16));
        ce90Label.setPreferredSize(new java.awt.Dimension(48, 16));
        ce90Label.setOpaque(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 6);
        outputErrorPanel.add(ce90Label, gridBagConstraints);

        le90Label.setText("90% LE:");
        le90Label.setMaximumSize(new java.awt.Dimension(48, 16));
        le90Label.setMinimumSize(new java.awt.Dimension(48, 16));
        le90Label.setPreferredSize(new java.awt.Dimension(48, 16));
        le90Label.setOpaque(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 6);
        outputErrorPanel.add(le90Label, gridBagConstraints);

        se90Label.setText("90% SE:");
        se90Label.setMaximumSize(new java.awt.Dimension(48, 16));
        se90Label.setMinimumSize(new java.awt.Dimension(48, 16));
        se90Label.setPreferredSize(new java.awt.Dimension(48, 16));
        se90Label.setOpaque(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 0);
        outputErrorPanel.add(se90Label, gridBagConstraints);

        ce90TextField.setToolTipText("");
        ce90TextField.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.LOWERED));
        ce90TextField.setMinimumSize(new java.awt.Dimension(48, 20));
        ce90TextField.setPreferredSize(new java.awt.Dimension(48, 20));
        ce90TextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                accuracyTextFieldKeyTyped(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 6);
        outputErrorPanel.add(ce90TextField, gridBagConstraints);

        le90TextField.setToolTipText("");
        le90TextField.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.LOWERED));
        le90TextField.setMinimumSize(new java.awt.Dimension(48, 20));
        le90TextField.setPreferredSize(new java.awt.Dimension(48, 20));
        le90TextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                accuracyTextFieldKeyTyped(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 6);
        outputErrorPanel.add(le90TextField, gridBagConstraints);

        se90TextField.setToolTipText("");
        se90TextField.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.LOWERED));
        se90TextField.setMinimumSize(new java.awt.Dimension(48, 20));
        se90TextField.setPreferredSize(new java.awt.Dimension(48, 20));
        se90TextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                accuracyTextFieldKeyTyped(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 0);
        outputErrorPanel.add(se90TextField, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 5);
        errorsPanel.add(outputErrorPanel, gridBagConstraints);

        inputErrorPanel.setLayout(new java.awt.GridBagLayout());

        inputErrorPanel.setMinimumSize(new java.awt.Dimension(265, 40));
        inputErrorPanel.setPreferredSize(new java.awt.Dimension(265, 40));
        sourcesLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        sourcesLabel.setText("Sources:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        inputErrorPanel.add(sourcesLabel, gridBagConstraints);

        sourcesComboBox.setMinimumSize(new java.awt.Dimension(265, 23));
        sourcesComboBox.setPreferredSize(new java.awt.Dimension(265, 23));
        sourcesComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                sourcesComboBoxActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        inputErrorPanel.add(sourcesComboBox, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 3);
        errorsPanel.add(inputErrorPanel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(1, 2, 1, 2);
        add(errorsPanel, gridBagConstraints);

    }//GEN-END:initComponents

  private void accuracyTextFieldKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_accuracyTextFieldKeyTyped
      int keyChar = evt.getKeyChar();
      if (keyChar != java.awt.event.KeyEvent.VK_ENTER)
          usePrevAccuracies = false;
  }//GEN-LAST:event_accuracyTextFieldKeyTyped

  private void sourcesComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_sourcesComboBoxActionPerformed
    updateAccuracy();
  }//GEN-LAST:event_sourcesComboBoxActionPerformed

  private void formComponentResized(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_formComponentResized
    setPanelSizes();
  }//GEN-LAST:event_formComponentResized

    private void fillAccuracyList()
    {
        try
        {
            JNISource jniSource = new JNISource();
            java.lang.String sourceName = "";
            long sourceCount = jniSource.JNISourceCount();

            for (int i = 1; i <= sourceCount; i++)
            {
              sourceName = jniSource.JNISourceName(i);
              sourcesComboBox.addItem(sourceName);
            }
        }
        catch(GeotransError e)
        {
            jniStrtoval.displayErrorMsg(new javax.swing.JFrame(), e.getMessage());
        }
        catch(JNIException e)
        {
            jniStrtoval.displayErrorMsg(new javax.swing.JFrame(), e.getMessage());
        }
    }


    private void setOneCoord()
    {
        _2CoordFieldsPanel.setVisible(false);
        _3CoordFieldsPanel.setVisible(true);
        coordLayeredPane.moveToFront(_3CoordFieldsPanel);

        // Hide optional fields.
        _3CoordFieldsLabelA.setVisible(false);
        _3CoordFieldsLabelC.setVisible(false);
        _3CoordFieldsTextFieldA.setVisible(false);
        _3CoordFieldsTextFieldC.setVisible(false);

        _3CoordFieldsLabelB.setText("Coordinate String:");
    }

    private void setTwoCoords()
    {
        _3CoordFieldsPanel.setVisible(false);
        _2CoordFieldsPanel.setVisible(true);
        coordLayeredPane.moveToFront(_2CoordFieldsPanel);
        _2CoordFieldsLabelA.setText("Easting / X (m):");
        _2CoordFieldsLabelB.setText("Northing / Y (m):");
        _2CoordFieldsTextFieldA.setText( "0" );
        _2CoordFieldsTextFieldB.setText( "0" );
    }

    private void setThreeCoords()
    {
        _2CoordFieldsPanel.setVisible(false);
        _3CoordFieldsPanel.setVisible(true);
        coordLayeredPane.moveToFront(_3CoordFieldsPanel);

        // Show optional fields.
        _3CoordFieldsLabelA.setVisible(true);
        _3CoordFieldsLabelC.setVisible(true);
        _3CoordFieldsTextFieldA.setVisible(true);
        _3CoordFieldsTextFieldC.setVisible(true);

        /* may be turned off by height type buttons. */
        setHeightFieldEditable();

        _3CoordFieldsLabelA.setText("X (m):");
        _3CoordFieldsLabelB.setText("Y (m):");
        _3CoordFieldsLabelC.setText("Z (m):");
        _3CoordFieldsTextFieldA.setText( "0" );
        _3CoordFieldsTextFieldB.setText( "0" );
        _3CoordFieldsTextFieldC.setText( "0" );
    }


    private void setFormat()
    {
        useNSEW = formatOptions.getUseNSEW();
        useMinutes = formatOptions.getUseMinutes();
        useSeconds = formatOptions.getUseSeconds();
    }

    // This function is needed to make the fields visible when the gui is displayed
    private void setPanelSizes()
    {
        java.awt.Dimension dsize = new java.awt.Dimension();
        dsize = coordLayeredPane.getSize();

        _2CoordFieldsPanel.setBounds (0, 0, dsize.width, dsize.height);
        _3CoordFieldsPanel.setBounds (0, 0, dsize.width, dsize.height);

        _2CoordFieldsPanel.updateUI();
        _3CoordFieldsPanel.updateUI();
    }

    // Set the input coordinates in the engine
    public void setCoords(int state, int direction, int projType)
    {
        try
        {
            switch(projType)
            {
                case CoordinateTypes.ALBERS:
                {
                    AlbersEqualAreaConic albersCoords = new AlbersEqualAreaConic(jniStrtoval.stringToDouble(_2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"),
                                                                                 jniStrtoval.stringToDouble(_2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    jniEngine.JNISetAlbersEqualAreaConicCoordinates(state, direction, albersCoords);

                    break;
                }
                case CoordinateTypes.AZIMUTHAL:
                {
                    AzimuthalEquidistant azeqCoords = new AzimuthalEquidistant(jniStrtoval.stringToDouble(_2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"),
                                                                               jniStrtoval.stringToDouble(_2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    jniEngine.JNISetAzimuthalEquidistantCoordinates(state, direction, azeqCoords);

                    break;
                }
                case CoordinateTypes.BNG:
                {
                    BNG BNGCoords = new BNG(_3CoordFieldsTextFieldB.getText().trim());
                    jniEngine.JNISetBNGCoordinates(state, direction, BNGCoords);

                    break;
                }
                case CoordinateTypes.BONNE:
                {
                    Bonne bonneCoords = new Bonne(jniStrtoval.stringToDouble(_2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"),
                                                  jniStrtoval.stringToDouble(_2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    jniEngine.JNISetBonneCoordinates(state, direction, bonneCoords);

                    break;
                }
                case CoordinateTypes.CASSINI:
                {
                    Cassini cassiniCoords = new Cassini(jniStrtoval.stringToDouble(_2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"),
                                                        jniStrtoval.stringToDouble(_2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                   jniEngine.JNISetCassiniCoordinates(state, direction, cassiniCoords);

                    break;
                }
                case CoordinateTypes.CYLEQA:
                {
                    CylindricalEqualArea cyleqaCoords = new CylindricalEqualArea(jniStrtoval.stringToDouble(_2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"),
                                                                                 jniStrtoval.stringToDouble(_2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    jniEngine.JNISetCylindricalEqualAreaCoordinates(state, direction, cyleqaCoords);

                    break;
                }
                case CoordinateTypes.ECKERT4:
                {
                    Eckert4 eckert4Coords = new Eckert4(jniStrtoval.stringToDouble(_2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"),
                                                        jniStrtoval.stringToDouble(_2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    jniEngine.JNISetEckert4Coordinates(state, direction, eckert4Coords);

                    break;
                }
                case CoordinateTypes.ECKERT6:
                {
                    Eckert6 eckert6Coords = new Eckert6(jniStrtoval.stringToDouble(_2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"),
                                                        jniStrtoval.stringToDouble(_2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    jniEngine.JNISetEckert6Coordinates(state, direction, eckert6Coords);

                    break;
                }
                case CoordinateTypes.EQDCYL:
                {
                    EquidistantCylindrical eqdcylCoords = new EquidistantCylindrical(jniStrtoval.stringToDouble(_2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"),
                                                                                     jniStrtoval.stringToDouble(_2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    jniEngine.JNISetEquidistantCylindricalCoordinates(state, direction, eqdcylCoords);

                    break;
                }
                case CoordinateTypes.F16GRS:
                {
                    java.lang.String coordString = _3CoordFieldsTextFieldB.getText().trim();
                    int length = coordString.length();
                    MGRS MGRSCoords;
                    if ((coordString.charAt(length - 1) == ('0')) && (coordString.charAt(length - 2) == ('0')))
                        MGRSCoords = new MGRS(coordString.substring(0, length - 2));
                    else
                        MGRSCoords = new MGRS(coordString);
                    jniEngine.JNISetMGRSCoordinates(state, direction, MGRSCoords);

                    break;
                }
                case CoordinateTypes.GARS:
                {
                    GARS GARSCoords = new GARS(_3CoordFieldsTextFieldB.getText().trim());
                    jniEngine.JNISetGARSCoordinates(state, direction, GARSCoords);

                    break;
                }
                case CoordinateTypes.GEOCENTRIC:
                {
                    Geocentric geocentricCoords = new Geocentric(jniStrtoval.stringToDouble(_3CoordFieldsTextFieldA.getText().trim(), "Invalid coord X"),
                                                                 jniStrtoval.stringToDouble(_3CoordFieldsTextFieldB.getText().trim(), "Invalid coord Y"),
                                                                 jniStrtoval.stringToDouble(_3CoordFieldsTextFieldC.getText().trim(), "Invalid coord Z"));
                    jniEngine.JNISetGeocentricCoordinates(state, direction, geocentricCoords);

                    break;
                }
                case CoordinateTypes.GEODETIC:
                {
                    Geodetic geodeticCoords = new Geodetic(jniStrtoval.stringToLongitude(_3CoordFieldsTextFieldA.getText().trim(), "Invalid Longitude"),
                                                           jniStrtoval.stringToLatitude(_3CoordFieldsTextFieldB.getText().trim(), "Invalid Latitude"),
                                                           jniStrtoval.stringToDouble(_3CoordFieldsTextFieldC.getText().trim(), "Invalid Height"));
                    jniEngine.JNISetGeodeticCoordinates(state, direction, geodeticCoords);

                    break;
                }
                case CoordinateTypes.GEOREF:
                {
                    GEOREF GEOREFCoords = new GEOREF(_3CoordFieldsTextFieldB.getText().trim());
                    jniEngine.JNISetGEOREFCoordinates(state, direction, GEOREFCoords);

                    break;
                }
                case CoordinateTypes.GNOMONIC:
                {
                    Gnomonic gnomonicCoords = new Gnomonic(jniStrtoval.stringToDouble(_2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"),
                                                           jniStrtoval.stringToDouble(_2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    jniEngine.JNISetGnomonicCoordinates(state, direction, gnomonicCoords);

                    break;
                }
                case CoordinateTypes.LAMBERT_1:
                {
                    LambertConformalConic1 lambert1Coords = new LambertConformalConic1(jniStrtoval.stringToDouble(_2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"),
                                                                                                                   jniStrtoval.stringToDouble(_2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    jniEngine.JNISetLambertConformalConic1Coordinates(state, direction, lambert1Coords);

                    break;
                }
                case CoordinateTypes.LAMBERT_2:
                {
                    LambertConformalConic2 lambert2Coords = new LambertConformalConic2(jniStrtoval.stringToDouble(_2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"),
                                                                                       jniStrtoval.stringToDouble(_2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                     jniEngine.JNISetLambertConformalConic2Coordinates(state, direction, lambert2Coords);

                    break;
                }
                case CoordinateTypes.LOCCART:
                {
                    LocalCartesian loccartCoords = new LocalCartesian(jniStrtoval.stringToDouble(_3CoordFieldsTextFieldA.getText().trim(), "Invalid coord X"),
                                                                      jniStrtoval.stringToDouble(_3CoordFieldsTextFieldB.getText().trim(), "Invalid coord Y"),
                                                                      jniStrtoval.stringToDouble(_3CoordFieldsTextFieldC.getText().trim(), "Invalid coord Z"));
                    jniEngine.JNISetLocalCartesianCoordinates(state, direction, loccartCoords);

                    break;
                }
                case CoordinateTypes.MERCATOR:
                {
                    Mercator mercatorCoords = new Mercator(jniStrtoval.stringToDouble(_2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"),
                                                           jniStrtoval.stringToDouble(_2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    jniEngine.JNISetMercatorCoordinates(state, direction, mercatorCoords);

                    break;
                }
                case CoordinateTypes.MGRS:
                {
                    MGRS MGRSCoords = new MGRS(_3CoordFieldsTextFieldB.getText().trim());
                    jniEngine.JNISetMGRSCoordinates(state, direction, MGRSCoords);

                    break;
                }
                case CoordinateTypes.MILLER:
                {
                    MillerCylindrical millerCoords = new MillerCylindrical(jniStrtoval.stringToDouble(_2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"),
                                                                           jniStrtoval.stringToDouble(_2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    jniEngine.JNISetMillerCylindricalCoordinates(state, direction, millerCoords);

                    break;
                }
                case CoordinateTypes.MOLLWEIDE:
                {
                    Mollweide mollweidCoords = new Mollweide(jniStrtoval.stringToDouble(_2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"),
                                                             jniStrtoval.stringToDouble(_2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    jniEngine.JNISetMollweideCoordinates(state, direction, mollweidCoords);

                    break;
                }
                case CoordinateTypes.NEYS:
                {
                    Neys neysCoords = new Neys(jniStrtoval.stringToDouble(_2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"),
                                              jniStrtoval.stringToDouble(_2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    jniEngine.JNISetNeysCoordinates(state, direction, neysCoords);

                    break;
                }
                case CoordinateTypes.NZMG:
                {
                    NZMG NZMGCoords = new NZMG(jniStrtoval.stringToDouble(_2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"),
                                               jniStrtoval.stringToDouble(_2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    jniEngine.JNISetNZMGCoordinates(state, direction, NZMGCoords);

                    break;
                }
                case CoordinateTypes.OMERC:
                {
                    ObliqueMercator omercCoords = new ObliqueMercator(jniStrtoval.stringToDouble(_2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"),
                                                                      jniStrtoval.stringToDouble(_2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    jniEngine.JNISetObliqueMercatorCoordinates(state, direction, omercCoords);

                    break;
                }
                case CoordinateTypes.ORTHOGRAPHIC:
                {
                    Orthographic orthogrCoords = new Orthographic(jniStrtoval.stringToDouble(_2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"),
                                                                  jniStrtoval.stringToDouble(_2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    jniEngine.JNISetOrthographicCoordinates(state, direction, orthogrCoords);

                    break;
                }
                case CoordinateTypes.POLARSTEREO:
                {
                    PolarStereographic polarstCoords = new PolarStereographic(jniStrtoval.stringToDouble(_2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"),
                                                                              jniStrtoval.stringToDouble(_2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    jniEngine.JNISetPolarStereographicCoordinates(state, direction, polarstCoords);

                    break;
                }
                case CoordinateTypes.POLYCONIC:
                {
                    Polyconic polyconCoords = new Polyconic(jniStrtoval.stringToDouble(_2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"),
                                                            jniStrtoval.stringToDouble(_2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    jniEngine.JNISetPolyconicCoordinates(state, direction, polyconCoords);

                    break;
                }
                case CoordinateTypes.SINUSOIDAL:
                {
                    Sinusoidal sinusoidCoords = new Sinusoidal(jniStrtoval.stringToDouble(_2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"),
                                                               jniStrtoval.stringToDouble(_2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    jniEngine.JNISetSinusoidalCoordinates(state, direction, sinusoidCoords);

                    break;
                }
                case CoordinateTypes.STEREOGRAPHIC:
                {
                    Stereographic stereogrCoords = new Stereographic(jniStrtoval.stringToDouble(_2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"),
                                                                     jniStrtoval.stringToDouble(_2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    jniEngine.JNISetStereographicCoordinates(state, direction, stereogrCoords);

                    break;
                }
                case CoordinateTypes.TRCYLEQA:
                {
                    TransverseCylindricalEqualArea trcyleqaCoords = new TransverseCylindricalEqualArea(jniStrtoval.stringToDouble(_2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"),
                                                                                                       jniStrtoval.stringToDouble(_2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    jniEngine.JNISetTransverseCylindricalEqualAreaCoordinates(state, direction, trcyleqaCoords);

                    break;
                }
                case CoordinateTypes.TRANMERC:
                {
                    TransverseMercator tranmercCoords = new TransverseMercator(jniStrtoval.stringToDouble(_2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"),
                                                                               jniStrtoval.stringToDouble(_2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                    jniEngine.JNISetTransverseMercatorCoordinates(state, direction, tranmercCoords);

                    break;
                }
                case CoordinateTypes.GRINTEN:
                {
                    VanDerGrinten grintenCoords = new VanDerGrinten(jniStrtoval.stringToDouble(_2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"),
                                                                    jniStrtoval.stringToDouble(_2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing")/*, hemisphere*/);
                    jniEngine.JNISetVanDerGrintenCoordinates(state, direction, grintenCoords);

                    break;
                }
                case CoordinateTypes.UPS:
                {
                    UPS UPSCoords = new UPS(jniStrtoval.stringToDouble(_2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"),
                                            jniStrtoval.stringToDouble(_2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"), hemisphere);
                    jniEngine.JNISetUPSCoordinates(state, direction, UPSCoords);

                    break;
                }
                case CoordinateTypes.USNG:
                {
                    USNG USNGCoords = new USNG(_3CoordFieldsTextFieldB.getText().trim());
                    jniEngine.JNISetUSNGCoordinates(state, direction, USNGCoords);

                    break;
                }
                case CoordinateTypes.UTM:
                {
                    UTM UTMCoords = new UTM(jniStrtoval.stringToDouble(_2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"),
                                            jniStrtoval.stringToDouble(_2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"), zone, hemisphere);
                    jniEngine.JNISetUTMCoordinates(state, direction, UTMCoords);

                    break;
                }
                default:
                    break;
            }
        }
        catch(GeotransError e)
        {
            jniStrtoval.setEngineError(true, e.getMessage());
        }
        catch(JNIException e)
        {
            jniStrtoval.setJNIError(true, e.getMessage());
        }
    }

    public boolean getCoords(int state, int direction, int projType)
    {
        boolean noErrors = true;

        setFormat();

        try
        {
            switch(projType)
            {
                case CoordinateTypes.ALBERS:
                {
                    AlbersEqualAreaConic albersCoords = jniEngine.JNIGetAlbersEqualAreaConicCoordinates(state, direction);
                    _2CoordFieldsTextFieldA.setText(jniStrtoval.JNIMeterToString(albersCoords.getEasting()));
                    _2CoordFieldsTextFieldB.setText(jniStrtoval.JNIMeterToString(albersCoords.getNorthing()));
                    break;
                }
                case CoordinateTypes.AZIMUTHAL:
                {
                    AzimuthalEquidistant azeqCoords = jniEngine.JNIGetAzimuthalEquidistantCoordinates(state, direction);
                    _2CoordFieldsTextFieldA.setText(jniStrtoval.JNIMeterToString(azeqCoords.getEasting()));
                    _2CoordFieldsTextFieldB.setText(jniStrtoval.JNIMeterToString(azeqCoords.getNorthing()));
                    break;
                }
                case CoordinateTypes.BNG:
                {
                    BNG BNGCoords = jniEngine.JNIGetBNGCoordinates(state, direction);
                    _3CoordFieldsTextFieldB.setText(BNGCoords.getCoordinateString());
                    break;
                }
                case CoordinateTypes.BONNE:
                {
                    Bonne bonneCoords = jniEngine.JNIGetBonneCoordinates(state, direction);
                    _2CoordFieldsTextFieldA.setText(jniStrtoval.JNIMeterToString(bonneCoords.getEasting()));
                    _2CoordFieldsTextFieldB.setText(jniStrtoval.JNIMeterToString(bonneCoords.getNorthing()));
                    break;
                }
                case CoordinateTypes.CASSINI:
                {
                    Cassini cassiniCoords = jniEngine.JNIGetCassiniCoordinates(state, direction);
                    _2CoordFieldsTextFieldA.setText(jniStrtoval.JNIMeterToString(cassiniCoords.getEasting()));
                    _2CoordFieldsTextFieldB.setText(jniStrtoval.JNIMeterToString(cassiniCoords.getNorthing()));
                    break;
                }
                case CoordinateTypes.CYLEQA:
                {
                    CylindricalEqualArea cyleqaCoords = jniEngine.JNIGetCylindricalEqualAreaCoordinates(state, direction);
                    _2CoordFieldsTextFieldA.setText(jniStrtoval.JNIMeterToString(cyleqaCoords.getEasting()));
                    _2CoordFieldsTextFieldB.setText(jniStrtoval.JNIMeterToString(cyleqaCoords.getNorthing()));
                    break;
                }
                case CoordinateTypes.ECKERT4:
                {
                    Eckert4 eckert4Coords = jniEngine.JNIGetEckert4Coordinates(state, direction);
                    _2CoordFieldsTextFieldA.setText(jniStrtoval.JNIMeterToString(eckert4Coords.getEasting()));
                    _2CoordFieldsTextFieldB.setText(jniStrtoval.JNIMeterToString(eckert4Coords.getNorthing()));
                    break;
                }
                case CoordinateTypes.ECKERT6:
                {
                    Eckert6 eckert6Coords = jniEngine.JNIGetEckert6Coordinates(state, direction);
                    _2CoordFieldsTextFieldA.setText(jniStrtoval.JNIMeterToString(eckert6Coords.getEasting()));
                    _2CoordFieldsTextFieldB.setText(jniStrtoval.JNIMeterToString(eckert6Coords.getNorthing()));
                    break;
                }
                case CoordinateTypes.EQDCYL:
                {
                    EquidistantCylindrical eqdcylCoords = jniEngine.JNIGetEquidistantCylindricalCoordinates(state, direction);
                    _2CoordFieldsTextFieldA.setText(jniStrtoval.JNIMeterToString(eqdcylCoords.getEasting()));
                    _2CoordFieldsTextFieldB.setText(jniStrtoval.JNIMeterToString(eqdcylCoords.getNorthing()));
                    break;
                }
                case CoordinateTypes.F16GRS:
                {
                    MGRS MGRSCoords = jniEngine.JNIGetMGRSCoordinates(state, direction);
                    java.lang.String temp = MGRSCoords.getCoordinateString();
                    if( jniEngine.JNIGetPrecision() == formatOptions.MET100000)
                        _3CoordFieldsTextFieldB.setText(temp + "00");
                    else
                       _3CoordFieldsTextFieldB.setText(temp);
                    break;
                }
                case CoordinateTypes.GARS:
                {
                    GARS GARSCoords = jniEngine.JNIGetGARSCoordinates(state, direction);
                    _3CoordFieldsTextFieldB.setText(GARSCoords.getCoordinateString());
                    break;
                }
                case CoordinateTypes.GEOCENTRIC:
                {
                    Geocentric geocentricCoords = jniEngine.JNIGetGeocentricCoordinates(state, direction);
                    _3CoordFieldsTextFieldA.setText(jniStrtoval.JNIMeterToString(geocentricCoords.getX()));
                    _3CoordFieldsTextFieldB.setText(jniStrtoval.JNIMeterToString(geocentricCoords.getY()));
                    _3CoordFieldsTextFieldC.setText(jniStrtoval.JNIMeterToString(geocentricCoords.getZ()));
                    break;
                }
                case CoordinateTypes.GEODETIC:
                {
                    Geodetic geodeticCoords = jniEngine.JNIGetGeodeticCoordinates(state, direction);
                    _3CoordFieldsTextFieldA.setText(jniStrtoval.JNILongitudeToString(geodeticCoords.getLongitude()*180/jniStrtoval.PI, useNSEW, useMinutes, useSeconds));
                    _3CoordFieldsTextFieldB.setText(jniStrtoval.JNILatitudeToString(geodeticCoords.getLatitude()*180/jniStrtoval.PI, useNSEW, useMinutes, useSeconds));
                    _3CoordFieldsTextFieldC.setText(jniStrtoval.JNIMeterToString(geodeticCoords.getHeight()));
                    break;
                }
                case CoordinateTypes.GEOREF:
                {
                    GEOREF GEOREFCoords = jniEngine.JNIGetGEOREFCoordinates(state, direction);
                    _3CoordFieldsTextFieldB.setText(GEOREFCoords.getCoordinateString());
                    break;
                }
                case CoordinateTypes.GNOMONIC:
                {
                    Gnomonic gnomonicCoords = jniEngine.JNIGetGnomonicCoordinates(state, direction);
                    _2CoordFieldsTextFieldA.setText(jniStrtoval.JNIMeterToString(gnomonicCoords.getEasting()));
                    _2CoordFieldsTextFieldB.setText(jniStrtoval.JNIMeterToString(gnomonicCoords.getNorthing()));
                    break;
                }
                case CoordinateTypes.LAMBERT_1:
                {
                    LambertConformalConic1 lambert1Coords = jniEngine.JNIGetLambertConformalConic1Coordinates(state, direction);
                    _2CoordFieldsTextFieldA.setText(jniStrtoval.JNIMeterToString(lambert1Coords.getEasting()));
                    _2CoordFieldsTextFieldB.setText(jniStrtoval.JNIMeterToString(lambert1Coords.getNorthing()));
                    break;
                }
                case CoordinateTypes.LAMBERT_2:
                {
                    LambertConformalConic2 lambert2Coords = jniEngine.JNIGetLambertConformalConic2Coordinates(state, direction);
                    _2CoordFieldsTextFieldA.setText(jniStrtoval.JNIMeterToString(lambert2Coords.getEasting()));
                    _2CoordFieldsTextFieldB.setText(jniStrtoval.JNIMeterToString(lambert2Coords.getNorthing()));
                    break;
                }
                case CoordinateTypes.LOCCART:
                {
                    LocalCartesian loccartCoords = jniEngine.JNIGetLocalCartesianCoordinates(state, direction);
                    _3CoordFieldsTextFieldA.setText(jniStrtoval.JNIMeterToString(loccartCoords.getX()));
                    _3CoordFieldsTextFieldB.setText(jniStrtoval.JNIMeterToString(loccartCoords.getY()));
                    _3CoordFieldsTextFieldC.setText(jniStrtoval.JNIMeterToString(loccartCoords.getZ()));
                    break;
                }
                case CoordinateTypes.MERCATOR:
                {
                    Mercator mercatorCoords = jniEngine.JNIGetMercatorCoordinates(state, direction);
                    _2CoordFieldsTextFieldA.setText(jniStrtoval.JNIMeterToString(mercatorCoords.getEasting()));
                    _2CoordFieldsTextFieldB.setText(jniStrtoval.JNIMeterToString(mercatorCoords.getNorthing()));
                    break;
                }
                case CoordinateTypes.MGRS:
                {
                    MGRS MGRSCoords = jniEngine.JNIGetMGRSCoordinates(state, direction);
                    _3CoordFieldsTextFieldB.setText(MGRSCoords.getCoordinateString());
                    break;
                }
                case CoordinateTypes.MILLER:
                {
                    MillerCylindrical millerCoords = jniEngine.JNIGetMillerCylindricalCoordinates(state, direction);
                    _2CoordFieldsTextFieldA.setText(jniStrtoval.JNIMeterToString(millerCoords.getEasting()));
                    _2CoordFieldsTextFieldB.setText(jniStrtoval.JNIMeterToString(millerCoords.getNorthing()));
                    break;
                }
                case CoordinateTypes.MOLLWEIDE:
                {
                    Mollweide mollweidCoords = jniEngine.JNIGetMollweideCoordinates(state, direction);
                    _2CoordFieldsTextFieldA.setText(jniStrtoval.JNIMeterToString(mollweidCoords.getEasting()));
                    _2CoordFieldsTextFieldB.setText(jniStrtoval.JNIMeterToString(mollweidCoords.getNorthing()));
                    break;
                }
                case CoordinateTypes.NEYS:
                {
                    Neys neysCoords = jniEngine.JNIGetNeysCoordinates(state, direction);
                    _2CoordFieldsTextFieldA.setText(jniStrtoval.JNIMeterToString(neysCoords.getEasting()));
                    _2CoordFieldsTextFieldB.setText(jniStrtoval.JNIMeterToString(neysCoords.getNorthing()));
                    break;
                }
                case CoordinateTypes.NZMG:
                {
                    NZMG NZMGCoords = jniEngine.JNIGetNZMGCoordinates(state, direction);
                    _2CoordFieldsTextFieldA.setText(jniStrtoval.JNIMeterToString(NZMGCoords.getEasting()));
                    _2CoordFieldsTextFieldB.setText(jniStrtoval.JNIMeterToString(NZMGCoords.getNorthing()));
                    break;
                }
                case CoordinateTypes.OMERC:
                {
                    ObliqueMercator omercCoords = jniEngine.JNIGetObliqueMercatorCoordinates(state, direction);
                    _2CoordFieldsTextFieldA.setText(jniStrtoval.JNIMeterToString(omercCoords.getEasting()));
                    _2CoordFieldsTextFieldB.setText(jniStrtoval.JNIMeterToString(omercCoords.getNorthing()));
                    break;
                }
                case CoordinateTypes.ORTHOGRAPHIC:
                {
                    Orthographic orthogrCoords = jniEngine.JNIGetOrthographicCoordinates(state, direction);
                    _2CoordFieldsTextFieldA.setText(jniStrtoval.JNIMeterToString(orthogrCoords.getEasting()));
                    _2CoordFieldsTextFieldB.setText(jniStrtoval.JNIMeterToString(orthogrCoords.getNorthing()));
                    break;
                }
                case CoordinateTypes.POLARSTEREO:
                {
                    PolarStereographic polarstCoords = jniEngine.JNIGetPolarStereographicCoordinates(state, direction);
                    _2CoordFieldsTextFieldA.setText(jniStrtoval.JNIMeterToString(polarstCoords.getEasting()));
                    _2CoordFieldsTextFieldB.setText(jniStrtoval.JNIMeterToString(polarstCoords.getNorthing()));
                    break;
                }
                case CoordinateTypes.POLYCONIC:
                {
                    Polyconic polyconCoords = jniEngine.JNIGetPolyconicCoordinates(state, direction);
                    _2CoordFieldsTextFieldA.setText(jniStrtoval.JNIMeterToString(polyconCoords.getEasting()));
                    _2CoordFieldsTextFieldB.setText(jniStrtoval.JNIMeterToString(polyconCoords.getNorthing()));
                    break;
                }
                case CoordinateTypes.SINUSOIDAL:
                {
                    Sinusoidal sinusoidCoords = jniEngine.JNIGetSinusoidalCoordinates(state, direction);
                    _2CoordFieldsTextFieldA.setText(jniStrtoval.JNIMeterToString(sinusoidCoords.getEasting()));
                    _2CoordFieldsTextFieldB.setText(jniStrtoval.JNIMeterToString(sinusoidCoords.getNorthing()));
                    break;
                }
                case CoordinateTypes.STEREOGRAPHIC:
                {
                    Stereographic stereogrCoords = jniEngine.JNIGetStereographicCoordinates(state, direction);
                    _2CoordFieldsTextFieldA.setText(jniStrtoval.JNIMeterToString(stereogrCoords.getEasting()));
                    _2CoordFieldsTextFieldB.setText(jniStrtoval.JNIMeterToString(stereogrCoords.getNorthing()));
                    break;
                }
                case CoordinateTypes.TRCYLEQA:
                {
                    TransverseCylindricalEqualArea trcyleqaCoords = jniEngine.JNIGetTransverseCylindricalEqualAreaCoordinates(state, direction);
                    _2CoordFieldsTextFieldA.setText(jniStrtoval.JNIMeterToString(trcyleqaCoords.getEasting()));
                    _2CoordFieldsTextFieldB.setText(jniStrtoval.JNIMeterToString(trcyleqaCoords.getNorthing()));
                    break;
                }
                case CoordinateTypes.TRANMERC:
                {
                    TransverseMercator tranmercCoords = jniEngine.JNIGetTransverseMercatorCoordinates(state, direction);
                    _2CoordFieldsTextFieldA.setText(jniStrtoval.JNIMeterToString(tranmercCoords.getEasting()));
                    _2CoordFieldsTextFieldB.setText(jniStrtoval.JNIMeterToString(tranmercCoords.getNorthing()));
                    break;
                }
                case CoordinateTypes.GRINTEN:
                {
                    VanDerGrinten grintenCoords = jniEngine.JNIGetVanDerGrintenCoordinates(state, direction);
                    _2CoordFieldsTextFieldA.setText(jniStrtoval.JNIMeterToString(grintenCoords.getEasting()));
                    _2CoordFieldsTextFieldB.setText(jniStrtoval.JNIMeterToString(grintenCoords.getNorthing()));
                    break;
                }
                case CoordinateTypes.UPS:
                {
                    // set hemisphere
                    UPS UPSCoords = jniEngine.JNIGetUPSCoordinates(state, direction);
                    hemisphere = UPSCoords.getHemisphere();
                    _2CoordFieldsTextFieldA.setText(jniStrtoval.JNIMeterToString(UPSCoords.getEasting()));
                    _2CoordFieldsTextFieldB.setText(jniStrtoval.JNIMeterToString(UPSCoords.getNorthing()));
                    break;
                }
                case CoordinateTypes.USNG:
                {
                    USNG USNGCoords = jniEngine.JNIGetUSNGCoordinates(state, direction);
                    _3CoordFieldsTextFieldB.setText(USNGCoords.getCoordinateString());
                    break;
                }
                case CoordinateTypes.UTM:
                {
                    // set zone, hemisphere
                    UTM UTMCoords = jniEngine.JNIGetUTMCoordinates(state, direction);
                    hemisphere = UTMCoords.getHemisphere();
                    zone = UTMCoords.getZoneCoord();
                    _2CoordFieldsTextFieldA.setText(jniStrtoval.JNIMeterToString(UTMCoords.getEasting()));
                    _2CoordFieldsTextFieldB.setText(jniStrtoval.JNIMeterToString(UTMCoords.getNorthing()));
                    break;
                }
                default:
                    break;
            }
        }
        catch(GeotransError e)
        {
            jniStrtoval.setEngineError(true, e.getMessage());
            noErrors = false;
        }
        catch(JNIException e)
        {
            jniStrtoval.setJNIError(true, e.getMessage());
            noErrors = false;
        }
        return noErrors;
    }

    public void createCoordPanel(int projType)
    {
        setFormat();

        switch (projType)
        {
            case CoordinateTypes.GEOCENTRIC:
            {
                setThreeCoords();
                break;
            }
            case CoordinateTypes.GEODETIC:
            { // height type
                _2CoordFieldsPanel.setVisible(false);
                _3CoordFieldsPanel.setVisible(true);
                coordLayeredPane.moveToFront(_3CoordFieldsPanel);
                // Show optional fields.
                _3CoordFieldsLabelA.setVisible(true);
                _3CoordFieldsLabelC.setVisible(true);
                _3CoordFieldsTextFieldA.setVisible(true);
                _3CoordFieldsTextFieldC.setVisible(true);
                /* may be turned off by height type buttons. */
                setHeightFieldEditable();

                _3CoordFieldsLabelA.setText("Longitude:");
                _3CoordFieldsLabelB.setText("Latitude:");
                _3CoordFieldsLabelC.setText("Height (m):");
                try
                {
                    _3CoordFieldsTextFieldA.setText(jniStrtoval.JNILongitudeToString(0, useNSEW, useMinutes, useSeconds));
                    _3CoordFieldsTextFieldB.setText(jniStrtoval.JNILatitudeToString(0, useNSEW, useMinutes, useSeconds));
                }
                catch(GeotransError e)
                {
                    jniStrtoval.displayErrorMsg(this, e.getMessage());
                }
                catch(JNIException e)
                {
                    jniStrtoval.displayErrorMsg(this, e.getMessage());
                }

                _3CoordFieldsTextFieldC.setText( "0" );
                break;
            }
            case CoordinateTypes.GEOREF:
            {
                setOneCoord();
                _3CoordFieldsTextFieldB.setText( "NGAA0000000000" );
                break;
            }
            case CoordinateTypes.GARS:
            {
                setOneCoord();
                _3CoordFieldsTextFieldB.setText( "361HN37" );
                break;
            }
            case CoordinateTypes.F16GRS:
            {
                setOneCoord();
                _3CoordFieldsTextFieldB.setText( "31NEA00" );
                break;
            }
            case CoordinateTypes.MGRS:
            {
                setOneCoord();
                _3CoordFieldsTextFieldB.setText( "31NEA0000000000" );
                break;
            }
            case CoordinateTypes.BNG:
            {
                setOneCoord();
                _3CoordFieldsTextFieldB.setText( "SV 0000000000" );
                break;
            }
            case CoordinateTypes.NZMG:
            {
                setTwoCoords();
                _2CoordFieldsTextFieldA.setText("2510000");
                _2CoordFieldsTextFieldB.setText("6023150");
                break;
            }
            case CoordinateTypes.UPS:
            { // Hemisphere
                setTwoCoords();
                _2CoordFieldsTextFieldA.setText("2000000");
                _2CoordFieldsTextFieldB.setText("2000000");
                break;
            }
            case CoordinateTypes.USNG:
            {
                setOneCoord();
                _3CoordFieldsTextFieldB.setText( "31NEA0000000000" );
                break;
            }
            case CoordinateTypes.UTM:
            {
                // Hemisphere  // Zone
                setTwoCoords();
                _2CoordFieldsTextFieldA.setText("500000");
                break;
            }
            case CoordinateTypes.LOCCART:
            {
                setThreeCoords();
                break;
            }
            case CoordinateTypes.ALBERS:
            case CoordinateTypes.AZIMUTHAL:
            case CoordinateTypes.BONNE:
            case CoordinateTypes.CASSINI:
            case CoordinateTypes.CYLEQA:
            case CoordinateTypes.ECKERT4:
            case CoordinateTypes.ECKERT6:
            case CoordinateTypes.EQDCYL:
            case CoordinateTypes.GNOMONIC:
            case CoordinateTypes.LAMBERT_1:
            case CoordinateTypes.LAMBERT_2:
            case CoordinateTypes.MERCATOR:
            case CoordinateTypes.MILLER:
            case CoordinateTypes.MOLLWEIDE:
            case CoordinateTypes.NEYS:
            case CoordinateTypes.OMERC:
            case CoordinateTypes.ORTHOGRAPHIC:
            case CoordinateTypes.POLARSTEREO:
            case CoordinateTypes.POLYCONIC:
            case CoordinateTypes.SINUSOIDAL:
            case CoordinateTypes.STEREOGRAPHIC:
            case CoordinateTypes.TRCYLEQA:
            case CoordinateTypes.TRANMERC:
            case CoordinateTypes.GRINTEN:
            {
                setTwoCoords();
                break;
            }
            default:
            {
                break;
            }
        } /*    end of switch(projType)  */
    } /*   end of createCoordPanel()     */

    public void resetOutputErrors()
    {
        ce90TextField.setText("N/A");
        le90TextField.setText("N/A");
        se90TextField.setText("N/A");
    }


    public void reportOutputErrors(int state)
    {
        Accuracy outputErrors = jniEngine.JNIGetConversionErrors(state);
        double ce90 = outputErrors.getCE90();
        double le90 = outputErrors.getLE90();
        double se90 = outputErrors.getSE90();

        usePrevAccuracies = true;

        if (ce90 == -1.0)
            ce90TextField.setText("Unk");
        else
            jniStrtoval.setNumberFormat(ce90TextField, ce90, 0);

        if (!_3dConversion)
        {
            le90TextField.setText("N/A");
            se90TextField.setText("N/A");
        }
        else
        {
            if (le90 == -1.0)
                le90TextField.setText("Unk");
            else
                jniStrtoval.setNumberFormat(le90TextField, le90, 0);

            if (se90 == -1.0)
                se90TextField.setText("Unk");
            else
                jniStrtoval.setNumberFormat(se90TextField, se90, 0);
        }
    }

    // Set the engine with the input accuracy values
    public void setAccuracy()
    {
        if (!usePrevAccuracies)
        {
            try
            {
                java.lang.String ce90String = ce90TextField.getText().trim();
                java.lang.String le90String = le90TextField.getText().trim();
                java.lang.String se90String = se90TextField.getText().trim();

                double ce90, le90, se90;
                if ((ce90String.equals("Unk")) || (ce90String.equals("N/A")))
                    ce90 = -1.0;
                else
                    ce90 = jniStrtoval.stringToDouble(ce90String,  "Invalid CE 90");
                if ((le90String.equals("Unk")) || (le90String.equals("N/A")))
                    le90 = -1.0;
                else
                    le90 = jniStrtoval.stringToDouble(le90String,  "Invalid LE 90");
                if ((se90String.equals("Unk")) || (se90String.equals("N/A")))
                    se90 = -1.0;
                else
                    se90 = jniStrtoval.stringToDouble(se90String,  "Invalid SE 90");

                jniEngine.JNISetConversionErrors(ConversionState.INTERACTIVE, ce90, le90, se90);

            }
            catch(GeotransError e)
            {
                jniStrtoval.displayErrorMsg(this, e.getMessage());
            }
        }
    }

    // Set the source text fields editable/uneditable if it's a 3D/2D conversion
    public void updateSrcErrors(boolean _3dConv)
    {
        le90TextField.setEditable(_3dConv);
        se90TextField.setEditable(_3dConv);
        _3dConversion = _3dConv;
        updateAccuracy();
    }

    // Set the source text fields with the values corresponding
    // to the current combo box selection
    public void updateAccuracy()
    {
        try
        {
            long index = sourcesComboBox.getSelectedIndex() + 1;
            Accuracy accuracy = new JNISource().JNISourceAccuracy(index);

            usePrevAccuracies = false;

            double ce90 = accuracy.getCE90();
            double le90 = accuracy.getLE90();
            double se90 = accuracy.getSE90();

            if (ce90 == -1.0)
                ce90TextField.setText("Unk");
            else
                jniStrtoval.setNumberFormat(ce90TextField, accuracy.getCE90(), 0);
            if (!_3dConversion)
            {
                le90TextField.setText("N/A");
                se90TextField.setText("N/A");
            }
            else
            {
                if (le90 == -1.0)
                    le90TextField.setText("Unk");
                else
                    jniStrtoval.setNumberFormat(le90TextField, accuracy.getLE90(), 0);
                if (se90 == -1.0)
                    se90TextField.setText("Unk");
                else
                    jniStrtoval.setNumberFormat(se90TextField, accuracy.getSE90(), 0);
            }
        }
        catch(GeotransError e)
        {
            jniStrtoval.displayErrorMsg(this, e.getMessage());
        }
        catch(JNIException e)
        {
            jniStrtoval.displayErrorMsg(this, e.getMessage());
        }
    }

    public void setHeightText(String height)
    {
        _3CoordFieldsTextFieldC.setText(height);
    }


    public void setHeightFieldUneditable()
    {
        _3CoordFieldsTextFieldC.setEditable(false);
    }

    public void setHeightFieldEditable()
    {
        _3CoordFieldsTextFieldC.setEditable(true);
    }

    public void setHeightFieldEditable(boolean editable)
    {
        _3CoordFieldsTextFieldC.setEditable(editable);
    }

    public void setHemisphere(char hemi)
    {
        hemisphere = hemi;
    }

    public void setZone(int z)
    {
        zone = z;
    }

    public char getHemisphere()
    {
        return hemisphere;
    }

    public long getZone()
    {
        return zone;
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel _2CoordFieldsLabelA;
    private javax.swing.JLabel _2CoordFieldsLabelB;
    private javax.swing.JPanel _2CoordFieldsPanel;
    private javax.swing.JTextField _2CoordFieldsTextFieldA;
    private javax.swing.JTextField _2CoordFieldsTextFieldB;
    private javax.swing.JLabel _3CoordFieldsLabelA;
    private javax.swing.JLabel _3CoordFieldsLabelB;
    private javax.swing.JLabel _3CoordFieldsLabelC;
    private javax.swing.JPanel _3CoordFieldsPanel;
    private javax.swing.JTextField _3CoordFieldsTextFieldA;
    private javax.swing.JTextField _3CoordFieldsTextFieldB;
    private javax.swing.JTextField _3CoordFieldsTextFieldC;
    private javax.swing.JLabel ce90Label;
    private javax.swing.JTextField ce90TextField;
    private javax.swing.JLayeredPane coordLayeredPane;
    private javax.swing.JPanel errorsPanel;
    private javax.swing.JPanel inputErrorPanel;
    private javax.swing.JLabel le90Label;
    private javax.swing.JTextField le90TextField;
    private javax.swing.JPanel outputErrorPanel;
    private javax.swing.JLabel se90Label;
    private javax.swing.JTextField se90TextField;
    private javax.swing.JComboBox sourcesComboBox;
    private javax.swing.JLabel sourcesLabel;
    private javax.swing.JLabel tempLabel1;
    private javax.swing.JLabel tempLabel2;
    private javax.swing.JTextField tempTextField1;
    private javax.swing.JTextField tempTextField2;
    // End of variables declaration//GEN-END:variables

}