/*
 * Decompiled with CFR 0.152.
 */
package geotrans.gui;

import geotrans.jni.GeotransError;
import geotrans.jni.JNIEngine;
import geotrans.jni.JNIException;
import geotrans.jni.JNIStrtoval;
import javax.swing.JComboBox;
import javax.swing.JFrame;

public class FillList {
    private JNIEngine jniEngine = new JNIEngine();
    private JNIStrtoval jniStrtoval = new JNIStrtoval();
    private long datumCount = 0L;

    public FillList(JComboBox list, int listType) {
        if (listType == 0) {
            this.fillDatumList(list);
        } else {
            this.fillEllipsoidList(list);
        }
    }

    private void fillDatumList(JComboBox datumList) {
        try {
            if (datumList.getItemCount() > 0) {
                datumList.removeAllItems();
            }
            String datumCode = "";
            String datumName = "";
            this.datumCount = this.jniEngine.JNIGetDatumCount();
            int i = 1;
            while ((long)i <= this.datumCount) {
                datumCode = this.jniEngine.JNIGetDatumCode(i);
                datumName = this.jniEngine.JNIGetDatumName(i);
                datumList.addItem(datumCode + ":  " + datumName);
                ++i;
            }
            datumList.setSelectedIndex((int)this.jniEngine.JNIGetDatumIndex("WGE") - 1);
        }
        catch (GeotransError e) {
            this.jniStrtoval.displayErrorMsg(new JFrame(), e.getMessage());
        }
        catch (JNIException e) {
            this.jniStrtoval.displayErrorMsg(new JFrame(), e.getMessage());
        }
    }

    private void fillEllipsoidList(JComboBox ellipsoidList) {
        try {
            String ellipsoidCode = "";
            String ellipsoidName = "";
            long ellipsoidCount = this.jniEngine.JNIGetEllipsoidCount();
            int i = 1;
            while ((long)i <= ellipsoidCount) {
                ellipsoidCode = this.jniEngine.JNIGetEllipsoidCode(i);
                ellipsoidName = this.jniEngine.JNIGetEllipsoidName(i);
                ellipsoidList.addItem(ellipsoidCode + ":  " + ellipsoidName);
                ++i;
            }
            ellipsoidList.setSelectedIndex((int)this.jniEngine.JNIGetEllipsoidIndex("WE") - 1);
        }
        catch (GeotransError e) {
            this.jniStrtoval.displayErrorMsg(new JFrame(), e.getMessage());
        }
        catch (JNIException e) {
            this.jniStrtoval.displayErrorMsg(new JFrame(), e.getMessage());
        }
    }

    public void addDatum(JComboBox datumList) {
        try {
            long newDatumCount = this.jniEngine.JNIGetDatumCount();
            if (this.datumCount < newDatumCount) {
                String datumCode = "";
                String datumName = "";
                int i = (int)this.datumCount;
                while ((long)i < newDatumCount) {
                    datumCode = this.jniEngine.JNIGetDatumCode(i + 1);
                    datumName = this.jniEngine.JNIGetDatumName(i + 1);
                    datumList.insertItemAt(datumCode + ":  " + datumName, i);
                    ++i;
                }
                this.datumCount = newDatumCount;
            }
        }
        catch (GeotransError e) {
            this.jniStrtoval.displayErrorMsg(new JFrame(), e.getMessage());
        }
        catch (JNIException e) {
            this.jniStrtoval.displayErrorMsg(new JFrame(), e.getMessage());
        }
    }

    public void deleteDatum(JComboBox datumList, int index) {
        try {
            long newDatumCount = this.jniEngine.JNIGetDatumCount();
            if (this.datumCount > newDatumCount) {
                datumList.removeItemAt(index);
                --this.datumCount;
            }
        }
        catch (GeotransError e) {
            this.jniStrtoval.displayErrorMsg(new JFrame(), e.getMessage());
        }
    }
}

