/*
 * Decompiled with CFR 0.152.
 */
package geotrans.gui;

import geotrans.gui.MasterPanel;
import geotrans.gui.ProgressDlg;
import geotrans.gui.jOptions;
import geotrans.jni.GeotransError;
import geotrans.jni.JNIException;
import geotrans.jni.JNIFiomeths;
import geotrans.jni.JNIStrtoval;
import geotrans.utility.Center;
import geotrans.utility.DATFileFilter;
import geotrans.utility.Directory;
import geotrans.utility.StartBrowser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.LineBorder;

public class FileDlg
extends JDialog {
    private Directory currentDir;
    private MasterPanel lowerFilePanel;
    private JNIFiomeths jniFiomeths;
    private JFrame parentFrame;
    private jOptions options;
    private JPanel buttonsPanel;
    private JButton cancelButton;
    private JButton helpButton;
    private JPanel inputFilePanel;
    private JLabel inputLabel;
    private JButton okButton;
    private JPanel outputFilePanel;
    private JLabel outputLabel;

    public FileDlg(JFrame parent, boolean modal, Directory dir, jOptions joptions, JNIFiomeths jni_Fiomeths) {
        super((Frame)parent, modal);
        this.initComponents();
        this.parentFrame = parent;
        this.currentDir = dir;
        this.jniFiomeths = jni_Fiomeths;
        this.options = joptions;
        MasterPanel upperFilePanel = new MasterPanel(0, 0, joptions);
        this.lowerFilePanel = new MasterPanel(0, 1, joptions);
        this.inputFilePanel.add((Component)upperFilePanel, "Center");
        this.outputFilePanel.add((Component)this.lowerFilePanel, "Center");
        this.pack();
        new Center(parent, this);
    }

    private void initComponents() {
        this.inputFilePanel = new JPanel();
        this.inputLabel = new JLabel();
        this.outputFilePanel = new JPanel();
        this.outputLabel = new JLabel();
        this.buttonsPanel = new JPanel();
        this.okButton = new JButton();
        this.helpButton = new JButton();
        this.cancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("GEOTRANS File Processing");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                FileDlg.this.closeDialog(evt);
            }
        });
        this.inputFilePanel.setLayout(new BorderLayout(1, 1));
        this.inputFilePanel.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.inputFilePanel.setMinimumSize(new Dimension(467, 197));
        this.inputFilePanel.setPreferredSize(new Dimension(467, 197));
        this.inputLabel.setText("INPUT");
        this.inputFilePanel.add((Component)this.inputLabel, "North");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.inputFilePanel, gridBagConstraints);
        this.outputFilePanel.setLayout(new BorderLayout(1, 1));
        this.outputFilePanel.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.outputFilePanel.setAlignmentY(1.5f);
        this.outputFilePanel.setMinimumSize(new Dimension(467, 197));
        this.outputFilePanel.setPreferredSize(new Dimension(467, 197));
        this.outputLabel.setText("OUTPUT");
        this.outputFilePanel.add((Component)this.outputLabel, "North");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 8;
        gridBagConstraints.insets = new Insets(3, 2, 2, 2);
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.getContentPane().add((Component)this.outputFilePanel, gridBagConstraints);
        this.buttonsPanel.setLayout(new GridBagLayout());
        this.buttonsPanel.setMinimumSize(new Dimension(330, 50));
        this.buttonsPanel.setPreferredSize(new Dimension(330, 50));
        this.okButton.setPreferredSize(new Dimension(80, 21));
        this.okButton.setBorder(new BevelBorder(0));
        this.okButton.setMnemonic(79);
        this.okButton.setMaximumSize(new Dimension(80, 21));
        this.okButton.setText("OK");
        this.okButton.setMinimumSize(new Dimension(80, 21));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileDlg.this.okActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 12, 45);
        this.buttonsPanel.add((Component)this.okButton, gridBagConstraints);
        this.helpButton.setMnemonic(72);
        this.helpButton.setText("Help");
        this.helpButton.setBorder(new BevelBorder(0));
        this.helpButton.setMaximumSize(new Dimension(80, 21));
        this.helpButton.setMinimumSize(new Dimension(80, 21));
        this.helpButton.setPreferredSize(new Dimension(80, 21));
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileDlg.this.helpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 12, 45);
        this.buttonsPanel.add((Component)this.helpButton, gridBagConstraints);
        this.cancelButton.setPreferredSize(new Dimension(80, 21));
        this.cancelButton.setBorder(new BevelBorder(0));
        this.cancelButton.setMnemonic(67);
        this.cancelButton.setMaximumSize(new Dimension(80, 21));
        this.cancelButton.setText("Cancel");
        this.cancelButton.setMinimumSize(new Dimension(80, 21));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileDlg.this.cancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.buttonsPanel.add((Component)this.cancelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.getContentPane().add((Component)this.buttonsPanel, gridBagConstraints);
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.jniFiomeths.JNICloseInputFile();
        this.dispose();
    }

    private void helpActionPerformed(ActionEvent evt) {
        File helpFile = new File("..");
        try {
            if (StartBrowser.isWindowsPlatform()) {
                StartBrowser.displayURL(this, "file:" + helpFile.getCanonicalPath() + "\\help\\fileproc.htm");
            } else {
                StartBrowser.displayURL(this, "file:" + helpFile.getCanonicalPath() + "/help/fileproc.htm");
            }
        }
        catch (Exception e) {
            new JNIStrtoval().displayErrorMsg(this, "Could not invoke browser");
        }
    }

    private void okActionPerformed(ActionEvent evt) {
        JNIStrtoval jniStrtoval = new JNIStrtoval();
        this.lowerFilePanel.setEngine();
        if (!this.lowerFilePanel.JNIError()) {
            if (!this.lowerFilePanel.engineError()) {
                this.setVisible(false);
                JFileChooser jChooser1 = new JFileChooser(this.currentDir.getDirectory());
                jChooser1.setDialogTitle("Save As");
                jChooser1.addChoosableFileFilter(new DATFileFilter());
                jChooser1.setSelectedFile(new File("*.dat"));
                int state = jChooser1.showSaveDialog(this.parentFrame);
                if (state == 0) {
                    File file = jChooser1.getSelectedFile();
                    this.currentDir.setDirectory(file.getAbsolutePath());
                    if (file != null) {
                        try {
                            this.jniFiomeths.JNIUseNSEW(this.options.getUseNSEW());
                            this.jniFiomeths.JNIUseMinutes(this.options.getUseMinutes());
                            this.jniFiomeths.JNIUseSeconds(this.options.getUseSeconds());
                            this.jniFiomeths.JNISetOutputFilename(file.getPath());
                            new ProgressDlg(this, true, this.jniFiomeths).show();
                        }
                        catch (GeotransError e) {
                            jniStrtoval.displayErrorMsg(this, e.getMessage());
                            this.jniFiomeths.JNICloseInputFile();
                        }
                        catch (JNIException e) {
                            jniStrtoval.displayErrorMsg(this, e.getMessage());
                            this.jniFiomeths.JNICloseInputFile();
                        }
                    }
                    this.dispose();
                } else {
                    this.jniFiomeths.JNICloseInputFile();
                    this.dispose();
                }
            } else {
                this.lowerFilePanel.showErrors(this);
            }
        } else {
            this.lowerFilePanel.showErrors(this);
            this.jniFiomeths.JNICloseInputFile();
            this.dispose();
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.jniFiomeths.JNICloseInputFile();
        this.dispose();
    }
}

