static char rcsid[] = "$Id: hsolve.c,v 1.2 1997/05/28 23:01:09 dhb Exp $";

/* Version EDS20i 95/06/02, Erik De Schutter, Caltech & BBF-UIA 4/94-7/94 */
/* Upinder S. Bhalla Caltech May-December 1991 */

/*
** $Log: hsolve.c,v $
** Revision 1.2  1997/05/28 23:01:09  dhb
** Replaced with version from Antwerp GENESIS 21e
**
** Revision 1.1  1992/12/11  19:03:11  dhb
** Initial revision
**
*/

#include "hines_ext.h"

/* trivial function that just loops over the funcs array and 
** performs the ops. I need to check if a case statement would
** be any faster, since this is the most intensively used function.
** I estimate about M * 17 operations, mainly the two ELIM ops */
do_fast_hsolve(hsolve)
    Hsolve  *hsolve;
{
    register int     *funcs;
    register double  temp,diavalue;
    register double  *resultvalue,*results,*values;
    register int     op;
    register int     index;

    values = hsolve->values;
    funcs = hsolve->funcs;
	/* first instructions is truncated SET_DIAG, but we do not want to change
	**  resultvalue yet */
    resultvalue = results = hsolve->results;
	diavalue = values[*funcs++];

    while(1) {
        op= *funcs++;
        index= *funcs++;
        if (op == FORWARD_ELIM){
            values[index] -= values[*funcs++]*temp;
        } else if (op == BACKWARD_ELIM){
            results[index] -= values[*funcs++]*temp;
        } else if (op == SCALE){
            temp = values[index]/diavalue;
            results[*funcs++] -= *resultvalue*temp;
        } else if (op == CALC_RESULTS){
            *resultvalue = temp = *resultvalue/values[index];
			resultvalue--;
        } else if (op == SET_DIAG){
            resultvalue++;
            diavalue = values[index];
        } else if (op == FINISH){
            break;
        }
	}
}

/* Another version of hsolve which actually does the matrix solution
** rather than filling up the funcs array for future use. 
** This version relies on the symmetry of the matrix to quickly find
** rows below the current one which have non-zero elements to eliminate
** This involves about 2 array lookups and 1 if statement more per
** coefficient than the 'unwound' version : perhaps 1/2 as fast ?
** This routine takes about 2x as long as the fast hsolve routine,
** but avoids the use of a func table. It is the default
*/
do_hsolve(hsolve)
	Hsolve	*hsolve;
{
	int i,j,k;
	int	row;
	int	ind1,ind2,ind3;
	int	ncompts;
	int	*ri,*cip,*diag;
	double resultvalue,diavalue,temp;
	double	*results,*values;
	int get_index();
	int	nextcip,di,cipnextrow;
	int	cipi,drow;

	ncompts=hsolve->ncompts;
	ri=hsolve->ri;
	cip=hsolve->cip;
	diag=hsolve->diag;
	results=hsolve->results;
	values=hsolve->values;

	/* looping over all rows, doing forward substitution */
	for(i=0;i<ncompts;i++) {
	    di=diag[i];
	    diavalue = values[di];
	    di++;
	    resultvalue=results[i];
	    nextcip=cip[i+1];
	    /* Looping over all coupled rows */
	    for(j=di;j<nextcip;j++) {
		row=ri[j]; /* since the matrix is symmetrical, the ri also
			   ** gives the correct row index */
		cipnextrow=cip[row+1];
		for(ind1=cip[row];ind1<cipnextrow;ind1++)
		    if(ri[ind1]==i) {
		    /* calculate scaling factor */
		    temp = values[ind1]/diavalue;
		    results[row] -= resultvalue*temp;
		    /* looping over all nonzero columns for _ith_ row */
		    for(ind2=di,ind3=ind1+1;ind2<nextcip;ind2++){
			for (;ri[ind3]!=ri[ind2];ind3++) {
			    if(ind3>=cipnextrow) {
				/* a major screw-up */
				Error();
				printf(" during SETUP of %s: bug in forward elim.\n",Pathname(hsolve));

				return(ERR);
			    }
			}
			/* Otherwise, proceed with elimination */
			values[ind3] -= values[ind2]*temp;
		    }
		}
	    }
	}
	/* looping over all rows, doing backwards elimination */
	for(i=ncompts-1;i>=0;i--) {
	    di=diag[i];
	    cipi=cip[i];
	    results[i] = temp = results[i]/values[di];
	    for(j=di-1;j>=cipi;j--) {
		    /* since the matrix is symmetrical, the ri also
		    ** gives the correct row index */
		    drow=diag[row=ri[j]];
		    for(ind1=cip[row+1]-1;ind1>drow;ind1--) {
			if(ri[ind1]==i) {
			    results[row] -= values[ind1]*temp;
			}
		    }
	    }
	}
}

#ifdef OLD
/*
** A version of hsolve which does the matrix solution
** rather than filling up the funcs array for future use. Mainly
** here for checking and speed comparison reasons. It is somewhat
** easier to understand than the others, but that is not saying
** much.
*/
do_slow_hsolve(hsolve)
	Hsolve	*hsolve;
{
	int i,j,k;
	int	ind1,ind2,ind3;
	int	ncompts;
	int	*ri,*cip,*diag;
	double resultvalue,diavalue,temp;
	double	*results,*values;
	int get_index();

	ncompts=hsolve->ncompts;
	ri=hsolve->ri;
	cip=hsolve->cip;
	diag=hsolve->diag;
	results=hsolve->results;
	values=hsolve->values;


	/* looping over all rows, doing forward substitution */
	for(i=0;i<ncompts;i++) {
		diavalue = values[diag[i]];
		resultvalue=results[i];
		/* looping over all rows below to find coupled ones */
		for(j=i+1;j<ncompts;j++) {
			if((ind1=get_index(j,i,ri,cip)) >= 0) {
			/* Found a coupled row ! */

				/* calculate scaling factor */
				temp = values[ind1]/diavalue;
				results[j] -= resultvalue*temp;

				/* looping over all nonzero columns for _ith_ row */
				for(k=i+1;k<ncompts;k++){
					if((ind2=get_index(i,k,ri,cip)) >= 0) {
						if((ind3=get_index(j,k,ri,cip)) < 0) {
							/* a major screw-up */
							fprintf(stderr,"Error in forward elim:(%d,%d) missing\n",j,k);
							fprintf(stderr,"hsetup failed\n",j,k);
							return;
						}
						/* Otherwise, proceed with elimination */
						values[ind3] -= values[ind2]*temp;
					}
				}
			}
		}
	}

	/* looping over all rows, doing backwards elimination */
	for(i=ncompts-1;i>=0;i--) {
		results[i] = temp = results[i]/values[diag[i]];
		for(j=i-1;j>=0;j--) {
			/* looking for a coupled row */
			if((ind1=get_index(j,i,ri,cip)) >= 0) {
				results[j] -= values[ind1]*temp;
			}
		}
	}
}

/* Using the matrix convention where the first index is vertical,
** and the c convention where numbering starts at zero */

int get_index(i,j,ri,cip)
    int i,j;
    int *ri,*cip;
{
    int k;

    for(k=cip[i];k<cip[i+1];k++){
        if (j<ri[k])
            return(-1);
        if (j==ri[k])
            return(k);
    }
    return(-1);
}
#endif

