static char rcsid[] = "$Id: hines_conc_init.c,v 1.1 1997/05/28 23:11:50 dhb Exp $";

/* Version EDS21d 97/02/07, Erik De Schutter, BBF-UIA 8/94-2/97 */

/*
** $Log: hines_conc_init.c,v $
** Revision 1.1  1997/05/28 23:11:50  dhb
** Initial revision
**
*/

/* initializes all arrays for concentrations */

#include "hines_ext.h"

int h_init_conc_solve(hsolve)
/* Creates and initializes fdiffs, numshells, fcoval,
** fbufval arrays, creates covals, bufvals,  coresult, 
** cores and codiag arrays.  */
	Hsolve	*hsolve;
{
	int 	ncompts=hsolve->ncompts;
	int 	nconcs=hsolve->nconcs;
	int 	nchildren=hsolve->nchildren;
	Element	**children,*child;
	int 	i,j,m,mr,ms,n,nb,nr,nv;
	int		nshells,nrows,nelms,nfix;
	int		*numshshells,*numshrows,*numshelms,*numshfix;
	short   *childtypes;
	int		*childstart,*childmsg,*childcode,*childpos;
	int		cm,ct;
	float	*childdata;
	int		ndiffs,*firstdiffs,*numshells,*diffconc;
	int		*firstcoval,*firstbufval,*diffchild;
	double	*flux,*coresult,*codiag;
	int		concID;

	children=hsolve->children;
	childtypes=hsolve->childtypes;
	childcode=hsolve->childcode;
	childdata=hsolve->childdata;
	childmsg=hsolve->childmsg;
	childpos=hsolve->childpos;
	childstart=hsolve->childstart;

	/* Count number of diffusion systems in each compartment 
	** A diffusion systems is defined as any set of concentrations +
	**  buffers, etc having the same concID */
	ndiffs=0;	/* count total */
	for (i=0;i<ncompts;i++){
		n=childstart[i];
		concID=-1;
		for (j=n; j<childstart[i+1]; j++) {
			ct=childtypes[j];
			switch (ct) {
                case CACONCEN_T:
					if (childcode[j]!=concID)  concID=-1;
					break;

                case DIFSHELL_T:
                case DIFSLAB_T:
                case DIFUSER_T:
					if (childcode[j]!=concID) {
						ndiffs++;
						concID=childcode[j];
					}
					break;

				default:
					break;
			}
		}
	}
	/* Allocate arrays */
	hsolve->conc=(double *)calloc(nconcs,sizeof(double));
	flux=hsolve->flux=(double *)calloc(nconcs,sizeof(double));
	if (ndiffs==0) return(0);	/* no diffusion */

	hsolve->ndiffs=ndiffs;
	coresult=hsolve->coresult=(double *)calloc(nconcs,sizeof(double));
	codiag=hsolve->codiag=(double *)calloc(nconcs,sizeof(double));
	hsolve->cores=(double *)calloc(nconcs,sizeof(double));
	for (i=0; i<nconcs; i++) {
		/* a lot of these values will never be changed! */
		flux[i]=coresult[i]=0.0;
		codiag[i]=1.0;
	}
	if (hsolve->readflag==HDUPLICATE_T) return(0);	/* rest is identical */

	firstdiffs=hsolve->fdiffs=(int *)calloc(ncompts+1,sizeof(int));
	firstcoval=hsolve->fcoval=(int *)calloc(ndiffs+1,sizeof(int));
	firstbufval=hsolve->fbufval=(int *)calloc(ndiffs+1,sizeof(int));
	diffchild=hsolve->dchild=(int *)calloc(ndiffs+1,sizeof(int));
	diffconc=hsolve->dconc=(int *)calloc(ndiffs+1,sizeof(int));
	numshells=hsolve->nshells=(int *)calloc(ndiffs+1,sizeof(int));
	numshrows=hsolve->nshrows=(int *)calloc(ndiffs+1,sizeof(int));
	numshelms=hsolve->nshelms=(int *)calloc(ndiffs+1,sizeof(int));
	numshfix=hsolve->nshfix=(int *)calloc(ndiffs+1,sizeof(int));
	/* Count number of shells and buffers in each diffusion system */
	mr=ms=ndiffs=0;
	for (i=0;i<ncompts;i++){
		n=childstart[i];
		firstdiffs[i]=ndiffs;
		concID=-1;
		nshells=nrows=0;	
		for (j=n; j<childstart[i+1]; j++) {
			ct=childtypes[j];
			cm=childmsg[j];	/* -> conc */
			switch (ct) {
                case CACONCEN_T:
					if (childcode[j]!=concID)  concID=-1;
					break;

                case FIXBUFF_T:
                case BUFSHELL_T:
                case BUFSLAB_T:
                case BUFUSER_T:
                case BUF2SHELL_T:
                case BUF2SLAB_T:
                case BUF2USER_T:
					if (BaseObject(hsolve)->method == BEULER_INT) {
						ErrorMessage("SETUP","Cannot solve buffer equations with backward Euler method.  Use Crank-Nicholson for",hsolve);
						return(ERR);
					}
                case DIFSHELL_T:
                case DIFSLAB_T:
                case DIFUSER_T:
					if (childcode[j]==concID) {
						switch (ct) {
							case FIXBUFF_T:
								if (nshells==0) nfix++;
								/* no break! */

							case BUFSHELL_T:
							case BUFSLAB_T:
							case BUFUSER_T:
								if (nshells==0) {
									nrows++;	/* one line in the array */
									nelms++;
								} else {
									nr++;
								}
								break;

							case BUF2SHELL_T:
							case BUF2SLAB_T:
							case BUF2USER_T:
								if (nshells==0) {
									nrows+=2;	/* two lines in the array */
									nelms++;
								} else {
									nr+=2;
								}
								break;

							case DIFSHELL_T:
							case DIFSLAB_T:
							case DIFUSER_T:
								if (nshells==0) {
									nrows++;	/* one line in the array */
									nelms++;
								} else {
									nr++;
								}
								nshells++;
								break;
						}
					} else {	/* new conc */
						if ((concID!=-1)&&(nshells>0)) {
						/* this is first conc new system, store old one */
							if (nshells==0) {
								fprintf(stderr,"Error while creating %s: diffusion system without shells!\n",hsolve->name);
								return(ERR);
							}
							if (nr!=nrows) {
								fprintf(stderr,"Error while creating %s: %s has different number of shells than rest\n",hsolve->name,children[j]->name);
								return(ERR);
							}
							numshells[ndiffs]=nshells;
							numshrows[ndiffs]=nrows;
							numshelms[ndiffs]=nelms;
							numshfix[ndiffs]=nfix;
							if (nshells>ms) ms=nshells;	/* maxshells */
							if (nrows>mr) mr=nrows;	/* maxrows */
							ndiffs++;
						}
						diffconc[ndiffs]=cm;	/* first conc */
						diffchild[ndiffs]=j;
						concID=childcode[j];
						nelms=nr=nrows=1;
						switch (ct) {
							case FIXBUFF_T:
								nfix=1;
								nshells=0;
								break;

							case BUFSHELL_T:
							case BUFSLAB_T:
							case BUFUSER_T:
							case BUF2SHELL_T:
							case BUF2SLAB_T:
							case BUF2USER_T:
								nfix=0;
								nshells=0;
								break;

							case DIFSHELL_T:
							case DIFSLAB_T:
							case DIFUSER_T:
								nfix=0;
								nshells=1;
								break;
						}
					}
					childcode[j]=ndiffs;
					break;

				default:
					break;
			}
		}
		if ((concID!=-1)&&(nshells>0)) {
		/* store last one */
			if (nshells==0) {
				fprintf(stderr,"Error while creating %s: diffusion system without shells!\n",hsolve->name);
				return(ERR);
			}
			numshells[ndiffs]=nshells;
			numshrows[ndiffs]=nrows;
			numshelms[ndiffs]=nelms;
			numshfix[ndiffs]=nfix;
			if (nshells>ms) ms=nshells;	/* maxshells */
			if (nrows>mr) mr=nrows;	/* maxrows */
			ndiffs++;
		}
	}
	if (ndiffs!=hsolve->ndiffs) {
		fprintf(stderr,"Error in %s: Bug #3 in h_init_conc_solve %d.\n",hsolve->name,ndiffs);
		return(ERR);
	}
	firstdiffs[i]=ndiffs;
	/* create covals array */
	nb=nv=0;
	/* count ncovals */
	for (i=0; i<ndiffs; i++) {	
		/* diffusion equation */
		firstcoval[i]=nv;
		firstbufval[i]=nb;
		if (numshrows[i]>1) {	/* has buffers */
			nv+=2*numshells[i]*(numshrows[i]-numshfix[i])-1;
			nb+=3*(numshrows[i]-1);
		} else {				/* pure diffusion */
			nv+=3*numshells[i]-2;
		}
	}
	firstcoval[i]=nv;
	firstbufval[i]=nb;
	hsolve->maxshells=ms;
	hsolve->maxshcols=mr;
	mr=mr*ms;		/* max number of rows in covals array */
	hsolve->covals0=(double *)calloc(nv,sizeof(double));
	hsolve->covals=(double *)calloc(mr*mr,sizeof(double));
	hsolve->cores=(double *)calloc(mr,sizeof(double));
	hsolve->bufvals=(double *)calloc(nb,sizeof(double));
	return(0);
}

int h_setup_conc_solve(hsolve)
/* Fills covals0 arrays */
/* For diffusion we use the Neumann condition d[Ca]0/dx=0 at the outer
**  shell.
*/
/* BUF2SHELL_T NOT IMPLEMENTED */
	Hsolve	*hsolve;
{
	int 	ndiffs=hsolve->ndiffs;
	Element	**children,*child;
	short   *childtypes;
	int		*childcode;
	int		ct;
	float	*childdata;
	int 	i,j,k,m,ms,n,ne,nb,nc,nv;
	int		*numshells,*numshelms,*diffchild,*diffwidth;
	double	Diff,cfu,cfd,diag,prevc;
	double	*cov0,*bufvals;
	double	dt,dt2;
	Dbuffer	*buffer;
	D2buffer *buffer2;
	Dshell	*shell;
	int		concID;

	children=hsolve->children;
	childtypes=hsolve->childtypes;
	childcode=hsolve->childcode;
	childdata=hsolve->childdata;
	numshells=hsolve->nshells;
	numshelms=hsolve->nshelms;
	diffwidth=hsolve->nshrows;
	diffchild=hsolve->dchild;
	cov0=hsolve->covals0;
	bufvals=hsolve->bufvals;
	dt = hsolve->dt;
	if (BaseObject(hsolve)->method == CRANK_INT)
		dt2 = dt/2.0;
	else /* BEULER by default */
		dt2 = dt;

	
	nv=nb=0;
	for (i=0; i<ndiffs; i++) {
	  ms=numshells[i];
	  j=diffchild[i];		/* index first element */
	  concID=childcode[j];
	  ne=numshelms[i];	/* number of rows */
		/* BANDED MATRIX */
		/* cycle through all children of this diffusion system */
		for (m=0; m<ms ; m++) {	/* all shells */
		  for (k=0; k<ne ; k++,j++) {	/* all rows of each shell */
			if (childcode[j]!=concID) {
				fprintf(stderr,"Error in %s: Bug #1 in h_setup_conc_solve %d %d.\n",hsolve->name,i,j);
				return(ERR);
			}
			ct=childtypes[j];
			switch (ct) {
                case FIXBUFF_T:
					/* fixed buffer: buffer rates */
					if (m==0) {
						buffer=(Dbuffer *)children[j];
						bufvals[nb]=dt2*buffer->kBf;
						bufvals[nb+1]=dt2*buffer->kBb;
						bufvals[nb+2]=dt*buffer->kBb*buffer->Btot;
						nb+=3;
					}
					break;

                case BUFSHELL_T:
                case BUFSLAB_T:
                case BUFUSER_T:
					/* diffusible buffer: buffer rates */
					buffer=(Dbuffer *)children[j];
					if (m==0) {
						bufvals[nb]=dt2*buffer->kBf;
						bufvals[nb+1]=dt2*buffer->kBb;
						bufvals[nb+2]=dt*buffer->kBb*buffer->Btot;
						nb+=3;
					}
					/* diffusible buffer: difusion */
					Diff=2.0*dt2*buffer->D/buffer->vol;	/* 2/(thick+thick) */
					/* first shell: we diffuse to mid-point -> total
					**  thickness=(2*thick0 + thick1)/2 */
					if (m<ms-1) {	/* not outer shell: upward diffusion */
						if (m) {	/* not first shell: downward diffusion */
							if (m==1) {	/* connected to first shell */
								cov0[nv++]=Diff*buffer->surf_down/
											(2*childdata[j-ne]+childdata[j]);
							} else {
								cov0[nv++]=Diff*buffer->surf_down/
											(childdata[j-ne]+childdata[j]);
							}
								cov0[nv++]=Diff*buffer->surf_up/
												(childdata[j]+childdata[j+ne]);
						} else { /* inner shell: place in mid-point */
							cov0[nv++]=Diff*buffer->surf_up/
											(2*childdata[j]+childdata[j+ne]);
						}
					} else {	/* outer shell */
					/* Neumann condition: */
						cov0[nv++]=Diff*buffer->surf_down/
											(childdata[j-ne]+childdata[j]);
					}
					break;

                case BUF2SHELL_T:
                case BUF2SLAB_T:
                case BUF2USER_T:
					break;

                case DIFSHELL_T:
                case DIFSLAB_T:
                case DIFUSER_T:
					/* shell diffusion: is always last in sequence */
					shell=(Dshell *)children[j];
					Diff=2.0*dt2*shell->D/shell->vol; /* 2/(thick+thick) */
					/* first shell: we diffuse to mid-point -> total
					**  thickness=(2*thick0 + thick1)/2 */
					if (m<ms-1) {	/* not outer shell: upward diffusion */
						if (m) {	/* not first shell: downward diffusion */
							if (m==1) {	/* connected to first shell */
								cov0[nv++]=Diff*shell->surf_down/
											(2*childdata[j-ne]+childdata[j]);
							} else {
								cov0[nv++]=Diff*shell->surf_down/
											(childdata[j-ne]+childdata[j]);
							}
								cov0[nv++]=Diff*shell->surf_up/
												(childdata[j]+childdata[j+ne]);
						} else { /* inner shell: place in mid-point */
							cov0[nv++]=Diff*shell->surf_up/
											(2*childdata[j]+childdata[j+ne]);
						}
					} else {	/* outer shell */
					/* Neumann condition: */
						cov0[nv++]=Diff*shell->surf_down/
											(childdata[j-ne]+childdata[j]);
					}
					break;

				default:
					fprintf(stderr,"Error in %s: Bug #2 in h_setup_conc_solve %d %d.\n",hsolve->name,j,ct);
					return(ERR);
			}
		  }
		}
	}
	if (nv>hsolve->fcoval[ndiffs]) {
		fprintf(stderr,"Error in %s: Bug #3 in h_setup_conc_solve %d.\n",hsolve->name,nv);
	}
	return(0);
}

int h_init_conc_chip(hsolve)
/* Creates the cchip and cops arrays and fills the cops array. */
    Hsolve  *hsolve;
{
    int     i,j,k,l,m,n;
    int     ncompts=hsolve->ncompts;
    int     nchildren=hsolve->nchildren;
    Element **compts,*compt,**children,*child;
    short   *childtypes;
    int     *childstart,*childlink,*childmsg;
    int     ct,cm,cl;
    int     *elmnum,*compchips,*compops,*childops,*childchips;
    int     nchip,nop,lastconc;
    Action  *action;
    double  *chip;
	Tpump	*pump;
    int     *ops;

    compts=hsolve->compts;
    children=hsolve->children;
    elmnum=hsolve->elmnum;
    childtypes=hsolve->childtypes;
    childlink=hsolve->childlink;
	childmsg=hsolve->childmsg;
    childstart=hsolve->childstart;
	childops=hsolve->childops;
    childchips=hsolve->childchips;

    action = GetAction("RECALC");

	/* First find the number of elements that the chip and ops arrays will
	**   have to deal with.  */
    nop=1;	/* LCONC_OP or LCACONC_OP */
    nchip=0;
    lastconc=-1; /* none selected */
    for (i=0;i<ncompts;i++){
        n=childstart[i];
        for (j=n; j<childstart[i+1]; j++) {
            child=children[j];
            CallElement(child,action);  /* update fields of element */
            ct=childtypes[j];
            cl=childlink[j];
            cm=childmsg[j];
            switch (ct) {
		case DIFSHELL_T:
		case DIFSLAB_T:
		case DIFUSER_T:
			if (cl>=FLUXOFFSET) {
				if (cm!=lastconc) {
					nop+=2;	  /* CONC_OP */
					lastconc=cm;
				}
				nop++;	/* FLUXCONC_OP */
				nchip+=2;
			}
			break;

		case TAUPUMP_T:
			if (cl!=lastconc) {
				nop+=2;	  /* CONC_OP */
				lastconc=cl;
			}
			pump=(Tpump *)child;
			if ((pump->T_A>0.0)||(pump->T_B!=0.0)) {
				nop+=2;	/* TAUPUMP_OP & index */
				nchip+=5;
			} else {
				nop++;	/* CTAUPUMP_OP */
				nchip+=2;
			}
			break;

		case MMPUMP_T:
			if (cl!=lastconc) {
				nop+=2;	  /* CONC_OP */
				lastconc=cl;
			}
			nop++;	/* MMPUMP_OP */
			nchip+=2;
			break;

		case CACONCEN_T:
			nop+=2;      /* CONC_OP & index */
			nchip+=3;
			break;

		default:
			break;
	    }
	}
    } /* i loop */
    /* Allocate chip and ops array */
    hsolve->nconcchips=nchip;
    chip=hsolve->concchip=(double *)calloc(nchip,sizeof(double));
    hsolve->nconcops=nop;
    ops=hsolve->concops=(int *)calloc(nop,sizeof(int));
    nop=nchip=0;
    lastconc=-1; /* none selected */
    for (i=0;i<ncompts;i++){
        compt = compts[elmnum[i]];
        n=childstart[i];
        for (j=n; j<childstart[i+1]; j++) {
            child=children[j];
            ct=childtypes[j];
            cm=childmsg[j];
            cl=childlink[j];
            /* store childops and childchips for any concen child */
            switch (ct) {
		case DIFSHELL_T:
		case DIFSLAB_T:
		case DIFUSER_T:
		case TAUPUMP_T:
		case MMPUMP_T:
		case CACONCEN_T:
			if (!hsolve->no_elminfo) {
                       		childops[j]=nop;
                       		childchips[j]=nchip;
                    	}
                    	break;

		default:
                   	break;
	    }
	    /* store ops */
	    switch (ct) {
		case DIFSHELL_T:
		case DIFSLAB_T:
		case DIFUSER_T:
			h_check_msgs(hsolve,child,CONC_OP,i,nop,nchip);
			if (cl>=FLUXOFFSET) {
			/* has in/outflows and/or leak */
				if (cm!=lastconc) {
					if (lastconc==-1) {
						ops[nop]=FCONC_OP;
					} else {
						ops[nop]=CONC_OP;
					}
					ops[nop+1]=cm;
					nop+=2;
					if (!hsolve->no_elminfo) childops[j]=nop;
					lastconc=cm;
				}
				ops[nop]=FLUXCONC_OP;
				nop++;
				nchip+=2;
			}
			break;

		case FIXBUFF_T:
		case BUFSHELL_T:
		case BUFSLAB_T:
		case BUFUSER_T:
			h_check_msgs(hsolve,child,BUFFER_OP,i,nop,nchip);
 			if (!hsolve->no_elminfo) {
                       		childops[j]=0;
                       		childchips[j]=0;
                    	}
			break;

		case TAUPUMP_T:
			h_check_msgs(hsolve,child,TAUPUMP_OP,i,nop,nchip);
			if (cl!=lastconc) {
				if (lastconc==-1) {
					ops[nop]=FCONC_OP;
				} else {
					ops[nop]=CONC_OP;
				}
				ops[nop+1]=cl;
				nop+=2;
				lastconc=cl;
			}
			pump=(Tpump *)child;
			if ((pump->T_A>0.0)||(pump->T_B!=0.0)) {
				ops[nop]=TAUPUMP_OP;
				ops[nop+1]=i;	/* index into vm */
				nop+=2;
				nchip+=5;
			} else {
				ops[nop]=CTAUPUMP_OP;
				nop++;
				nchip+=2;
			}
			break;

		case MMPUMP_T:
			if (cl!=lastconc) {
				if (lastconc==-1) {
					ops[nop]=FCONC_OP;
				} else {
					ops[nop]=CONC_OP;
				}
				ops[nop+1]=cl;
				nop+=2;
				lastconc=cl;
			}
			h_check_msgs(hsolve,child,MMPUMP_OP,i,nop,nchip);
			ops[nop]=MMPUMP_OP;
			nop++;
			nchip+=2;
			break;

		case CACONCEN_T:
			h_check_msgs(hsolve,child,CACONC_OP,i,nop,nchip);
			ops[nop]=CACONC_OP;
			ops[nop+1]=cm;
			nop+=2;
			nchip+=3;
			break;

		default:
			break;
	    }
	}
    } /* i loop */
    if (lastconc>-1) {
	ops[nop]=LCONC_OP;
    } else {
	ops[nop]=LCACONC_OP;
    }
    if (nop+1!=hsolve->nconcops) {
	fprintf(stderr,"Error in %s: Bug #1 in h_init_conc_chip %d.\n",hsolve->name,nop);
    }
    if (nchip!=hsolve->nconcchips) {
	fprintf(stderr,"Error in %s: Bug #2 in h_init_conc_chip %d.\n",hsolve->name,nchip);
    }
    return(0);
}

