/* $Id: hines_conc_chip.c,v 1.2 1997/05/29 18:37:01 dhb Exp $
**
** This files is included in several other C files so the RCS Id is
** in a comment rather than compiled in as a static variable.
*/

/* Version EDS21e 97/05/05, Erik De Schutter, Caltech & BBF-UIA 8/92-5/97 */

/*
** $Log: hines_conc_chip.c,v $
** Revision 1.2  1997/05/29 18:37:01  dhb
** Moved RCS Id tag into a comment
**
** Revision 1.1  1997/05/28 23:11:50  dhb
** Initial revision
**
*/

/*  Contains the routine which updates the concchip array (Ca_concen,
**   flux and pumps). */

#include "hines_ext.h"

#ifdef CHANMODE4
do_h4_conc_chip_update(hsolve)
#else
do_h2_conc_chip_update(hsolve)
#endif
	Hsolve	*hsolve;
{
	register int	k,index;
	register double	c,result,X,itau;
	register double *chip=hsolve->concchip;
	register double *coresult=hsolve->coresult;
	register double *codiag=hsolve->codiag;
	register int    *op=hsolve->concops;
	register double	*conc=hsolve->conc,*concin;
	register double	*flux=hsolve->flux,*influx;
	register double dt=hsolve->dt;
#ifdef CHANMODE4
	register double *givals=hsolve->ovals;
#endif
	double	 *vm=hsolve->vm;

	while (1) {
	    switch (*op++) {
		case CONC_OP:
		    /* store results */
		    coresult[index]=result;
		    /* NO BREAK */

		case FCONC_OP:
		    index=*op++;
		    result=0.0;
		    break;

		case FLUXCONC_OP:
		    /* get and scale flux */
		    /* chip[n]==dt.leak, chip[n+1]==dt/zFV */
		    influx=flux+index;
		    result+=*chip +  *influx * *(chip+1);
#ifdef CHANMODE4
#else
		    *influx=0.0;
#endif
		    chip+=2;
		    break;

		case CTAUPUMP_OP:
		    /* taupump */
		    itau=*chip++;		/* chip[n]==dt/T_C */
		    result+=*chip++ * itau;	/* chip[n]==Ceq */
		    codiag[index]+=itau;
		    break;

		case TAUPUMP_OP:
		    /* taupump */
		    /* chip: T_C, T_A, T_V, 1/T_B */
#ifdef CHANMODE4
		    *givals++=itau=dt /(*chip + *(chip+1) *
				(exp((*(vm + *op++) - *(chip+2)) * *(chip+3))));
#else
		    itau=dt / (*chip + *(chip+1) * (exp((*(vm + *op++) 
				- *(chip+2)) * *(chip+3))));
#endif
		    chip+=4;
		    result+=*chip++ * itau;	/* chip[n]==Ceq */
		    codiag[index]+=itau;
		    break;

		case MMPUMP_OP:
		    /* Michaelis Menten pump: electrogenic ones are 
		    **  computed in do_chip_hh2_update */
		    /* chip[n]==dt.vmax.surf/vol, chip[n+1]==Kd */
		    codiag[index]+=*chip/(conc[index] + *(chip+1));
		    chip+=2;
		    break;

		case LCONC_OP:
		    /* store results and finish */
		    coresult[index]=result;
		    return;

		case CACONC_OP:
		    /* compute Ca_concen: use k instead of index so that we
		    **  can mix SHELLs and CACONCs freely */
		    concin=conc + *op;
		    influx=flux + *op++;
		    X=*chip++;      /* Ca_base */
		    itau=*chip++;      /* tau */
		    *concin=X+((*concin-X)*(2.0-itau)+(*influx * *chip++))/itau;
#ifdef CHANMODE4
#else
		    *influx=0.0;
#endif
		    break;

		case LCACONC_OP:
		    /* finish */
		    return;

		default:
		    Error();
		    printf("Error hsolve: undefined concchip operation: %d %d %d\n",*(op-2),*(op-1),*op);
		    return(ERR);
	    }
	}
}

