static char rcsid[] = "$Id: h_calc.c,v 1.4 1997/05/28 22:34:40 dhb Exp $";

/*  Version EDS21d 97/03/18, Erik De Schutter, Caltech & BBF-UIA 12/91-3/97 
** Upinder S. Bhalla Caltech May-December 1991 */

/*
** $Log: h_calc.c,v $
** Revision 1.4  1997/05/28 22:34:40  dhb
** Moved Antwerp version header up in file; removed redundant log message
**
** Revision 1.3  1997/05/28 22:32:50  dhb
** Replaced with Antwerp GENESIS 21e version
**
** Revision 1.2  1995/08/01  19:29:03  dhb
** Changes from Erik DeSchutter described below.
** Also fixed bug in initialization of useinject.
**
** Revision 1.4  1994/03/22 eds
** Included special code for INJECT/EREST msg in chanmode 0/1
**
** Revision 1.1  1992/12/11  19:03:08  dhb
** Initial revision
**
*/

#include "hines_ext.h"

/* This routine uses a large chunk of CPU time, calculating coeffs 
** This version disobeys all rules of object orientedness, taking
** over all the calculations that should be done by the compartments */

do_hcalc(hsolve)
	Hsolve	*hsolve;
{
	int	nvalues = hsolve->nvalues;
	int	ncompts = hsolve->ncompts;
	double *values;
	int		*cip,*ri,*diag,*elmnum,*parents;
	struct compartment_type	*compt,*link,**compts;
	struct tab_channel_type *h;
	Tcinfo **hh,*hentry;
	Cinfo  **chan,*centry;
	struct channelA_type *ch; /* basic channel */
	register int	i,j;
	double	*flux;
	int	k;
	int	comptindex,linkindex,chanmode;
	int	nextcip;
	double	*results;
	double	dt,sumgchan,ichan,diagterm,tbyc;
	float Rm,Ra,Em,inject;
	double Vm;
	MsgIn   *msgin;
	short   *msgcompts = hsolve->msgcompts;
	int     useinject;

	values = hsolve->values;
	results = hsolve->results;
	cip = hsolve->cip;
	ri = hsolve->ri;
	diag = hsolve->diag;
	elmnum = hsolve->elmnum;
	parents = hsolve->parents;
	compts = (struct compartment_type **)hsolve->compts;
	hh = hsolve->hh;
	chan = hsolve->chan;
	flux = hsolve->flux;
	chanmode = hsolve->chanmode;

	if (BaseObject(hsolve)->method == CRANK_INT)
	    dt = Clockrate(hsolve)/2.0;
	else /* BEULER by default */
	    dt = Clockrate(hsolve);
	
	for(i=0;i<ncompts;i++) {
	    comptindex=elmnum[i];
	    compt = compts[comptindex];
	    if (msgcompts[comptindex]) {
		/* copy part of the compartment MSGLOOP: yes it is another
		**  hack folks, and it is slow to boot! */
		inject = 0.0;
		useinject = 0;
		MSGLOOP(compt, msgin) {
		    case INJECT:
			inject += MSGVALUE(msgin,0);
			useinject++;
			break;
		    case EREST:
			compt->Em = MSGVALUE(msgin,0);
			break;
		    default:
			break;
		}
		if (useinject) compt->inject = inject;
	    }
	    Vm = compt->Vm; /* perhaps */
	    Em = compt->Em; /* perhaps */
	    Rm = compt->Rm; /* definitely */
	    Ra = compt->Ra; /* definitely */
	    tbyc=dt/compt->Cm;

	    ichan=sumgchan=0.0;
	    if (chanmode) {
	    /* CHANMODE 1 */
		/* Calculating contribution due to tabchannels */
		for (hentry=hh[i];hentry;hentry=hentry->next) {
		    h=(struct tab_channel_type *)(hentry->chan);
		    sumgchan+=h->Gk;
		    ichan+=h->Ek*h->Gk;
		}
	    }
	    /* Calculating contribution due to other channels */
	    for (centry=chan[i];centry;centry=centry->next) {
		ch=(struct channelA_type *)(centry->chan);
		sumgchan+=ch->Gk;
		ichan+=ch->Ek*ch->Gk;
	    }

	    results[i]=Vm+tbyc*(compt->inject+Em/Rm+ichan);
	    diagterm = tbyc*sumgchan;

	    nextcip=cip[i+1];
	    for (j=cip[i];j<nextcip;j++) {
		/* finding the column number */
		k=ri[j];
		/* Diagonal element */
		if (i==k) {
		    diagterm += 1.0 + tbyc/Rm;
		    } else {
			linkindex=elmnum[k];
			link=compts[linkindex];
			/* Child elements */
			if (parents[linkindex]==comptindex) {
			    diagterm -= (values[j]= -tbyc/link->Ra);
			/* parent element */
			} else if (parents[comptindex] == linkindex) {
			    diagterm -= (values[j]= -tbyc/Ra);
		    /* Siblings */
			} else {
			    printf("** Warning - Sibling coeffs only occur for symcompartments\n");
			}
		}
	    }
	    values[diag[i]]=diagterm;
	}
}

/* old stuff
do_chip_hcalc(hsolve)
	Hsolve	*hsolve;
{
	register double *values;
	int	 *cip,*ri,*diag,*elmnum,*parents;
    register Compinfo *comp,*comps;
	register int i,j,k;
	register int *comptindex;
	register double	dt,diagterm,tbyc;

	values = hsolve->values;
	cip = hsolve->cip;
	ri = hsolve->ri;
	diag = hsolve->diag;
	elmnum = hsolve->elmnum;
	comptindex = hsolve->elmnum;
	parents = hsolve->parents;
	comp=comps=hsolve->comps;

	if (BaseObject(hsolve)->method == CRANK_INT)
		dt = hsolve->dt/2.0;
	else 
		dt = hsolve->dt;
	
	for(i=0; i < hsolve->ncompts; i++) {
		tbyc=comp->tbiCm;
		diagterm = tbyc*comp->sumgchan;

		for(j=*cip;j<*cip++;j++){
			k=ri[j];
			if (i==k) {
				diagterm += comp->tbiRm;
			} else {
				if (parents[elmnum[k]]==*comptindex) {
					diagterm -= (values[j]= -tbyc*(comps[k]).iRa);
				} else {
					diagterm -= (values[j]= -tbyc*comp->iRa);
				}
			}
		}
		values[*diag++]=diagterm;
		comp++;
		comptindex++;
	}
}
*/
