//genesis
/**********************************************************************
** This program is part of kinetikit and is
**           copyright (C) 1995-1997 Upinder S. Bhalla.
** It is made available under the terms of the GNU General Public License. 
** See the file COPYRIGHT for the full notice.
**********************************************************************/

/******************************************************************
      Stuff for connecting reacs
******************************************************************/
// reacs are created directly on groups, which is handled by the
// xdrag functions.

// These two functions are for the special situations where we
// add/remove rate constant controls to reacs.
function pool_to_reac_kf(pool,reac)
	str pool,reac
	echo in pool_to_reac_kf with {reac}, {pool}
	if ({getmsg {reac} -find {pool} KF} == -1)
		addmsg {pool} {reac} KF Co
	else
		deletemsg {reac} 0 -find {pool} KF
	end
	call /edit/draw/tree RESET
end

function pool_to_reac_kb(pool,reac)
	str pool,reac
	echo in pool_to_reac_kb with {reac}, {pool}
	if ({getmsg {reac} -find {pool} KB} == -1)
		addmsg {pool} {reac} KB Co
	else
		deletemsg {reac} 0 -find {pool} KB
	end
	call /edit/draw/tree RESET
end

// called from the reac when a pool is dropped on it
// Attaches the pool to the reac as a substrate
function pool_to_reac_add(pool,reac)
	str pool,reac
// think about this. ADDMSGARROW should call this case
	if ({getfield /simcontrol/kf state} == 1)
		pool_to_reac_kf {pool} {reac}
		setfield /simcontrol/kf state 0
		return
	end
	if ({getfield /simcontrol/kb state} == 1)
		pool_to_reac_kb {pool} {reac}
		setfield /simcontrol/kb state 0
		return
	end
	echo in pool_to_reac_add with {reac}, {pool}
	addmsg {reac} {pool} REAC A B
	addmsg {pool} {reac} SUBSTRATE n
	call /edit/draw/tree RESET
end


function pool_to_reac_drop(pool,reac)
	str pool,reac
// Check if high_order reactions are allowed
	if ({getfield /simcontrol/high_order state} == 1)
		pool_to_reac_add {pool} {reac}
		setfield /simcontrol/high_order state 0
		return
	end
	if ({getfield /simcontrol/kf state} == 1)
		pool_to_reac_kf {pool} {reac}
		setfield /simcontrol/kf state 0
		return
	end
	if ({getfield /simcontrol/kb state} == 1)
		pool_to_reac_kb {pool} {reac}
		setfield /simcontrol/kb state 0
		return
	end
	echo in pool_to_reac_drop with {reac}, {pool}
	deletemsg {pool} 0 -find {reac} REAC
	deletemsg {reac} 0 -find {pool} SUBSTRATE
	call /edit/draw/tree RESET
end

// Attaches the reac to the pool as a substrate
function reac_to_pool_add(reac,pool)
	str reac,pool
// think about this. ADDMSGARROW should call this case
	echo in reac_to_pool_add with {reac}, {pool}
	addmsg {reac} {pool} REAC B A
	addmsg {pool} {reac} PRODUCT n
	call /edit/draw/tree RESET
end

function reac_to_pool_drop(reac,pool)
	str reac,pool
// Check if high_order reactions are allowed
	if ({getfield /simcontrol/high_order state} == 1)
		reac_to_pool_add {reac} {pool}
		setfield /simcontrol/high_order state 0
		return
	end
	echo in reac_to_pool_drop with {reac}, {pool}
	deletemsg {reac} 0 -find {pool} PRODUCT
	deletemsg {pool} 0 -find {reac} REAC
	call /edit/draw/tree RESET
end


/******************************************************************
      Stuff for editing reac
******************************************************************/


function do_update_reacinfo
	str reac = {getfield /parmedit/reac elmpath}

	setfield /parmedit/reac/path value {getpath {reac} -head}
	setfield /parmedit/reac/name value {getpath {reac} -tail}
    setfield /parmedit/reac/kf value {getfield {reac} kf}
    setfield /parmedit/reac/kb value {getfield {reac} kb}
	setfield /parmedit/reac/notes initialtext {getfield {reac} notes}
	setfield /parmedit/reac/color value {getfield {reac} xtree_fg_req}
end

function make_xedit_reac
	create xform /parmedit/reac [{EX},{EY},{EW},295]
	addfield /parmedit/reac elmpath \
		-description "path of elm being edited"
	ce /parmedit/reac
	create xdialog path -wgeom 60% -title "Parent" 
	create xdialog name -xgeom 60% -ygeom 0 -wgeom 40% -title "Name" \
		-script "set_item_name <w> <v>"
	create xdialog kf [0,0:name,50%,30] -script "set_field <w> <v>"
	create xdialog kb [50%,0:name,50%,30] -script "set_field <w> <v>"
	create xdialog color -script "set_item_color <w> <v>"
	create xbutton savenotes -label NOTES [0,0:last,10%,130] \
		-script "save_item_notes <w>" -offbg gray
	create xtext notes [0:last,0:color,90%,130] -editable 1
	create xbutton UPDATE [0%,0:notes,50%,30] \
		-script "do_update_reacinfo"
	create xbutton HIDE [50%,0:notes,50%,30] \
		-script "save_item_notes <w>; xhide /parmedit/reac"
	ce /
end

function edit_reac(reac)
	str reac

	setfield /parmedit/reac elmpath {reac}
	do_update_reacinfo
	xshowontop /parmedit/reac
end


/******************************************************************
      Stuff for graphing reacs
******************************************************************/

// might wish to graph all the substrates and prds here
function graph_reac(self,value,dest)
	str self,value,dest
	if ({strncmp {dest} "/graphs/" 8} == 0)
		do_warning 0 "Warning: Nothing to graph in reacs"
	end
end

/******************************************************************
      Stuff for initializing reacs
******************************************************************/
function kreacproto
	create reac /reac
	setfield /reac \
		kf 0.1	\
		kb 0.1
 	addfield /reac notes -description "string for reac, eg, refs"
 	addfield /reac editfunc -description "name of editfunc for reac"
 	addfield /reac xtree_fg_req -description "color for reac icon"
 	addfield /reac xtree_textfg_req -description "text color for reac icon"
 	addfield /reac plotfield -description "field of reac to plot"
 	addfield /reac manageclass -description "Class to manage reacs"
	addobject kreac /reac \
		-author "Upi Bhalla Mt Sinai" \
		-description "reac plus a field for a description string"
	setdefault kreac editfunc "edit_reac"
	setdefault kreac xtree_fg_req "white"
	setdefault kreac xtree_textfg_req "black"
	setdefault kreac plotfield "A"
	setdefault kreac manageclass "group"
end

function xreacproto
	ce /control/lib/tree
	create xshape shape -autoindex \
		-fg white \
		-drawmode DrawArrows \
		-coords "[-1,0.2,0][1,0.2,0][1,-0.2,0][-1,-0.2,0]" \
		-text "reac" \
		-textfont 6x10 \
		-textmode draw \
		-textcolor black \
		-linewidth 2 \
		-pixflags v \
		-pixflags c \
		-value "kreac" \
		-script "edit_lib.D"

	copy {el ^} /edit/draw/tree -autoindex
	setfield ^ \
		script \
		"edit_reac.D; reac_to_pool.w; pool_to_reac.p; graph_reac.w"

	ce /
end



function init_xreac
    // set up the prototype object and icon
	kreacproto

	if (DO_X)
	    xreacproto
	
		// Set up the calls used to handle dragging reacs to pools
		call /edit/draw/tree ADDMSGARROW "/kinetics/##[TYPE=kreac]" \
			"/kinetics/##[TYPE=kpool]" "REAC" "kpool" "none" -1 0 \
			"echo.p dragging <S> to <D> for product" \
			"reac_to_pool_add.p <S> <D>" \
			"reac_to_pool_drop.p <S> <D>"
		call /edit/draw/tree ADDMSGARROW "/kinetics/##[TYPE=kpool]" \
			"/kinetics/##[TYPE=kreac]" "SUBSTRATE" "kreac" "green" \
			-1 0 \
			"echo.p dragging <S> to <D> for substrate" \
			"pool_to_reac_add.p <S> <D>" \
			"pool_to_reac_drop.p <S> <D>"
		call /edit/draw/tree ADDMSGARROW "/kinetics/##[TYPE=kpool]" \
			"/kinetics/##[TYPE=kreac]" "KF" "kreac" "purple" \
			-1 0 \
			"" "" ""
		call /edit/draw/tree ADDMSGARROW "/kinetics/##[TYPE=kpool]" \
			"/kinetics/##[TYPE=kreac]" "KB" "kreac" "hotpink" \
			-1 0 \
			"" "" ""
		/* This draws the other arrow, but flipped */
		call /edit/draw/tree ADDMSGARROW "/kinetics/##[TYPE=kpool]" \
			"/kinetics/##[TYPE=kreac]" "PRODUCT" "kreac" "green" -1 1 \
			"" "" ""
	
	    // make the editor for reacs
	    make_xedit_reac
	end
end

/******************************************************************/
