#  multimedia.rb - 
#  Copyright (C) 2004-2006 Frdric Logier

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


require 'singleton'
require 'gst'

module Geekast
  module Multimedia

    def self.main
      Stream.instance
    end

    #######
    private
    #######

    class Stream
      include Singleton

      def initialize
        @geekastConfig = Geekast::Model::Preferences.instance

        puts "Multimedia singleton launched" if $DEBUG


        Gst.init
        # Initialize playbin element
        @playbin = Gst::ElementFactory.make("playbin")
        puts "gstreamer init" if $DEBUG
      end 


      def create(url)
        stop
        stream(url)
      end

      def stop
        @playbin.stop
      end


      #######
      private
      #######


      def stream(url)

        # get audio output
        @audiosink = Gst::ElementFactory.make(@geekastConfig.audiosink)
        #get video output
        @videosink = Gst::ElementFactory.make(@geekastConfig.videosink)
        # get visual effect
        @visualsink = Gst::ElementFactory.make(@geekastConfig.visualsink)

        @playbin.uri = url
        @playbin.audio_sink = @audiosink
        if @geekastConfig.effect 
          @playbin.vis_plugin = @visualsink
        end
        @playbin.video_sink = @videosink

        # get drawingarea_video widget
        window = $Gvideo

        # hang the videosink with widget
        window.signal_connect('expose-event') { @videosink.xwindow_id = window.window.xid  } 


        puts "playing : " + url if $DEBUG
        # play the stream
        @playbin.play
        SIGNAL.emit("VrefreshVIDEO", 0)
      end
      
    end
  end
end
