#  config.rb - 
#  Copyright (C) 2004-2006 Frédéric Logier

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

require "glib2"

module Geekast
  module Config

    Thread.abort_on_exception = true

    # notebook page
    INFORMATION = 0
    RELAY = 1
    CONNECTION = 2
    YP = 3
    VIDEO = 4
    WEB = 5
    BOOKMARK = 6
    CHANINFO = 7


    # Geekast/Peercast configuration
    @geekastConfig = Geekast::Model::Preferences.instance


    PEERCAST_IP = @geekastConfig.ip
    PEERCAST_PORT = @geekastConfig.port.to_i.to_s


    YELLOWPAGES_IP = @geekastConfig.yellowpages
    YELLOWPAGES_PORT = '80'
    YELLOWPAGES_URL = '/?xml'

    #######  a test file ############
=begin
    YELLOWPAGES_IP = 'geekoland.org'
    YELLOWPAGES_PORT = '80'
    YELLOWPAGES_URL = '/fichiers/yp.xml'       
=end


    AUDIO_TYPE = Regexp.new("OGG|MP3|WMA", Regexp::EXTENDED)
    VIDEO_TYPE = Regexp.new("OGM|NSV|WMV", Regexp::EXTENDED)


    PEERCAST_STATS = '/admin?cmd=viewxml'
    PEERCAST_INFORMATION = '/html/geekast/information_xml.html'
    PEERCAST_RELAY = '/html/geekast/chaninfo_xml.html?id='
    PEERCAST_CONNECTIONS = '/html/geekast/connections_xml.html'

    # old #
    # PEERCAST_INFO_INTERNAL = '/html/geekast/info_internal_xml.html'
    # PEERCAST_INFO_BANDWIDTH = '/html/geekast/info_bandwidth_xml.html'
    # PEERCAST_INFO_CONNECTIONS = '/html/geekast/info_connections_xml.html'
    # PEERCAST_INFO_INFORMATION = '/html/geekast/info_information_xml.html'

    HOME_USER = ENV["HOME"]
    DATA_DIR = '/usr/local/share/geekast'
    # DATA_DIR = HOME_USER + '/dev/gnome/geekast/data/'


    end
end
