#line 28 "../noweb/g_funcs.nw"
/* gEDA - GPL Electronic Design Automation
 * gschem - gEDA Schematic Capture
 * Copyright (C) 1998-2000 Ales V. Hvezda
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA
 */


#line 11 "../noweb/g_funcs.nw"
/* DO NOT read or edit this file ! Use ../noweb/g_funcs.nw instead */

#line 51 "../noweb/g_funcs.nw"
#include <config.h>

#include <stdio.h>
#include <sys/stat.h>
#include <ctype.h>
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <libgeda/libgeda.h>

#include "../include/globals.h"
#include "../include/prototype.h"

#ifdef HAVE_LIBDMALLOC
#include <dmalloc.h>
#endif

#line 84 "../noweb/g_funcs.nw"
SCM g_funcs_print(SCM filename)
{
  SCM_ASSERT(SCM_NIMP(filename) && SCM_STRINGP(filename), filename,
	     SCM_ARG1, "gschem-print");

  if (output_filename) {
    f_print(global_window_current, output_filename);
  } else {
    f_print(global_window_current, SCM_STRING_CHARS(filename));
  }

  return SCM_BOOL_T;
}


#line 108 "../noweb/g_funcs.nw"
SCM g_funcs_image(SCM filename)
{
  SCM_ASSERT(SCM_NIMP(filename) && SCM_STRINGP(filename), filename,
	     SCM_ARG1, "gschem-image");

  if (output_filename) {
    x_image_lowlevel(global_window_current, output_filename);
  } else {
    x_image_lowlevel(global_window_current, SCM_STRING_CHARS(filename));
  }

  return SCM_BOOL_T;
}


#line 132 "../noweb/g_funcs.nw"
SCM g_funcs_exit(void)
{
  exit(0);
}


#line 147 "../noweb/g_funcs.nw"
SCM g_funcs_use_rc_values(void)
{
  i_vars_set(global_window_current);
  return SCM_BOOL_T;
}


#line 163 "../noweb/g_funcs.nw"
static gchar *key_value_string = NULL;

/* there is no string size checking here... so if it core dumps... DOH! */
/* TODO: fix this ^^^^^^^^^^^^^ */
/* it's actually pretty usable right now, but needs to be reviewed again */
SCM g_funcs_key_name(SCM keystring)
{
  SCM_ASSERT(SCM_STRINGP(keystring), keystring, 1, "gschem-key-name");

  if (key_value_string != NULL) {
    x_dialog_hotkeys_fill(key_value_string);
    g_free(key_value_string);
    key_value_string = NULL;
  }

  /* the 25 is for a few spaces and the characters */
  key_value_string = g_strdup_printf("%s :%25c",
				     SCM_STRING_CHARS(keystring), ' ');

  return SCM_BOOL_T;
}


#line 195 "../noweb/g_funcs.nw"
SCM g_funcs_key_value(SCM keystring)
{
  gchar *temp;

  SCM_ASSERT(SCM_STRINGP(keystring), keystring, 1, "gschem-key-value");

  if (key_value_string == NULL) {
    fprintf(stderr,
	    _("Ack! something got fouled up with the keymappings!\n"));
    exit(-1);
  }

  temp = g_strdup_printf("%s %s",
			 key_value_string, SCM_STRING_CHARS(keystring));
  g_free(key_value_string);
  key_value_string = temp;

  return SCM_BOOL_T;
}


#line 225 "../noweb/g_funcs.nw"
SCM g_funcs_key_done(void)
{
  x_dialog_hotkeys_fill(key_value_string);
  g_free(key_value_string);
  key_value_string = NULL;
  return SCM_BOOL_T;
}


#line 244 "../noweb/g_funcs.nw"
/* all of the declaration part is copied from some other c-code of
 * gEDA gschem. 
 * I don't really know, whether this all are necessary or not, but 
 * it works :-). */

static void
hash_table_2_list(gpointer key, gpointer value, gpointer user_data)
{
  SCM *plist = (SCM *) user_data;
  *plist = scm_cons(scm_makfrom0str((char *) value), *plist);
}

SCM get_selected_component_attributes(TOPLEVEL * toplevel)
{
  SCM list = SCM_EOL;
  OBJECT *obj;
  GHashTable *ht;

  /* build a hash table */
  ht = g_hash_table_new(g_str_hash, g_str_equal);
  for (obj = toplevel->page_current->object_head; obj != NULL;
       obj = obj->next) {
    if (obj->selected &&
	obj->type == OBJ_TEXT && obj->text->string != NULL) {
      /* add text string in the hash table */
      g_hash_table_insert(ht, obj->text->string, obj->text->string);
    }
  }
  /* now create a scheme list of the entries in the hash table */
  g_hash_table_foreach(ht, hash_table_2_list, &list);
  /* and get ride of the hast table */
  g_hash_table_destroy(ht);

  return list;
}



#line 298 "../noweb/g_funcs.nw"
SCM get_selected_filename(TOPLEVEL * w_current)
{
  SCM return_value;

  exit_if_null(w_current);

  return_value = scm_take0str(w_current->page_current->page_filename);

  return (return_value);
}
