/* gEDA - GPL Electronic Design Automation
 * gschem - gEDA Schematic Capture
 * Copyright (C) 1998-2000 Ales V. Hvezda
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA
 */


/* DO NOT read or edit this file ! Use ../noweb/o_basic.nw instead */

#include <config.h>
#include <stdio.h>

/* instrumentation code */
#if 0
#include <sys/time.h>
#include <unistd.h>
#endif

#include <libgeda/libgeda.h>

#include "../include/x_states.h"
#include "../include/prototype.h"


/* TODO: Lots of Gross code... needs lots of cleanup - mainly
 * readability issues */

/* Kazu on July 16, 1999 - Added these macros to simplify the code */
#define GET_BOX_WIDTH(w)                        \
        abs((w)->last_x - (w)->start_x)
#define GET_BOX_HEIGHT(w)                       \
        abs((w)->last_y - (w)->start_y)

void o_redraw_all(TOPLEVEL * w_current)
{
#if 0
  struct timeval tv1;
  struct timeval tv2;
#endif


  if (!w_current->DONT_REDRAW) {
    x_repaint_background(w_current);
  }
#if 0
  gettimeofday(&tv1, NULL);
#endif

  o_recalc(w_current, w_current->page_current->object_head);

  if (!w_current->DONT_REDRAW) {
    o_redraw(w_current, w_current->page_current->object_head);
    o_cue_redraw_all(w_current, w_current->page_current->object_head);
  }
#if 0
  gettimeofday(&tv2, NULL);
  printf("secs: %d\n", tv2.tv_sec - tv1.tv_sec);
  printf("usecs: %d\n\n", tv2.tv_usec - tv1.tv_usec);
#endif

  if (w_current->inside_action) {
    switch (w_current->event_state) {
    case (ENDMOVE):
    case (ENDCOPY):
      o_drawbounding(w_current, NULL,
		     w_current->page_current->selection2_head->next,
		     x_get_color(w_current->bb_color), FALSE);
      break;

    case (DRAWCOMP):
    case (ENDCOMP):
      o_drawbounding(w_current,
		     w_current->page_current->complex_place_head->next,
		     NULL, x_get_color(w_current->bb_color), FALSE);
      break;

    case (DRAWATTRIB):
    case (ENDATTRIB):
    case (DRAWTEXT):
    case (ENDTEXT):
      o_drawbounding(w_current,
		     w_current->page_current->attrib_place_head->next,
		     NULL, x_get_color(w_current->bb_color), FALSE);
      break;
    }
  }
}


/* basically like above but doesn't do the o_conn_disconnect_update */
void o_redraw_all_fast(TOPLEVEL * w_current)
{
  if (!w_current->DONT_REDRAW) {
    x_repaint_background(w_current);
  }

  o_recalc(w_current, w_current->page_current->object_head);

  if (!w_current->DONT_REDRAW) {
    o_redraw(w_current, w_current->page_current->object_head);
    o_cue_redraw_all(w_current, w_current->page_current->object_head);
  }
}


void o_redraw(TOPLEVEL * w_current, OBJECT * object_list)
{
  OBJECT *o_current = object_list;

  while (o_current != NULL) {
    if ((o_current->draw_func != NULL) && (o_current->type != OBJ_HEAD)) {
      w_current->inside_redraw = 1;
      (*o_current->draw_func) (w_current, o_current);
      w_current->inside_redraw = 0;
    }

    o_current = o_current->next;
  }
}


void o_unselect_all(TOPLEVEL * w_current)
{
  if (!w_current->SHIFTKEY) {
    o_selection_remove_most(w_current,
			    w_current->page_current->selection2_head);
  }
}


void o_erase_selected(TOPLEVEL * w_current)
{
  if (w_current->inside_redraw) {
    return;
  }
}


void o_erase_single(TOPLEVEL * w_current, OBJECT * object)
{
  OBJECT *o_current;

  if (w_current->inside_redraw) {
    return;
  }

  o_current = object;

  w_current->DONT_DRAW_CONN = 1;
  w_current->override_color = w_current->background_color;
  if (o_current != NULL) {
    if (o_current->draw_func && o_current->type != OBJ_HEAD) {
      (*o_current->draw_func) (w_current, o_current);
    }
  }
  w_current->override_color = -1;
  w_current->DONT_DRAW_CONN = 0;
}


/* both outline and boundingbox work! */
/* name is blah */
void
o_drawbounding(TOPLEVEL * w_current, OBJECT * o_list, SELECTION * s_list,
	       GdkColor * color, int firsttime)
{
  int diff_x, diff_y;
  int test_x, test_y;

  /* static is highly temp */
  /* you have to make these static... for the once mode */
  static int rleft, rtop, rbottom, rright;

  if (!o_list && !s_list) {
    return;
  }

  if ((w_current->last_drawb_mode == OUTLINE) &&
      (w_current->actionfeedback_mode == BOUNDINGBOX)) {
#if DEBUG
    printf("going to bounding\n");
#endif

    diff_x = w_current->last_x - w_current->start_x;
    diff_y = w_current->last_y - w_current->start_y;

    gdk_gc_set_foreground(w_current->bounding_xor_gc,
			  x_get_color(w_current->background_color));
    if (o_list) {
      o_complex_translate_display(w_current, diff_x, diff_y, o_list);
    } else if (s_list) {
      o_complex_translate_display_selection(w_current,
					    diff_x, diff_y, s_list);
    }

    gdk_gc_set_foreground(w_current->bounding_xor_gc, color);

    if (o_list) {
      get_complex_bounds(w_current, o_list,
			 &rleft, &rtop, &rright, &rbottom);
    } else if (s_list) {
      get_complex_bounds_selection(w_current, s_list,
				   &rleft, &rtop, &rright, &rbottom);
    }

    gdk_draw_rectangle(w_current->window,
		       w_current->bounding_xor_gc, FALSE,
		       rleft + diff_x,
		       rtop + diff_y, rright - rleft, rbottom - rtop);

  }

  if ((w_current->last_drawb_mode == BOUNDINGBOX) &&
      (w_current->actionfeedback_mode == OUTLINE)) {
#if DEBUG
    printf("going to outline\n");
#endif

    if (o_list) {
      get_complex_bounds(w_current, o_list,
			 &rleft, &rtop, &rright, &rbottom);
    } else if (s_list) {
      get_complex_bounds_selection(w_current, s_list,
				   &rleft, &rtop, &rright, &rbottom);
    }

    diff_x = w_current->last_x - w_current->start_x;
    diff_y = w_current->last_y - w_current->start_y;
    gdk_gc_set_foreground(w_current->gc,
			  x_get_color(w_current->background_color));
    gdk_draw_rectangle(w_current->window,
		       w_current->gc, FALSE,
		       rleft + diff_x,
		       rtop + diff_y, rright - rleft, rbottom - rtop);

    if (o_list) {
      o_complex_translate_display(w_current, diff_x, diff_y, o_list);
    } else if (s_list) {
      o_complex_translate_display_selection(w_current,
					    diff_x, diff_y, s_list);
    }
  }

  w_current->last_drawb_mode = w_current->actionfeedback_mode;

  /* everything above is okay */

  /* TODO: much replicated code... this is the behaviour we need, but
   * we need to clean it up !!! */

  /* erase old outline */
  /* going to constrained from free */
  if ((w_current->CONTROLKEY) &&
      (w_current->drawbounding_action_mode == FREE)) {
    diff_x = w_current->last_x - w_current->start_x;
    diff_y = w_current->last_y - w_current->start_y;
#if 0
    printf("switching to contrained\n");
#endif
    w_current->drawbounding_action_mode = CONSTRAINED;

    if (w_current->actionfeedback_mode == OUTLINE) {
      if (o_list) {
	o_complex_translate_display(w_current, diff_x, diff_y, o_list);
      } else if (s_list) {
	o_complex_translate_display_selection(w_current,
					      diff_x, diff_y, s_list);
      }
    } else {
      if (o_list) {
	get_complex_bounds(w_current, o_list,
			   &rleft, &rtop, &rright, &rbottom);
      } else if (s_list) {
	get_complex_bounds_selection(w_current, s_list,
				     &rleft, &rtop, &rright, &rbottom);
      }

      gdk_gc_set_foreground(w_current->bounding_xor_gc, color);
      gdk_draw_rectangle(w_current->window,
			 w_current->bounding_xor_gc, FALSE,
			 rleft + diff_x,
			 rtop + diff_y, rright - rleft, rbottom - rtop);
    }

    test_x = GET_BOX_WIDTH(w_current);
    test_y = GET_BOX_HEIGHT(w_current);
    if (test_x >= test_y) {
      w_current->last_y = w_current->start_y;
    } else {
      w_current->last_x = w_current->start_x;
    }

    diff_x = w_current->last_x - w_current->start_x;
    diff_y = w_current->last_y - w_current->start_y;

    if (w_current->actionfeedback_mode == OUTLINE) {
      if (o_list) {
	o_complex_translate_display(w_current, diff_x, diff_y, o_list);
      } else if (s_list) {
	o_complex_translate_display_selection(w_current,
					      diff_x, diff_y, s_list);
      }
    } else {
      if (o_list) {
	get_complex_bounds(w_current, o_list,
			   &rleft, &rtop, &rright, &rbottom);
      } else if (s_list) {
	get_complex_bounds_selection(w_current, s_list,
				     &rleft, &rtop, &rright, &rbottom);
      }
      gdk_gc_set_foreground(w_current->bounding_xor_gc, color);
      gdk_draw_rectangle(w_current->window,
			 w_current->bounding_xor_gc,
			 FALSE,
			 rleft + diff_x,
			 rtop + diff_y, rright - rleft, rbottom - rtop);
    }

    if (w_current->netconn_rubberband) {
      o_move_stretch_rubberband(w_current);
      o_move_stretch_rubberband(w_current);
    }
  }

  /* erase old outline */
  /* going to free from constrained */
  if ((!w_current->CONTROLKEY) &&
      (w_current->drawbounding_action_mode == CONSTRAINED)) {
#if 0
    printf("switching to free\n");
#endif
    diff_x = w_current->last_x - w_current->start_x;
    diff_y = w_current->last_y - w_current->start_y;
    w_current->drawbounding_action_mode = FREE;
    if (w_current->actionfeedback_mode == OUTLINE) {
      /* do it twice to get rid of old outline */
      if (o_list) {
	o_complex_translate_display(w_current, diff_x, diff_y, o_list);
	o_complex_translate_display(w_current, diff_x, diff_y, o_list);
      } else if (s_list) {
	o_complex_translate_display_selection(w_current,
					      diff_x, diff_y, s_list);
	o_complex_translate_display_selection(w_current,
					      diff_x, diff_y, s_list);
      }
    } else {
      /* TODO: why are we doing this here...?
       * probably a reason */
      if (o_list) {
	get_complex_bounds(w_current, o_list,
			   &rleft, &rtop, &rright, &rbottom);
      } else if (s_list) {
	get_complex_bounds_selection(w_current, s_list,
				     &rleft, &rtop, &rright, &rbottom);
      }
    }
    if (w_current->netconn_rubberband) {
      o_move_stretch_rubberband(w_current);
      o_move_stretch_rubberband(w_current);
    }
  }

  if (w_current->CONTROLKEY) {
    test_x = GET_BOX_WIDTH(w_current);
    test_y = GET_BOX_HEIGHT(w_current);
    if (test_x >= test_y) {
      w_current->last_y = w_current->start_y;
    } else {
      w_current->last_x = w_current->start_x;
    }
  }

  if (w_current->actionfeedback_mode == BOUNDINGBOX) {

    if (firsttime == TRUE) {
      if (o_list) {
	get_complex_bounds(w_current, o_list,
			   &rleft, &rtop, &rright, &rbottom);
      } else if (s_list) {
	get_complex_bounds_selection(w_current, s_list,
				     &rleft, &rtop, &rright, &rbottom);
      }
      /*printf("once\n"); */

    }
    diff_x = w_current->last_x - w_current->start_x;
    diff_y = w_current->last_y - w_current->start_y;
    gdk_gc_set_foreground(w_current->bounding_xor_gc, color);
    gdk_draw_rectangle(w_current->window,
		       w_current->bounding_xor_gc, FALSE,
		       rleft + diff_x,
		       rtop + diff_y, rright - rleft, rbottom - rtop);

    return;
  }

  diff_x = w_current->last_x - w_current->start_x;
  diff_y = w_current->last_y - w_current->start_y;

  /* TODO: have I mentioned how temp this is? Make this general
   * so that all lists can be moved ... */
  if (o_list) {
    o_complex_translate2(w_current, diff_x, diff_y, o_list);
  } else if (s_list) {
    o_complex_translate_selection(w_current, diff_x, diff_y, s_list);
  }
}


void
o_erasebounding(TOPLEVEL * w_current, OBJECT * o_list, SELECTION * s_list)
{
  int diff_x, diff_y;
  int rleft, rtop, rright, rbottom;

  if (o_list == NULL) {
    /* this is an error condition */
    w_current->event_state = SELECT;
    w_current->inside_action = 0;
    return;
  }

  if (w_current->actionfeedback_mode == OUTLINE) {
    return;
  }

  if (o_list) {
    get_complex_bounds(w_current, o_list,
		       &rleft, &rtop, &rright, &rbottom);
  } else if (s_list) {
    get_complex_bounds_selection(w_current, s_list,
				 &rleft, &rtop, &rright, &rbottom);
  }

  diff_x = w_current->last_x - w_current->start_x;
  diff_y = w_current->last_y - w_current->start_y;

  gdk_gc_set_foreground(w_current->gc,
			x_get_color(w_current->background_color));
  gdk_draw_rectangle(w_current->window, w_current->gc, FALSE,
		     rleft + diff_x,
		     rtop + diff_y, rright - rleft, rbottom - rtop);
}
