/* gdkxft - Provide Xft font support in gdk
 * Copyright (C) 2001 Josh Parsons
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gnome.h>
#include <glade/glade.h>
#include "gdkxftcfg.h"

void
changed(void)
{
}

int
main (int argc, char **argv)
{
	GtkWidget *window;
	GladeXML *gxml;

	gnome_init ("gdkxft-capplet", VERSION, argc, argv);
	glade_gnome_init();

	/* set up the glade interface */
	gxml = glade_xml_new("gdkxft-capplet.glade",NULL);
	g_assert(gxml!=NULL);
	glade_xml_signal_autoconnect(gxml);
	window=glade_xml_get_widget(gxml,"window1");
	g_assert(window!=NULL);

	/* look for the clists */
	good_font_clist=GTK_CLIST(glade_xml_get_widget(gxml,
						       "good_font_clist"));
	bad_font_clist= GTK_CLIST(glade_xml_get_widget(gxml,
						       "bad_font_clist"));
	bad_app_clist=  GTK_CLIST(glade_xml_get_widget(gxml,
						       "bad_app_clist"));
	g_assert(good_font_clist!=NULL);
	g_assert(bad_font_clist!=NULL);
	g_assert(bad_app_clist!=NULL);

	/* revert to start us off */
	read_cfg();

	/* hook up to control center and go... */
	gtk_widget_show_all(GTK_WIDGET(window));
	gtk_main();

	return 0;
}
