/*
Copyright (C) 2000 by Sean David Fleming

sean@power.curtin.edu.au

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

The GNU GPL can also be found at http://www.gnu.org
*/

#include "config.h"
#include <math.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>

#include "gdis.h"

#define DEBUG 0
#define DEBUG2 0

/* global pak structures */
extern struct sysenv_pak sysenv;
extern struct elem_pak elements[];

/* animation globals */
gint anim_loop=0;

/* TODO - a stop button for animations (difficult?), plus a way of */
/* specifying that pbc confinement should/should not be performed */
/* on each frame. */

/****************/
/* do animation */
/****************/
void anim_hook(gint id)
{
animate(sysenv.dialog[id].model, -1);
}

/*******************************/
/* process anim dialog changes */
/*******************************/
gint anim_event(GtkWidget *w, gpointer *spin)
{
gint id;
gfloat r;
struct model_pak *data;

/* checks & setup */
g_return_val_if_fail(w != NULL, FALSE);
r = SPIN_FVAL(GTK_SPIN_BUTTON(spin));
data = (struct model_pak *) gtk_object_get_data(GTK_OBJECT(spin), "ptr");
g_return_val_if_fail(data != NULL, FALSE);
id = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(spin), "id"));

/* mode dependent spinner update */
switch(id)
  {
  case ANIM_FRAME:
    animate(data->number, (gint) r);
    break;
  case DELAY:
    data->delay = (gint) r;
    break;
  }
return(FALSE);
}

/***********************/
/* configure animation */
/***********************/
void animate_setup_widget()
{
gint id;
gchar *tmp;
GtkWidget *frame, *vbox, *hbox, *button, *label, *spin;
GtkAdjustment *adj;
struct dialog_pak *anim_dialog;
struct model_pak *data;

/* checks */
if (!sysenv.num_models) 
  return;
data = model_ptr(sysenv.active, RECALL);
if (!data)
  return;

/* dialog setup */
if ((id = request_dialog(sysenv.active, ANIM)) < 0)
  return;
anim_dialog = &sysenv.dialog[id];
anim_dialog->model = data->number;

anim_dialog->win = gtk_dialog_new();
gtk_window_set_title(GTK_WINDOW(anim_dialog->win), "Animate");
gtk_signal_connect(GTK_OBJECT(anim_dialog->win), "destroy",
                   GTK_SIGNAL_FUNC(event_close_dialog), (gpointer) id);

/* Frame 1 - general animation stuff */
frame = gtk_frame_new ("Properties");
gtk_box_pack_start(GTK_BOX(GTK_DIALOG(anim_dialog->win)->vbox),frame,TRUE,TRUE,0);
/* create a vbox in the frame */
vbox = gtk_vbox_new (FALSE, 0);
gtk_container_add(GTK_CONTAINER(frame), vbox);

hbox = gtk_hbox_new(FALSE, 0);
gtk_container_set_border_width(GTK_CONTAINER (hbox), 10);
gtk_box_pack_start(GTK_BOX (vbox), hbox, TRUE, TRUE, 0);

/* TODO - align the adjustment widgets */

/* delay - label */
label = gtk_label_new ("Frame delay (ms) ");
/* align left */
gtk_misc_set_alignment(GTK_MISC(label), 0, 0);
gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);

/* delay - adjustment */
adj = (GtkAdjustment *) gtk_adjustment_new (data->delay, 0, 500, 10, 20, 0);
spin = gtk_spin_button_new(adj, 0, 0);
gtk_spin_button_set_wrap(GTK_SPIN_BUTTON(spin), FALSE);
gtk_spin_button_set_shadow_type(GTK_SPIN_BUTTON(spin), GTK_SHADOW_OUT);
gtk_box_pack_end(GTK_BOX(hbox), spin, FALSE, TRUE, 0);
/* modification event */
gtk_signal_connect(GTK_OBJECT(adj), "value_changed",
                   GTK_SIGNAL_FUNC(anim_event), (gpointer) spin);
gtk_object_set_data(GTK_OBJECT(spin), "id", (gpointer) DELAY);
gtk_object_set_data(GTK_OBJECT(spin), "ptr", (gpointer) data);

/* TODO - if file read counted DATE or BIOSYM lines we would */
/*        know how many frames there were */

hbox = gtk_hbox_new (FALSE, 0);
gtk_container_set_border_width (GTK_CONTAINER (hbox), 10);
gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);

/* frame - label */
label = gtk_label_new ("Display frame ");
/* align left */
gtk_misc_set_alignment (GTK_MISC (label), 0, 0);
gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
/* frame - adjustment */
adj = (GtkAdjustment *) gtk_adjustment_new (0, 0, data->num_frames-1, 1, 1, 0);
spin = gtk_spin_button_new (adj, 0, 0);
gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spin), TRUE);
gtk_spin_button_set_shadow_type (GTK_SPIN_BUTTON (spin), GTK_SHADOW_OUT);
gtk_box_pack_end(GTK_BOX (hbox), spin, FALSE, TRUE, 0);
/* modification event */
gtk_signal_connect(GTK_OBJECT(adj), "value_changed",
                   GTK_SIGNAL_FUNC(anim_event), (gpointer) spin);
gtk_object_set_data(GTK_OBJECT(spin), "id", (gpointer) ANIM_FRAME);
gtk_object_set_data(GTK_OBJECT(spin), "ptr", (gpointer) data);

/* num frames */
hbox = gtk_hbox_new (FALSE, 0);
gtk_container_set_border_width (GTK_CONTAINER (hbox), 10);
gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
tmp = g_strdup_printf("Number of frames: %d",data->num_frames);
label = gtk_label_new(tmp);
gtk_misc_set_alignment (GTK_MISC (label), 0, 0);
gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

/* Last - terminating buttons */
button = gtk_button_new_with_label (" Run ");
gtk_box_pack_start(GTK_BOX(GTK_DIALOG(anim_dialog->win)->action_area),
                                      button, FALSE, TRUE, 0);
gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
                          GTK_SIGNAL_FUNC(anim_hook),
                          (gpointer) id);

button = gtk_button_new_with_label ("Close");
gtk_box_pack_start(GTK_BOX(GTK_DIALOG(anim_dialog->win)->action_area),
                                      button, FALSE, TRUE, 0);
gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
                          GTK_SIGNAL_FUNC(close_dialog),
                          (gpointer) id);

/* display the dialog */
gtk_widget_show_all(anim_dialog->win);
}

/********************************************************/
/* General routine for getting the next available frame */
/********************************************************/
gint get_frame(struct model_pak *data, gint first)
{
gint flag;
struct parse_pak parse_data;

/* first frame exception */
if (first)
  {
  switch(data->id)
    {
    case BIOSYM:
      data->afp = fopen(data->filename,"r");
      break;
    case GULP:
      data->afp = fopen(data->gulp.trj_file,"r");
      break;
    default:
      printf("get_frame() error: bad model type.\n");
      return(1);
    }
  }
/* open file stream? */
if (!data->afp)
  {
  printf("get_frame() error: no active file stream!\n");
  return(1);
  }
/* load coords into the models data space */
flag=0;
/* FIXME - if an error is returned, should keep the old data */
/* ie don't overwrite data unless load was successful */
/* probably better if implemented in the load routines */
switch(data->id)
  {
  case BIOSYM:
    parse_ptr(&parse_data, data->id);
    parse_data.hdr_skip = !first;
    flag = load_data(data->afp, &parse_data, data);
    if (!flag)
      {
      make_xlat(data);
/* post-load cartesian -> fractional */
      if (data->periodic && !data->fractional)
        latmat_fudge(data);
      }
    break;
  case GULP:
/* cartesian -> fractional conversion taken care of in the load routine */
    flag = load_gulp_trj(data->afp, data, first);
    if (!flag)
      make_xlat(data);
    break;
  }

/* refresh */
init_objs(REDO_COORDS, data);  /* necessary? */
calc_bonds(data);
calc_mols(data);

/* close file if failed to get another frame */
if (flag)
  {
  fclose(data->afp);
  data->afp = NULL;
  return(2);
  }
/* done */
return(0);
}

/**********************************/
/* open and configure a data file */
/**********************************/
/* mode = -1 (all frames), else goto that frame */
#define DEBUG_ANIMATE 0
void animate(gint model, gint frame)
{
gint n, ret;
struct model_pak *data;

data = model_ptr(model, RECALL);
g_return_if_fail(data != NULL);

#if DEBUG_ANIMATE
printf("animate() request frame: %d\n",frame);
#endif

/* open file for reading in frames */
show_text("Animating current model...");    
ret = get_frame(data, TRUE);

/* animation loop */
n=ret=0;
while(!ret)
  {
#if DEBUG_ANIMATE
printf("n = %d, frame = %d\n",n,frame);
#endif
/* show all frames */
  if (frame < 0 || n == frame)
    {
#if DEBUG_ANIMATE
printf("Displaying...\n");
#endif
    if (data->periodic)
      {
/* refresh the cell (in case it changed) */
      data->cell_on = TRUE;
/* TODO - PBC applied only if desired */
      pbc_constrain_mols(data);
      init_objs(REDO_COORDS, data);
      calc_bonds(data);
      calc_mols(data);
      }
/* misc updates */
    update_geom_info();
/* redraw */
    redraw_canvas(SINGLE);
/* NEW - my delay routine */
/* data->delay is in milli-sec, but the routine wants micro-sec */
    delay(data->delay * 1000);
    }
/* terminate if reached the one we wanted */
  if (n == frame)
     break;
  ret = get_frame(data, FALSE);
#if DEBUG_ANIMATE
printf("ret = %d\n",ret);
#endif
/* inc counter */
  n++; 
  }

show_text("Animate completed.");
}

