from Vault import Vault
from main.Control import Control
from plugin.Interface import Interface


#
# Wrapper for controls.
#
class ControlWrapper(object):

    def __init__(self, control):
        
        self.__dict__["_ControlWrapper__control"] = Vault(control)
        self.__dict__["_ControlWrapper__properties"] = Vault(control.get_properties())

        ids =  [ i.get_id()
                 for i in Interface.get_interfaces( control.__class__ ) ]
        
        self.__dict__["_ControlWrapper__ifaces_id"] = Vault( tuple(ids) )



    def __setattr__(self, name, value):

        try:
            prop = self.__properties(open)[name]
            prop.fset(self.__control(open), value)
        except:
            import traceback; traceback.print_exc()


    def __getattr__(self, name):

        if name in Control.AUTHORIZED_METHODS:
            return getattr(self.__control(open), name)

        try:
            prop = self.__properties(open)[name]
            return prop.fget(self.__control(open))
        except:
            import traceback; traceback.print_exc()
            return Null


    def get_interfaces_id(self):

        """
        @return : implemented interfaces' id
        @rtype : list of str
        """
        
        return self.__ifaces_id(open)

