import os
import sys

# gDesklets home paths
HOME = os.path.abspath(os.path.join(os.path.dirname(__file__), os.pardir))
USERHOME = os.path.join(os.path.expanduser("~"), ".gdesklets")
OLDHOME = os.path.join(HOME, os.pardir, os.pardir, "share", "gdesklets")

# we need the DISPLAY variable
try:
    DISPLAY = os.environ["DISPLAY"]
except KeyError:
    print "The DISPLAY variable is NOT set, which means, that X isn't running!"
    sys.exit(1)

# the path of the log file
LOGFILE = os.path.join(USERHOME, "gdesklets" + DISPLAY + ".log")

# the path of the positions file
POSITIONSFILE = os.path.join(USERHOME, "positions")

# the name of the purge key
PURGE_KEY = "_paths_to_purge_"

# for unset coordinates
UNSET_COORD = -1000

# paths where the display files are located
DISPLAYPATHS = [os.path.join(USERHOME, "Displays"),
                os.path.join(HOME, "Displays"),
                os.path.join(OLDHOME, "Displays")]
# paths where gDesklets looks for sensors and displays
SENSORPATHS = [os.path.join(USERHOME, "Sensors"),
               os.path.join(HOME, "Sensors"),
               os.path.join(OLDHOME, "Sensors")]
# paths where gDesklets looks for controls
CONTROLPATHS = [os.path.join(USERHOME, "Controls"),
                os.path.join(HOME, "Controls"),
                os.path.join(OLDHOME, "Controls")]
# path of the communication sockets
SOCKET_PATH = os.path.join(USERHOME, "sockets")

PID_PATH = os.path.join(USERHOME, "gdesklets%s.pid" % DISPLAY)

# setup i18n
from utils.i18n import Translator
_ = Translator("gdesklets")


NAME = "gDesklets"
VERSION = "0.33.1"
COPYRIGHT = u"Copyright \xa9 2003 - 2005 The gDesklets Team"
DESCRIPTION = _("A desktop applet system for GNOME")
AUTHORS = ( "Martin Grimme <martin@pycage.de>",
            "Christian Meyer <chrisime@gnome-de.org>",
            "Jesse Andrews <jdandr2@cs.uky.edu>",
           u"S\xe9bastien Bacher <seb128@debian.org>",
           u"Beno\xeet Dejean <tazforever@dlfp.org>"
          )
DOCUMENTERS = ("Martin Grimme <martin@pycage.de>",)
ICON = os.path.join(HOME, "data", "gdesklets.png")
CREDITS = (
           (_("Version %s") % (VERSION,),
           (u"Copyright \xa9 2003 - 2005", "The gDesklets Team")),

           (_("Core Programming:"),
           ("Martin Grimme", "Christian Meyer", "Jesse Andrews",
            u"Beno\xeet Dejean")),

           (_("Architecture Design:"),
           ("Martin Grimme", "Christian Meyer")),

           (_("GNOME Integration:"),
           ("Christian Neumair", "Martin Grimme", u"S\xe9bastien Bacher",
            "Christian Kellner", "Christian Meyer")),

           (_("Artwork:"),
           ("Johannes Rebhan",)),

           (_("Website:"),
           ("Luke Stroven",))
          )


# create the gDesklets home dir
try:
    if (not os.path.exists(USERHOME)):
        os.makedirs(USERHOME)
except StandardError:
    pass


def init():

    """ gDesklets init process """

    try:
        import gnome.ui
    except ImportError:
        print "The GNOME python bindings aren't (correctly) installed!"
	print "Install this package, exiting!"
        sys.exit(1)
        
    try:
        import gtk
    except ImportError:
        print "The gtk+ python bindings aren't (correctly) installed!"
	print "Install this package, exiting!"

    import signal

    # prepare GTK for threads
    try:
        gtk.threads_init()
    except:
        print "No threading support available in python."
	print "Compile python with --enable-threads. Exiting!"
        sys.exit(1)

    # init gnome
    chldhandler = signal.getsignal(signal.SIGCHLD)
    gnome.program_init(NAME, VERSION)

    # gnome.program_init has the bad new habit to modify the locale settings
    # (bug #135055); repair it
    import locale
    locale.setlocale(locale.LC_NUMERIC, "C")

    # gnome.program_init < 1.99.18 breaks the SIGCHLD handler; gotta repair it
    signal.signal(signal.SIGCHLD, chldhandler)

    # install signal handler to quit on Ctrl-C
    signal.signal(signal.SIGINT, gtk.main_quit)

