from ConfigWidget import ConfigWidget

import gtk
import gnome.ui


class ConfigEnum(ConfigWidget):

    def __init__(self, attrs, getter, setter, item_list):

        ConfigWidget.__init__(self, attrs, getter, setter)
        label = attrs.get("label", "")

        lbl = gtk.Label(label)
        lbl.show()
        align = gtk.Alignment(0.0, 0.0, 0.0, 0.0)
        align.show()
        align.add(lbl)

        value = self._get_config()
        optmenu = gtk.combo_box_new_text()
        optmenu.show()
        items = []
        cnt = 0
        index = 0
        for k, v in item_list:
            optmenu.append_text(k)
            items.append(v)
            if (v == value): index = cnt
            cnt += 1
        #end for
        optmenu.set_active(index)
        optmenu.connect("changed", self.__on_change, items)

        self.__widgets = (align, optmenu)


    def get_widgets(self): return self.__widgets


    def __on_change(self, src, items):

        value = items[src.get_active()]
        self._set_config("\"" + value + "\"")
