#!/usr/bin/perl

# James Eitelberg
#
# this script searches ebay for the items defined in the first command line argument
# the second command line argument is required and specifies the max # reults returned
#
#  please use this script with respect
#  i.e automated searching is great, but do not over-burden Ebay
#  Ebay has a commercial API avialable for this purpose
#  please see the Ebay user aggreement if you have any questions
#
#
# this script requires the CPAN modules WWW::Search and WWW:Search::Ebay
#
#
# this script is intended for searching the USA Ebay site
# it may not work in other places.
# also, it is dependent on the HTML format of Ebay, which can change
# this script comes with no warranty of any kind
#
# feel free to use this script and modify as you like


use WWW::Search;

# check for the correct number of arguments
$numArgs = $#ARGV + 1;
if ($numArgs != 2)
{
    print "\nWoaaa!\nInvalid # of arguments\n";
    print "Usage: SearchEbay.pl search_string max_results\n";
    print "Example: SearchEbay.pl \"Red ST4\" 10\n\n";
    die;
};

# we have correct number of arguments
# first one is search term
# check second is positive integer for max results
if ($ARGV[1] =~ m/[^0-9]/)
{
    print "\nWoaaa!\nsecond argument must be positive integer\n";
    print "Usage: SearchEbay.pl search_string max_results\n";
    print "Example: SearchEbay.pl \"Red ST4\" 10\n\n";
    die;
};


# my $oSearch = new WWW::Search('Ebay'); 	  # order by listing date, newest first
my $oSearch = new WWW::Search('Ebay::ByEndDate'); # order by ending date, soonest first
my $sQuery = WWW::Search::escape_query($ARGV[0]); 


#print out the search criteria
printf "Search:\n%.50s\nMax Results = %.50s\n\n", $ARGV[0], $ARGV[1];


#print out the table header
printf "%-14.14s%-7.7s%-16.16s%-13.13s\n", "Item", "Bids", "Price", "Time";

$oSearch->native_query($sQuery);
$oSearch->maximum_to_retrieve($ARGV[1]);
while (my $oResult = $oSearch->next_result())
{
    print "--------------------------------------------------\n";
    #split the description into {item#, #bids, price} 
    @desc = split(/;/, $oResult->description, 3);
    
    #trim the item by removing all non-digit chars
    $desc[0] =~ s/[^0-9]//g;

    #trim the bids by removing all non-digit chars
    #set empty string to 0
    $desc[1] =~ s/[^0-9]//g;
    if ($desc[1] !~ m/^[0-9]/)
    {
	$desc[1] = "0"
    }
   
    #trim the price by removing "starting bid" and "current bid"
    #replace buy it now price with *
    #remove unwanted chars
    $desc[2] =~ s/starting bid //g;
    $desc[2] =~ s/current bid //g;
    $desc[2] =~ s/ \(.*/\*/g;
    $desc[2] =~ s/[^0-9A-Za-z\$\s\.]/ /g;

    #trim unwanted chars from ending date
    my $time = $oResult->change_date;
    $time =~ s/[^0-9DdHhMm\s]/ /g;

    #output the data in a table 
    printf "%.50s\n%-14.14s%-7.7s%-16.16s%-13.13s\n", 
	$oResult->title, 	#the title
	$desc[0],		#the item number
	$desc[1],		#the number of bids
	$desc[2],		#the price
	$time;			#the ending time 
}
