/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.27
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */


#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};
#endif

/***********************************************************************
 *
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 *
 ************************************************************************/

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
#  if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#    define SWIGTEMPLATEDISAMBIGUATOR template
#  else
#    define SWIGTEMPLATEDISAMBIGUATOR 
#  endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__) || defined(__ICC)
#   define SWIGUNUSED __attribute__ ((unused)) 
# else
#   define SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods for Windows DLLs */
#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   define SWIGEXPORT
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif



/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTELC__)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" } };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else


#include <iostream>
using namespace std;

#include "cpl_string.h"
#include "cpl_conv.h"

#include "ogr_srs_api.h"

typedef void OSRSpatialReferenceShadow;
typedef void OSRCoordinateTransformationShadow;



#if defined(SWIG_NOINCLUDE) || defined(SWIG_NOARRAYS)


int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input);
void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input);
jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz);


int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input);
void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input);
jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz);


int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input);
void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input);
jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz);


int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input);
void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input);
jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz);


int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input);
void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input);
jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz);


int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input);
void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input);
jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz);


int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input);
void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input);
jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz);


int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input);
void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input);
jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz);


int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input);
void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input);
jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz);


int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input);
void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input);
jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz);


int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input);
void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input);
jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz);


int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input);
void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input);
jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz);


#else


/* bool[] support */
int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetBooleanArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new bool[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = ((*jarr)[i] != 0);
  return 1;
}

void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jboolean)carr[i];
  jenv->ReleaseBooleanArrayElements(input, jarr, 0);
}

jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz) {
  jboolean *arr;
  int i;
  jbooleanArray jresult = jenv->NewBooleanArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetBooleanArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jboolean)result[i];
  jenv->ReleaseBooleanArrayElements(jresult, arr, 0);
  return jresult;
}


/* signed char[] support */
int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetByteArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new signed char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (signed char)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jbyte)carr[i];
  jenv->ReleaseByteArrayElements(input, jarr, 0);
}

jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz) {
  jbyte *arr;
  int i;
  jbyteArray jresult = jenv->NewByteArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetByteArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jbyte)result[i];
  jenv->ReleaseByteArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned char[] support */
int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned char)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* short[] support */
int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (short)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned short[] support */
int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned short)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* int[] support */
int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (int)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned int[] support */
int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned int)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* long[] support */
int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (long)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned long[] support */
int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned long)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* jlong[] support */
int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new jlong[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (jlong)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* float[] support */
int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetFloatArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new float[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (float)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jfloat)carr[i];
  jenv->ReleaseFloatArrayElements(input, jarr, 0);
}

jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz) {
  jfloat *arr;
  int i;
  jfloatArray jresult = jenv->NewFloatArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetFloatArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jfloat)result[i];
  jenv->ReleaseFloatArrayElements(jresult, arr, 0);
  return jresult;
}


/* double[] support */
int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetDoubleArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new double[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (double)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jdouble)carr[i];
  jenv->ReleaseDoubleArrayElements(input, jarr, 0);
}

jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz) {
  jdouble *arr;
  int i;
  jdoubleArray jresult = jenv->NewDoubleArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetDoubleArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jdouble)result[i];
  jenv->ReleaseDoubleArrayElements(jresult, arr, 0);
  return jresult;
}


#endif


OGRErr GetWellKnownGeogCSAsWKT( const char *name, char **argout ) {
  OGRSpatialReferenceH srs = OSRNewSpatialReference("");
  OSRSetWellKnownGeogCS( srs, name );
  OGRErr rcode = OSRExportToWkt ( srs, argout );  
  OSRDestroySpatialReference( srs );
  return rcode;
}


static char const *
OGRErrMessages( int rc ) {
  switch( rc ) {
  case 0:
    return "OGR Error %d: None";
  case 1:
    return "OGR Error %d: Not enough data";
  case 2:
    return "OGR Error %d: Unsupported geometry type";
  case 3:
    return "OGR Error %d: Unsupported operation";
  case 4:
    return "OGR Error %d: Corrupt data";
  case 5:
    return "OGR Error %d: General Error";
  case 6:
    return "OGR Error %d: Unsupported SRS";
  default:
    return "OGR Error %d: Unknown";
  }
}

static OSRSpatialReferenceShadow *new_OSRSpatialReferenceShadow(char const *wkt=""){
    OSRSpatialReferenceShadow *sr = (OSRSpatialReferenceShadow*) OSRNewSpatialReference(wkt);
    if (sr) {
      OSRReference( sr );
    }
    return sr;
  }
static void delete_OSRSpatialReferenceShadow(OSRSpatialReferenceShadow *self){
    if (OSRDereference( self ) == 0 ) {
      OSRDestroySpatialReference( self );
    }
  }
static char *OSRSpatialReferenceShadow___str__(OSRSpatialReferenceShadow *self){
    char *buf = 0;
    OSRExportToPrettyWkt( self, &buf, 0 );
    return buf;
  }
static int OSRSpatialReferenceShadow_IsSame(OSRSpatialReferenceShadow *self,OSRSpatialReferenceShadow *rhs){
    return OSRIsSame( self, rhs );
  }
static int OSRSpatialReferenceShadow_IsSameGeogCS(OSRSpatialReferenceShadow *self,OSRSpatialReferenceShadow *rhs){
    return OSRIsSameGeogCS( self, rhs );
  }
static int OSRSpatialReferenceShadow_IsGeographic(OSRSpatialReferenceShadow *self){
    return OSRIsGeographic(self);
  }
static int OSRSpatialReferenceShadow_IsProjected(OSRSpatialReferenceShadow *self){
    return OSRIsProjected(self);
  }
static char const *OSRSpatialReferenceShadow_GetAttrValue(OSRSpatialReferenceShadow *self,char const *name,int child=0){
    return OSRGetAttrValue( self, name, child );
  }
static OGRErr OSRSpatialReferenceShadow_SetAttrValue(OSRSpatialReferenceShadow *self,char const *name,char const *value){
    return OSRSetAttrValue( self, name, value ); 
  }
static OGRErr OSRSpatialReferenceShadow_SetAngularUnits(OSRSpatialReferenceShadow *self,char const *name,double to_radians){
    return OSRSetAngularUnits( self, name, to_radians );
  }
static double OSRSpatialReferenceShadow_GetAngularUnits(OSRSpatialReferenceShadow *self){
    // Return code ignored.
    return OSRGetAngularUnits( self, 0 );
  }
static OGRErr OSRSpatialReferenceShadow_SetLinearUnits(OSRSpatialReferenceShadow *self,char const *name,double to_meters){
    return OSRSetAngularUnits( self, name, to_meters );
  }
static double OSRSpatialReferenceShadow_GetLinearUnits(OSRSpatialReferenceShadow *self){
    // Return code ignored.
    return OSRGetLinearUnits( self, 0 );
  }
static char const *OSRSpatialReferenceShadow_GetLinearUnitsName(OSRSpatialReferenceShadow *self){
    const char *name = 0;
    if ( OSRIsProjected( self ) ) {
      name = OSRGetAttrValue( self, "PROJCS|UNIT", 0 );
    }
    else if ( OSRIsLocal( self ) ) {
      name = OSRGetAttrValue( self, "LOCAL_CS|UNIT", 0 );
    }

    if (name != 0) 
      return name;

    return "Meter";
  }
static char const *OSRSpatialReferenceShadow_GetAuthorityCode(OSRSpatialReferenceShadow *self,char const *target_key){
    return OSRGetAuthorityCode( self, target_key );
  }
static char const *OSRSpatialReferenceShadow_GetAuthorityName(OSRSpatialReferenceShadow *self,char const *target_key){
    return OSRGetAuthorityName( self, target_key );
  }
static OGRErr OSRSpatialReferenceShadow_SetUTM(OSRSpatialReferenceShadow *self,int zone,int north=1){
    return OSRSetUTM( self, zone, north );
  }
static OGRErr OSRSpatialReferenceShadow_SetStatePlane(OSRSpatialReferenceShadow *self,int zone,int is_nad83=1,char const *unitsname="",double units=0.0){
    return OSRSetStatePlaneWithUnits( self, zone, is_nad83, unitsname, units );
  }
static OGRErr OSRSpatialReferenceShadow_AutoIdentifyEPSG(OSRSpatialReferenceShadow *self){
    return OSRAutoIdentifyEPSG( self );
  }
static OGRErr OSRSpatialReferenceShadow_SetProjection(OSRSpatialReferenceShadow *self,char const *arg){
    return OSRSetProjection( self, arg );
  }
static OGRErr OSRSpatialReferenceShadow_SetProjParm(OSRSpatialReferenceShadow *self,char const *name,double val){
    return OSRSetProjParm( self, name, val ); 
  }
static double OSRSpatialReferenceShadow_GetProjParm(OSRSpatialReferenceShadow *self,char const *name,double default_val=0.0){
    // Return code ignored.
    return OSRGetProjParm( self, name, default_val, 0 );
  }
static OGRErr OSRSpatialReferenceShadow_SetNormProjParm(OSRSpatialReferenceShadow *self,char const *name,double val){
    return OSRSetNormProjParm( self, name, val );
  }
static double OSRSpatialReferenceShadow_GetNormProjParm(OSRSpatialReferenceShadow *self,char const *name,double default_val=0.0){
    // Return code ignored.
    return OSRGetNormProjParm( self, name, default_val, 0 );
  }
static OGRErr OSRSpatialReferenceShadow_SetACEA(OSRSpatialReferenceShadow *self,double stdp1,double stdp2,double clat,double clong,double fe,double fn){
    return OSRSetACEA( self, stdp1, stdp2, clat, clong, fe, fn );
  }
static OGRErr OSRSpatialReferenceShadow_SetAE(OSRSpatialReferenceShadow *self,double clat,double clon,double fe,double fn){
    return OSRSetAE( self, clat, clon, fe, fn );
  }
static OGRErr OSRSpatialReferenceShadow_SetCS(OSRSpatialReferenceShadow *self,double clat,double clong,double fe,double fn){
    return OSRSetCS( self, clat, clong, fe, fn );
  }
static OGRErr OSRSpatialReferenceShadow_SetBonne(OSRSpatialReferenceShadow *self,double clat,double clong,double fe,double fn){
    return OSRSetBonne( self, clat, clong, fe, fn );
  }
static OGRErr OSRSpatialReferenceShadow_SetEC(OSRSpatialReferenceShadow *self,double stdp1,double stdp2,double clat,double clong,double fe,double fn){
    return OSRSetEC( self, stdp1, stdp2, clat, clong, fe, fn );
  }
static OGRErr OSRSpatialReferenceShadow_SetEckertIV(OSRSpatialReferenceShadow *self,double cm,double fe,double fn){
    return OSRSetEckertIV( self, cm, fe, fn );
  }
static OGRErr OSRSpatialReferenceShadow_SetEckertVI(OSRSpatialReferenceShadow *self,double cm,double fe,double fn){
    return OSRSetEckertVI( self, cm, fe, fn );
  }
static OGRErr OSRSpatialReferenceShadow_SetEquirectangular(OSRSpatialReferenceShadow *self,double clat,double clong,double fe,double fn){
    return OSRSetEquirectangular( self, clat, clong, fe, fn );
  }
static OGRErr OSRSpatialReferenceShadow_SetGS(OSRSpatialReferenceShadow *self,double cm,double fe,double fn){
    return OSRSetGS( self, cm, fe, fn );
  }
static OGRErr OSRSpatialReferenceShadow_SetWellKnownGeogCS(OSRSpatialReferenceShadow *self,char const *name){
    return OSRSetWellKnownGeogCS( self, name );
  }
static OGRErr OSRSpatialReferenceShadow_SetFromUserInput(OSRSpatialReferenceShadow *self,char const *name){
    return OSRSetFromUserInput( self, name );
  }
static OGRErr OSRSpatialReferenceShadow_CopyGeogCSFrom(OSRSpatialReferenceShadow *self,OSRSpatialReferenceShadow *rhs){
    return OSRCopyGeogCSFrom( self, rhs );
  }
static OGRErr OSRSpatialReferenceShadow_SetTOWGS84(OSRSpatialReferenceShadow *self,double p1,double p2,double p3,double p4=0.0,double p5=0.0,double p6=0.0,double p7=0.0){
    return OSRSetTOWGS84( self, p1, p2, p3, p4, p5, p6, p7 );
  }
static OGRErr OSRSpatialReferenceShadow_GetTOWGS84(OSRSpatialReferenceShadow *self,double argout[7]){
    return OSRGetTOWGS84( self, argout, 7 );
  }
static OGRErr OSRSpatialReferenceShadow_SetGeogCS(OSRSpatialReferenceShadow *self,char const *pszGeogName,char const *pszDatumName,char const *pszEllipsoidName,double dfSemiMajor,double dfInvFlattening,char const *pszPMName="Greenwich",double dfPMOffset=0.0,char const *pszUnits="degree",double dfConvertToRadians=0.0174532925199433){
    return OSRSetGeogCS( self, pszGeogName, pszDatumName, pszEllipsoidName,
                         dfSemiMajor, dfInvFlattening,
                         pszPMName, dfPMOffset, pszUnits, dfConvertToRadians );
  }
static OGRErr OSRSpatialReferenceShadow_SetProjCS(OSRSpatialReferenceShadow *self,char const *name="unnamed"){
    return OSRSetProjCS( self, name );
  }
static OGRErr OSRSpatialReferenceShadow_ImportFromWkt(OSRSpatialReferenceShadow *self,char **ppszInput){
    return OSRImportFromWkt( self, ppszInput );
  }
static OGRErr OSRSpatialReferenceShadow_ImportFromProj4(OSRSpatialReferenceShadow *self,char *ppszInput){
    return OSRImportFromProj4( self, ppszInput );
  }
static OGRErr OSRSpatialReferenceShadow_ImportFromESRI(OSRSpatialReferenceShadow *self,char **ppszInput){
    return OSRImportFromESRI( self, ppszInput );
  }
static OGRErr OSRSpatialReferenceShadow_ImportFromEPSG(OSRSpatialReferenceShadow *self,int arg){
    return OSRImportFromEPSG(self, arg);
  }
static OGRErr OSRSpatialReferenceShadow_ImportFromPCI(OSRSpatialReferenceShadow *self,char const *proj,char const *units="METRE",double argin[17]=0){
    return OSRImportFromPCI( self, proj, units, argin );
  }
static OGRErr OSRSpatialReferenceShadow_ImportFromUSGS(OSRSpatialReferenceShadow *self,long proj_code,long zone=0,double argin[15]=0,long datum_code=0){
    return OSRImportFromUSGS( self, proj_code, zone, argin, datum_code );
  }
static OGRErr OSRSpatialReferenceShadow_ImportFromXML(OSRSpatialReferenceShadow *self,char const *xmlString){
    return OSRImportFromXML( self, xmlString );
  }
static OGRErr OSRSpatialReferenceShadow_ExportToWkt(OSRSpatialReferenceShadow *self,char **argout){
    return OSRExportToWkt( self, argout );
  }
static OGRErr OSRSpatialReferenceShadow_ExportToPrettyWkt(OSRSpatialReferenceShadow *self,char **argout,int simplify=0){
    return OSRExportToPrettyWkt( self, argout, simplify );
  }
static OGRErr OSRSpatialReferenceShadow_ExportToProj4(OSRSpatialReferenceShadow *self,char **argout){
    return OSRExportToProj4( self, argout );
  }
static OGRErr OSRSpatialReferenceShadow_ExportToPCI(OSRSpatialReferenceShadow *self,char **proj,char **units,double *parms[17]){
    return OSRExportToPCI( self, proj, units, parms );
  }
static OGRErr OSRSpatialReferenceShadow_ExportToUSGS(OSRSpatialReferenceShadow *self,long *code,long *zone,double *parms[15],long *datum){
    return OSRExportToUSGS( self, code, zone, parms, datum );
  }
static OGRErr OSRSpatialReferenceShadow_ExportToXML(OSRSpatialReferenceShadow *self,char **argout,char const *dialect=""){
    return OSRExportToXML( self, argout, dialect );
  }
static OSRSpatialReferenceShadow *OSRSpatialReferenceShadow_CloneGeogCS(OSRSpatialReferenceShadow *self){
    return (OSRSpatialReferenceShadow*) OSRCloneGeogCS(self);
  }
static OGRErr OSRSpatialReferenceShadow_Validate(OSRSpatialReferenceShadow *self){
    return OSRValidate(self);
  }
static OGRErr OSRSpatialReferenceShadow_StripCTParms(OSRSpatialReferenceShadow *self){
    return OSRStripCTParms(self);
  }
static OGRErr OSRSpatialReferenceShadow_FixupOrdering(OSRSpatialReferenceShadow *self){
    return OSRFixupOrdering(self);
  }
static OGRErr OSRSpatialReferenceShadow_Fixup(OSRSpatialReferenceShadow *self){
    return OSRFixup(self);
  }
static OGRErr OSRSpatialReferenceShadow_MorphToESRI(OSRSpatialReferenceShadow *self){
    return OSRMorphToESRI(self);
  }
static OGRErr OSRSpatialReferenceShadow_MorphFromESRI(OSRSpatialReferenceShadow *self){
    return OSRMorphFromESRI(self);
  }
static OSRCoordinateTransformationShadow *new_OSRCoordinateTransformationShadow(OSRSpatialReferenceShadow *src,OSRSpatialReferenceShadow *dst){
    OSRCoordinateTransformationShadow *obj = (OSRCoordinateTransformationShadow*) OCTNewCoordinateTransformation( src, dst );
    if (obj == 0 ) {
      throw "Failed to create coordinate transformation";
    }
    return obj;
  }
static void delete_OSRCoordinateTransformationShadow(OSRCoordinateTransformationShadow *self){
    OCTDestroyCoordinateTransformation( self );
  }
static void OSRCoordinateTransformationShadow_TransformPoint__SWIG_0(OSRCoordinateTransformationShadow *self,double inout[3]){
    OCTTransform( self, 1, &inout[0], &inout[1], &inout[2] );
  }
static void OSRCoordinateTransformationShadow_TransformPoint__SWIG_1(OSRCoordinateTransformationShadow *self,double argout[3],double x,double y,double z=0.0){
    argout[0] = x;
    argout[1] = y;
    argout[2] = z;
    OCTTransform( self, 1, &argout[0], &argout[1], &argout[2] );
  }

#ifdef __cplusplus
extern "C" {
#endif

JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1ALBERS_1CONIC_1EQUAL_1AREA_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_ALBERS_CONIC_EQUAL_AREA";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1AZIMUTHAL_1EQUIDISTANT_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_AZIMUTHAL_EQUIDISTANT";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1CASSINI_1SOLDNER_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_CASSINI_SOLDNER";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1CYLINDRICAL_1EQUAL_1AREA_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_CYLINDRICAL_EQUAL_AREA";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1ECKERT_1IV_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_ECKERT_IV";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1ECKERT_1VI_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_ECKERT_VI";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1EQUIDISTANT_1CONIC_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_EQUIDISTANT_CONIC";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1EQUIRECTANGULAR_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_EQUIRECTANGULAR";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1GALL_1STEREOGRAPHIC_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_GALL_STEREOGRAPHIC";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1GNOMONIC_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_GNOMONIC";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1GOODE_1HOMOLOSINE_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_GOODE_HOMOLOSINE";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1HOTINE_1OBLIQUE_1MERCATOR_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_HOTINE_OBLIQUE_MERCATOR";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1HOTINE_1OBLIQUE_1MERCATOR_1TWO_1POINT_1NATURAL_1ORIGIN_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_HOTINE_OBLIQUE_MERCATOR_TWO_POINT_NATURAL_ORIGIN";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1LABORDE_1OBLIQUE_1MERCATOR_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_LABORDE_OBLIQUE_MERCATOR";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1LAMBERT_1CONFORMAL_1CONIC_11SP_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_LAMBERT_CONFORMAL_CONIC_1SP";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1LAMBERT_1CONFORMAL_1CONIC_12SP_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_LAMBERT_CONFORMAL_CONIC_2SP";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1LAMBERT_1CONFORMAL_1CONIC_12SP_1BELGIUM_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_LAMBERT_CONFORMAL_CONIC_2SP_BELGIUM";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1LAMBERT_1AZIMUTHAL_1EQUAL_1AREA_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_LAMBERT_AZIMUTHAL_EQUAL_AREA";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1MERCATOR_11SP_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_MERCATOR_1SP";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1MERCATOR_12SP_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_MERCATOR_2SP";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1MILLER_1CYLINDRICAL_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_MILLER_CYLINDRICAL";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1MOLLWEIDE_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_MOLLWEIDE";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1NEW_1ZEALAND_1MAP_1GRID_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_NEW_ZEALAND_MAP_GRID";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1OBLIQUE_1STEREOGRAPHIC_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_OBLIQUE_STEREOGRAPHIC";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1ORTHOGRAPHIC_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_ORTHOGRAPHIC";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1POLAR_1STEREOGRAPHIC_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_POLAR_STEREOGRAPHIC";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1POLYCONIC_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_POLYCONIC";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1ROBINSON_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_ROBINSON";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1SINUSOIDAL_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_SINUSOIDAL";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1STEREOGRAPHIC_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_STEREOGRAPHIC";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1SWISS_1OBLIQUE_1CYLINDRICAL_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_SWISS_OBLIQUE_CYLINDRICAL";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1TRANSVERSE_1MERCATOR_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_TRANSVERSE_MERCATOR";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1TRANSVERSE_1MERCATOR_1SOUTH_1ORIENTED_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_TRANSVERSE_MERCATOR_SOUTH_ORIENTED";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1TRANSVERSE_1MERCATOR_1MI_122_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_TRANSVERSE_MERCATOR_MI_22";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1TRANSVERSE_1MERCATOR_1MI_123_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_TRANSVERSE_MERCATOR_MI_23";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1TRANSVERSE_1MERCATOR_1MI_124_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_TRANSVERSE_MERCATOR_MI_24";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1TRANSVERSE_1MERCATOR_1MI_125_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_TRANSVERSE_MERCATOR_MI_25";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1TUNISIA_1MINING_1GRID_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_TUNISIA_MINING_GRID";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1VANDERGRINTEN_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_VANDERGRINTEN";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PT_1KROVAK_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PT_KROVAK";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PP_1CENTRAL_1MERIDIAN_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PP_CENTRAL_MERIDIAN";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PP_1SCALE_1FACTOR_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PP_SCALE_FACTOR";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PP_1STANDARD_1PARALLEL_11_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PP_STANDARD_PARALLEL_1";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PP_1STANDARD_1PARALLEL_12_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PP_STANDARD_PARALLEL_2";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PP_1PSEUDO_1STD_1PARALLEL_11_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PP_PSEUDO_STD_PARALLEL_1";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PP_1LONGITUDE_1OF_1CENTER_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PP_LONGITUDE_OF_CENTER";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PP_1LATITUDE_1OF_1CENTER_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PP_LATITUDE_OF_CENTER";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PP_1LONGITUDE_1OF_1ORIGIN_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PP_LONGITUDE_OF_ORIGIN";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PP_1LATITUDE_1OF_1ORIGIN_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PP_LATITUDE_OF_ORIGIN";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PP_1FALSE_1EASTING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PP_FALSE_EASTING";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PP_1FALSE_1NORTHING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PP_FALSE_NORTHING";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PP_1AZIMUTH_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PP_AZIMUTH";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PP_1LONGITUDE_1OF_1POINT_11_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PP_LONGITUDE_OF_POINT_1";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PP_1LATITUDE_1OF_1POINT_11_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PP_LATITUDE_OF_POINT_1";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PP_1LONGITUDE_1OF_1POINT_12_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PP_LONGITUDE_OF_POINT_2";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PP_1LATITUDE_1OF_1POINT_12_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PP_LATITUDE_OF_POINT_2";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PP_1LONGITUDE_1OF_1POINT_13_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PP_LONGITUDE_OF_POINT_3";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PP_1LATITUDE_1OF_1POINT_13_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PP_LATITUDE_OF_POINT_3";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PP_1RECTIFIED_1GRID_1ANGLE_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PP_RECTIFIED_GRID_ANGLE";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PP_1LANDSAT_1NUMBER_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PP_LANDSAT_NUMBER";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PP_1PATH_1NUMBER_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PP_PATH_NUMBER";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PP_1PERSPECTIVE_1POINT_1HEIGHT_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PP_PERSPECTIVE_POINT_HEIGHT";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PP_1FIPSZONE_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PP_FIPSZONE";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1PP_1ZONE_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_PP_ZONE";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1UL_1METER_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_UL_METER";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1UL_1FOOT_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_UL_FOOT";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1UL_1FOOT_1CONV_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_UL_FOOT_CONV";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1UL_1US_1FOOT_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_UL_US_FOOT";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1UL_1US_1FOOT_1CONV_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_UL_US_FOOT_CONV";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1UL_1NAUTICAL_1MILE_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_UL_NAUTICAL_MILE";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1UL_1NAUTICAL_1MILE_1CONV_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_UL_NAUTICAL_MILE_CONV";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1UL_1LINK_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_UL_LINK";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1UL_1LINK_1CONV_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_UL_LINK_CONV";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1UL_1CHAIN_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_UL_CHAIN";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1UL_1CHAIN_1CONV_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_UL_CHAIN_CONV";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1UL_1ROD_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_UL_ROD";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1UL_1ROD_1CONV_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_UL_ROD_CONV";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1DN_1NAD27_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_DN_NAD27";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1DN_1NAD83_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_DN_NAD83";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1DN_1WGS72_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_DN_WGS72";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SRS_1DN_1WGS84_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SRS_DN_WGS84";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_gdal_osr_osrJNI_SRS_1WGS84_1SEMIMAJOR_1get(JNIEnv *jenv, jclass jcls) {
    jdouble jresult = 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    result = (double) SRS_WGS84_SEMIMAJOR;
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_gdal_osr_osrJNI_SRS_1WGS84_1INVFLATTENING_1get(JNIEnv *jenv, jclass jcls) {
    jdouble jresult = 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    result = (double) SRS_WGS84_INVFLATTENING;
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_GetWellKnownGeogCSAsWKT(JNIEnv *jenv, jclass jcls, jstring jarg1, jobjectArray jarg2) {
    jint jresult = 0 ;
    char *arg1 = (char *) 0 ;
    char **arg2 = (char **) 0 ;
    OGRErr result;
    char *argout2 = 0 ;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
            if (!arg1) return 0;
        }
    }
    {
        /* %typemap(in) (char **argout2) */
        arg2 = &argout2;
    }
    result = (OGRErr)GetWellKnownGeogCSAsWKT((char const *)arg1,arg2);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(argout) (char **argout) */
        jstring temp_string;
        
        if((int)jenv->GetArrayLength(jarg2) >= 1) {
            temp_string = jenv->NewStringUTF(argout2);
            jenv->SetObjectArrayElement(jarg2, 0, temp_string);
            jenv->DeleteLocalRef(temp_string);
        }
    }
    {
        if (arg1) jenv->ReleaseStringUTFChars(jarg1, arg1); 
    }
    {
        /* %typemap(freearg) (char **argout) */
        if(arg2) {
            free((void *)argout2);
        }
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jobjectArray JNICALL Java_org_gdal_osr_osrJNI_GetProjectionMethods(JNIEnv *jenv, jclass jcls) {
    jobjectArray jresult = 0 ;
    char **result;
    
    (void)jenv;
    (void)jcls;
    result = (char **)OPTGetProjectionMethods();
    
    {
        /* %typemap(out) char ** */
        int i;
        int len=0;
        jstring temp_string;
        const jclass clazz = jenv->FindClass("java/lang/String");
        
        while (result[len]) len++;    
        jresult = jenv->NewObjectArray(len, clazz, NULL);
        /* exception checking omitted */
        
        for (i=0; i<len; i++) {
            temp_string = jenv->NewStringUTF(*result++);
            jenv->SetObjectArrayElement(jresult, i, temp_string);
            jenv->DeleteLocalRef(temp_string);
        }
    }
    return jresult;
}


JNIEXPORT jobjectArray JNICALL Java_org_gdal_osr_osrJNI_GetProjectionMethodParameterList(JNIEnv *jenv, jclass jcls, jstring jarg1, jobjectArray jarg2) {
    jobjectArray jresult = 0 ;
    char *arg1 = (char *) 0 ;
    char **arg2 = (char **) 0 ;
    char **result;
    jint size2 ;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
            if (!arg1) return 0;
        }
    }
    {
        /* %typemap(in) char ** (jint size2) */
        int i = 0;
        size2 = jenv->GetArrayLength(jarg2);
        arg2 = (char **) malloc((size2+1)*sizeof(char *));
        /* make a copy of each string */
        for (i = 0; i<size2; i++) {
            jstring j_string = (jstring)jenv->GetObjectArrayElement(jarg2, i);
            const char * c_string = jenv->GetStringUTFChars(j_string, 0);
            arg2[i] = (char *)malloc(strlen((c_string)+1)*sizeof(const char *));
            strcpy(arg2[i], c_string);
            jenv->ReleaseStringUTFChars(j_string, c_string);
            jenv->DeleteLocalRef(j_string);
        }
        arg2[i] = 0;
    }
    result = (char **)OPTGetParameterList(arg1,arg2);
    
    {
        /* %typemap(out) char ** */
        int i;
        int len=0;
        jstring temp_string;
        const jclass clazz = jenv->FindClass("java/lang/String");
        
        while (result[len]) len++;    
        jresult = jenv->NewObjectArray(len, clazz, NULL);
        /* exception checking omitted */
        
        for (i=0; i<len; i++) {
            temp_string = jenv->NewStringUTF(*result++);
            jenv->SetObjectArrayElement(jresult, i, temp_string);
            jenv->DeleteLocalRef(temp_string);
        }
    }
    {
        if (arg1) jenv->ReleaseStringUTFChars(jarg1, arg1); 
    }
    {
        /* %typemap(freearg) char ** */
        int i;
        for (i=0; i<size2-1; i++)
        free(arg2[i]);
        free(arg2);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_osr_osrJNI_GetProjectionMethodParamInfo(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jobjectArray jarg3, jobjectArray jarg4, jlong jarg5) {
    char *arg1 = (char *) 0 ;
    char *arg2 = (char *) 0 ;
    char **arg3 = (char **) 0 ;
    char **arg4 = (char **) 0 ;
    double *arg5 = (double *) 0 ;
    jint size3 ;
    jint size4 ;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
            if (!arg1) return ;
        }
    }
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        /* %typemap(in) char ** (jint size3) */
        int i = 0;
        size3 = jenv->GetArrayLength(jarg3);
        arg3 = (char **) malloc((size3+1)*sizeof(char *));
        /* make a copy of each string */
        for (i = 0; i<size3; i++) {
            jstring j_string = (jstring)jenv->GetObjectArrayElement(jarg3, i);
            const char * c_string = jenv->GetStringUTFChars(j_string, 0);
            arg3[i] = (char *)malloc(strlen((c_string)+1)*sizeof(const char *));
            strcpy(arg3[i], c_string);
            jenv->ReleaseStringUTFChars(j_string, c_string);
            jenv->DeleteLocalRef(j_string);
        }
        arg3[i] = 0;
    }
    {
        /* %typemap(in) char ** (jint size4) */
        int i = 0;
        size4 = jenv->GetArrayLength(jarg4);
        arg4 = (char **) malloc((size4+1)*sizeof(char *));
        /* make a copy of each string */
        for (i = 0; i<size4; i++) {
            jstring j_string = (jstring)jenv->GetObjectArrayElement(jarg4, i);
            const char * c_string = jenv->GetStringUTFChars(j_string, 0);
            arg4[i] = (char *)malloc(strlen((c_string)+1)*sizeof(const char *));
            strcpy(arg4[i], c_string);
            jenv->ReleaseStringUTFChars(j_string, c_string);
            jenv->DeleteLocalRef(j_string);
        }
        arg4[i] = 0;
    }
    arg5 = *(double **)(void *)&jarg5; 
    OPTGetParameterInfo(arg1,arg2,arg3,arg4,arg5);
    
    {
        if (arg1) jenv->ReleaseStringUTFChars(jarg1, arg1); 
    }
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    {
        /* %typemap(freearg) char ** */
        int i;
        for (i=0; i<size3-1; i++)
        free(arg3[i]);
        free(arg3);
    }
    {
        /* %typemap(freearg) char ** */
        int i;
        for (i=0; i<size4-1; i++)
        free(arg4[i]);
        free(arg4);
    }
}


JNIEXPORT jlong JNICALL Java_org_gdal_osr_osrJNI_new_1SpatialReference(JNIEnv *jenv, jclass jcls, jstring jarg1) {
    jlong jresult = 0 ;
    char *arg1 = (char *) "" ;
    OSRSpatialReferenceShadow *result;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
            if (!arg1) return 0;
        }
    }
    result = (OSRSpatialReferenceShadow *)new_OSRSpatialReferenceShadow((char const *)arg1);
    
    *(OSRSpatialReferenceShadow **)(void *)&jresult = result; 
    {
        if (arg1) jenv->ReleaseStringUTFChars(jarg1, arg1); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_osr_osrJNI_delete_1SpatialReference(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    delete_OSRSpatialReferenceShadow(arg1);
    
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1_1_1str_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    result = (char *)OSRSpatialReferenceShadow___str__(arg1);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    delete [] result;
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1IsSame(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    OSRSpatialReferenceShadow *arg2 = (OSRSpatialReferenceShadow *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    arg2 = *(OSRSpatialReferenceShadow **)(void *)&jarg2; 
    result = (int)OSRSpatialReferenceShadow_IsSame(arg1,arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1IsSameGeogCS(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    OSRSpatialReferenceShadow *arg2 = (OSRSpatialReferenceShadow *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    arg2 = *(OSRSpatialReferenceShadow **)(void *)&jarg2; 
    result = (int)OSRSpatialReferenceShadow_IsSameGeogCS(arg1,arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1IsGeographic(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    result = (int)OSRSpatialReferenceShadow_IsGeographic(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1IsProjected(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    result = (int)OSRSpatialReferenceShadow_IsProjected(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1GetAttrValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
    jstring jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    int arg3 = (int) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    arg3 = (int)jarg3; 
    result = (char *)OSRSpatialReferenceShadow_GetAttrValue(arg1,(char const *)arg2,arg3);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1SetAttrValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    char *arg3 = (char *) 0 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return 0;
        }
    }
    result = (OGRErr)OSRSpatialReferenceShadow_SetAttrValue(arg1,(char const *)arg2,(char const *)arg3);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1SetAngularUnits(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jdouble jarg3) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    double arg3 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    arg3 = (double)jarg3; 
    result = (OGRErr)OSRSpatialReferenceShadow_SetAngularUnits(arg1,(char const *)arg2,arg3);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1GetAngularUnits(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    result = (double)OSRSpatialReferenceShadow_GetAngularUnits(arg1);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1SetLinearUnits(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jdouble jarg3) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    double arg3 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    arg3 = (double)jarg3; 
    result = (OGRErr)OSRSpatialReferenceShadow_SetLinearUnits(arg1,(char const *)arg2,arg3);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1GetLinearUnits(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    result = (double)OSRSpatialReferenceShadow_GetLinearUnits(arg1);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1GetLinearUnitsName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    result = (char *)OSRSpatialReferenceShadow_GetLinearUnitsName(arg1);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1GetAuthorityCode(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jstring jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (char *)OSRSpatialReferenceShadow_GetAuthorityCode(arg1,(char const *)arg2);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1GetAuthorityName(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jstring jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (char *)OSRSpatialReferenceShadow_GetAuthorityName(arg1,(char const *)arg2);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1SetUTM(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    int arg2 ;
    int arg3 = (int) 1 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (int)jarg3; 
    result = (OGRErr)OSRSpatialReferenceShadow_SetUTM(arg1,arg2,arg3);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1SetStatePlane(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jstring jarg4, jdouble jarg5) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    int arg2 ;
    int arg3 = (int) 1 ;
    char *arg4 = (char *) "" ;
    double arg5 = (double) 0.0 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (int)jarg3; 
    {
        arg4 = 0;
        if (jarg4) {
            arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
            if (!arg4) return 0;
        }
    }
    arg5 = (double)jarg5; 
    result = (OGRErr)OSRSpatialReferenceShadow_SetStatePlane(arg1,arg2,arg3,(char const *)arg4,arg5);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        if (arg4) jenv->ReleaseStringUTFChars(jarg4, arg4); 
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1AutoIdentifyEPSG(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    result = (OGRErr)OSRSpatialReferenceShadow_AutoIdentifyEPSG(arg1);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1SetProjection(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (OGRErr)OSRSpatialReferenceShadow_SetProjection(arg1,(char const *)arg2);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1SetProjParm(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jdouble jarg3) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    double arg3 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    arg3 = (double)jarg3; 
    result = (OGRErr)OSRSpatialReferenceShadow_SetProjParm(arg1,(char const *)arg2,arg3);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1GetProjParm(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jdouble jarg3) {
    jdouble jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    double arg3 = (double) 0.0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    arg3 = (double)jarg3; 
    result = (double)OSRSpatialReferenceShadow_GetProjParm(arg1,(char const *)arg2,arg3);
    
    jresult = (jdouble)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1SetNormProjParm(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jdouble jarg3) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    double arg3 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    arg3 = (double)jarg3; 
    result = (OGRErr)OSRSpatialReferenceShadow_SetNormProjParm(arg1,(char const *)arg2,arg3);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1GetNormProjParm(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jdouble jarg3) {
    jdouble jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    double arg3 = (double) 0.0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    arg3 = (double)jarg3; 
    result = (double)OSRSpatialReferenceShadow_GetNormProjParm(arg1,(char const *)arg2,arg3);
    
    jresult = (jdouble)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1SetACEA(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5, jdouble jarg6, jdouble jarg7) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    double arg2 ;
    double arg3 ;
    double arg4 ;
    double arg5 ;
    double arg6 ;
    double arg7 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    arg2 = (double)jarg2; 
    arg3 = (double)jarg3; 
    arg4 = (double)jarg4; 
    arg5 = (double)jarg5; 
    arg6 = (double)jarg6; 
    arg7 = (double)jarg7; 
    result = (OGRErr)OSRSpatialReferenceShadow_SetACEA(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1SetAE(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    double arg2 ;
    double arg3 ;
    double arg4 ;
    double arg5 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    arg2 = (double)jarg2; 
    arg3 = (double)jarg3; 
    arg4 = (double)jarg4; 
    arg5 = (double)jarg5; 
    result = (OGRErr)OSRSpatialReferenceShadow_SetAE(arg1,arg2,arg3,arg4,arg5);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1SetCS(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    double arg2 ;
    double arg3 ;
    double arg4 ;
    double arg5 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    arg2 = (double)jarg2; 
    arg3 = (double)jarg3; 
    arg4 = (double)jarg4; 
    arg5 = (double)jarg5; 
    result = (OGRErr)OSRSpatialReferenceShadow_SetCS(arg1,arg2,arg3,arg4,arg5);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1SetBonne(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    double arg2 ;
    double arg3 ;
    double arg4 ;
    double arg5 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    arg2 = (double)jarg2; 
    arg3 = (double)jarg3; 
    arg4 = (double)jarg4; 
    arg5 = (double)jarg5; 
    result = (OGRErr)OSRSpatialReferenceShadow_SetBonne(arg1,arg2,arg3,arg4,arg5);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1SetEC(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5, jdouble jarg6, jdouble jarg7) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    double arg2 ;
    double arg3 ;
    double arg4 ;
    double arg5 ;
    double arg6 ;
    double arg7 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    arg2 = (double)jarg2; 
    arg3 = (double)jarg3; 
    arg4 = (double)jarg4; 
    arg5 = (double)jarg5; 
    arg6 = (double)jarg6; 
    arg7 = (double)jarg7; 
    result = (OGRErr)OSRSpatialReferenceShadow_SetEC(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1SetEckertIV(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    double arg2 ;
    double arg3 ;
    double arg4 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    arg2 = (double)jarg2; 
    arg3 = (double)jarg3; 
    arg4 = (double)jarg4; 
    result = (OGRErr)OSRSpatialReferenceShadow_SetEckertIV(arg1,arg2,arg3,arg4);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1SetEckertVI(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    double arg2 ;
    double arg3 ;
    double arg4 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    arg2 = (double)jarg2; 
    arg3 = (double)jarg3; 
    arg4 = (double)jarg4; 
    result = (OGRErr)OSRSpatialReferenceShadow_SetEckertVI(arg1,arg2,arg3,arg4);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1SetEquirectangular(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    double arg2 ;
    double arg3 ;
    double arg4 ;
    double arg5 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    arg2 = (double)jarg2; 
    arg3 = (double)jarg3; 
    arg4 = (double)jarg4; 
    arg5 = (double)jarg5; 
    result = (OGRErr)OSRSpatialReferenceShadow_SetEquirectangular(arg1,arg2,arg3,arg4,arg5);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1SetGS(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    double arg2 ;
    double arg3 ;
    double arg4 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    arg2 = (double)jarg2; 
    arg3 = (double)jarg3; 
    arg4 = (double)jarg4; 
    result = (OGRErr)OSRSpatialReferenceShadow_SetGS(arg1,arg2,arg3,arg4);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1SetWellKnownGeogCS(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (OGRErr)OSRSpatialReferenceShadow_SetWellKnownGeogCS(arg1,(char const *)arg2);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1SetFromUserInput(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (OGRErr)OSRSpatialReferenceShadow_SetFromUserInput(arg1,(char const *)arg2);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1CopyGeogCSFrom(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    OSRSpatialReferenceShadow *arg2 = (OSRSpatialReferenceShadow *) 0 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    arg2 = *(OSRSpatialReferenceShadow **)(void *)&jarg2; 
    result = (OGRErr)OSRSpatialReferenceShadow_CopyGeogCSFrom(arg1,arg2);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1SetTOWGS84(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5, jdouble jarg6, jdouble jarg7, jdouble jarg8) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    double arg2 ;
    double arg3 ;
    double arg4 ;
    double arg5 = (double) 0.0 ;
    double arg6 = (double) 0.0 ;
    double arg7 = (double) 0.0 ;
    double arg8 = (double) 0.0 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    arg2 = (double)jarg2; 
    arg3 = (double)jarg3; 
    arg4 = (double)jarg4; 
    arg5 = (double)jarg5; 
    arg6 = (double)jarg6; 
    arg7 = (double)jarg7; 
    arg8 = (double)jarg8; 
    result = (OGRErr)OSRSpatialReferenceShadow_SetTOWGS84(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1GetTOWGS84(JNIEnv *jenv, jclass jcls, jlong jarg1, jdoubleArray jarg2) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    double *arg2 ;
    OGRErr result;
    jdouble *jarr2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    if (jarg2 && jenv->GetArrayLength(jarg2) != 7) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
        return 0;
    }
    if (!SWIG_JavaArrayInDouble(jenv, &jarr2, &arg2, jarg2)) return 0; 
    result = (OGRErr)OSRSpatialReferenceShadow_GetTOWGS84(arg1,arg2);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    SWIG_JavaArrayArgoutDouble(jenv, jarr2, arg2, jarg2); 
    delete [] arg2; 
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1SetGeogCS(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jstring jarg4, jdouble jarg5, jdouble jarg6, jstring jarg7, jdouble jarg8, jstring jarg9, jdouble jarg10) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    char *arg3 = (char *) 0 ;
    char *arg4 = (char *) 0 ;
    double arg5 ;
    double arg6 ;
    char *arg7 = (char *) "Greenwich" ;
    double arg8 = (double) 0.0 ;
    char *arg9 = (char *) "degree" ;
    double arg10 = (double) 0.0174532925199433 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return 0;
        }
    }
    {
        arg4 = 0;
        if (jarg4) {
            arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
            if (!arg4) return 0;
        }
    }
    arg5 = (double)jarg5; 
    arg6 = (double)jarg6; 
    {
        arg7 = 0;
        if (jarg7) {
            arg7 = (char *)jenv->GetStringUTFChars(jarg7, 0);
            if (!arg7) return 0;
        }
    }
    arg8 = (double)jarg8; 
    {
        arg9 = 0;
        if (jarg9) {
            arg9 = (char *)jenv->GetStringUTFChars(jarg9, 0);
            if (!arg9) return 0;
        }
    }
    arg10 = (double)jarg10; 
    result = (OGRErr)OSRSpatialReferenceShadow_SetGeogCS(arg1,(char const *)arg2,(char const *)arg3,(char const *)arg4,arg5,arg6,(char const *)arg7,arg8,(char const *)arg9,arg10);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    {
        if (arg4) jenv->ReleaseStringUTFChars(jarg4, arg4); 
    }
    {
        if (arg7) jenv->ReleaseStringUTFChars(jarg7, arg7); 
    }
    {
        if (arg9) jenv->ReleaseStringUTFChars(jarg9, arg9); 
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1SetProjCS(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *arg2 = (char *) "unnamed" ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (OGRErr)OSRSpatialReferenceShadow_SetProjCS(arg1,(char const *)arg2);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1ImportFromWkt(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char **arg2 = (char **) 0 ;
    OGRErr result;
    char *val2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    {
        /* %typemap(in) (char **ignorechange) */
        val2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
        arg2 = &val2;
    }
    result = (OGRErr)OSRSpatialReferenceShadow_ImportFromWkt(arg1,arg2);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(freearg) (char **ignorechange) */
        jenv->ReleaseStringUTFChars(jarg2, val2);
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1ImportFromProj4(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (OGRErr)OSRSpatialReferenceShadow_ImportFromProj4(arg1,arg2);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1ImportFromESRI(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char **arg2 = (char **) 0 ;
    OGRErr result;
    char *val2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    {
        /* %typemap(in) (char **ignorechange) */
        val2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
        arg2 = &val2;
    }
    result = (OGRErr)OSRSpatialReferenceShadow_ImportFromESRI(arg1,arg2);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(freearg) (char **ignorechange) */
        jenv->ReleaseStringUTFChars(jarg2, val2);
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1ImportFromEPSG(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    int arg2 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    result = (OGRErr)OSRSpatialReferenceShadow_ImportFromEPSG(arg1,arg2);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1ImportFromPCI(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jdoubleArray jarg4) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    char *arg3 = (char *) "METRE" ;
    double *arg4 = (double *) (double *)0 ;
    OGRErr result;
    jboolean isCopy4 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return 0;
        }
    }
    {
        /* %typemap(in) (double argin[ANY]) */
        arg4 = (double *)jenv->GetDoubleArrayElements(jarg4, &isCopy4);
    }
    result = (OGRErr)OSRSpatialReferenceShadow_ImportFromPCI(arg1,(char const *)arg2,(char const *)arg3,arg4);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(argout) (double argin[ANY]) */
    }
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    {
        /* %typemap(in) (double argin[ANY]) */
        if(isCopy4 == JNI_TRUE) {
            jenv->ReleaseDoubleArrayElements(jarg4, (jdouble *)arg4, 0);
        }
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1ImportFromUSGS(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jdoubleArray jarg4, jint jarg5) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    long arg2 ;
    long arg3 = (long) 0 ;
    double *arg4 = (double *) (double *)0 ;
    long arg5 = (long) 0 ;
    OGRErr result;
    jboolean isCopy4 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    arg2 = (long)jarg2; 
    arg3 = (long)jarg3; 
    {
        /* %typemap(in) (double argin[ANY]) */
        arg4 = (double *)jenv->GetDoubleArrayElements(jarg4, &isCopy4);
    }
    arg5 = (long)jarg5; 
    result = (OGRErr)OSRSpatialReferenceShadow_ImportFromUSGS(arg1,arg2,arg3,arg4,arg5);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(argout) (double argin[ANY]) */
    }
    {
        /* %typemap(in) (double argin[ANY]) */
        if(isCopy4 == JNI_TRUE) {
            jenv->ReleaseDoubleArrayElements(jarg4, (jdouble *)arg4, 0);
        }
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1ImportFromXML(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (OGRErr)OSRSpatialReferenceShadow_ImportFromXML(arg1,(char const *)arg2);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1ExportToWkt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobjectArray jarg2) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char **arg2 = (char **) 0 ;
    OGRErr result;
    char *argout2 = 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    {
        /* %typemap(in) (char **argout2) */
        arg2 = &argout2;
    }
    result = (OGRErr)OSRSpatialReferenceShadow_ExportToWkt(arg1,arg2);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(argout) (char **argout) */
        jstring temp_string;
        
        if((int)jenv->GetArrayLength(jarg2) >= 1) {
            temp_string = jenv->NewStringUTF(argout2);
            jenv->SetObjectArrayElement(jarg2, 0, temp_string);
            jenv->DeleteLocalRef(temp_string);
        }
    }
    {
        /* %typemap(freearg) (char **argout) */
        if(arg2) {
            free((void *)argout2);
        }
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1ExportToPrettyWkt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobjectArray jarg2, jint jarg3) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char **arg2 = (char **) 0 ;
    int arg3 = (int) 0 ;
    OGRErr result;
    char *argout2 = 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    {
        /* %typemap(in) (char **argout2) */
        arg2 = &argout2;
    }
    arg3 = (int)jarg3; 
    result = (OGRErr)OSRSpatialReferenceShadow_ExportToPrettyWkt(arg1,arg2,arg3);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(argout) (char **argout) */
        jstring temp_string;
        
        if((int)jenv->GetArrayLength(jarg2) >= 1) {
            temp_string = jenv->NewStringUTF(argout2);
            jenv->SetObjectArrayElement(jarg2, 0, temp_string);
            jenv->DeleteLocalRef(temp_string);
        }
    }
    {
        /* %typemap(freearg) (char **argout) */
        if(arg2) {
            free((void *)argout2);
        }
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1ExportToProj4(JNIEnv *jenv, jclass jcls, jlong jarg1, jobjectArray jarg2) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char **arg2 = (char **) 0 ;
    OGRErr result;
    char *argout2 = 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    {
        /* %typemap(in) (char **argout2) */
        arg2 = &argout2;
    }
    result = (OGRErr)OSRSpatialReferenceShadow_ExportToProj4(arg1,arg2);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(argout) (char **argout) */
        jstring temp_string;
        
        if((int)jenv->GetArrayLength(jarg2) >= 1) {
            temp_string = jenv->NewStringUTF(argout2);
            jenv->SetObjectArrayElement(jarg2, 0, temp_string);
            jenv->DeleteLocalRef(temp_string);
        }
    }
    {
        /* %typemap(freearg) (char **argout) */
        if(arg2) {
            free((void *)argout2);
        }
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1ExportToPCI(JNIEnv *jenv, jclass jcls, jlong jarg1, jobjectArray jarg2, jobjectArray jarg3, jdoubleArray jarg4) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char **arg2 = (char **) 0 ;
    char **arg3 = (char **) 0 ;
    double **arg4 ;
    OGRErr result;
    char *argout2 = 0 ;
    char *argout3 = 0 ;
    double *argout4[17] ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    {
        /* %typemap(in) (char **argout2) */
        arg2 = &argout2;
    }
    {
        /* %typemap(in) (char **argout3) */
        arg3 = &argout3;
    }
    {
        /* %typemap(in) (double *argout4[ANY]) */
        arg4 = argout4;
    }
    result = (OGRErr)OSRSpatialReferenceShadow_ExportToPCI(arg1,arg2,arg3,arg4);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(argout) (char **argout) */
        jstring temp_string;
        
        if((int)jenv->GetArrayLength(jarg2) >= 1) {
            temp_string = jenv->NewStringUTF(argout2);
            jenv->SetObjectArrayElement(jarg2, 0, temp_string);
            jenv->DeleteLocalRef(temp_string);
        }
    }
    {
        /* %typemap(argout) (char **argout) */
        jstring temp_string;
        
        if((int)jenv->GetArrayLength(jarg3) >= 1) {
            temp_string = jenv->NewStringUTF(argout3);
            jenv->SetObjectArrayElement(jarg3, 0, temp_string);
            jenv->DeleteLocalRef(temp_string);
        }
    }
    {
        /* %typemap(argout) (double *argout[ANY]) */
        jenv->SetDoubleArrayRegion(jarg4, (jsize)0, (jsize)17, arg4[0]);
    }
    {
        /* %typemap(freearg) (char **argout) */
        if(arg2) {
            free((void *)argout2);
        }
    }
    {
        /* %typemap(freearg) (char **argout) */
        if(arg3) {
            free((void *)argout3);
        }
    }
    {
        /* %typemap(freearg) (double *argout[ANY]) */
        CPLFree(arg4);
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1ExportToUSGS(JNIEnv *jenv, jclass jcls, jlong jarg1, jintArray jarg2, jintArray jarg3, jdoubleArray jarg4, jintArray jarg5) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    long *arg2 = (long *) 0 ;
    long *arg3 = (long *) 0 ;
    double **arg4 ;
    long *arg5 = (long *) 0 ;
    OGRErr result;
    long temp2 ;
    long temp3 ;
    double *argout4[15] ;
    long temp5 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    {
        if (!jarg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return 0;
        }
        if (jenv->GetArrayLength(jarg2) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return 0;
        }
        arg2 = &temp2; 
    }
    {
        if (!jarg3) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return 0;
        }
        if (jenv->GetArrayLength(jarg3) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return 0;
        }
        arg3 = &temp3; 
    }
    {
        /* %typemap(in) (double *argout4[ANY]) */
        arg4 = argout4;
    }
    {
        if (!jarg5) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return 0;
        }
        if (jenv->GetArrayLength(jarg5) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return 0;
        }
        arg5 = &temp5; 
    }
    result = (OGRErr)OSRSpatialReferenceShadow_ExportToUSGS(arg1,arg2,arg3,arg4,arg5);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        jint jvalue = (jint)temp2;
        jenv->SetIntArrayRegion(jarg2, 0, 1, &jvalue);
    }
    {
        jint jvalue = (jint)temp3;
        jenv->SetIntArrayRegion(jarg3, 0, 1, &jvalue);
    }
    {
        /* %typemap(argout) (double *argout[ANY]) */
        jenv->SetDoubleArrayRegion(jarg4, (jsize)0, (jsize)15, arg4[0]);
    }
    {
        jint jvalue = (jint)temp5;
        jenv->SetIntArrayRegion(jarg5, 0, 1, &jvalue);
    }
    
    
    {
        /* %typemap(freearg) (double *argout[ANY]) */
        CPLFree(arg4);
    }
    
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1ExportToXML(JNIEnv *jenv, jclass jcls, jlong jarg1, jobjectArray jarg2, jstring jarg3) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    char **arg2 = (char **) 0 ;
    char *arg3 = (char *) "" ;
    OGRErr result;
    char *argout2 = 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    {
        /* %typemap(in) (char **argout2) */
        arg2 = &argout2;
    }
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return 0;
        }
    }
    result = (OGRErr)OSRSpatialReferenceShadow_ExportToXML(arg1,arg2,(char const *)arg3);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(argout) (char **argout) */
        jstring temp_string;
        
        if((int)jenv->GetArrayLength(jarg2) >= 1) {
            temp_string = jenv->NewStringUTF(argout2);
            jenv->SetObjectArrayElement(jarg2, 0, temp_string);
            jenv->DeleteLocalRef(temp_string);
        }
    }
    {
        /* %typemap(freearg) (char **argout) */
        if(arg2) {
            free((void *)argout2);
        }
    }
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1CloneGeogCS(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    OSRSpatialReferenceShadow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    result = (OSRSpatialReferenceShadow *)OSRSpatialReferenceShadow_CloneGeogCS(arg1);
    
    *(OSRSpatialReferenceShadow **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1Validate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    result = (OGRErr)OSRSpatialReferenceShadow_Validate(arg1);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1StripCTParms(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    result = (OGRErr)OSRSpatialReferenceShadow_StripCTParms(arg1);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1FixupOrdering(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    result = (OGRErr)OSRSpatialReferenceShadow_FixupOrdering(arg1);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1Fixup(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    result = (OGRErr)OSRSpatialReferenceShadow_Fixup(arg1);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1MorphToESRI(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    result = (OGRErr)OSRSpatialReferenceShadow_MorphToESRI(arg1);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_osr_osrJNI_SpatialReference_1MorphFromESRI(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    result = (OGRErr)OSRSpatialReferenceShadow_MorphFromESRI(arg1);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_osr_osrJNI_new_1CoordinateTransformation(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    OSRSpatialReferenceShadow *arg1 = (OSRSpatialReferenceShadow *) 0 ;
    OSRSpatialReferenceShadow *arg2 = (OSRSpatialReferenceShadow *) 0 ;
    OSRCoordinateTransformationShadow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRSpatialReferenceShadow **)(void *)&jarg1; 
    arg2 = *(OSRSpatialReferenceShadow **)(void *)&jarg2; 
    result = (OSRCoordinateTransformationShadow *)new_OSRCoordinateTransformationShadow(arg1,arg2);
    
    *(OSRCoordinateTransformationShadow **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_osr_osrJNI_delete_1CoordinateTransformation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    OSRCoordinateTransformationShadow *arg1 = (OSRCoordinateTransformationShadow *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRCoordinateTransformationShadow **)(void *)&jarg1; 
    delete_OSRCoordinateTransformationShadow(arg1);
    
}


JNIEXPORT void JNICALL Java_org_gdal_osr_osrJNI_CoordinateTransformation_1TransformPoint_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jdoubleArray jarg2) {
    OSRCoordinateTransformationShadow *arg1 = (OSRCoordinateTransformationShadow *) 0 ;
    double *arg2 ;
    jboolean isCopy2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRCoordinateTransformationShadow **)(void *)&jarg1; 
    {
        /* %typemap(in) (double argin[ANY]) */
        arg2 = (double *)jenv->GetDoubleArrayElements(jarg2, &isCopy2);
    }
    OSRCoordinateTransformationShadow_TransformPoint__SWIG_0(arg1,arg2);
    
    {
        /* %typemap(argout) (double argin[ANY]) */
    }
    {
        /* %typemap(in) (double argin[ANY]) */
        if(isCopy2 == JNI_TRUE) {
            jenv->ReleaseDoubleArrayElements(jarg2, (jdouble *)arg2, 0);
        }
    }
}


JNIEXPORT void JNICALL Java_org_gdal_osr_osrJNI_CoordinateTransformation_1TransformPoint_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jdoubleArray jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5) {
    OSRCoordinateTransformationShadow *arg1 = (OSRCoordinateTransformationShadow *) 0 ;
    double *arg2 ;
    double arg3 ;
    double arg4 ;
    double arg5 = (double) 0.0 ;
    jdouble *jarr2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OSRCoordinateTransformationShadow **)(void *)&jarg1; 
    if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
        return ;
    }
    if (!SWIG_JavaArrayInDouble(jenv, &jarr2, &arg2, jarg2)) return ; 
    arg3 = (double)jarg3; 
    arg4 = (double)jarg4; 
    arg5 = (double)jarg5; 
    OSRCoordinateTransformationShadow_TransformPoint__SWIG_1(arg1,arg2,arg3,arg4,arg5);
    
    SWIG_JavaArrayArgoutDouble(jenv, jarr2, arg2, jarg2); 
    delete [] arg2; 
}


#ifdef __cplusplus
}
#endif

