/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.xs.AbstractDateTimeDV;
import org.apache.xerces.impl.dv.xs.SchemaDateTimeException;
import org.apache.xerces.impl.validation.ValidationContext;

public class MonthDayDV
extends AbstractDateTimeDV {
    private static final int MONTHDAY_SIZE = 7;

    public Object getActualValue(String string, ValidationContext validationContext) throws InvalidDatatypeValueException {
        try {
            return this.parse(string, null);
        }
        catch (Exception exception) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string, "gMonthDay"});
        }
    }

    protected int[] parse(String string, int[] nArray) throws SchemaDateTimeException {
        this.resetBuffer(string);
        if (nArray == null) {
            nArray = new int[8];
        }
        this.resetDateObj(nArray);
        nArray[0] = 2001;
        if (this.fBuffer.charAt(0) != '-' || this.fBuffer.charAt(1) != '-') {
            throw new SchemaDateTimeException("Invalid format for gMonthDay: " + string);
        }
        nArray[1] = this.parseInt(this.fStart + 2, this.fStart + 4);
        this.fStart += 4;
        if (this.fBuffer.charAt(this.fStart++) != '-') {
            throw new SchemaDateTimeException("Invalid format for gMonthDay: " + string);
        }
        nArray[2] = this.parseInt(this.fStart, this.fStart + 2);
        if (7 < this.fEnd) {
            int n = this.findUTCSign(7, this.fEnd);
            if (n < 0) {
                throw new SchemaDateTimeException("Error in month parsing:" + string);
            }
            this.getTimeZone(nArray, n);
        }
        this.validateDateTime(nArray);
        if (nArray[7] != 0 && nArray[7] != 90) {
            this.normalize(nArray);
        }
        return nArray;
    }

    protected String dateToString(int[] nArray) {
        this.message.setLength(0);
        this.message.append('-');
        this.message.append('-');
        this.message.append(nArray[1]);
        this.message.append('-');
        this.message.append(nArray[2]);
        this.message.append((char)nArray[7]);
        return this.message.toString();
    }
}

