package GCPlugins::GCfilms::GCFilmWeb;

###################################################
#
#  Copyright 2005-2006 Tian
#
#  This file is part of GCstar.
#
#  GCstar is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCstar is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCstar; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;
use utf8;

use GCPlugins::GCfilms::GCfilmsCommon;

{
    package GCPlugins::GCfilms::GCPluginFilmWeb;

    use base qw(GCPlugins::GCfilms::GCfilmsPluginsBase);

    sub start
    {
        my ($self, $tagname, $attr, $attrseq, $origtext) = @_;
	
        $self->{inside}->{$tagname}++;
		
        if ($self->{parsingList})
        {
            if ($self->{parsingEnded})
            {
                if (($tagname eq 'input')
                 && ($attr->{name} eq 'id'))
                {
                    $self->{itemIdx} = 0;
                    $self->{itemsList}[0]->{title} = '';
                    $self->{itemsList}[0]->{url} = 'http://www.filmweb.pl/Film?id='. $attr->{value};
                }
            }
            
            if (($tagname eq 'img')
             && ($attr->{src} eq 'http://gfx.filmweb.pl/gf/ic/lu.gif')
             && ($self->{insideResults} != -1))
            {
                $self->{insideResults} = 1;
            }
            
            if (($tagname eq 'form')
             && ($self->{insideResults} == 1))
            {
                $self->{insideResults} = -1;
            }
            
            if (($tagname eq 'a')
             && ($self->{insideResults} == 1))
            {
                $self->{isMovie} = 1;
                $self->{itemIdx}++;
                $self->{itemsList}[$self->{itemIdx}]->{url} = $attr->{href};
            }
        }
        else
        {
            if ($tagname eq 'div')
            { 
                $self->{isTitle} = 1
                    if ($attr->{id} eq 'filmTitle');
                $self->{isImage} = 1
                    if ($attr->{id} eq 'filmPhoto');
                $self->{isActors} = 1
                    if ($attr->{class} eq 'filmActor');
            }
            elsif ($tagname eq 'span')
            {
                $self->{isOrig} = 1
                    if ($attr->{class} eq 'otherTitle');
            }
            elsif ($tagname eq 'a')
            {
                $self->{isCountry} = 1
                    if (! ($self->{curInfo}->{date} || $self->{curInfo}->{type}))
                    && ($attr->{href} =~ m|/film/top/world\?country\.id=|);
                $self->{isGenre} = 1
                    if ($attr->{href} =~ m|/film/top/world\?genre\.id=|);
                if ($attr->{href} =~ m|,FilmDescriptions,|)
                {
                    my $page = $self->loadPage($attr->{href});
                    $page =~ m|<li><div align="justify">(.*?)</div></li>|ms;
                    $self->{curInfo}->{synopsis} = $1;
                    $self->{curInfo}->{synopsis} =~ s/<br\/>/<br>/gi;
                    $self->{curInfo}->{synopsis} =~ s/\n//gm;
                }
            }
            elsif ($tagname eq 'td')
            {
                $self->{isPreDate} = 1
                    if ($attr->{class} eq 'gr3');
            }
            elsif ($tagname eq 'b')
            {
                if ($self->{isPreDate})
                {
                    $self->{isDate} = 1;
                    $self->{isPreDate} = 0;
                }
            }
            elsif ($tagname eq 'img')
            {
                if ($self->{isImage})
                {
                    $self->{curInfo}->{image} = $attr->{src};
                    $self->{isImage} = 0;
                }
            }
        }
    }

    sub end
    {
		my ($self, $tagname) = @_;
		
        $self->{inside}->{$tagname}--;
    }

    sub text
    {
        my ($self, $origtext) = @_;

        if ($self->{parsingList})
        {
            if ($self->{inside}->{title})
            {
                $self->{parsingEnded} = 1
                    if $origtext !~ /Filmweb\.pl - /;
            }
            if ($self->{parsingEnded})
            {
                return;
            }
            if ($self->{isMovie})
            {
                $origtext =~ s/^\s*//m;
                $origtext =~ s/\s*$//m;
                $origtext =~ s|\s*\([[:alpha:].]*\)$||;
                return if !$origtext;
                #$origtext =~ m|^([^/]*?)(/[^(]*)?.*?\(([0-9]{4})\)$|;
                $origtext =~ m|(.*?)\(([0-9]{4})\)$|;
                
                $self->{itemsList}[$self->{itemIdx}]->{title} = $1;
                $self->{itemsList}[$self->{itemIdx}]->{date} = $2;
                $self->{isMovie} = 0;
            }
        }
        else
        {
            $origtext =~ s/^\s*//m;
            $origtext =~ s/\s*$//m;
                 
            return if !$origtext;       
            if ($self->{isTitle})
            {
                $self->{curInfo}->{title} = $origtext;
                $self->{isTitle} = 0;
            }
            elsif ($self->{isOrig})
            {
                $self->{curInfo}->{original} = $origtext
                    if $origtext !~ /\(/;
                $self->{isOrig} = 0;   
            }
            elsif ($self->{isCountry})
            {
                $self->{curInfo}->{country} .= $self->{curInfo}->{country} ? ", " . $origtext : $origtext;
                $self->{isCountry} = 0;
            }
            elsif ($self->{isGenre})
            {
                $self->{curInfo}->{genre} .= $self->{curInfo}->{genre} ? ", " . $origtext : $origtext;
                $self->{isGenre} = 0;
            }
            elsif ($self->{isDate})
            {
                $self->{curInfo}->{date} = $origtext;
                $self->{isDate} = 0;   
            }
            elsif ($self->{inside}->{details})
            {
                $origtext =~ m/re.yseria\s*(.+?)\s*scenariusz/gms;
                $self->{curInfo}->{director} = $1;
                $self->{curInfo}->{director} =~ s/\s+/ /g;
                
                $origtext =~ m/od lat: ([0-9]*)/;
                $self->{curInfo}->{age} = $1;

                $origtext =~ m/czas trwania: ([0-9]*)/;
                $self->{curInfo}->{time} = $1;
            }
            elsif ($self->{isActors})
            {
                $self->{curInfo}->{actors} .= $self->{curInfo}->{actors} ? ", " . $origtext : $origtext
                    if ($self->{actorsCounter} < $GCPlugins::GCfilms::GCfilmsCommon::MAX_ACTORS);
                $self->{actorsCounter}++;
                $self->{isActors} = 0;
            }            
        }
    } 

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{hasField} = {
            title => 1,
            date => 1,
            director => 0,
            actors => 0
        };

        $self->{isInfo} = 0;
        $self->{isMovie} = 0;
        $self->{curName} = undef;
        $self->{curUrl} = undef;

        return $self;
    }

    sub preProcess
    {
        my ($self, $html) = @_;

        $self->{parsingEnded} = 0;
        $self->{insideResults} = 0;
        $self->{actorsCounter} = 0;

        if (!$self->{parsingList})
        {
            $html =~ s|<div style="margin: 0px 15px 5px 15px; font-family: Verdana, Geneva, Arial, Helvetica, sans-serif; font-size: 11px;">(.*?)</div>|<details>$1</details></div>|gms;
            #$html =~ s|<\!-- z backup -->(.*?)</div>|<details>$1</details></div>|gms;
            my $details = $1;
            $details =~ s|<a[^>]*>([^<]*)</a>|$1|gms;
            $html =~ s|<details>(.*?)</details>|<details>$details</details>|gms;
        }
        $html =~ s|<span style='color: #8D0000;'>(.*?)</span>|$1|gm;
        $html =~ s|<span style="font-size: 15px">(.*?)</span>|$1|gm;

        return $html;
    }
    
    sub getSearchUrl
    {
		my ($self, $word) = @_;
	
        return "http://www.filmweb.pl/Find?query=$word&category=1&submit=szukaj";
    }
    
    sub getItemUrl
    {
		my ($self, $url) = @_;
		
        return $url unless $url eq '';
        return "filmweb.pl";
    }

    sub changeUrl
    {
        my ($self, $url) = @_;
        
        return $url;
    }

    sub getName
    {
        return "FilmWeb";
    }
    
    sub getImageFile
    {
        return "filmaffinity.png";
    }

    sub getCharset
    {
        my $self = shift;
    
        #return "UTF-8";
        return "ISO-8859-2";
    }

    sub getAuthor
    {
        return 'Tian';
    }
    
    sub getLang
    {
        return 'PL';
    }
}

1;
