{
    package GCLang;
    
###################################################
#
#  Copyright 2005-2006 Tian
#
#  This file is part of GCstar.
#
#  GCstar is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCstar is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCstar; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;

use base 'Exporter';
our @EXPORT = qw(%langs @langsNames);

use File::Basename;
use FindBin qw($RealBin $Script);
use GCUtils 'glob';
    
our %langs;
our @langsNames = ();

sub loadLangs
{
    return if $#langsNames > 0;
    foreach (glob $ENV{GCS_LIB_DIR}.'/GCLang/*')
    {
        next if /CVS/ || /pm$/;
        my $lang = basename($_);
        eval "use GCLang::${lang}::GCstar";
        my %tmpLang;
        eval "%tmpLang = %GCLang::${lang}::lang";
        $langs{$lang} = \%tmpLang;
    }

    foreach (keys %langs)
    {
        push @langsNames, $langs{$_}->{LangName};
    }
    @langsNames = sort @langsNames;
}

# TODO Make it working with GCstar
# Used to check languages (which translation are missing)
# Usage: perl -e "use GCLang; GCLang::checkLangs"
sub checkLangs
{
    my $ref = 'FR';
    my $otherRef = 'EN';
    my %results;
    
    foreach (sort keys %{$langs{$ref}})
    {
        foreach my $langName(keys %langs)
        {
            next if $langName eq $ref;
            if (! exists $langs{$langName}->{$_})
            {
                push @{$results{$langName}{error}}, $_;
            }
            else
            {
                next if $langName eq $otherRef;
                push @{$results{$langName}{warning}}, $_
                    if ($langs{$langName}->{$_} eq $langs{$ref}->{$_})
                    || ($langs{$langName}->{$_} eq $langs{$otherRef}->{$_});
            }
        }
    }
    
    foreach (keys %results)
    {
        print "\n\nLang $_\n-------\n\n";
        print "Errors:\n\n";
        foreach my $value(@{$results{$_}{error}})
        {
            print "'$value' => '",$langs{$otherRef}->{$value},"',\n";
        }
        print "\nWarnings:\n\n";
        foreach my $value(@{$results{$_}{warning}})
        {
            print "'$value' => '",$langs{$_}->{$value},"',\n";
        }
    }
}

    
}


1;
