/*
** Copyright (C) 12 Mar 1999 Jonas Munsin <jmunsin@iki.fi>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "menu.h"
#include "vector_commands.h"
#include "contractions.h"
#include "cdlabel.h"
#include "common_gtk.h"
#include "locks.h"
#include "filepicker.h"
#include "modify_file_set.h"
#include "selection_IO.h"
#include "clist_common.h"
#include "preferences.h"
#include "mainwindow.h"
#include "command.h"
#include "globals.h"

static void quit_cmd_callback(GtkWidget *, gpointer);
static void about_cmd_callback(GtkWidget *, gpointer);
static void load_selection_callback(GtkWidget *, gpointer);
static void save_data_selection_callback(GtkWidget *, gpointer);
static void save_data_selection_as_callback(GtkWidget *, gpointer);
static void save_audio_selection_callback(GtkWidget *, gpointer);
static void save_audio_selection_as_callback(GtkWidget *, gpointer);
static void trayaction_cmd_callback(GtkWidget *, guint);
static char *last_saved_data_selection = NULL, *last_saved_audio_selection = NULL;

static GtkItemFactoryEntry menu_items[] =
{
	{N_("/_File"), NULL, NULL, 0, "<Branch>"},
	{N_("/File/_Print cover"), "<control>P", print_cmd_callback, 0, NULL},
	{N_("/File/P_references..."), "<control>R", preferences_cmd_callback, 0, NULL},
	{N_("/File/sep"), NULL, NULL, 0, "<Separator>"},
	{N_("/File/_Eject cd-r"), "<control>E", trayaction_cmd_callback, TRAY_EJECT, NULL},
	{N_("/File/_Close cd-r"), "<control>C", trayaction_cmd_callback, TRAY_CLOSE, NULL},
	{N_("/File/sep"), NULL, NULL, 0, "<Separator>"},
	{N_("/File/_Quit"), "<control>Q", quit_cmd_callback, 0, NULL},
	{N_("/File selection"), NULL, NULL, 0, "<Branch>"},
	{N_("/File selection/_Load selection"), "<control>L", load_selection_callback,
			0, NULL},
	{N_("/File selection/sep"), NULL, NULL, 0, "<Separator>"},
	{N_("/File selection/_Save data selection"), "<control>S", save_data_selection_callback,
			0, NULL},
	{N_("/File selection/_Save data selection as..."), NULL, save_data_selection_as_callback,
			0, NULL},
	{N_("/File selection/sep"), NULL, NULL, 0, "<Separator>"},
	{N_("/File selection/Save audio selection"), NULL, save_audio_selection_callback,
			0, NULL},
	{N_("/File selection/Save audio selection as..."), NULL, save_audio_selection_as_callback,
			0, NULL},
	{N_("/_Help"), NULL, NULL, 0, "<LastBranch>"},
	{N_("/Help/_About"), NULL, about_cmd_callback, 0, NULL}
};

static void call_load_selection(GtkWidget *widget, gpointer data) {
	load_selection(gtk_file_selection_get_filename(data));
	gtk_widget_destroy(GTK_WIDGET(data));
}

static void load_selection_callback(GtkWidget *widget, gpointer data) {
	choose_file_at(def_selection_path, (gpointer) call_load_selection);
}

static void save_data_selection_callback(GtkWidget *widget, gpointer data) {
	if (NULL != last_saved_data_selection)
		save_selection(last_saved_data_selection, 0);
	else
		save_data_selection_as_callback(NULL, 0);
}

static void call_save_data_selection(GtkWidget *widget, gpointer data) {
	if (last_saved_data_selection)
			free(last_saved_data_selection);
	last_saved_data_selection = strdup(gtk_file_selection_get_filename(data));
	save_selection(last_saved_data_selection, 0);
	gtk_widget_destroy(GTK_WIDGET(data));
}

static void save_data_selection_as_callback(GtkWidget *widget, gpointer data) {
	choose_file_at(def_selection_path, (gpointer) call_save_data_selection);
}

static void save_audio_selection_callback(GtkWidget *widget, gpointer data) {
	if (NULL != last_saved_audio_selection)
		save_selection(last_saved_audio_selection, 1);
	else
		save_audio_selection_as_callback(NULL, (gpointer)1);
}

static void call_save_audio_selection(GtkWidget *widget, gpointer data) {
	if (last_saved_audio_selection)
			free(last_saved_audio_selection);
	last_saved_audio_selection = strdup(gtk_file_selection_get_filename(data));
	save_selection(last_saved_audio_selection, 1);
	gtk_widget_destroy(GTK_WIDGET(data));
}

static void save_audio_selection_as_callback(GtkWidget *widget, gpointer data) {
	choose_file_at(def_selection_path, (gpointer) call_save_audio_selection);
}

static void dont_quit(GtkWidget *widget, gpointer data) {
	gtk_widget_destroy(GTK_WIDGET(data));
}                       

/* FIXME: this one doesn't belong in menu.c, really... */

void ask_really_sure(void) {
	GtkWidget *ask, *yes, *no, *label;

	ask = gtk_dialog_new();
	gtk_widget_show(ask);
	label = gtk_label_new(_("Something (mkisofs or cdrecord) is still running,\n"
				"are you really sure you want to exit?"));
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ask)->vbox), label, FALSE, FALSE, 10);
	gtk_widget_show(label);

	yes = gtk_button_new_with_label(_("Yes"));
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ask)->action_area), yes, FALSE, FALSE, 10);
	gtk_widget_show(yes);
	no = gtk_button_new_with_label(_("No"));
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ask)->action_area), no, FALSE, FALSE, 10);
	gtk_widget_show(no);

	gtk_signal_connect(GTK_OBJECT(yes), "clicked",
			GTK_SIGNAL_FUNC(exit_program), (gpointer) ask);
	gtk_signal_connect(GTK_OBJECT(no), "clicked",
			GTK_SIGNAL_FUNC(dont_quit), (gpointer) ask);
}

static void quit_cmd_callback(GtkWidget *widget, gpointer data) {
	if (check_if_running())
		ask_really_sure();
	else
		exit_program();
}

static void about_cmd_callback(GtkWidget *widget, gpointer data) {
	GtkWidget *about_win, *label, *ok;
	char *info_text;

	about_win = gtk_dialog_new();
	gtk_widget_show(about_win);

	info_text = g_strdup_printf("gcombust version %s\n(c) 1999, 2000, 2001 Jonas Munsin <jmunsin@iki.fi>\nReleased under GPL.\n\n I plan to graduate soon.\n Interesting and/or well-paid job offers are welcome ;-) \n CV at http://www.iki.fi/jmunsin/CV.eng  ", VERSION);
	label = gtk_label_new(info_text);
	g_free(info_text);

	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(about_win)->vbox), label,
			TRUE, TRUE, 10);
	gtk_widget_show(label);

	ok = gtk_button_new_with_label(_("OK"));
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(about_win)->action_area), ok, FALSE, FALSE, 10);
	gtk_signal_connect(GTK_OBJECT(ok), "clicked",
			GTK_SIGNAL_FUNC(close_dialog), (gpointer) about_win);
	GTK_WIDGET_SET_FLAGS(ok, GTK_CAN_DEFAULT);
	gtk_widget_grab_default(ok);
	gtk_widget_show(ok);

}
GtkWidget *create_menu(void) {
	GtkWidget *menubar;
	GtkItemFactory *item_factory;
	GtkAccelGroup *acc_group;
	int i, n;

	/* FIXME: this should probably be somewhere else... */
	if (NULL == def_selection_path)
		def_selection_path = g_strdup("");

	acc_group = gtk_accel_group_new();
	item_factory = gtk_item_factory_new(GTK_TYPE_MENU_BAR, "<main>", acc_group);

	/* translate menu items */
	n = sizeof(menu_items) / sizeof(menu_items[0]);
	for (i = 0; i < n; i++) {
		menu_items[i].path = gettext((menu_items[i].path));
	};                                                                              
	gtk_item_factory_create_items(item_factory,
			sizeof(menu_items)/sizeof(menu_items[0]), menu_items, NULL);

	gtk_accel_group_attach(acc_group, GTK_OBJECT(mainwindow));

	menubar = gtk_item_factory_get_widget(item_factory, "<main>");

	mainptr->menu = gtk_item_factory_get_widget(item_factory, "<main>");
	
	gtk_widget_show(menubar);

	return menubar;
}

static void trayaction_cmd_callback(GtkWidget *widget, guint action) {
	cmd_v *cdr_cmd;
	FILE *output;

	cdr_cmd = make_cdrecord_trayaction_command(mainptr->cdr_option_info, action);

	if (NULL == (output = popen_r_stdout(cdr_cmd))) {
		g_warning("%s::%i: popen failed for tray action", __FILE__, __LINE__);
		destroy_cmd(cdr_cmd);
	} else {
		destroy_cmd(cdr_cmd);
		pclose(output);
	}
}

