/*
  GNOME Comics Organizer
  Copyright (C) 1999-2001 Maxximum Software
   
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <glade/glade.h>

#include "fileops.h"
#include "fileops-helper.h"
#include "debug.h"

extern GladeXML *xml;
extern GString *GLADE_FILE;
extern GList *ComicList;

extern gchar *new_filename;
extern gchar *current_filename;
extern gboolean file_changed;

extern gchar *MainWindowKey;
extern gchar *ComicListKey;
extern gchar *ComicToAddKey;
extern gchar *ComicToAddToKey;
extern gchar *ComicToEditKey;
extern gchar *IssueToEditKey;

void real_save_file(GtkWidget *main_window)
{
  GString *wintitle;
  FILE *fp;

  wintitle = g_string_new(NULL);
  fp = my_open (new_filename, "w");
  if (fp == NULL)
    {
      gnome_app_flash(GNOME_APP(main_window), "Unable to save file.");
      return;
    }
  SaveFile(ComicList, fp);
  current_filename = new_filename;
  gnome_app_flash(GNOME_APP(main_window), "File saved.");
  g_string_sprintf(wintitle, "GNOME Comics Organizer - %s", g_basename(current_filename));
  gtk_window_set_title (GTK_WINDOW (main_window), wintitle->str);
  file_changed = FALSE;
  my_close(fp);
}

gboolean on_save_file_selection_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
  GtkWidget *save_file_selection;
  GladeXML *temp_xml = user_data;

  save_file_selection = glade_xml_get_widget (temp_xml, "save_file_selection");
  gtk_widget_destroy (save_file_selection);

  return FALSE;
}

void on_save_file_selection_ok_button_clicked (GtkButton *button, gpointer user_data)
{
  GtkWidget *main_window, *save_file_selection;
  GString *temp;
  GladeXML *temp_xml = user_data;

  save_file_selection = glade_xml_get_widget (temp_xml, "save_file_selection");
  main_window = gtk_object_get_data (GTK_OBJECT (save_file_selection), MainWindowKey);

  /* FIXME - very ugly hack to make sure sufficient space is allocated for current_filename */
  temp = g_string_new (NULL);
  g_string_sprintf (temp, "%s", gtk_file_selection_get_filename (GTK_FILE_SELECTION (save_file_selection)));
  new_filename = temp->str;

  if (file_exists (new_filename))
    {
      // show Yes/No dialog
      GtkWidget* mbox;
      GString *question;
      int reply;

      question = g_string_new (new_filename);
      question = g_string_append (question, " already exists\n");
      question = g_string_append (question, "Overwrite it?");
      
      mbox = gnome_message_box_new (question->str, 
				    GNOME_MESSAGE_BOX_QUESTION,
				    GNOME_STOCK_BUTTON_YES,
				    GNOME_STOCK_BUTTON_NO,
				    NULL);

      gtk_window_set_modal (GTK_WINDOW (mbox), TRUE);
      reply = gnome_dialog_run (GNOME_DIALOG(mbox));

      if (reply == GNOME_OK)
	{
	  real_save_file (main_window);
	  gtk_widget_destroy (save_file_selection);
	}
    }
  else
    {
      real_save_file (main_window);
      gtk_widget_destroy (save_file_selection);
    }
}

void on_save_file_selection_cancel_button_clicked (GtkButton *button, gpointer user_data)
{
  GtkWidget *save_file_selection;
  GladeXML *temp_xml = user_data;

  save_file_selection = glade_xml_get_widget (temp_xml, "save_file_selection");
  gtk_widget_destroy (save_file_selection);
}



void show_save_dialog ()
{
  GtkWidget *main_window, *save_file_selection = NULL;
  GladeXML *temp_xml;
 
  main_window = glade_xml_get_widget (xml, "main_window");

  temp_xml = glade_xml_new (GLADE_FILE->str, "save_file_selection");
  save_file_selection = glade_xml_get_widget (temp_xml, "save_file_selection");
  
  gtk_signal_connect_full (GTK_OBJECT(glade_xml_get_widget (temp_xml, "ok_button")), "clicked",
			   GTK_SIGNAL_FUNC(on_save_file_selection_ok_button_clicked), NULL,
			   temp_xml, (GtkDestroyNotify)gtk_object_unref,
			   FALSE, FALSE);
  gtk_signal_connect_full (GTK_OBJECT(glade_xml_get_widget (temp_xml, "cancel_button")), "clicked",
			   GTK_SIGNAL_FUNC(on_save_file_selection_cancel_button_clicked), NULL,
			   temp_xml, (GtkDestroyNotify)gtk_object_unref,
			   FALSE, FALSE);
  gtk_signal_connect_full (GTK_OBJECT(save_file_selection), "delete_event",
			   GTK_SIGNAL_FUNC(on_save_file_selection_delete_event), NULL,
			   temp_xml, (GtkDestroyNotify)gtk_object_unref,
			   FALSE, FALSE);
  
  gtk_object_set_data (GTK_OBJECT (save_file_selection), MainWindowKey, main_window);
  gtk_widget_show (save_file_selection);
}
