/*
 * GChangepass -- GTK+ Frontend to passwd
 * Copyright (C) 2005 Guilherme de Siqueira Pastore
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <string.h>
#include <pwd.h>
#include <sys/types.h>

typedef struct {
  gchar *username;
  uid_t userid;
} TmpUser;

void secure_free (gchar *string)
{
  if (string)
    {
      bzero (string, strlen (string));
      g_free (string);
    }
}

void gchangepass_dialog (GtkMessageType type, gchar *format, ...)
{
  GtkWidget *dialog;
  va_list ap;
  gchar *msg;

  va_start (ap, format);
  msg = g_strdup_vprintf (format, ap);
  va_end (ap);

  dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, type,
				   GTK_BUTTONS_CLOSE, msg);
  g_free (msg);

  gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_CENTER);
  gtk_window_set_resizable (GTK_WINDOW (dialog), FALSE);

  gtk_dialog_run (GTK_DIALOG (dialog));

  gtk_widget_destroy (dialog);
}

static int get_user_list_cmp (gconstpointer a, gconstpointer b)
{
  return ((TmpUser *) a)->userid - ((TmpUser *) b)->userid;
}

GList *get_user_list (guint myuid)
{
  GList *ret, *tmp, *list;
  TmpUser *tu;
  struct passwd *pw;

  ret = tmp = NULL;

  setpwent();

  while ((pw = getpwent()))
    {
      tu = g_new (TmpUser, 1);

      tu->username = g_strdup (pw->pw_name);
      tu->userid = pw->pw_uid;

      /* Don't include myself nor system accounts */
      if ((tu->userid >= (uid_t) 1000) && (tu->userid != myuid))
	tmp = g_list_prepend (tmp, tu);
    }

  tmp = g_list_sort (tmp, get_user_list_cmp);

  for (list = tmp; list; list = g_list_next (list))
    {
      tu = list->data;

      ret = g_list_append(ret, tu->username);
      g_free (tu);
    }

  g_list_free (tmp);
  endpwent ();

  return ret;
}

void free_user_list (GList *list)
{
  for (; list; list = g_list_next (list))
    g_free (list->data);

  g_list_free (list);
}
