/* local_state.c                  -*-C++-*-
 *
 *************************************************************************
 *
 *  @copyright
 *  Copyright (C) 2010-2013, Intel Corporation
 *  All rights reserved.
 *  
 *  @copyright
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *  
 *    * Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *    * Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in
 *      the documentation and/or other materials provided with the
 *      distribution.
 *    * Neither the name of Intel Corporation nor the names of its
 *      contributors may be used to endorse or promote products derived
 *      from this software without specific prior written permission.
 *  
 *  @copyright
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 *  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 *  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 *  AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY
 *  WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 *
 **************************************************************************/

#include "local_state.h"
#include "bug.h"
#include "full_frame.h"

void run_scheduling_stack_fcn(__cilkrts_worker *w)
{
    scheduling_stack_fcn_t fcn = w->l->post_suspend;
    full_frame *ff2 = w->l->frame_ff;
    __cilkrts_stack_frame *sf2 = w->l->suspended_stack;

    w->l->post_suspend = 0;
    w->l->suspended_stack = 0;

    // Conceptually, after clearing w->l->frame_ff,
    // w no longer owns the full frame ff.
    // The next time another (possibly different) worker takes
    // ownership of ff will be at a provably_good_steal on ff. 
    w->l->frame_ff = NULL;

    CILK_ASSERT(fcn);
    CILK_ASSERT(ff2);
    fcn(w, ff2, sf2);

    // After we run the scheduling stack function, we shouldn't
    // (still) not have a full frame.
    CILK_ASSERT(NULL == w->l->frame_ff);
}

/* End local_state.c */
